/*
 * Decompiled with CFR 0.152.
 */
package com.yuzhyn.azylee.ext.web.mqs.rocketmq;

import com.yuzhyn.azylee.core.configs.rocketmq.RockermqConsumerConfig;
import com.yuzhyn.azylee.ext.web.mqs.rocketmq.RocketmqProducerManager;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PreDestroy;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.consumer.listener.MessageListener;
import org.apache.rocketmq.common.consumer.ConsumeFromWhere;

public class RocketmqConsumerManager {
    private static ConcurrentHashMap<String, DefaultMQPushConsumer> consumerPool = new ConcurrentHashMap();

    public static DefaultMQPushConsumer getConsumer(String name) {
        return consumerPool.get(name);
    }

    public static boolean create(RockermqConsumerConfig consumerPart, MessageListener listener) {
        try {
            DefaultMQPushConsumer consumer = new DefaultMQPushConsumer(consumerPart.getGroup());
            consumer.setNamesrvAddr(consumerPart.getNamesrvAddr());
            consumer.setConsumeFromWhere(ConsumeFromWhere.CONSUME_FROM_FIRST_OFFSET);
            consumer.subscribe(consumerPart.getTopic(), consumerPart.getTag());
            consumer.registerMessageListener(listener);
            consumerPool.put(consumerPart.getName(), consumer);
            return true;
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            return false;
        }
    }

    public static boolean createAndStart(RockermqConsumerConfig consumerPart, MessageListener listener) {
        if (RocketmqConsumerManager.create(consumerPart, listener)) {
            return RocketmqConsumerManager.start(consumerPart.getName());
        }
        return false;
    }

    public static boolean start(String name) {
        try {
            RocketmqConsumerManager.getConsumer(name).start();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void shutdown(String name) {
        RocketmqConsumerManager.getConsumer(name).shutdown();
    }

    public static void shutdownAll() {
        if (consumerPool != null && consumerPool.size() > 0) {
            for (String name : consumerPool.keySet()) {
                if (!consumerPool.containsKey(name) || consumerPool.get(name) == null) continue;
                RocketmqConsumerManager.shutdown(name);
            }
        }
    }

    @PreDestroy
    public void preDestroy() {
        long now = System.currentTimeMillis();
        System.out.println("\u5173\u95ed\u6240\u6709 Rocketmq \u8fde\u63a5");
        RocketmqProducerManager.shutdownAll();
        System.out.println("\u603b\u8ba1\u7528\u65f6\uff1a" + (System.currentTimeMillis() - now));
    }
}

