/*
 * Decompiled with CFR 0.152.
 */
package com.yuzhyn.azylee.ext.web.sshs;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.yuzhyn.azylee.core.datas.exceptions.ExceptionTool;
import com.yuzhyn.azylee.core.logs.Alog;
import com.yuzhyn.azylee.ext.web.sshs.SshClient;
import com.yuzhyn.azylee.ext.web.sshs.SshHistory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;

public class SshManager {
    private ConcurrentMap<String, SshClient> sshClientMap;
    private ExecutorService executorService = Executors.newCachedThreadPool();

    public Map<String, SshClient> getSshClientMap() {
        return this.sshClientMap;
    }

    public void setSshClientMap(ConcurrentMap<String, SshClient> sshClientMap) {
        this.sshClientMap = sshClientMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean create(String id, String host, int port, String username, String password, Map<String, String> attach) {
        try {
            JSch jsch = new JSch();
            Session session = jsch.getSession(username, host, port);
            session.setPassword(password);
            Properties config = new Properties();
            config.put("StrictHostKeyChecking", "no");
            session.setConfig(config);
            int timeout = 30000;
            session.setTimeout(timeout);
            session.connect();
            SshClient sshClient = new SshClient();
            sshClient.setCreateTime(LocalDateTime.now());
            sshClient.setHistory(new ArrayList<SshHistory>());
            sshClient.setAttach(new HashMap<String, String>());
            if (attach != null) {
                sshClient.getAttach().putAll(attach);
            }
            sshClient.setjSch(jsch);
            sshClient.setSession(session);
            if (this.getSshClientMap() == null) {
                this.setSshClientMap(new ConcurrentHashMap<String, SshClient>());
            }
            this.getSshClientMap().put(id, sshClient);
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            boolean bl = false;
            return bl;
        }
    }

    public void close(String id) {
        SshClient client = this.getSshClientMap().getOrDefault(id, null);
        if (client != null) {
            if (client.getChannel().isConnected()) {
                client.getChannel().disconnect();
                Alog.i((String)("cleanSshConnection: \u65ad\u5f00 channel: " + id));
            }
            if (client.getSession().isConnected()) {
                client.getSession().disconnect();
                Alog.i((String)("cleanSshConnection: \u5173\u95ed session: " + id));
            }
            Alog.i((String)("cleanSshConnection: \u5173\u95ed\u8fde\u63a5: " + id));
            if (!client.getSession().isConnected()) {
                this.getSshClientMap().remove(id);
                Alog.i((String)("cleanSshConnection: \u79fb\u9664\u8fde\u63a5: " + id));
            }
        }
    }

    public boolean openChannel(String id) {
        try {
            SshClient sshClient = this.getSshClientMap().getOrDefault(id, null);
            if (sshClient == null) {
                return false;
            }
            Channel channel = sshClient.getSession().openChannel("shell");
            channel.connect(3000);
            InputStream inputStream = channel.getInputStream();
            sshClient.setChannel(channel);
            sshClient.getChannel().setInputStream(inputStream);
            return true;
        }
        catch (JSchException | IOException ex) {
            Alog.e((String)ExceptionTool.getStackTrace((Exception)ex));
            return false;
        }
    }

    public void readChannel(String id, Consumer<byte[]> consumer) {
        this.executorService.execute(() -> {
            try {
                SshClient sshClient = this.getSshClientMap().getOrDefault(id, null);
                if (sshClient == null) {
                    // empty if block
                }
                byte[] buffer = new byte[10240];
                int i = 0;
                while ((i = sshClient.getChannel().getInputStream().read(buffer)) != -1) {
                    String s = new String(buffer, 0, i);
                    sshClient.getHistory().add(new SshHistory(false, s));
                    Alog.i((String)s);
                    consumer.accept(Arrays.copyOfRange(buffer, 0, i));
                }
                String string = "[[##hidoc->serverman.run::end.manager//sshmanager_read_end]]";
            }
            catch (IOException e) {
                Alog.e((String)"SshManager: io exception");
                Alog.e((String)("SshManager: io exception is: " + e.getMessage()));
            }
        });
    }

    public void sendCommandRun(String id, String command) throws IOException {
        command = (String)command + "\n";
        SshClient sshClient = this.getSshClientMap().getOrDefault(id, null);
        sshClient.getHistory().add(new SshHistory(true, (String)command));
        Channel channel = sshClient.getChannel();
        if (channel != null) {
            OutputStream outputStream = channel.getOutputStream();
            outputStream.write(((String)command).getBytes());
            outputStream.flush();
        }
    }

    public void sendCommand(String id, String command) throws IOException {
        SshClient sshClient = this.getSshClientMap().getOrDefault(id, null);
        sshClient.getHistory().add(new SshHistory(true, command));
        Channel channel = sshClient.getChannel();
        if (channel != null) {
            OutputStream outputStream = channel.getOutputStream();
            outputStream.write(command.getBytes());
            outputStream.flush();
        }
    }
}

