/*
 * Decompiled with CFR 0.152.
 */
package com.yuzhyn.azylee.ext.web.mails;

import com.yuzhyn.azylee.core.datas.collections.ListTool;
import com.yuzhyn.azylee.core.datas.objects.ObjectTool;
import jakarta.mail.Address;
import jakarta.mail.Authenticator;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.PasswordAuthentication;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeMessage;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import reactor.util.function.Tuple2;

public class EmailTool {
    private String personalName;
    private String emailAddress;
    private String emailPassword;
    private Session session;
    private Integer port;
    private boolean isSsl;
    private String smtpHost;
    private boolean isDebug = false;
    private String charset = "UTF-8";
    private String contentType = "text/html;charset=UTF-8";

    public EmailTool(String address, String personal, String password, int port, boolean isSsl, String smtpHost) {
        this.emailAddress = address;
        this.personalName = personal;
        this.emailPassword = password;
        this.port = port;
        this.isSsl = isSsl;
        this.smtpHost = smtpHost;
    }

    public void createSession() {
        final Properties props = new Properties();
        props.setProperty("mail.transport.protocol", "smtp");
        props.setProperty("mail.smtp.host", this.smtpHost);
        props.setProperty("mail.smtp.auth", "true");
        props.setProperty("mail.smtp.port", String.valueOf(this.port));
        props.setProperty("mail.user", this.emailAddress);
        props.setProperty("mail.password", this.emailPassword);
        if (this.isSsl) {
            props.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            props.put("mail.smtp.starttls.enable", (Object)true);
            props.put("mail.smtp.ssl.trust", (Object)true);
        }
        Authenticator authenticator = new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                String userName = props.getProperty("mail.user");
                String password = props.getProperty("mail.password");
                return new PasswordAuthentication(userName, password);
            }
        };
        this.session = Session.getInstance((Properties)props, (Authenticator)authenticator);
        this.session.setDebug(this.isDebug);
    }

    public Address[] createAddressByT2(List<Tuple2<String, String>> datas) throws UnsupportedEncodingException {
        if (ListTool.ok(datas)) {
            Address[] addresses = new Address[datas.size()];
            for (int i = 0; i < datas.size(); ++i) {
                addresses[i] = new InternetAddress((String)ObjectTool.optional((Object)((String)datas.get(i).getT1()), (Object)""), (String)ObjectTool.optional((Object)((String)datas.get(i).getT2()), (Object)""), this.charset);
            }
            return addresses;
        }
        return null;
    }

    public Address[] createAddress(List<String> datas) throws AddressException {
        if (ListTool.ok(datas)) {
            Address[] addresses = new Address[datas.size()];
            for (int i = 0; i < datas.size(); ++i) {
                addresses[i] = new InternetAddress(datas.get(i));
            }
            return addresses;
        }
        return null;
    }

    public void sendMessage(Address[] recipients, String title, String content) throws Exception {
        MimeMessage message = this.createMessage(this.session, recipients, title, content);
        Transport transport = this.session.getTransport();
        transport.connect(this.emailAddress, this.emailPassword);
        transport.sendMessage((Message)message, message.getAllRecipients());
        transport.close();
    }

    public void sendMessage(MimeMessage message) throws MessagingException {
        Transport transport = this.session.getTransport();
        transport.connect(this.emailAddress, this.emailPassword);
        transport.sendMessage((Message)message, message.getAllRecipients());
        transport.close();
    }

    private MimeMessage createMessage(Session session, Address[] recipients, String title, String content) throws Exception {
        MimeMessage message = new MimeMessage(session);
        message.setFrom((Address)new InternetAddress(this.emailAddress, this.personalName, this.charset));
        message.setRecipients(MimeMessage.RecipientType.TO, recipients);
        message.setSubject(title, this.charset);
        message.setContent((Object)content, this.contentType);
        message.setSentDate(new Date());
        message.saveChanges();
        return message;
    }
}

