/*
 * Decompiled with CFR 0.152.
 */
package com.yuzhyn.azylee.ext.web.https;

import com.yuzhyn.azylee.ext.web.https.DownloadInfo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class FileFetchTool {
    public static void download(String url, String filePath, Function<DownloadInfo, Void> callback) throws IOException {
        OkHttpClient client = new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).build();
        Request request = new Request.Builder().url(url).build();
        try (Response response = client.newCall(request).execute();){
            int bytesRead;
            if (!response.isSuccessful()) {
                throw new IOException("\u4e0b\u8f7d\u5931\u8d25\uff0c\u54cd\u5e94\u7801: " + response.code());
            }
            long contentLength = response.body().contentLength();
            InputStream inputStream = response.body().byteStream();
            FileOutputStream outputStream = new FileOutputStream(new File(filePath));
            byte[] buffer = new byte[4096];
            long totalBytesRead = 0L;
            long startTime = System.currentTimeMillis();
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
                int progress = (int)((totalBytesRead += (long)bytesRead) * 100L / contentLength);
                long elapsedTime = System.currentTimeMillis() - startTime;
                if (elapsedTime <= 0L) continue;
                double speed = (double)totalBytesRead / ((double)elapsedTime / 1000.0) / 1024.0;
                long remainingBytes = contentLength - totalBytesRead;
                long remainingSeconds = (long)((double)remainingBytes / (speed * 1024.0));
                DownloadInfo info = new DownloadInfo(progress, speed, remainingSeconds);
                callback.apply(info);
            }
        }
    }
}

