/*
 * Decompiled with CFR 0.152.
 */
package top.zackyoung.tool.hugegraph;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baidu.hugegraph.driver.HugeClient;
import com.baidu.hugegraph.structure.graph.Edge;
import com.baidu.hugegraph.structure.graph.Path;
import com.baidu.hugegraph.structure.graph.Vertex;
import com.baidu.hugegraph.structure.gremlin.ResultSet;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class HugegraphUtils {
    static String host;
    static String port;
    static HugeClient hugeClient;
    static NumberFormat nf;

    public static JSONArray getChildNode(String name) {
        ResultSet resultSet = hugeClient.gremlin().gremlin("g.V().has(\"name\",\"" + name + "\").outE().inV().path()").execute();
        JSONArray array = new JSONArray();
        resultSet.iterator().forEachRemaining(result -> {
            List objects = result.getPath().objects();
            Edge edge = (Edge)objects.get(1);
            double regRate = Double.parseDouble(edge.properties().get("stock_percent").toString());
            if (regRate <= 0.0) {
                return;
            }
            Vertex vertex = (Vertex)objects.get(2);
            JSONObject json = new JSONObject();
            json.putAll(vertex.properties());
            json.put("regRate", (Object)nf.format(regRate));
            json.put("isChild", (Object)false);
            array.add((Object)json);
        });
        return array;
    }

    public static Set<String> getChildNodeIsChild(String name) {
        ResultSet resultSet = hugeClient.gremlin().gremlin("g.V().has(\"name\",\"" + name + "\").out(\"e_invest\").outE().inV().path()").execute();
        HashMap isExistMap = new HashMap();
        resultSet.iterator().forEachRemaining(result -> {
            Edge edge;
            Object stockPercent;
            double aDouble;
            Path path = (Path)result.getObject();
            Vertex vertex1 = (Vertex)path.objects().get(1);
            String eid = vertex1.properties().get("eid").toString();
            if (!isExistMap.getOrDefault(eid, false).booleanValue() && (aDouble = Double.parseDouble((stockPercent = (edge = (Edge)path.objects().get(2)).properties().get("stock_percent")).toString())) > 0.0) {
                isExistMap.put(eid, true);
            }
        });
        return isExistMap.keySet();
    }

    public static void main(String[] args) {
        String name = "\u91cd\u5e86\u6b63\u5927\u8f6f\u4ef6\uff08\u96c6\u56e2\uff09\u6709\u9650\u516c\u53f8";
        JSONArray childNode = HugegraphUtils.getChildNode(name);
        Set<String> childNodeIsChild = HugegraphUtils.getChildNodeIsChild(name);
        childNode.forEach(x -> {
            JSONObject json = (JSONObject)x;
            if (childNodeIsChild.contains(json.getString("eid"))) {
                json.put("isChild", (Object)true);
            }
        });
        System.out.println(childNode);
    }

    static {
        hugeClient = HugeClient.builder((String)"http://10.255.57.139:8080", (String)"hugegraph").build();
        nf = NumberFormat.getPercentInstance();
        nf.setMaximumFractionDigits(2);
    }
}

