/*
 * Decompiled with CFR 0.152.
 */
package top.zackyoung.tool.json;

import cn.hutool.core.bean.BeanPath;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.TypeUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JSONUtils {
    private static final Logger log = LogManager.getLogger(JSONUtils.class);
    static Set<Class<?>> clazzSet = CollectionUtil.newHashSet((Object[])new Class[]{Integer.class, BigDecimal.class, Long.class, Boolean.class, Date.class, Float.class, String.class});

    public static <T> T toBean(Class<T> clazz, JSONObject json) {
        Field[] declaredFields;
        Object t = ReflectUtil.newInstance(clazz, (Object[])new Object[0]);
        for (Field field : declaredFields = ReflectUtil.getFields(clazz)) {
            JSONField annotation = field.getAnnotation(JSONField.class);
            if (annotation == null) continue;
            field.setAccessible(true);
            String name = annotation.name();
            if (StrUtil.isBlank((CharSequence)name)) continue;
            List split = StrUtil.split((CharSequence)name, (CharSequence)":");
            BeanPath resolver = new BeanPath((String)split.get(0));
            Object o1 = resolver.get((Object)json);
            try {
                Class cla;
                if (o1 == null && split.size() == 2) {
                    try {
                        o1 = Convert.convert(field.getType(), split.get(1));
                    }
                    catch (Exception e) {
                        log.error("\u8f6c\u6362\u7c7b\u578b\u9519\u8bef\uff1a\u8868\u8fbe\u5f0f\uff1a{}", (Object)name, (Object)e);
                    }
                }
                if (field.getType().equals(List.class)) {
                    cla = (Class)TypeUtil.getTypeArgument((Type)TypeUtil.getType((Field)field));
                    ArrayList list = o1 == null || o1 instanceof List && !((List)o1).isEmpty() && ((List)o1).get(0) == null ? new ArrayList() : JSONUtils.toBeanList(cla, (JSONArray)o1);
                    field.set(t, list);
                    continue;
                }
                if (clazzSet.contains(field.getType())) {
                    field.set(t, o1);
                    continue;
                }
                cla = (Class)TypeUtil.getType((Field)field);
                T o = JSONUtils.toBean(cla, o1 == null ? null : (JSONObject)o1);
                field.set(t, o);
            }
            catch (Exception e) {
                log.error("\u7c7b \uff1a{}  \u5b57\u6bb5\uff1a{}\uff0c\u89e3\u6790\u9519\u8bef\uff0c\u89e3\u6790\u6807\u7b7e:{} ", (Object)clazz.getName(), (Object)field.getName(), (Object)name, (Object)e);
            }
        }
        Method format = ReflectUtil.getMethodByName(clazz, (String)"format");
        Optional.ofNullable(format).ifPresent(x -> ReflectUtil.invoke((Object)t, (Method)format, (Object[])new Object[0]));
        return (T)t;
    }

    public static <T> List<T> toBeanList(Class<T> clazz, JSONArray json, Function<JSONObject, Boolean> condition) {
        return JSONUtils.toBeanList(clazz, json, condition, x -> {});
    }

    public static <T> Stream<T> toBeanStream(Class<T> clazz, JSONArray json, Function<JSONObject, Boolean> condition) {
        return json.stream().map(x -> JSONObject.parseObject((String)JSONObject.toJSONString((Object)x))).filter(condition::apply).map(x -> JSONUtils.toBean(clazz, x));
    }

    public static <T> Stream<T> toBeanStream(Class<T> clazz, JSONArray json) {
        return json.stream().map(x -> JSONObject.parseObject((String)JSONObject.toJSONString((Object)x))).filter(x -> true).map(x -> JSONUtils.toBean(clazz, x));
    }

    public static <T> List<T> toBeanList(Class<T> clazz, JSONArray json, Function<JSONObject, Boolean> condition, Consumer<T> reSet) {
        List list = json.stream().map(x -> JSONObject.parseObject((String)JSONObject.toJSONString((Object)x))).filter(condition::apply).map(x -> JSONUtils.toBean(clazz, x)).peek(reSet::accept).collect(Collectors.toList());
        return list;
    }

    public static <T> List<T> toBeanList(Class<T> clazz, JSONArray json, Consumer<T> reSet) {
        return JSONUtils.toBeanList(clazz, json, x -> true, reSet);
    }

    public static <T> List<T> toBeanList(Class<T> clazz, JSONArray json) {
        return JSONUtils.toBeanList(clazz, json, (JSONObject x) -> true);
    }

    public static JSONObject parseFiled(int length, JSONObject json, String[] fields) {
        if (length >= fields.length - 1) {
            return json;
        }
        Object o = json.get((Object)fields[length]);
        if (o instanceof JSONArray) {
            JSONArray o1 = (JSONArray)o;
            return o1.isEmpty() ? null : o1.getJSONObject(0);
        }
        JSONObject o1 = (JSONObject)o;
        return JSONUtils.parseFiled(++length, o1, fields);
    }
}

