/*
 * Decompiled with CFR 0.152.
 */
package top.zephyrs.mybatis.semi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.parameter.ParameterHandler;
import org.apache.ibatis.executor.resultset.DefaultResultSetHandler;
import org.apache.ibatis.executor.resultset.ResultSetHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import top.zephyrs.mybatis.semi.SemiMapperBuilder;
import top.zephyrs.mybatis.semi.config.GlobalConfig;
import top.zephyrs.mybatis.semi.config.KeyGenerateConfig;
import top.zephyrs.mybatis.semi.exceptions.KeyGenerateException;
import top.zephyrs.mybatis.semi.executor.ParameterHandlerWrapper;
import top.zephyrs.mybatis.semi.executor.ResultSetHandlerWrapper;
import top.zephyrs.mybatis.semi.injects.DefaultInjectProcessor;
import top.zephyrs.mybatis.semi.injects.InjectMethod;
import top.zephyrs.mybatis.semi.injects.InjectProcessor;
import top.zephyrs.mybatis.semi.plugins.keygenerate.IdType;
import top.zephyrs.mybatis.semi.plugins.keygenerate.KeyCreator;
import top.zephyrs.mybatis.semi.plugins.keygenerate.generators.AutoKeyCreator;
import top.zephyrs.mybatis.semi.plugins.keygenerate.generators.NoneKeyCreator;
import top.zephyrs.mybatis.semi.plugins.keygenerate.generators.SnowflakeKeyCreator;
import top.zephyrs.mybatis.semi.plugins.keygenerate.generators.UUIDKeyCreator;

public class SemiMybatisConfiguration
extends Configuration {
    private InjectProcessor injectProcessor = new DefaultInjectProcessor();
    private GlobalConfig globalConfig;
    private final Map<IdType, KeyCreator<?>> keyCreatorMap = new HashMap();
    private final List<String> sensitiveMappedStatementIds = new ArrayList<String>();

    public SemiMybatisConfiguration(Environment environment) {
        super(environment);
    }

    public SemiMybatisConfiguration() {
    }

    public MappedStatement getMappedStatement(String id) {
        return super.getMappedStatement(id);
    }

    public MappedStatement getMappedStatement(String id, boolean validateIncompleteStatements) {
        return super.getMappedStatement(id, validateIncompleteStatements);
    }

    public ParameterHandler newParameterHandler(MappedStatement mappedStatement, Object parameterObject, BoundSql boundSql) {
        ParameterHandler parameterHandler = mappedStatement.getLang().createParameterHandler(mappedStatement, parameterObject, boundSql);
        return (ParameterHandler)this.interceptorChain.pluginAll((Object)new ParameterHandlerWrapper(parameterHandler, mappedStatement));
    }

    public ResultSetHandler newResultSetHandler(Executor executor, MappedStatement mappedStatement, RowBounds rowBounds, ParameterHandler parameterHandler, ResultHandler resultHandler, BoundSql boundSql) {
        DefaultResultSetHandler resultSetHandler = new DefaultResultSetHandler(executor, mappedStatement, parameterHandler, resultHandler, boundSql, rowBounds);
        return (ResultSetHandler)this.interceptorChain.pluginAll((Object)new ResultSetHandlerWrapper((ResultSetHandler)resultSetHandler, mappedStatement));
    }

    protected void buildAllStatements() {
        super.buildAllStatements();
        this.buildAllProcessorStatements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildAllProcessorStatements() {
        this.injectProcessor.loadMethods();
        for (Class type : this.mapperRegistry.getMappers()) {
            boolean loadCompleted = false;
            try {
                SemiMapperBuilder parse = new SemiMapperBuilder(this, type);
                parse.parse();
                loadCompleted = true;
            }
            finally {
                if (loadCompleted) continue;
            }
        }
    }

    public GlobalConfig getGlobalConfig() {
        return this.globalConfig;
    }

    public void setGlobalConfig(GlobalConfig globalConfig) {
        this.globalConfig = globalConfig;
    }

    public InjectMethod getInjectMethod(String id) {
        return this.injectProcessor.getMethod(id);
    }

    public InjectProcessor getInjectProcessor() {
        return this.injectProcessor;
    }

    public void setInjectProcessor(InjectProcessor injectProcessor) {
        this.injectProcessor = injectProcessor;
    }

    public void setKeyCreators() {
        KeyGenerateConfig cfg = this.globalConfig.getKeyGenerate();
        if (cfg == null) {
            cfg = new KeyGenerateConfig();
        }
        this.setKeyCreator(IdType.UUID, new UUIDKeyCreator());
        this.setKeyCreator(IdType.SNOWFLAKE, new SnowflakeKeyCreator(cfg.getWorkId()));
        this.setKeyCreator(IdType.NONE, new NoneKeyCreator());
        this.setKeyCreator(IdType.AUTO, new AutoKeyCreator());
        try {
            if (cfg.getCustomKeyCreator() != null) {
                this.setKeyCreator(IdType.CUSTOM, cfg.getCustomKeyCreator().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
        }
        catch (Exception e) {
            throw new KeyGenerateException("Failed to create custom keyCreator. Please check the constructor function. class=" + cfg.getCustomKeyCreator().getName(), e);
        }
        this.setKeyCreator(IdType.DEFAULT, this.getKeyCreator(cfg.getDefaultIdType()));
    }

    public void setKeyCreator(IdType idType, KeyCreator<?> keyCreator) {
        this.keyCreatorMap.put(idType, keyCreator);
    }

    public KeyCreator<?> getKeyCreator(IdType idType) {
        return this.keyCreatorMap.get((Object)idType);
    }

    public void addSensitiveMappedStatementIds(String id) {
        this.sensitiveMappedStatementIds.add(id);
    }

    public boolean isSensitiveDecrypt(String id) {
        if (this.globalConfig.getSensitive() == null || !this.globalConfig.getSensitive().isOpen()) {
            return false;
        }
        if (this.globalConfig.getSensitive().isDefaultDecrypt()) {
            return true;
        }
        return this.sensitiveMappedStatementIds.contains(id);
    }
}

