/*
 * Decompiled with CFR 0.152.
 */
package top.zephyrs.mybatis.semi.plugins.sensitive;

import java.lang.reflect.Field;
import java.sql.PreparedStatement;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.executor.parameter.ParameterHandler;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import top.zephyrs.mybatis.semi.config.SensitiveConfig;
import top.zephyrs.mybatis.semi.exceptions.SensitiveException;
import top.zephyrs.mybatis.semi.executor.ParameterHandlerWrapper;
import top.zephyrs.mybatis.semi.plugins.sensitive.ISensitive;
import top.zephyrs.mybatis.semi.plugins.sensitive.SensitiveHelper;

@Intercepts(value={@Signature(type=ParameterHandler.class, method="setParameters", args={PreparedStatement.class})})
public class SensitiveEncryptInterceptor
implements Interceptor {
    private final SensitiveConfig config;

    public SensitiveEncryptInterceptor(SensitiveConfig config) {
        this.config = config;
    }

    public Object intercept(Invocation invocation) throws Throwable {
        ParameterHandlerWrapper parameterHandler = (ParameterHandlerWrapper)invocation.getTarget();
        Object parameter = parameterHandler.getParameterObject();
        if (Objects.isNull(parameter) || !this.config.isOpen()) {
            return invocation.proceed();
        }
        HashSet<Object> needEncryptObjects = new HashSet<Object>();
        if (parameter instanceof MapperMethod.ParamMap) {
            for (Object e : ((MapperMethod.ParamMap)parameter).values()) {
                if (e instanceof Collection) {
                    needEncryptObjects.addAll((Collection)e);
                    continue;
                }
                needEncryptObjects.add(e);
            }
        } else {
            if (Map.class.isAssignableFrom(parameter.getClass())) {
                return invocation.proceed();
            }
            needEncryptObjects.add(parameter);
        }
        try {
            for (Object e : needEncryptObjects) {
                SensitiveHelper.SensitiveBean sensitiveBean = SensitiveHelper.getSensitiveBean(this.config, e);
                if (sensitiveBean == null) continue;
                for (Field field : sensitiveBean.getFields()) {
                    ISensitive sensitive = sensitiveBean.getSensitive(field);
                    Object original = field.get(e);
                    if (!(original instanceof String)) continue;
                    String ciphertext = sensitive.encrypt(e, String.valueOf(original));
                    field.set(e, ciphertext);
                }
            }
        }
        catch (Exception e) {
            throw new SensitiveException("Failed to encrypt sensitive field." + e.getMessage(), e);
        }
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        if (target instanceof ParameterHandlerWrapper) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }
}

