/*
 * Decompiled with CFR 0.152.
 */
package top.zephyrs.mybatis.semi.plugins.sensitive;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import top.zephyrs.mybatis.semi.annotations.Sensitive;
import top.zephyrs.mybatis.semi.config.SensitiveConfig;
import top.zephyrs.mybatis.semi.metadata.MetadataHelper;
import top.zephyrs.mybatis.semi.plugins.sensitive.DefaultSensitive;
import top.zephyrs.mybatis.semi.plugins.sensitive.ISensitive;

public class SensitiveHelper {
    private static final Map<Class<? extends ISensitive>, ISensitive> sensitivesMap = new HashMap<Class<? extends ISensitive>, ISensitive>();
    private static final Map<Class<?>, SensitiveBean> sensitiveBeanMap = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SensitiveBean getSensitiveBean(SensitiveConfig config, Object obj) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        if (obj instanceof String || obj instanceof Long || obj instanceof Integer || obj instanceof Short || obj instanceof Boolean || obj instanceof Character || obj instanceof Collection || obj instanceof Map) {
            return null;
        }
        Class<?> clazz = obj.getClass();
        SensitiveBean sensitiveBean = sensitiveBeanMap.get(clazz);
        if (sensitiveBean != null) return sensitiveBean;
        Class<SensitiveBean> clazz2 = SensitiveBean.class;
        synchronized (SensitiveBean.class) {
            sensitiveBean = sensitiveBeanMap.get(clazz);
            if (sensitiveBean != null) return sensitiveBean;
            List needSensitiveFields = MetadataHelper.getAllFields(clazz).stream().filter(field -> field.getAnnotation(Sensitive.class) != null).collect(Collectors.toList());
            HashMap<Field, ISensitive> sensitiveMap = new HashMap<Field, ISensitive>();
            for (Field field2 : needSensitiveFields) {
                ISensitive sensitive;
                field2.setAccessible(true);
                Sensitive annotation = field2.getAnnotation(Sensitive.class);
                if (annotation == null) continue;
                Class<? extends ISensitive> sensitiveClass = annotation.value();
                if (sensitiveClass == DefaultSensitive.class && config.getDefaultImpl() != null) {
                    sensitiveClass = config.getDefaultImpl();
                }
                if ((sensitive = sensitivesMap.get(sensitiveClass)) == null) {
                    sensitive = annotation.value().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    sensitivesMap.put(annotation.value(), sensitive);
                }
                sensitiveMap.put(field2, sensitive);
            }
            sensitiveBean = new SensitiveBean(clazz, sensitiveMap);
            sensitiveBeanMap.put(clazz, sensitiveBean);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return sensitiveBean;
        }
    }

    public static class SensitiveBean {
        private final Class<?> clazz;
        private final Map<Field, ISensitive> sensitiveMap;

        SensitiveBean(Class<?> clazz, Map<Field, ISensitive> sensitiveMap) {
            this.clazz = clazz;
            this.sensitiveMap = sensitiveMap;
        }

        public Class<?> getSensitiveClass() {
            return this.clazz;
        }

        Collection<Field> getFields() {
            return this.sensitiveMap.keySet();
        }

        ISensitive getSensitive(Field field) {
            return this.sensitiveMap.get(field);
        }
    }
}

