/*
 * Decompiled with CFR 0.152.
 */
package top.zephyrs.mybatis.semi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Lang;
import org.apache.ibatis.annotations.MapKey;
import org.apache.ibatis.annotations.Options;
import org.apache.ibatis.annotations.ResultMap;
import org.apache.ibatis.annotations.ResultType;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.SelectKey;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.builder.IncompleteElementException;
import org.apache.ibatis.builder.MapperBuilderAssistant;
import org.apache.ibatis.builder.annotation.MethodResolver;
import org.apache.ibatis.builder.annotation.ProviderSqlSource;
import org.apache.ibatis.cursor.Cursor;
import org.apache.ibatis.executor.keygen.KeyGenerator;
import org.apache.ibatis.executor.keygen.NoKeyGenerator;
import org.apache.ibatis.executor.keygen.SelectKeyGenerator;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultFlag;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.mapping.ResultSetType;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.mapping.StatementType;
import org.apache.ibatis.reflection.TypeParameterResolver;
import org.apache.ibatis.scripting.LanguageDriver;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.UnknownTypeHandler;
import top.zephyrs.mybatis.semi.SemiMybatisConfiguration;
import top.zephyrs.mybatis.semi.annotations.DatabaseId;
import top.zephyrs.mybatis.semi.annotations.SensitiveDecrypt;
import top.zephyrs.mybatis.semi.base.IMapper;
import top.zephyrs.mybatis.semi.config.SensitiveConfig;
import top.zephyrs.mybatis.semi.injects.InjectMethod;
import top.zephyrs.mybatis.semi.metadata.ColumnInfo;
import top.zephyrs.mybatis.semi.metadata.MetadataHelper;
import top.zephyrs.mybatis.semi.metadata.TableInfo;

public class SemiMapperBuilder {
    private final SemiMybatisConfiguration configuration;
    private final MapperBuilderAssistant assistant;
    private final Class<?> type;

    public SemiMapperBuilder(SemiMybatisConfiguration configuration, Class<?> type) {
        String resource = type.getName().replace('.', '/') + ".java (semi)";
        this.assistant = new MapperBuilderAssistant((Configuration)configuration, resource);
        this.configuration = configuration;
        this.type = type;
    }

    public void parse() {
        this.assistant.setCurrentNamespace(this.type.getName());
        for (Method method : this.type.getMethods()) {
            String mappedProcessorId;
            InjectMethod processor;
            SensitiveDecrypt decrypt;
            if (!SemiMapperBuilder.canHaveStatement(method)) continue;
            String mappedStatementId = this.type.getName() + "." + method.getName();
            SensitiveConfig sensitiveCfg = this.configuration.getGlobalConfig().getSensitive();
            if (sensitiveCfg != null && sensitiveCfg.isOpen() && !sensitiveCfg.isDefaultDecrypt() && (decrypt = method.getAnnotation(SensitiveDecrypt.class)) != null) {
                this.configuration.addSensitiveMappedStatementIds(mappedStatementId);
            }
            if (this.configuration.hasStatement(mappedStatementId, false) || (processor = this.configuration.getInjectMethod(mappedProcessorId = method.getName())) == null) continue;
            Class<?> beanClass = this.getBeanType(this.type);
            if (beanClass == null) {
                return;
            }
            TableInfo tableInfo = MetadataHelper.getTableInfo(this.configuration.getGlobalConfig(), beanClass, true);
            if (tableInfo == null) {
                return;
            }
            if (method.getAnnotation(ResultMap.class) == null) {
                this.parseResultMap(method, beanClass, tableInfo);
            }
            this.parseStatement(mappedStatementId, method, processor, beanClass, tableInfo);
        }
        this.parsePendingMethods();
    }

    private static boolean canHaveStatement(Method method) {
        return !method.isBridge() && !method.isDefault();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parsePendingMethods() {
        Collection incompleteMethods;
        Collection collection = incompleteMethods = this.configuration.getIncompleteMethods();
        synchronized (collection) {
            Iterator iter = incompleteMethods.iterator();
            while (iter.hasNext()) {
                try {
                    ((MethodResolver)iter.next()).resolve();
                    iter.remove();
                }
                catch (IncompleteElementException incompleteElementException) {}
            }
        }
    }

    private String parseResultMap(Method method, Class<?> beanClass, TableInfo tableInfo) {
        Class<?> returnType = SemiMapperBuilder.getReturnType(method, this.type);
        String resultMapId = this.generateResultMapName(method);
        this.applyResultMap(resultMapId, returnType, tableInfo);
        return resultMapId;
    }

    private String generateResultMapName(Method method) {
        Results results = method.getAnnotation(Results.class);
        if (results != null && !results.id().isEmpty()) {
            return this.type.getName() + "." + results.id();
        }
        StringBuilder suffix = new StringBuilder();
        for (Class<?> c : method.getParameterTypes()) {
            suffix.append("-");
            suffix.append(c.getSimpleName());
        }
        if (suffix.length() < 1) {
            suffix.append("-void");
        }
        return this.type.getName() + "." + method.getName() + suffix;
    }

    private void applyResultMap(String resultMapId, Class<?> returnType, TableInfo tableInfo) {
        if (this.configuration.hasResultMap(resultMapId)) {
            return;
        }
        ArrayList<ResultMapping> resultMappings = new ArrayList<ResultMapping>();
        if (returnType.isAssignableFrom(tableInfo.getType())) {
            for (ColumnInfo columnInfo : tableInfo.getColumns()) {
                if (columnInfo.getTypeHandler() == null || columnInfo.getTypeHandler() == UnknownTypeHandler.class) continue;
                ArrayList<ResultFlag> flags = new ArrayList<ResultFlag>();
                if (columnInfo.isPK()) {
                    flags.add(ResultFlag.ID);
                }
                ResultMapping resultMapping = this.assistant.buildResultMapping(returnType, columnInfo.getFieldName(), columnInfo.getColumnName(), columnInfo.getFieldType(), null, null, null, null, null, columnInfo.getTypeHandler(), flags, null, null, this.isLazy());
                resultMappings.add(resultMapping);
            }
        }
        this.assistant.addResultMap(resultMapId, returnType, null, null, resultMappings, null);
    }

    void parseStatement(String mappedStatementId, Method method, InjectMethod processor, Class<?> beanClass, TableInfo tableInfo) {
        DatabaseId databaseIdAnnotation;
        LanguageDriver languageDriver;
        Class<?> parameterTypeClass = this.getParameterType(method);
        SqlSource sqlSource = processor.createSqlSource(this.configuration, this.type, beanClass, method, parameterTypeClass, languageDriver = this.getLanguageDriver(method));
        if (sqlSource == null) {
            return;
        }
        String databaseId = processor.databaseId();
        Options options = method.getAnnotation(Options.class);
        SqlCommandType sqlCommandType = processor.getSqlCommandType();
        ResultSetType resultSetType = this.configuration.getDefaultResultSetType();
        boolean isSelect = sqlCommandType == SqlCommandType.SELECT;
        boolean flushCache = !isSelect;
        boolean useCache = isSelect;
        Integer fetchSize = null;
        Integer timeout = null;
        StatementType statementType = StatementType.PREPARED;
        if (options != null) {
            databaseId = options.databaseId() == null ? "" : options.databaseId();
            statementType = options.statementType();
            fetchSize = options.fetchSize() > -1 || options.fetchSize() == Integer.MIN_VALUE ? Integer.valueOf(options.fetchSize()) : null;
            Integer n = timeout = options.timeout() > -1 ? Integer.valueOf(options.timeout()) : null;
            if (options.resultSetType() != ResultSetType.DEFAULT) {
                resultSetType = options.resultSetType();
            }
            if (!options.useCache()) {
                useCache = false;
            }
            if (Options.FlushCachePolicy.TRUE.equals((Object)options.flushCache())) {
                flushCache = true;
            } else if (Options.FlushCachePolicy.FALSE.equals((Object)options.flushCache())) {
                flushCache = false;
            }
        }
        if ((databaseIdAnnotation = method.getAnnotation(DatabaseId.class)) == null) {
            databaseIdAnnotation = this.type.getAnnotation(DatabaseId.class);
        }
        if (databaseIdAnnotation != null) {
            databaseId = databaseIdAnnotation.value();
        }
        String resultMapId = null;
        if (isSelect) {
            ResultMap resultMapAnnotation = method.getAnnotation(ResultMap.class);
            resultMapId = resultMapAnnotation != null ? String.join((CharSequence)",", resultMapAnnotation.value()) : this.generateResultMapName(method);
        }
        processor.addMappedStatement(tableInfo, this.assistant, mappedStatementId, sqlSource, statementType, sqlCommandType, fetchSize, timeout, null, parameterTypeClass, resultMapId, SemiMapperBuilder.getReturnType(method, this.type), resultSetType, flushCache, useCache, false, (KeyGenerator)NoKeyGenerator.INSTANCE, null, null, databaseId, languageDriver, options != null ? this.nullOrEmpty(options.resultSets()) : null, processor.isDirtySelect());
    }

    private LanguageDriver getLanguageDriver(Method method) {
        Lang lang = method.getAnnotation(Lang.class);
        Class langClass = null;
        if (lang != null) {
            langClass = lang.value();
        }
        return this.configuration.getLanguageDriver(langClass);
    }

    private Class<?> getParameterType(Method method) {
        Class<?>[] parameterTypes;
        Class<Object> parameterType = null;
        for (Class<?> currentParameterType : parameterTypes = method.getParameterTypes()) {
            if (RowBounds.class.isAssignableFrom(currentParameterType) || ResultHandler.class.isAssignableFrom(currentParameterType)) continue;
            parameterType = parameterType == null ? currentParameterType : MapperMethod.ParamMap.class;
        }
        return parameterType;
    }

    private static Class<?> getReturnType(Method method, Class<?> type) {
        Class returnType = method.getReturnType();
        Type resolvedReturnType = TypeParameterResolver.resolveReturnType((Method)method, type);
        if (resolvedReturnType instanceof Class) {
            ResultType rt;
            returnType = (Class)resolvedReturnType;
            if (returnType.isArray()) {
                returnType = returnType.getComponentType();
            }
            if (Void.TYPE.equals(returnType) && (rt = method.getAnnotation(ResultType.class)) != null) {
                returnType = rt.value();
            }
        } else if (resolvedReturnType instanceof ParameterizedType) {
            Type[] actualTypeArguments;
            Type returnTypeParameter;
            ParameterizedType parameterizedType = (ParameterizedType)resolvedReturnType;
            Class rawType = (Class)parameterizedType.getRawType();
            if (Collection.class.isAssignableFrom(rawType) || Cursor.class.isAssignableFrom(rawType)) {
                Type[] actualTypeArguments2 = parameterizedType.getActualTypeArguments();
                if (actualTypeArguments2 != null && actualTypeArguments2.length == 1) {
                    Type returnTypeParameter2 = actualTypeArguments2[0];
                    if (returnTypeParameter2 instanceof Class) {
                        returnType = (Class)returnTypeParameter2;
                    } else if (returnTypeParameter2 instanceof ParameterizedType) {
                        returnType = (Class)((ParameterizedType)returnTypeParameter2).getRawType();
                    } else if (returnTypeParameter2 instanceof GenericArrayType) {
                        Class componentType = (Class)((GenericArrayType)returnTypeParameter2).getGenericComponentType();
                        returnType = Array.newInstance(componentType, 0).getClass();
                    }
                }
            } else if (method.isAnnotationPresent(MapKey.class) && Map.class.isAssignableFrom(rawType)) {
                Type[] actualTypeArguments3 = parameterizedType.getActualTypeArguments();
                if (actualTypeArguments3 != null && actualTypeArguments3.length == 2) {
                    Type returnTypeParameter3 = actualTypeArguments3[1];
                    if (returnTypeParameter3 instanceof Class) {
                        returnType = (Class)returnTypeParameter3;
                    } else if (returnTypeParameter3 instanceof ParameterizedType) {
                        returnType = (Class)((ParameterizedType)returnTypeParameter3).getRawType();
                    }
                }
            } else if (Optional.class.equals((Object)rawType) && (returnTypeParameter = (actualTypeArguments = parameterizedType.getActualTypeArguments())[0]) instanceof Class) {
                returnType = (Class)returnTypeParameter;
            }
        }
        return returnType;
    }

    private boolean isLazy() {
        return this.configuration.isLazyLoadingEnabled();
    }

    private String nullOrEmpty(String value) {
        return value == null || value.trim().length() == 0 ? null : value;
    }

    private KeyGenerator handleSelectKeyAnnotation(SelectKey selectKeyAnnotation, String baseStatementId, Class<?> parameterTypeClass, LanguageDriver languageDriver) {
        String id = baseStatementId + "!selectKey";
        Class resultTypeClass = selectKeyAnnotation.resultType();
        StatementType statementType = selectKeyAnnotation.statementType();
        String keyProperty = selectKeyAnnotation.keyProperty();
        String keyColumn = selectKeyAnnotation.keyColumn();
        boolean executeBefore = selectKeyAnnotation.before();
        boolean useCache = false;
        NoKeyGenerator keyGenerator = NoKeyGenerator.INSTANCE;
        Integer fetchSize = null;
        Integer timeout = null;
        boolean flushCache = false;
        String parameterMap = null;
        String resultMap = null;
        ResultSetType resultSetTypeEnum = null;
        String databaseId = selectKeyAnnotation.databaseId().isEmpty() ? null : selectKeyAnnotation.databaseId();
        SqlSource sqlSource = this.buildSqlSource((Annotation)selectKeyAnnotation, parameterTypeClass, languageDriver, null);
        SqlCommandType sqlCommandType = SqlCommandType.SELECT;
        this.assistant.addMappedStatement(id, sqlSource, statementType, sqlCommandType, fetchSize, timeout, parameterMap, parameterTypeClass, resultMap, resultTypeClass, resultSetTypeEnum, flushCache, useCache, false, (KeyGenerator)keyGenerator, keyProperty, keyColumn, databaseId, languageDriver, null, false);
        id = this.assistant.applyCurrentNamespace(id, false);
        MappedStatement keyStatement = this.configuration.getMappedStatement(id, false);
        SelectKeyGenerator answer = new SelectKeyGenerator(keyStatement, executeBefore);
        this.configuration.addKeyGenerator(id, (KeyGenerator)answer);
        return answer;
    }

    private SqlSource buildSqlSource(Annotation annotation, Class<?> parameterType, LanguageDriver languageDriver, Method method) {
        if (annotation instanceof Select) {
            return this.buildSqlSourceFromStrings(((Select)annotation).value(), parameterType, languageDriver);
        }
        if (annotation instanceof Update) {
            return this.buildSqlSourceFromStrings(((Update)annotation).value(), parameterType, languageDriver);
        }
        if (annotation instanceof Insert) {
            return this.buildSqlSourceFromStrings(((Insert)annotation).value(), parameterType, languageDriver);
        }
        if (annotation instanceof Delete) {
            return this.buildSqlSourceFromStrings(((Delete)annotation).value(), parameterType, languageDriver);
        }
        if (annotation instanceof SelectKey) {
            return this.buildSqlSourceFromStrings(((SelectKey)annotation).statement(), parameterType, languageDriver);
        }
        return new ProviderSqlSource(this.assistant.getConfiguration(), annotation, this.type, method);
    }

    private SqlSource buildSqlSourceFromStrings(String[] strings, Class<?> parameterTypeClass, LanguageDriver languageDriver) {
        return languageDriver.createSqlSource((Configuration)this.configuration, String.join((CharSequence)" ", strings).trim(), parameterTypeClass);
    }

    protected Class<?> getBeanType(Class<?> mapperClass) {
        if (!IMapper.class.isAssignableFrom(this.type)) {
            return null;
        }
        for (Type type : mapperClass.getGenericInterfaces()) {
            Type[] params;
            if (!(type instanceof ParameterizedType) || (params = ((ParameterizedType)type).getActualTypeArguments()).length == 0 || !(params[0] instanceof Class)) continue;
            return (Class)params[0];
        }
        return Object.class;
    }
}

