/*
 * Decompiled with CFR 0.152.
 */
package top.zephyrs.mybatis.semi.injects.methods;

import org.apache.ibatis.mapping.SqlCommandType;
import top.zephyrs.mybatis.semi.SemiMybatisConfiguration;
import top.zephyrs.mybatis.semi.injects.AbstractInjectMethod;
import top.zephyrs.mybatis.semi.metadata.ColumnInfo;
import top.zephyrs.mybatis.semi.metadata.TableInfo;

public class SelectAll
extends AbstractInjectMethod {
    @Override
    public String getId() {
        return "selectAll";
    }

    @Override
    public SqlCommandType getSqlCommandType() {
        return SqlCommandType.SELECT;
    }

    @Override
    public String buildSqlScript(SemiMybatisConfiguration configuration, Class<?> beanClass, Class<?> parameterTypeClass, TableInfo tableInfo) {
        String sqlTemplate;
        StringBuilder columnScript = new StringBuilder();
        for (ColumnInfo column : tableInfo.getColumns()) {
            if (!column.isSelect()) continue;
            columnScript.append(column.getColumnName()).append(", ");
        }
        String columns = columnScript.substring(0, columnScript.length() - 2);
        if (tableInfo.isLogical()) {
            sqlTemplate = "SELECT %s FROM %s WHERE %s=%s";
            return String.format(sqlTemplate, columns, tableInfo.getTableName(), tableInfo.getLogicalColumn().getColumnName(), tableInfo.getNoDeletedValue());
        }
        sqlTemplate = "SELECT %s FROM %s";
        return String.format(sqlTemplate, columns, tableInfo.getTableName());
    }
}

