/*
 * Decompiled with CFR 0.152.
 */
package top.zephyrs.mybatis.semi.plugins.sensitive;

import java.lang.reflect.Field;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.ibatis.executor.resultset.ResultSetHandler;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import top.zephyrs.mybatis.semi.SemiMybatisConfiguration;
import top.zephyrs.mybatis.semi.config.SensitiveConfig;
import top.zephyrs.mybatis.semi.exceptions.SensitiveException;
import top.zephyrs.mybatis.semi.executor.ResultSetHandlerWrapper;
import top.zephyrs.mybatis.semi.plugins.sensitive.ISensitive;
import top.zephyrs.mybatis.semi.plugins.sensitive.SensitiveHelper;

@Intercepts(value={@Signature(type=ResultSetHandler.class, method="handleResultSets", args={Statement.class})})
public class SensitiveDecryptInterceptor
implements Interceptor {
    private SensitiveConfig config;

    public SensitiveDecryptInterceptor(SensitiveConfig config) {
        this.config = config;
    }

    public Object intercept(Invocation invocation) throws Throwable {
        ResultSetHandlerWrapper resultSetHandler = (ResultSetHandlerWrapper)invocation.getTarget();
        MappedStatement mappedStatement = resultSetHandler.getMappedStatement();
        Object resultObject = invocation.proceed();
        if (Objects.isNull(resultObject)) {
            return null;
        }
        if (((List)resultObject).isEmpty()) {
            return resultObject;
        }
        SensitiveHelper.SensitiveBean sensitiveBean = SensitiveHelper.getSensitiveBean(this.config, ((List)resultObject).get(0));
        if (sensitiveBean == null) {
            return resultObject;
        }
        SemiMybatisConfiguration configuration = (SemiMybatisConfiguration)mappedStatement.getConfiguration();
        boolean needDecrypt = true;
        if (!configuration.isSensitiveDecrypt(mappedStatement.getId())) {
            needDecrypt = false;
        }
        try {
            for (Object result : (List)resultObject) {
                if (result instanceof Map) {
                    return resultObject;
                }
                for (Field field : sensitiveBean.getFields()) {
                    String original;
                    ISensitive sensitive = sensitiveBean.getSensitive(field);
                    if (sensitive == null) continue;
                    Object ciphertext = field.get(result);
                    if (!needDecrypt || sensitiveBean.isIgnore(field)) {
                        original = ciphertext == null ? null : sensitive.normal(result, String.valueOf(ciphertext));
                        field.set(result, original);
                        continue;
                    }
                    original = ciphertext == null ? null : sensitive.decrypt(result, String.valueOf(ciphertext));
                    field.set(result, original);
                }
            }
        }
        catch (Exception e) {
            throw new SensitiveException("Failed to decrypt result\uff1a" + e.getMessage(), e);
        }
        return resultObject;
    }

    public Object plugin(Object target) {
        if (target instanceof ResultSetHandlerWrapper) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }
}

