/*
 * Decompiled with CFR 0.152.
 */
package top.zephyrs.mybatis.semi.plugins.sensitive;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import top.zephyrs.mybatis.semi.annotations.Sensitive;
import top.zephyrs.mybatis.semi.config.SensitiveConfig;
import top.zephyrs.mybatis.semi.metadata.ReflectionUtils;
import top.zephyrs.mybatis.semi.plugins.sensitive.DefaultSensitive;
import top.zephyrs.mybatis.semi.plugins.sensitive.ISensitive;

public class SensitiveHelper {
    private static final Map<Class<? extends ISensitive>, ISensitive> sensitivesMap = new HashMap<Class<? extends ISensitive>, ISensitive>();
    private static final Map<Class<?>, SensitiveBean> sensitiveBeanMap = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SensitiveBean getSensitiveBean(SensitiveConfig config, Object obj) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        if (obj == null || obj instanceof String || obj instanceof Long || obj instanceof Integer || obj instanceof Short || obj instanceof Boolean || obj instanceof Character || obj instanceof Collection || obj instanceof Map) {
            return null;
        }
        Class<?> clazz = obj.getClass();
        SensitiveBean sensitiveBean = sensitiveBeanMap.get(clazz);
        if (sensitiveBean != null) return sensitiveBean;
        Class<SensitiveBean> clazz2 = SensitiveBean.class;
        synchronized (SensitiveBean.class) {
            sensitiveBean = sensitiveBeanMap.get(clazz);
            if (sensitiveBean != null) return sensitiveBean;
            List<Field> needSensitiveFields = SensitiveHelper.getNeedSensitiveFields(clazz);
            HashMap<Field, ISensitive> sensitiveMap = new HashMap<Field, ISensitive>();
            HashSet<Field> ignoreDecryptFieldSet = new HashSet<Field>();
            for (Field field : needSensitiveFields) {
                ISensitive sensitive;
                Class<? extends ISensitive> sensitiveClass;
                ReflectionUtils.makeAccessible(field);
                Sensitive annotation = field.getAnnotation(Sensitive.class);
                if (annotation == null) continue;
                if (!annotation.needDecrypt()) {
                    ignoreDecryptFieldSet.add(field);
                }
                if ((sensitiveClass = annotation.value()) == DefaultSensitive.class && config.getDefaultImpl() != null) {
                    sensitiveClass = config.getDefaultImpl();
                }
                if ((sensitive = sensitivesMap.get(sensitiveClass)) == null) {
                    sensitive = annotation.value().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    sensitivesMap.put(annotation.value(), sensitive);
                }
                sensitiveMap.put(field, sensitive);
            }
            sensitiveBean = new SensitiveBean(clazz, sensitiveMap, ignoreDecryptFieldSet);
            sensitiveBeanMap.put(clazz, sensitiveBean);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return sensitiveBean;
        }
    }

    private static List<Field> getNeedSensitiveFields(Class<?> type) {
        return ReflectionUtils.getAllFields(type).stream().filter(field -> field.getAnnotation(Sensitive.class) != null).collect(Collectors.toList());
    }

    public static class SensitiveBean {
        private final Class<?> clazz;
        private final Map<Field, ISensitive> sensitiveMap;
        private final Set<Field> ignoreDecryptSet;

        SensitiveBean(Class<?> clazz, Map<Field, ISensitive> sensitiveMap, Set<Field> ignoreDecryptSet) {
            this.clazz = clazz;
            this.sensitiveMap = sensitiveMap;
            this.ignoreDecryptSet = ignoreDecryptSet;
        }

        public Class<?> getSensitiveClass() {
            return this.clazz;
        }

        Collection<Field> getFields() {
            return this.sensitiveMap.keySet();
        }

        ISensitive getSensitive(Field field) {
            return this.sensitiveMap.get(field);
        }

        public boolean isIgnore(Field field) {
            return this.ignoreDecryptSet.contains(field);
        }
    }
}

