/*
 * Decompiled with CFR 0.152.
 */
package top.zephyrs.mybatis.semi.injects.methods;

import org.apache.ibatis.mapping.SqlCommandType;
import top.zephyrs.mybatis.semi.SemiMybatisConfiguration;
import top.zephyrs.mybatis.semi.injects.AbstractInjectMethod;
import top.zephyrs.mybatis.semi.metadata.ColumnInfo;
import top.zephyrs.mybatis.semi.metadata.MetaInfo;

public class Enable
extends AbstractInjectMethod {
    @Override
    public String getId() {
        return "enable";
    }

    @Override
    public SqlCommandType getSqlCommandType() {
        return SqlCommandType.UPDATE;
    }

    @Override
    public String buildSqlScript(SemiMybatisConfiguration configuration, MetaInfo metaInfo) {
        if (!metaInfo.isEnable()) {
            return "";
        }
        ColumnInfo primary = metaInfo.getPkColumn();
        if (primary == null) {
            return "";
        }
        String sqlTmpl = "UPDATE %s SET %s=%s WHERE %s";
        return String.format(sqlTmpl, metaInfo.getTableName(), metaInfo.getEnableColumn().getColumnName(), metaInfo.getEnabledValue(), primary.getColumnName() + "=#{id}");
    }
}

