/*
 * Decompiled with CFR 0.152.
 */
package top.zephyrs.mybatis.semi.injects.methods;

import org.apache.ibatis.mapping.SqlCommandType;
import top.zephyrs.mybatis.semi.SemiMybatisConfiguration;
import top.zephyrs.mybatis.semi.injects.AbstractInjectMethod;
import top.zephyrs.mybatis.semi.metadata.ColumnInfo;
import top.zephyrs.mybatis.semi.metadata.MetaInfo;

public class ToggleEnable
extends AbstractInjectMethod {
    @Override
    public String getId() {
        return "toggleEnable";
    }

    @Override
    public SqlCommandType getSqlCommandType() {
        return SqlCommandType.UPDATE;
    }

    @Override
    public String buildSqlScript(SemiMybatisConfiguration configuration, MetaInfo metaInfo) {
        if (!metaInfo.isEnable()) {
            return "";
        }
        ColumnInfo primary = metaInfo.getPkColumn();
        if (primary == null) {
            return "";
        }
        ColumnInfo enableColumn = metaInfo.getEnableColumn();
        String sqlTmpl = "UPDATE %s SET %s=CASE %s WHEN %s THEN %s ELSE %s END WHERE %s";
        return String.format(sqlTmpl, metaInfo.getTableName(), enableColumn.getColumnName(), enableColumn.getColumnName(), metaInfo.getEnabledValue(), metaInfo.getDisabledValue(), metaInfo.getEnabledValue(), primary.getColumnName() + "=#{id}");
    }
}

