/*
 * Decompiled with CFR 0.152.
 */
package top.zephyrs.mybatis.semi.injects.methods;

import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.type.UnknownTypeHandler;
import top.zephyrs.mybatis.semi.SemiMybatisConfiguration;
import top.zephyrs.mybatis.semi.injects.AbstractInjectMethod;
import top.zephyrs.mybatis.semi.metadata.ColumnInfo;
import top.zephyrs.mybatis.semi.metadata.MetaInfo;

public class UpdateById
extends AbstractInjectMethod {
    @Override
    public String getId() {
        return "updateById";
    }

    @Override
    public SqlCommandType getSqlCommandType() {
        return SqlCommandType.UPDATE;
    }

    @Override
    public String buildSqlScript(SemiMybatisConfiguration configuration, MetaInfo metaInfo) {
        ColumnInfo primary = metaInfo.getPkColumn();
        if (primary == null) {
            return null;
        }
        StringBuilder setScript = new StringBuilder("<set>");
        for (ColumnInfo column : metaInfo.getColumns()) {
            if (column.isPK() || !column.isExists() || !column.isUpdate()) continue;
            if (column.isIfNullUpdate()) {
                if (column.getTypeHandler() == null || column.getTypeHandler().equals(UnknownTypeHandler.class)) {
                    setScript.append(column.getColumnName()).append("=#{").append(column.getFieldName()).append("}, ");
                    continue;
                }
                setScript.append(column.getColumnName()).append("=#{").append(column.getFieldName()).append(", typeHandler=").append(column.getTypeHandler().getTypeName()).append("}, ");
                continue;
            }
            if (column.getTypeHandler() == null || column.getTypeHandler().equals(UnknownTypeHandler.class)) {
                setScript.append("<if test=\"").append(column.getFieldName()).append(" != null\">").append(column.getColumnName()).append("=#{").append(column.getFieldName()).append("}, </if>");
                continue;
            }
            setScript.append("<if test=\"").append(column.getFieldName()).append(" != null\">").append(column.getColumnName()).append("=#{").append(column.getFieldName()).append(", typeHandler=").append(column.getTypeHandler().getTypeName()).append("}, </if>");
        }
        setScript.append("</set>");
        String sqlTmpl = "<script>update %s %s where %s</script>";
        return String.format(sqlTmpl, metaInfo.getTableName(), setScript, primary.getColumnName() + "=#{" + primary.getFieldName() + "}");
    }
}

