/*
 * Decompiled with CFR 0.152.
 */
package top.zephyrs.mybatis.semi.metadata;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import top.zephyrs.mybatis.semi.exceptions.ReflectionException;

public class ReflectionUtils {
    public static List<Field> getAllFields(Class<?> type) {
        List<Field> fields = Arrays.stream(type.getDeclaredFields()).filter(field -> !Modifier.isStatic(field.getModifiers())).collect(Collectors.toList());
        Class<?> superClass = type.getSuperclass();
        if (superClass != null && !superClass.equals(Object.class)) {
            List<Field> superFields = ReflectionUtils.getAllFields(superClass);
            fields.addAll(superFields);
        }
        return fields;
    }

    public static List<Field> getProperty(Class<?> type) throws Exception {
        PropertyDescriptor[] propertyDescriptors;
        BeanInfo beanInfo = Introspector.getBeanInfo(type, Object.class);
        if (beanInfo == null) {
            return Collections.emptyList();
        }
        HashSet<String> propertyNameSet = new HashSet<String>();
        for (PropertyDescriptor descriptor : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
            propertyNameSet.add(descriptor.getName());
        }
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Field field : ReflectionUtils.getAllFields(type)) {
            fields.add(field);
            if (!propertyNameSet.contains(field.getName())) continue;
            fields.add(field);
        }
        return fields;
    }

    public static void makeAccessible(Field field) {
        if (!(Modifier.isPublic(field.getModifiers()) && Modifier.isPublic(field.getDeclaringClass().getModifiers()) && !Modifier.isFinal(field.getModifiers()) || field.isAccessible())) {
            field.setAccessible(true);
        }
    }

    public static Field findField(Class<?> clazz, String name) {
        try {
            return clazz.getDeclaredField(name);
        }
        catch (NoSuchFieldException e) {
            throw new ReflectionException(e);
        }
    }

    public static void setField(Field field, Object target, Object value) {
        try {
            field.set(target, value);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e);
        }
    }
}

