/*
 * Decompiled with CFR 0.152.
 */
package top.zephyrs.mybatis.semi.plugins.keygenerate;

import java.util.Collection;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import top.zephyrs.mybatis.semi.SemiMybatisConfiguration;
import top.zephyrs.mybatis.semi.metadata.MetaHelper;
import top.zephyrs.mybatis.semi.metadata.MetaInfo;
import top.zephyrs.mybatis.semi.plugins.keygenerate.KeyHelper;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class KeyGenerateInterceptor
implements Interceptor {
    private final SemiMybatisConfiguration configuration;

    public KeyGenerateInterceptor(SemiMybatisConfiguration configuration) {
        this.configuration = configuration;
    }

    public Object intercept(Invocation invocation) throws Throwable {
        MappedStatement mappedStatement = (MappedStatement)invocation.getArgs()[0];
        SqlCommandType sqlCommandType = mappedStatement.getSqlCommandType();
        if (sqlCommandType == SqlCommandType.INSERT) {
            Object parameter = invocation.getArgs()[1];
            if (parameter == null) {
                return invocation.proceed();
            }
            Class<?> type = parameter.getClass();
            if (parameter instanceof MapperMethod.ParamMap) {
                for (Object params : ((MapperMethod.ParamMap)parameter).values()) {
                    if (params instanceof Collection) {
                        ((Collection)params).forEach(item -> {
                            MetaInfo metaInfo = MetaHelper.getMetaInfo(item.getClass());
                            if (metaInfo != null) {
                                try {
                                    KeyHelper.setKey(this.configuration, item, metaInfo);
                                }
                                catch (IllegalAccessException e) {
                                    throw new RuntimeException(e);
                                }
                            }
                        });
                        continue;
                    }
                    MetaInfo metaInfo = MetaHelper.getMetaInfo(type);
                    if (metaInfo == null) continue;
                    KeyHelper.setKey(this.configuration, params, metaInfo);
                }
            } else if (parameter instanceof Collection) {
                ((Collection)parameter).forEach(item -> {
                    MetaInfo metaInfo = MetaHelper.getMetaInfo(item.getClass());
                    if (metaInfo != null) {
                        try {
                            KeyHelper.setKey(this.configuration, item, metaInfo);
                        }
                        catch (IllegalAccessException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
            } else {
                MetaInfo metaInfo = MetaHelper.getMetaInfo(type);
                if (metaInfo != null) {
                    KeyHelper.setKey(this.configuration, parameter, metaInfo);
                }
            }
        }
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        if (target instanceof Executor) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }
}

