/*
 * Decompiled with CFR 0.152.
 */
package top.zephyrs.mybatis.semi.plugins.typehandlers;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import top.zephyrs.mybatis.semi.plugins.typehandlers.AbstractJsonTypeHandler;

public class JsonTypeHandler
extends AbstractJsonTypeHandler {
    private static ObjectMapper mapper;

    public JsonTypeHandler(Class<?> type) {
        super(type);
    }

    public static ObjectMapper getObjectMapper() {
        if (null == mapper) {
            mapper = new ObjectMapper();
        }
        return mapper;
    }

    @Override
    public String toJson(Object obj) {
        try {
            return JsonTypeHandler.getObjectMapper().writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            this.log.error("serialize " + obj + " to json error ", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public Object fromJson(String json, Class<?> type) {
        ObjectMapper objectMapper = JsonTypeHandler.getObjectMapper();
        try {
            return objectMapper.readValue(json, type);
        }
        catch (JacksonException e) {
            this.log.error("deserialize json: " + json + " to " + type + " error ", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

