/*
 * Decompiled with CFR 0.152.
 */
package top.zgod.sqlupdatecheck;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;
import top.zgod.sqlupdatecheck.annotation.EnableSqlUpdateCheck;
import top.zgod.sqlupdatecheck.annotation.TableName;
import top.zgod.sqlupdatecheck.bean.ColumnBean;
import top.zgod.sqlupdatecheck.config.SqlUpdateCheckConfig;
import top.zgod.sqlupdatecheck.handler.JdbcDataHandler;
import top.zgod.sqlupdatecheck.handler.RemindHandler;
import top.zgod.sqlupdatecheck.type.AbstractTypeConvert;
import top.zgod.sqlupdatecheck.type.TypeConvert;

public class SqlUpdateCheck
implements ImportBeanDefinitionRegistrar,
ApplicationRunner {
    private static final Logger log = LoggerFactory.getLogger(SqlUpdateCheck.class);
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private SqlUpdateCheckConfig sqlUpdateCheckConfig;
    private boolean hasError;
    Map<String, List<TypeConvert>> typeParseMap;
    private static final int BEAN_TYPE_JAVA = 1;
    private static final int BEAN_TYPE_JDBC = 2;
    private Boolean isSystemExit;
    private List<String> excludeTableNames;
    private Boolean isCheckEntityByDataBase;
    private Boolean isCheckColumnType;
    private List<String> basePackages;
    private List<String> extraTypeParsePackages;
    private Class<? extends RemindHandler> remindHandler;
    private Class<? extends JdbcDataHandler> jdbcDataHandler;
    private Boolean enableTableName;
    private static final String REMIND_STR1 = "[\u8868\u521b\u5efasql\u672a\u63d0\u4ea4\u5f02\u5e38]\u8be5{}\u8868\u6ca1\u6709\u521b\u5efa\uff0c\u8bf7\u63d0\u4ea4\u521b\u5efa\u8868sql";
    private static final String REMIND_STR2 = "[\u5b57\u6bb5\u521b\u5efasql\u672a\u63d0\u4ea4\u5f02\u5e38]\u8be5{}\u8868\u7684{}\u5b57\u6bb5\u6ca1\u6709\u521b\u5efa\uff0c\u8bf7\u63d0\u4ea4\u521b\u5efa\u5b57\u6bb5sql";
    private static final String REMIND_STR3 = "[\u5b9e\u4f53\u7c7b\u672a\u521b\u5efa\u5f02\u5e38]\u8be5{}\u5b9e\u4f53\u7c7b\u6ca1\u6709\u521b\u5efa\uff0c\u8bf7\u6839\u636e\u6570\u636e\u5e93\u8868\u521b\u5efa\u597d\u76f8\u5e94\u5b9e\u4f53\u7c7b";
    private static final String REMIND_STR4 = "[\u5b9e\u4f53\u7c7b\u5b57\u6bb5\u672a\u521b\u5efa\u5f02\u5e38]\u8be5{}\u5b9e\u4f53\u7c7b\u7684{}\u5b57\u6bb5\u6ca1\u6709\u521b\u5efa\uff0c\u8bf7\u6839\u636e\u6570\u636e\u5e93\u8868\u521b\u5efa\u597d\u76f8\u5e94\u5b9e\u4f53\u7c7b\u5b57\u6bb5";
    private static final String REMIND_STR5 = "[\u5b57\u6bb5\u4e0d\u5339\u914d\u5f02\u5e38]\u8be5{}\u5b9e\u4f53\u7c7b\u4e0e{}\u8868\u7684\u5b57\u6bb5\uff1a{}\u5bf9\u5e94\u5173\u7cfb\u4e0d\u5339\u914d\uff0c\u8bf7\u63d0\u4ea4sql\u6216\u68c0\u67e5\u597d\u5bf9\u5e94\u5173\u7cfb";
    private List<String> remindStrList = new ArrayList<String>();

    private SqlUpdateCheck() {
    }

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        AnnotationAttributes mapperScanAttrs = AnnotationAttributes.fromMap((Map)importingClassMetadata.getAnnotationAttributes(EnableSqlUpdateCheck.class.getName()));
        if (mapperScanAttrs != null) {
            ArrayList basePackages = new ArrayList();
            ArrayList excludeTableNames = new ArrayList();
            ArrayList extraTypeParsePackages = new ArrayList();
            basePackages.addAll(Arrays.stream(mapperScanAttrs.getStringArray("value")).filter(StringUtils::hasText).collect(Collectors.toList()));
            basePackages.addAll(Arrays.stream(mapperScanAttrs.getStringArray("basePackages")).filter(StringUtils::hasText).collect(Collectors.toList()));
            extraTypeParsePackages.addAll(Arrays.stream(mapperScanAttrs.getStringArray("extraTypeParsePackages")).filter(StringUtils::hasText).collect(Collectors.toList()));
            if (CollectionUtils.isEmpty(basePackages)) {
                throw new NullPointerException("basePackages must not be null!");
            }
            excludeTableNames.addAll(Arrays.stream(mapperScanAttrs.getStringArray("excludeTableNames")).filter(StringUtils::hasText).collect(Collectors.toList()));
            Boolean isCheckEntityByDataBase = mapperScanAttrs.getBoolean("isCheckEntityByDB");
            Boolean isCheckColumnType = mapperScanAttrs.getBoolean("isCheckColumnType");
            Boolean isSystemExit = mapperScanAttrs.getBoolean("isSystemExit");
            Boolean enableTableName = mapperScanAttrs.getBoolean("enableTableName");
            Class remindHandler = mapperScanAttrs.getClass("remindHandler");
            Class jdbcDataHandler = mapperScanAttrs.getClass("jdbcDataHandler");
            GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
            beanDefinition.setBeanClassName(SqlUpdateCheck.class.getName());
            MutablePropertyValues values = beanDefinition.getPropertyValues();
            values.addPropertyValue("basePackages", basePackages);
            values.addPropertyValue("excludeTableNames", excludeTableNames);
            values.addPropertyValue("isCheckEntityByDataBase", (Object)isCheckEntityByDataBase);
            values.addPropertyValue("isCheckColumnType", (Object)isCheckColumnType);
            values.addPropertyValue("isSystemExit", (Object)isSystemExit);
            values.addPropertyValue("enableTableName", (Object)enableTableName);
            values.addPropertyValue("extraTypeParsePackages", extraTypeParsePackages);
            values.addPropertyValue("remindHandler", (Object)remindHandler);
            values.addPropertyValue("jdbcDataHandler", (Object)jdbcDataHandler);
            registry.registerBeanDefinition("sqlUpdateCheck", (BeanDefinition)beanDefinition);
        }
    }

    public Map<String, List<TypeConvert>> registerTypeParseMap() throws IllegalAccessException, InstantiationException {
        String name = AbstractTypeConvert.class.getPackage().getName();
        List<Class<?>> classes = this.getClasses(name + ".impl", 2);
        if (!CollectionUtils.isEmpty(this.extraTypeParsePackages)) {
            for (String extraTypeParsePackage : this.extraTypeParsePackages) {
                classes.addAll(this.getClasses(extraTypeParsePackage, 2));
            }
        }
        ArrayList<AbstractTypeConvert> typePars = new ArrayList<AbstractTypeConvert>();
        for (Class<?> aClass : classes) {
            AbstractTypeConvert abstractTypeConvert = (AbstractTypeConvert)aClass.newInstance();
            abstractTypeConvert.checkJavaColumnTypeName();
            abstractTypeConvert.checkJdbcColumnTypeName();
            typePars.add(abstractTypeConvert);
        }
        return typePars.stream().collect(Collectors.groupingBy(TypeConvert::getInitJdbcColumnTypeName));
    }

    public void check() throws InstantiationException, IllegalAccessException {
        Boolean enabledScan = this.sqlUpdateCheckConfig.getEnabledScan();
        if (!enabledScan.booleanValue()) {
            return;
        }
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        this.typeParseMap = this.registerTypeParseMap();
        HashMap<String, List<ColumnBean>> dbBeanMap = this.getJdbcBeanMap();
        HashMap<String, List<ColumnBean>> entityBeanMap = this.getEntityBeanMap();
        HashMap<String, List<ColumnBean>> columnTypeDifferentMap = new HashMap<String, List<ColumnBean>>(8);
        HashMap<String, List<ColumnBean>> withoutTableOrColumnMap = this.getVacancyBeanMap(dbBeanMap, entityBeanMap, columnTypeDifferentMap);
        this.remind(true, withoutTableOrColumnMap, REMIND_STR1, REMIND_STR2);
        HashMap<String, List<ColumnBean>> withoutEntityOrPropertyMap = new HashMap(8);
        if (this.isCheckEntityByDataBase.booleanValue()) {
            withoutEntityOrPropertyMap = this.getVacancyBeanMap(entityBeanMap, dbBeanMap, columnTypeDifferentMap);
            this.remind(false, withoutEntityOrPropertyMap, REMIND_STR3, REMIND_STR4);
        }
        this.remindTypeNotFit(columnTypeDifferentMap);
        stopWatch.stop();
        log.info("SqlUpdateCheck\u626b\u63cf\u65f6\u95f4\u6beb\u79d2\u503c\uff1a{}", (Object)stopWatch.getTotalTimeMillis());
        if (this.hasError) {
            log.error("\u76d1\u6d4b\u5230\u60a8\u7684\u6570\u636e\u5e93\u5b9e\u4f53\u7c7b\u548c\u6570\u636e\u5e93\u4e0d\u5339\u914d\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\uff01");
            this.notifyUser(withoutTableOrColumnMap, withoutEntityOrPropertyMap, columnTypeDifferentMap);
            if (this.isSystemExit.booleanValue()) {
                log.error("\u5373\u5c06\u5173\u95ed\u7cfb\u7edf\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002");
                System.exit(-1);
            }
        }
    }

    private void remindTypeNotFit(HashMap<String, List<ColumnBean>> columnTypeDifferentMap) {
        if (!columnTypeDifferentMap.isEmpty()) {
            this.hasError = true;
            columnTypeDifferentMap.forEach((tableName, columnBeans) -> {
                StringBuilder reminds = new StringBuilder();
                String className = "";
                for (ColumnBean columnBean : columnBeans) {
                    reminds.append(columnBean.getJavaColumnName()).append("(").append(columnBean.getJavaColumnType()).append(")").append("\u4e0e").append(columnBean.getJdbcColumnName()).append("(").append(columnBean.getJdbcColumnType()).append(")").append(",");
                    className = columnBean.getClassName();
                }
                String replace1 = REMIND_STR5.replaceFirst("\\{}", className);
                String replace2 = replace1.replaceFirst("\\{}", (String)tableName);
                String replace3 = replace2.replace("{}", reminds.toString());
                this.remindStrList.add(replace3);
                log.error(replace3);
            });
        }
    }

    private void notifyUser(HashMap<String, List<ColumnBean>> withoutTableOrColumnMap, HashMap<String, List<ColumnBean>> withoutEntityOrPropertyMap, HashMap<String, List<ColumnBean>> columnTypeDifferentMap) {
        ObjectProvider beanProvider = this.applicationContext.getBeanProvider(this.remindHandler);
        RemindHandler remindHandlerBean = (RemindHandler)beanProvider.getIfAvailable();
        if (remindHandlerBean == null) {
            String name = this.remindHandler.getName();
            throw new RuntimeException("\u63d0\u9192\u7c7b\u9519\u8bef\uff01\u8bf7\u5c06\u540d\u79f0\u4e3a" + name + "\u7684\u8be5\u7c7b\u6dfb\u52a0\u4e0a@Component\u6216\u653e\u5230spring\u5bb9\u5668\u4e2d!");
        }
        remindHandlerBean.remindContainer(withoutTableOrColumnMap, withoutEntityOrPropertyMap, columnTypeDifferentMap);
        remindHandlerBean.remindMessage(this.remindStrList);
    }

    private HashMap<String, List<ColumnBean>> getVacancyBeanMap(HashMap<String, List<ColumnBean>> beanMap1, HashMap<String, List<ColumnBean>> beanMap2, HashMap<String, List<ColumnBean>> columnTypeDifferentMap) {
        HashMap<String, List<ColumnBean>> vacancyEntityBeanMap = new HashMap<String, List<ColumnBean>>(8);
        beanMap2.forEach((tableName1, columnBeans1) -> {
            AtomicBoolean hasTable = new AtomicBoolean(false);
            beanMap1.forEach((tableName2, columnBeans2) -> {
                if (tableName1.equals(tableName2)) {
                    hasTable.set(true);
                    for (ColumnBean columnBean1 : columnBeans1) {
                        List<ColumnBean> columnBeans;
                        boolean hasColumn = false;
                        String columnName1 = columnBean1.getJavaColumnName();
                        for (ColumnBean columnBean2 : columnBeans2) {
                            String columnName2 = columnBean2.getJavaColumnName();
                            if (!columnName1.equals(columnName2)) continue;
                            hasColumn = true;
                            this.matchColumnType(columnTypeDifferentMap, (String)tableName1, columnBean1, columnBean2);
                            break;
                        }
                        if (hasColumn) continue;
                        ColumnBean targetColumnBean1 = new ColumnBean();
                        BeanUtils.copyProperties((Object)columnBean1, (Object)targetColumnBean1);
                        if (vacancyEntityBeanMap.containsKey(tableName1)) {
                            columnBeans = (List)vacancyEntityBeanMap.get(tableName1);
                            columnBeans.add(targetColumnBean1);
                            continue;
                        }
                        columnBeans = new ArrayList();
                        columnBeans.add(targetColumnBean1);
                        vacancyEntityBeanMap.put((String)tableName1, columnBeans);
                    }
                }
            });
            if (!hasTable.get()) {
                vacancyEntityBeanMap.put((String)tableName1, new ArrayList());
            }
        });
        return vacancyEntityBeanMap;
    }

    private void matchColumnType(HashMap<String, List<ColumnBean>> columnTypeDifferentMap, String tableName1, ColumnBean columnBean1, ColumnBean columnBean2) {
        if (this.isCheckColumnType.booleanValue()) {
            String jdbcColumnType;
            String javaColumnType;
            boolean notFit;
            int beanType1 = columnBean1.getBeanType();
            int beanType2 = columnBean2.getBeanType();
            if (beanType1 == 1 && beanType2 == 2 && (notFit = this.compareFit(javaColumnType = columnBean1.getJavaColumnType(), jdbcColumnType = columnBean2.getJdbcColumnType()))) {
                ColumnBean columnBean = ColumnBean.builder().className(columnBean1.getClassName()).tableName(columnBean1.getTableName()).javaColumnType(columnBean1.getJavaColumnType()).javaColumnName(columnBean1.getJavaColumnName()).jdbcColumnType(columnBean2.getJdbcColumnType()).jdbcColumnName(columnBean2.getJdbcColumnName()).build();
                if (columnTypeDifferentMap.containsKey(tableName1)) {
                    List<ColumnBean> columnBeans = columnTypeDifferentMap.get(tableName1);
                    columnBeans.add(columnBean);
                } else {
                    ArrayList<ColumnBean> columnBeans = new ArrayList<ColumnBean>();
                    columnBeans.add(columnBean);
                    columnTypeDifferentMap.put(tableName1, columnBeans);
                }
            }
        }
    }

    private boolean compareFit(String javaColumnType, String jdbcColumnType) {
        AtomicBoolean notFit = new AtomicBoolean(true);
        this.typeParseMap.forEach((jdbcTypeName, typeParses) -> {
            if (!StringUtils.isEmpty((Object)jdbcColumnType) && jdbcColumnType.equals(jdbcTypeName.toLowerCase())) {
                for (TypeConvert typePars : typeParses) {
                    String initJavaColumnType = typePars.getInitJavaColumnTypeName();
                    if (!javaColumnType.equals(initJavaColumnType)) continue;
                    notFit.set(false);
                    break;
                }
            }
        });
        return notFit.get();
    }

    private HashMap<String, List<ColumnBean>> getEntityBeanMap() {
        HashMap<String, List<ColumnBean>> columnBeanMap = new HashMap<String, List<ColumnBean>>(32);
        for (String basePackage : this.basePackages) {
            List<Class<?>> typesAnnotatedWith = this.getClasses(basePackage, 1);
            for (Class<?> aClass : typesAnnotatedWith) {
                ArrayList<ColumnBean> columnBeans = new ArrayList<ColumnBean>();
                ColumnBean columnBean = this.getColumnBean(aClass);
                String tableName = columnBean.getTableName();
                String className = columnBean.getClassName();
                List<Class<?>> superClasses = this.getSuperClass(aClass);
                for (Class<?> superClass : superClasses) {
                    this.getProperty(columnBeans, tableName, className, superClass);
                }
                this.getProperty(columnBeans, tableName, className, aClass);
                columnBeanMap.put(tableName, columnBeans);
            }
        }
        return columnBeanMap;
    }

    private HashMap<String, List<ColumnBean>> getJdbcBeanMap() {
        ObjectProvider beanProvider = this.applicationContext.getBeanProvider(this.jdbcDataHandler);
        JdbcDataHandler jdbcDataHandlerBean = (JdbcDataHandler)beanProvider.getIfAvailable();
        if (jdbcDataHandlerBean == null) {
            String name = this.remindHandler.getName();
            throw new RuntimeException("\u6570\u636e\u5e93\u6570\u636e\u7c7b\u9519\u8bef\uff01\u8bf7\u5c06\u540d\u79f0\u4e3a" + name + "\u7684\u8be5\u7c7b\u6dfb\u52a0\u4e0a@Component\u6216\u653e\u5230spring\u5bb9\u5668\u4e2d,\u6216\u8005\u4f7f\u7528\u9ed8\u8ba4\u5b9e\u73b0\u7c7b!");
        }
        List<Map<String, Object>> dbInfo = jdbcDataHandlerBean.getJdbcData();
        if (dbInfo.isEmpty()) {
            throw new RuntimeException("\u83b7\u53d6\u6570\u636e\u5e93\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        HashMap<String, List<ColumnBean>> dbColumnBeanMap = new HashMap<String, List<ColumnBean>>(32);
        block0: for (Map<String, Object> stringObjectMap : dbInfo) {
            List<Object> columnBeans;
            String tableName = stringObjectMap.get("TABLE_NAME").toString();
            String columnName = stringObjectMap.get("COLUMN_NAME").toString();
            String dataType = stringObjectMap.get("DATA_TYPE").toString();
            for (String excludeTableName : this.excludeTableNames) {
                if (!excludeTableName.equals(tableName)) continue;
                continue block0;
            }
            ColumnBean columnBean = ColumnBean.builder().beanType(2).javaColumnName(this.underlineToHump(columnName)).jdbcColumnType(dataType).tableName(tableName).jdbcColumnName(columnName).build();
            if (!dbColumnBeanMap.containsKey(tableName)) {
                columnBeans = new ArrayList<ColumnBean>();
                columnBeans.add(columnBean);
                dbColumnBeanMap.put(tableName, columnBeans);
                continue;
            }
            columnBeans = dbColumnBeanMap.get(tableName);
            columnBeans.add(columnBean);
        }
        return dbColumnBeanMap;
    }

    private void getProperty(List<ColumnBean> columnBeans, String tableName, String className, Class<?> superClass) {
        Field[] declaredFields;
        for (Field declaredField : declaredFields = superClass.getDeclaredFields()) {
            String columnName = declaredField.getName();
            if ("serialVersionUID".equals(columnName)) continue;
            Class<?> type = declaredField.getType();
            String columnType = type.getName();
            for (int i = columnBeans.size() - 1; i > -1; --i) {
                ColumnBean columnBean = columnBeans.get(i);
                if (!columnBean.getJavaColumnName().equals(columnName)) continue;
                columnBeans.remove(i);
            }
            columnBeans.add(ColumnBean.builder().beanType(1).javaColumnName(columnName).javaColumnType(columnType).tableName(tableName).className(className).build());
        }
    }

    private String underlineToHump(String inputString) {
        StringBuilder sb = new StringBuilder();
        boolean nextUpperCase = false;
        for (int i = 0; i < inputString.length(); ++i) {
            char c = inputString.charAt(i);
            if (c == '_') {
                if (sb.length() <= 0) continue;
                nextUpperCase = true;
                continue;
            }
            if (nextUpperCase) {
                sb.append(Character.toUpperCase(c));
                nextUpperCase = false;
                continue;
            }
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString();
    }

    public ColumnBean getColumnBean(Class<?> clazz) {
        String tableName;
        String className = clazz.getSimpleName();
        if (this.enableTableName.booleanValue()) {
            com.baomidou.mybatisplus.annotation.TableName annotation1 = clazz.getAnnotation(com.baomidou.mybatisplus.annotation.TableName.class);
            if (annotation1 != null) {
                tableName = annotation1.value();
            } else {
                TableName annotation2 = clazz.getAnnotation(TableName.class);
                tableName = annotation2.value();
            }
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            char[] ch = className.toCharArray();
            for (int i = 0; i < ch.length; ++i) {
                if (ch[i] >= 'A' && ch[i] <= 'Z') {
                    String ch1 = String.valueOf(ch[i]).toLowerCase();
                    if (i == 0) {
                        stringBuilder.append(ch1);
                        continue;
                    }
                    stringBuilder.append("_").append(ch1);
                    continue;
                }
                stringBuilder.append(ch[i]);
            }
            tableName = stringBuilder.toString();
        }
        return ColumnBean.builder().beanType(1).tableName(tableName).className(className).build();
    }

    public List<Class<?>> getSuperClass(Class<?> clazz) {
        ArrayList clazzs = new ArrayList();
        for (Class<?> suCl = clazz.getSuperclass(); suCl != null; suCl = suCl.getSuperclass()) {
            clazzs.add(suCl);
        }
        return clazzs;
    }

    public static String upperCaseFirst(String str) {
        char[] cs = str.toCharArray();
        cs[0] = (char)(cs[0] - 32);
        return String.valueOf(cs);
    }

    private void remind(boolean isCheckJdbc, HashMap<String, List<ColumnBean>> vacancyEntityBeanMap, String remind1, String remind2) {
        vacancyEntityBeanMap.forEach((tableName, columnBeans) -> {
            String tableOrEntityName;
            String string = tableOrEntityName = isCheckJdbc ? tableName : SqlUpdateCheck.upperCaseFirst(this.underlineToHump((String)tableName));
            if (CollectionUtils.isEmpty((Collection)columnBeans)) {
                this.hasError = true;
                String replace1 = remind1.replace("{}", tableOrEntityName);
                this.remindStrList.add(replace1);
                log.error(replace1);
            } else {
                StringBuilder columnNames = new StringBuilder();
                for (ColumnBean columnBean : columnBeans) {
                    String columnName = columnBean.getJavaColumnName();
                    columnNames.append(columnName).append(",");
                    this.hasError = true;
                }
                String replace2 = remind2.replaceFirst("\\{}", tableOrEntityName).replace("{}", columnNames.substring(0, columnNames.length() - 1));
                this.remindStrList.add(replace2);
                log.error(replace2);
            }
        });
    }

    public void run(ApplicationArguments args) throws IllegalAccessException, InstantiationException {
        this.check();
    }

    public List<Class<?>> getClasses(String packageName, int type) {
        ArrayList classes = new ArrayList();
        boolean recursive = true;
        String packageDirName = packageName.replace('.', '/');
        try {
            Enumeration<URL> dirs = Thread.currentThread().getContextClassLoader().getResources(packageDirName);
            while (dirs.hasMoreElements()) {
                URL url = dirs.nextElement();
                String protocol = url.getProtocol();
                if ("file".equals(protocol)) {
                    String filePath = URLDecoder.decode(url.getFile(), "UTF-8");
                    this.findAndAddClassesInPackageByFile(packageName, filePath, recursive, classes, type);
                    continue;
                }
                if (!"jar".equals(protocol)) continue;
                try {
                    JarFile jar = ((JarURLConnection)url.openConnection()).getJarFile();
                    Enumeration<JarEntry> entries = jar.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        String name = entry.getName();
                        if (name.charAt(0) == '/') {
                            name = name.substring(1);
                        }
                        if (!name.startsWith(packageDirName)) continue;
                        int idx = name.lastIndexOf(47);
                        if (idx != -1) {
                            packageName = name.substring(0, idx).replace('/', '.');
                        }
                        if (idx == -1 && !recursive || !name.endsWith(".class") || entry.isDirectory()) continue;
                        String className = name.substring(packageName.length() + 1, name.length() - 6);
                        try {
                            this.getTargetClasses(packageName, classes, className, type);
                        }
                        catch (ClassNotFoundException e) {
                            e.printStackTrace();
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return classes;
    }

    public void findAndAddClassesInPackageByFile(String packageName, String packagePath, boolean recursive, List<Class<?>> classes, int type) {
        File dir = new File(packagePath);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        File[] dirFiles = dir.listFiles(file -> recursive && file.isDirectory() || file.getName().endsWith(".class"));
        assert (dirFiles != null);
        for (File file2 : dirFiles) {
            if (file2.isDirectory()) {
                this.findAndAddClassesInPackageByFile(packageName + "." + file2.getName(), file2.getAbsolutePath(), recursive, classes, type);
                continue;
            }
            String className = file2.getName().substring(0, file2.getName().length() - 6);
            try {
                this.getTargetClasses(packageName, classes, className, type);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    private void getTargetClasses(String packageName, List<Class<?>> classes, String className, int type) throws ClassNotFoundException {
        Class<?> aClass = Class.forName(packageName + '.' + className);
        if (type == 1) {
            if (this.enableTableName.booleanValue()) {
                com.baomidou.mybatisplus.annotation.TableName annotation = aClass.getAnnotation(com.baomidou.mybatisplus.annotation.TableName.class);
                if (annotation != null) {
                    classes.add(aClass);
                } else {
                    TableName annotation1 = aClass.getAnnotation(TableName.class);
                    if (annotation1 != null) {
                        classes.add(aClass);
                    }
                }
            } else {
                classes.add(aClass);
            }
        } else if (type == 2) {
            Class<?> superclass = aClass.getSuperclass();
            Deprecated annotation = aClass.getAnnotation(Deprecated.class);
            if (superclass.getName().equals(AbstractTypeConvert.class.getName()) && annotation == null) {
                classes.add(aClass);
            }
        }
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public SqlUpdateCheckConfig getSqlUpdateCheckConfig() {
        return this.sqlUpdateCheckConfig;
    }

    public boolean isHasError() {
        return this.hasError;
    }

    public Map<String, List<TypeConvert>> getTypeParseMap() {
        return this.typeParseMap;
    }

    public Boolean getIsSystemExit() {
        return this.isSystemExit;
    }

    public List<String> getExcludeTableNames() {
        return this.excludeTableNames;
    }

    public Boolean getIsCheckEntityByDataBase() {
        return this.isCheckEntityByDataBase;
    }

    public Boolean getIsCheckColumnType() {
        return this.isCheckColumnType;
    }

    public List<String> getBasePackages() {
        return this.basePackages;
    }

    public List<String> getExtraTypeParsePackages() {
        return this.extraTypeParsePackages;
    }

    public Class<? extends RemindHandler> getRemindHandler() {
        return this.remindHandler;
    }

    public Class<? extends JdbcDataHandler> getJdbcDataHandler() {
        return this.jdbcDataHandler;
    }

    public Boolean getEnableTableName() {
        return this.enableTableName;
    }

    public List<String> getRemindStrList() {
        return this.remindStrList;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setSqlUpdateCheckConfig(SqlUpdateCheckConfig sqlUpdateCheckConfig) {
        this.sqlUpdateCheckConfig = sqlUpdateCheckConfig;
    }

    public void setHasError(boolean hasError) {
        this.hasError = hasError;
    }

    public void setTypeParseMap(Map<String, List<TypeConvert>> typeParseMap) {
        this.typeParseMap = typeParseMap;
    }

    public void setIsSystemExit(Boolean isSystemExit) {
        this.isSystemExit = isSystemExit;
    }

    public void setExcludeTableNames(List<String> excludeTableNames) {
        this.excludeTableNames = excludeTableNames;
    }

    public void setIsCheckEntityByDataBase(Boolean isCheckEntityByDataBase) {
        this.isCheckEntityByDataBase = isCheckEntityByDataBase;
    }

    public void setIsCheckColumnType(Boolean isCheckColumnType) {
        this.isCheckColumnType = isCheckColumnType;
    }

    public void setBasePackages(List<String> basePackages) {
        this.basePackages = basePackages;
    }

    public void setExtraTypeParsePackages(List<String> extraTypeParsePackages) {
        this.extraTypeParsePackages = extraTypeParsePackages;
    }

    public void setRemindHandler(Class<? extends RemindHandler> remindHandler) {
        this.remindHandler = remindHandler;
    }

    public void setJdbcDataHandler(Class<? extends JdbcDataHandler> jdbcDataHandler) {
        this.jdbcDataHandler = jdbcDataHandler;
    }

    public void setEnableTableName(Boolean enableTableName) {
        this.enableTableName = enableTableName;
    }

    public void setRemindStrList(List<String> remindStrList) {
        this.remindStrList = remindStrList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SqlUpdateCheck)) {
            return false;
        }
        SqlUpdateCheck other = (SqlUpdateCheck)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ApplicationContext this$applicationContext = this.getApplicationContext();
        ApplicationContext other$applicationContext = other.getApplicationContext();
        if (this$applicationContext == null ? other$applicationContext != null : !this$applicationContext.equals(other$applicationContext)) {
            return false;
        }
        SqlUpdateCheckConfig this$sqlUpdateCheckConfig = this.getSqlUpdateCheckConfig();
        SqlUpdateCheckConfig other$sqlUpdateCheckConfig = other.getSqlUpdateCheckConfig();
        if (this$sqlUpdateCheckConfig == null ? other$sqlUpdateCheckConfig != null : !this$sqlUpdateCheckConfig.equals(other$sqlUpdateCheckConfig)) {
            return false;
        }
        if (this.isHasError() != other.isHasError()) {
            return false;
        }
        Map<String, List<TypeConvert>> this$typeParseMap = this.getTypeParseMap();
        Map<String, List<TypeConvert>> other$typeParseMap = other.getTypeParseMap();
        if (this$typeParseMap == null ? other$typeParseMap != null : !((Object)this$typeParseMap).equals(other$typeParseMap)) {
            return false;
        }
        Boolean this$isSystemExit = this.getIsSystemExit();
        Boolean other$isSystemExit = other.getIsSystemExit();
        if (this$isSystemExit == null ? other$isSystemExit != null : !((Object)this$isSystemExit).equals(other$isSystemExit)) {
            return false;
        }
        List<String> this$excludeTableNames = this.getExcludeTableNames();
        List<String> other$excludeTableNames = other.getExcludeTableNames();
        if (this$excludeTableNames == null ? other$excludeTableNames != null : !((Object)this$excludeTableNames).equals(other$excludeTableNames)) {
            return false;
        }
        Boolean this$isCheckEntityByDataBase = this.getIsCheckEntityByDataBase();
        Boolean other$isCheckEntityByDataBase = other.getIsCheckEntityByDataBase();
        if (this$isCheckEntityByDataBase == null ? other$isCheckEntityByDataBase != null : !((Object)this$isCheckEntityByDataBase).equals(other$isCheckEntityByDataBase)) {
            return false;
        }
        Boolean this$isCheckColumnType = this.getIsCheckColumnType();
        Boolean other$isCheckColumnType = other.getIsCheckColumnType();
        if (this$isCheckColumnType == null ? other$isCheckColumnType != null : !((Object)this$isCheckColumnType).equals(other$isCheckColumnType)) {
            return false;
        }
        List<String> this$basePackages = this.getBasePackages();
        List<String> other$basePackages = other.getBasePackages();
        if (this$basePackages == null ? other$basePackages != null : !((Object)this$basePackages).equals(other$basePackages)) {
            return false;
        }
        List<String> this$extraTypeParsePackages = this.getExtraTypeParsePackages();
        List<String> other$extraTypeParsePackages = other.getExtraTypeParsePackages();
        if (this$extraTypeParsePackages == null ? other$extraTypeParsePackages != null : !((Object)this$extraTypeParsePackages).equals(other$extraTypeParsePackages)) {
            return false;
        }
        Class<? extends RemindHandler> this$remindHandler = this.getRemindHandler();
        Class<? extends RemindHandler> other$remindHandler = other.getRemindHandler();
        if (this$remindHandler == null ? other$remindHandler != null : !this$remindHandler.equals(other$remindHandler)) {
            return false;
        }
        Class<? extends JdbcDataHandler> this$jdbcDataHandler = this.getJdbcDataHandler();
        Class<? extends JdbcDataHandler> other$jdbcDataHandler = other.getJdbcDataHandler();
        if (this$jdbcDataHandler == null ? other$jdbcDataHandler != null : !this$jdbcDataHandler.equals(other$jdbcDataHandler)) {
            return false;
        }
        Boolean this$enableTableName = this.getEnableTableName();
        Boolean other$enableTableName = other.getEnableTableName();
        if (this$enableTableName == null ? other$enableTableName != null : !((Object)this$enableTableName).equals(other$enableTableName)) {
            return false;
        }
        List<String> this$remindStrList = this.getRemindStrList();
        List<String> other$remindStrList = other.getRemindStrList();
        return !(this$remindStrList == null ? other$remindStrList != null : !((Object)this$remindStrList).equals(other$remindStrList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SqlUpdateCheck;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ApplicationContext $applicationContext = this.getApplicationContext();
        result = result * 59 + ($applicationContext == null ? 43 : $applicationContext.hashCode());
        SqlUpdateCheckConfig $sqlUpdateCheckConfig = this.getSqlUpdateCheckConfig();
        result = result * 59 + ($sqlUpdateCheckConfig == null ? 43 : $sqlUpdateCheckConfig.hashCode());
        result = result * 59 + (this.isHasError() ? 79 : 97);
        Map<String, List<TypeConvert>> $typeParseMap = this.getTypeParseMap();
        result = result * 59 + ($typeParseMap == null ? 43 : ((Object)$typeParseMap).hashCode());
        Boolean $isSystemExit = this.getIsSystemExit();
        result = result * 59 + ($isSystemExit == null ? 43 : ((Object)$isSystemExit).hashCode());
        List<String> $excludeTableNames = this.getExcludeTableNames();
        result = result * 59 + ($excludeTableNames == null ? 43 : ((Object)$excludeTableNames).hashCode());
        Boolean $isCheckEntityByDataBase = this.getIsCheckEntityByDataBase();
        result = result * 59 + ($isCheckEntityByDataBase == null ? 43 : ((Object)$isCheckEntityByDataBase).hashCode());
        Boolean $isCheckColumnType = this.getIsCheckColumnType();
        result = result * 59 + ($isCheckColumnType == null ? 43 : ((Object)$isCheckColumnType).hashCode());
        List<String> $basePackages = this.getBasePackages();
        result = result * 59 + ($basePackages == null ? 43 : ((Object)$basePackages).hashCode());
        List<String> $extraTypeParsePackages = this.getExtraTypeParsePackages();
        result = result * 59 + ($extraTypeParsePackages == null ? 43 : ((Object)$extraTypeParsePackages).hashCode());
        Class<? extends RemindHandler> $remindHandler = this.getRemindHandler();
        result = result * 59 + ($remindHandler == null ? 43 : $remindHandler.hashCode());
        Class<? extends JdbcDataHandler> $jdbcDataHandler = this.getJdbcDataHandler();
        result = result * 59 + ($jdbcDataHandler == null ? 43 : $jdbcDataHandler.hashCode());
        Boolean $enableTableName = this.getEnableTableName();
        result = result * 59 + ($enableTableName == null ? 43 : ((Object)$enableTableName).hashCode());
        List<String> $remindStrList = this.getRemindStrList();
        result = result * 59 + ($remindStrList == null ? 43 : ((Object)$remindStrList).hashCode());
        return result;
    }

    public String toString() {
        return "SqlUpdateCheck(applicationContext=" + this.getApplicationContext() + ", sqlUpdateCheckConfig=" + this.getSqlUpdateCheckConfig() + ", hasError=" + this.isHasError() + ", typeParseMap=" + this.getTypeParseMap() + ", isSystemExit=" + this.getIsSystemExit() + ", excludeTableNames=" + this.getExcludeTableNames() + ", isCheckEntityByDataBase=" + this.getIsCheckEntityByDataBase() + ", isCheckColumnType=" + this.getIsCheckColumnType() + ", basePackages=" + this.getBasePackages() + ", extraTypeParsePackages=" + this.getExtraTypeParsePackages() + ", remindHandler=" + this.getRemindHandler() + ", jdbcDataHandler=" + this.getJdbcDataHandler() + ", enableTableName=" + this.getEnableTableName() + ", remindStrList=" + this.getRemindStrList() + ")";
    }
}

