/*
 * Decompiled with CFR 0.152.
 */
package top.zgod.sqlupdatecheck.bean;

import java.sql.JDBCType;
import java.util.HashMap;
import java.util.Map;

public enum JdbcType {
    NULL(0),
    OTHER(1111),
    CURSOR(-10),
    UNDEFINED(-2147482648),
    STRUCT(2002),
    JAVA_OBJECT(2000),
    DISTINCT(2001),
    REF(2006),
    DATALINK(70),
    ROWID(-8),
    SQLXML(2009),
    DATETIMEOFFSET(-155),
    TIME_WITH_TIMEZONE(2013),
    TIMESTAMP_WITH_TIMEZONE(2014);

    public final int TYPE_CODE;
    private static Map<Integer, JdbcType> codeLookup;

    private JdbcType(int code) {
        JDBCType[] values;
        this.TYPE_CODE = code;
        for (JDBCType value : values = JDBCType.values()) {
            Integer vendorTypeNumber = value.getVendorTypeNumber();
            if (code != vendorTypeNumber) continue;
            String name = value.getName().toLowerCase();
            System.out.println(name);
        }
    }

    public static JdbcType forCode(int code) {
        return codeLookup.get(code);
    }

    static {
        codeLookup = new HashMap<Integer, JdbcType>();
        for (JdbcType type : JdbcType.values()) {
            codeLookup.put(type.TYPE_CODE, type);
        }
    }
}

