/*
 * Decompiled with CFR 0.152.
 */
package top.zhogjianhao;

import com.sun.istack.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegExUtils
extends org.apache.commons.lang3.RegExUtils {
    private static final Logger log = LoggerFactory.getLogger(RegExUtils.class);

    private RegExUtils() {
    }

    public static String replaceAllSpecialChar(String source) {
        return source.replaceAll("/", "\\/").replaceAll("\\\\", "\\\\\\").replaceAll("\\(", "\\\\(").replaceAll("\\)", "\\\\)").replaceAll("\\.", "\\\\.").replaceAll("\\?", "\\\\?").replaceAll("\\*", "\\\\*").replaceAll("\\+", "\\\\+").replaceAll("\\|", "\\\\|").replaceAll("\\^", "\\\\^").replaceAll("\\$", "\\\\$");
    }

    public static Matcher getMatcher(@NotNull String text, @NotNull String regex, int flags) {
        Pattern pattern = Pattern.compile(regex, flags);
        return pattern.matcher(text);
    }

    public static Matcher getMatcher(@NotNull String text, @NotNull String regex) {
        return RegExUtils.getMatcher(text, regex, 0);
    }

    public static int indexOf(@NotNull String text, @NotNull String regex, int flags) {
        try {
            Matcher matcher = RegExUtils.getMatcher(text, regex, flags);
            if (matcher.find()) {
                return matcher.start();
            }
            return -1;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return -1;
        }
    }

    public static int indexOf(@NotNull String text, @NotNull String regex) {
        try {
            Matcher matcher = RegExUtils.getMatcher(text, regex);
            if (matcher.find()) {
                return matcher.start();
            }
            return -1;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return -1;
        }
    }

    public static String match(@NotNull String text, @NotNull String regex, int item, int group, int flags) {
        if (item < 0 || group < 0) {
            log.warn("match \u6216 group \u53c2\u6570\u9519\u8bef\uff01");
            return null;
        }
        String result = null;
        try {
            Matcher matcher = RegExUtils.getMatcher(text, regex, flags);
            int i = 0;
            while (matcher.find()) {
                if (item == i) {
                    return matcher.group(group);
                }
                ++i;
            }
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String match(@NotNull String text, @NotNull String regex, int item, int group) {
        return RegExUtils.match(text, regex, item, group, 0);
    }

    public static String match(@NotNull String text, @NotNull String regex, int item) {
        return RegExUtils.match(text, regex, item, 0);
    }

    public static String matchFirst(@NotNull String text, @NotNull String regex, int group, int flags) {
        return RegExUtils.match(text, regex, 0, group, flags);
    }

    public static String matchFirst(@NotNull String text, @NotNull String regex, int group) {
        return RegExUtils.matchFirst(text, regex, group, 0);
    }

    public static String matchFirst(@NotNull String text, @NotNull String regex) {
        return RegExUtils.matchFirst(text, regex, 0);
    }

    public static boolean isMatch(@NotNull String text, @NotNull String regex, int flags) {
        return StringUtils.isNotBlank((CharSequence)RegExUtils.matchFirst(text, regex, 0, flags));
    }

    public static boolean isMatch(@NotNull String text, @NotNull String regex) {
        return StringUtils.isNotBlank((CharSequence)RegExUtils.matchFirst(text, regex, 0));
    }

    public static List<String> matches(@NotNull String text, @NotNull String regex, int group, int flags) {
        ArrayList<String> resultList = new ArrayList<String>();
        try {
            Matcher matcher = RegExUtils.getMatcher(text, regex, flags);
            while (matcher.find()) {
                resultList.add(matcher.group(group));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            resultList = new ArrayList();
        }
        return resultList;
    }

    public static List<String> matches(@NotNull String text, @NotNull String regex, int group) {
        return RegExUtils.matches(text, regex, group, 0);
    }

    public static List<String> matches(@NotNull String text, @NotNull String regex) {
        return RegExUtils.matches(text, regex, 0);
    }

    public static String replace(@NotNull String text, @NotNull String regex, @NotNull String replacement, int item, int group, int flags) {
        if (item < 0 || group < 0) {
            log.warn("match \u6216 group \u53c2\u6570\u9519\u8bef\uff01");
            return null;
        }
        Matcher matcher = RegExUtils.getMatcher(text, regex, flags);
        int i = 0;
        while (matcher.find()) {
            if (i == item) {
                int startIndex = matcher.start(group);
                return text.substring(0, startIndex) + replacement + text.substring(startIndex + matcher.group(group).length());
            }
            ++i;
        }
        return null;
    }

    public static String replace(@NotNull String text, @NotNull String regex, @NotNull String replacement, int item, int flags) {
        return RegExUtils.replace(text, regex, replacement, item, 0, flags);
    }

    public static String replace(@NotNull String text, @NotNull String regex, @NotNull String replacement, int item) {
        return RegExUtils.replace(text, regex, replacement, item, 0);
    }

    public static String replaceFirst(@NotNull String text, @NotNull String regex, @NotNull String replacement, int group, int flags) {
        return RegExUtils.replace(text, regex, replacement, 0, group, flags);
    }

    public static String replaceFirst(@NotNull String text, @NotNull String regex, @NotNull String replacement, int group) {
        return RegExUtils.replaceFirst(text, regex, replacement, group, 0);
    }

    public static String replaceFirst(@NotNull String text, @NotNull String regex, @NotNull String replacement) {
        return RegExUtils.replaceFirst(text, regex, replacement, 0, 0);
    }

    public static String replaceAll(@NotNull String text, @NotNull String regex, @NotNull String replacement, int group, int flags) {
        if (group < 0) {
            log.warn("group \u53c2\u6570\u9519\u8bef\uff01");
            return null;
        }
        StringBuilder result = new StringBuilder();
        Matcher matcher = RegExUtils.getMatcher(text, regex, flags);
        if (matcher.find()) {
            String text1;
            Matcher matcher1;
            int startIndex = matcher.start(group);
            String firstMatchText = text.substring(0, startIndex) + replacement + text.substring(startIndex + matcher.group(group).length());
            result.append(firstMatchText, 0, startIndex + replacement.length());
            int i = 0;
            while ((matcher1 = RegExUtils.getMatcher(text1 = firstMatchText.substring(result.toString().length()), regex, flags)).find()) {
                int startIndex1 = matcher1.start(group);
                String nextMatchText = text1.substring(0, startIndex1) + replacement + text1.substring(startIndex1 + matcher1.group(group).length());
                firstMatchText = result + nextMatchText;
                result.append(nextMatchText, 0, startIndex1 + replacement.length());
                ++i;
            }
            matcher = RegExUtils.getMatcher(text, regex, flags);
            int j = 0;
            while (matcher.find()) {
                if (i == j) {
                    result.append(text.substring(matcher.start(group) + 1));
                }
                ++j;
            }
        }
        return result.toString();
    }

    public static String replaceAll(@NotNull String text, @NotNull String regex, @NotNull String replacement, int group) {
        return RegExUtils.replaceAll(text, regex, replacement, group, 0);
    }

    public static boolean containsHanZi(String source) {
        return RegExUtils.isMatch("[\u4e00-\u9fa5]", source);
    }
}

