/*
 * Decompiled with CFR 0.152.
 */
package top.zhogjianhao;

import com.sun.istack.NotNull;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalField;
import java.time.temporal.WeekFields;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.WordUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.zhogjianhao.CollectionUtils;
import top.zhogjianhao.RegExUtils;

public class DateUtils
extends org.apache.commons.lang3.time.DateUtils {
    private static final Logger log = LoggerFactory.getLogger(DateUtils.class);
    public static final String PATTERN_UUUU_MM_DD_HH_MM_SS = "uuuu-MM-dd HH:mm:ss";
    public static final String PATTERN_UUUUMMDDHHMMSS = "uuuuMMddHHmmss";
    public static final String PATTERN_UUUU_MM_DD_HH_MM = "uuuu-MM-dd HH:mm";
    public static final String PATTERN_UUUU_MM_DD = "uuuu-MM-dd";
    public static final String PATTERN_UUUU_MM = "uuuu-MM";
    public static final String PATTERN_YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    public static final String PATTERN_YYYYMMDDHHMMSS = "yyyyMMddHHmmss";
    public static final String PATTERN_YYYY_MM_DD_HH_MM = "yyyy-MM-dd HH:mm";
    public static final String PATTERN_YYYY_MM_DD = "yyyy-MM-dd";
    public static final String PATTERN_YYYY_MM = "yyyy-MM";
    public static final String PATTERN_HH_MM_SS = "HH:mm:ss";
    public static final String PATTERN_HH_MM = "HH:mm";
    private static final Locale DEFAULT_LOCALE = Locale.ENGLISH;
    private static final DateTimeFormatter DEFAULT_DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("uuuu-MM-dd HH:mm:ss", DEFAULT_LOCALE);
    public static final ZoneId SYSTEM_ZONE_ID = ZoneId.systemDefault();
    public static final ZoneOffset SYSTEM_ZONE_OFFSET = OffsetDateTime.now(SYSTEM_ZONE_ID).getOffset();
    public static final ResolverStyle DEFAULT_RESOLVER_STYLE = ResolverStyle.STRICT;
    public static String defaultDatePattern = "yyyy-MM-dd HH:mm:ss";
    public static String defaultLocalDatePattern = "uuuu-MM-dd";
    public static String defaultLocalDateTimePattern = "yyyy-MM-dd HH:mm:ss";
    public static String defaultLocalTimePattern = "HH:mm:ss";

    public static DateTimeFormatterBuilder getFormatterBuilder(@NotNull String pattern, Map<TemporalField, Long> fieldValueMap) {
        DateTimeFormatterBuilder formatterBuilder = new DateTimeFormatterBuilder().appendPattern(pattern);
        ChronoField maybeExistTemporalField = ChronoField.YEAR;
        if (!pattern.toLowerCase().contains("y") && fieldValueMap.containsKey(maybeExistTemporalField)) {
            formatterBuilder.parseDefaulting(maybeExistTemporalField, fieldValueMap.get(maybeExistTemporalField));
            fieldValueMap.remove(maybeExistTemporalField);
        }
        maybeExistTemporalField = ChronoField.MONTH_OF_YEAR;
        if (!pattern.contains("M") && !pattern.contains("L") && fieldValueMap.containsKey(maybeExistTemporalField)) {
            formatterBuilder.parseDefaulting(maybeExistTemporalField, fieldValueMap.get(maybeExistTemporalField));
            fieldValueMap.remove(maybeExistTemporalField);
        }
        maybeExistTemporalField = ChronoField.DAY_OF_MONTH;
        if (!pattern.toLowerCase().contains("d") && !pattern.contains("F") && fieldValueMap.containsKey(maybeExistTemporalField)) {
            formatterBuilder.parseDefaulting(maybeExistTemporalField, fieldValueMap.get(maybeExistTemporalField));
            fieldValueMap.remove(maybeExistTemporalField);
        }
        maybeExistTemporalField = ChronoField.HOUR_OF_DAY;
        if (!pattern.toLowerCase().contains("h") && !pattern.toLowerCase().contains("k") && fieldValueMap.containsKey(maybeExistTemporalField)) {
            formatterBuilder.parseDefaulting(maybeExistTemporalField, fieldValueMap.get(maybeExistTemporalField));
            fieldValueMap.remove(maybeExistTemporalField);
        }
        for (TemporalField temporalField : fieldValueMap.keySet()) {
            formatterBuilder.parseDefaulting(temporalField, fieldValueMap.get(temporalField));
        }
        return formatterBuilder;
    }

    public static DateTimeFormatter getDefaultFormatter(@NotNull String pattern, Locale locale, ZoneId zoneId) {
        HashMap<TemporalField, Long> fieldValueMap = new HashMap<TemporalField, Long>();
        fieldValueMap.put(ChronoField.YEAR, 1970L);
        fieldValueMap.put(ChronoField.MONTH_OF_YEAR, 1L);
        fieldValueMap.put(ChronoField.DAY_OF_MONTH, 1L);
        fieldValueMap.put(ChronoField.HOUR_OF_DAY, 0L);
        DateTimeFormatterBuilder formatterBuilder = DateUtils.getFormatterBuilder(pattern, fieldValueMap);
        DateTimeFormatter dateTimeFormatter = locale != null ? formatterBuilder.toFormatter(locale) : formatterBuilder.toFormatter();
        dateTimeFormatter.withResolverStyle(DEFAULT_RESOLVER_STYLE);
        if (zoneId != null) {
            dateTimeFormatter.withZone(zoneId);
        }
        return dateTimeFormatter;
    }

    public static DateTimeFormatter getDefaultFormatter(@NotNull String pattern, @NotNull Locale locale) {
        return DateUtils.getDefaultFormatter(pattern, locale, null);
    }

    public static DateTimeFormatter getDefaultFormatter(@NotNull String pattern, @NotNull ZoneId zoneId) {
        return DateUtils.getDefaultFormatter(pattern, null, zoneId);
    }

    public static DateTimeFormatter getDefaultFormatter(@NotNull String pattern) {
        return DateUtils.getDefaultFormatter(pattern, DEFAULT_LOCALE);
    }

    private static String convertByPattern(@NotNull String source, @NotNull String pattern) {
        int mmmIndex = pattern.indexOf("MMM");
        if (mmmIndex != -1) {
            String mmm = source.substring(mmmIndex, mmmIndex + 3);
            source = source.replaceAll(mmm, WordUtils.capitalize((String)mmm.toLowerCase()));
        }
        return source;
    }

    public static String format(@NotNull Date date, @NotNull String pattern) {
        return new SimpleDateFormat(pattern).format(date);
    }

    public static String format(@NotNull Date date) {
        return DateUtils.format(date, defaultDatePattern);
    }

    public static String format(@NotNull Temporal temporal, @NotNull String pattern) {
        return DateUtils.getDefaultFormatter(pattern).format(temporal);
    }

    public static String format(@NotNull Temporal temporal) {
        if (temporal == null) {
            return null;
        }
        String pattern = null;
        if (temporal instanceof LocalDate) {
            pattern = defaultLocalDatePattern;
        } else if (temporal instanceof LocalDateTime) {
            pattern = defaultLocalDateTimePattern;
        } else if (temporal instanceof LocalTime) {
            pattern = defaultLocalTimePattern;
        }
        return DateUtils.format(temporal, pattern);
    }

    public static Date parseDate(@NotNull long timeStamp) {
        return new Date(timeStamp);
    }

    public static Date parseDate(@NotNull String source) {
        try {
            if (source.contains("-") || source.contains(":")) {
                String pattern = null;
                switch (source.length()) {
                    case 19: {
                        pattern = PATTERN_UUUU_MM_DD_HH_MM_SS;
                        break;
                    }
                    case 16: {
                        pattern = PATTERN_UUUU_MM_DD_HH_MM;
                        break;
                    }
                    case 10: {
                        pattern = PATTERN_UUUU_MM_DD;
                        break;
                    }
                    case 7: {
                        pattern = PATTERN_UUUU_MM;
                        break;
                    }
                    case 8: {
                        pattern = PATTERN_HH_MM_SS;
                        break;
                    }
                    case 5: {
                        pattern = PATTERN_HH_MM;
                        break;
                    }
                }
                if (pattern != null) {
                    return new SimpleDateFormat(pattern).parse(source);
                }
            }
        }
        catch (ParseException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
        return null;
    }

    public static LocalDate parseLocalDate(@NotNull long timeStamp, @NotNull ZoneId zoneId) {
        return Instant.ofEpochMilli(timeStamp).atZone(zoneId).toLocalDate();
    }

    public static LocalDate parseLocalDate(@NotNull long timeStamp) {
        return DateUtils.parseLocalDate(timeStamp, SYSTEM_ZONE_ID);
    }

    public static LocalDate parseLocalDate(@NotNull String source, @NotNull String pattern, @NotNull ZoneId zoneId) {
        source = DateUtils.convertByPattern(source, pattern);
        return LocalDate.parse(source, DateUtils.getDefaultFormatter(pattern, zoneId));
    }

    public static LocalDate parseLocalDate(@NotNull String source, @NotNull String pattern) {
        return DateUtils.parseLocalDate(source, pattern, SYSTEM_ZONE_ID);
    }

    public static LocalDate parseLocalDate(@NotNull String source, @NotNull ZoneId zoneId, String ... patterns) {
        LocalDate result = null;
        for (String pattern : patterns) {
            try {
                result = DateUtils.parseLocalDate(source, pattern, zoneId);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static LocalDate parseLocalDate(@NotNull String source, String ... patterns) {
        LocalDate result = null;
        for (String pattern : patterns) {
            try {
                result = DateUtils.parseLocalDate(source, pattern);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static LocalDate parseLocalDate(@NotNull String source) {
        int length = source.length();
        String pattern = null;
        if (source.contains("-") || source.contains(":")) {
            switch (length) {
                case 10: {
                    pattern = PATTERN_UUUU_MM_DD;
                    break;
                }
                case 7: {
                    pattern = PATTERN_UUUU_MM;
                }
            }
            if (pattern != null) {
                return DateUtils.parseLocalDate(source, pattern);
            }
        }
        return null;
    }

    public static LocalDateTime parseLocalDateTime(@NotNull long timeStamp, @NotNull ZoneId zoneId) {
        return Instant.ofEpochMilli(timeStamp).atZone(zoneId).toLocalDateTime();
    }

    public static LocalDateTime parseLocalDateTime(@NotNull long timeStamp) {
        return DateUtils.parseLocalDateTime(timeStamp, SYSTEM_ZONE_ID);
    }

    public static LocalDateTime parseLocalDateTime(@NotNull String source, @NotNull String pattern, @NotNull ZoneId zoneId) {
        if (StringUtils.isBlank((CharSequence)source)) {
            return null;
        }
        source = DateUtils.convertByPattern(source, pattern);
        return LocalDateTime.parse(source, DateUtils.getDefaultFormatter(pattern, zoneId));
    }

    public static LocalDateTime parseLocalDateTime(@NotNull String source, @NotNull String pattern) {
        return DateUtils.parseLocalDateTime(source, pattern, SYSTEM_ZONE_ID);
    }

    public static LocalDateTime parseLocalDateTime(@NotNull String source, @NotNull ZoneId zoneId, String ... patterns) {
        LocalDateTime result = null;
        for (String pattern : patterns) {
            try {
                result = DateUtils.parseLocalDateTime(source, pattern, zoneId);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static LocalDateTime parseLocalDateTime(@NotNull String source, String ... patterns) {
        LocalDateTime result = null;
        for (String pattern : patterns) {
            try {
                result = DateUtils.parseLocalDateTime(source, pattern);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static LocalDateTime parseLocalDateTime(@NotNull String source) {
        String pattern = null;
        if (source.contains("-") || source.contains(":")) {
            switch (source.length()) {
                case 19: {
                    pattern = PATTERN_UUUU_MM_DD_HH_MM_SS;
                    break;
                }
                case 16: {
                    pattern = PATTERN_UUUU_MM_DD_HH_MM;
                    break;
                }
                case 10: {
                    pattern = PATTERN_UUUU_MM_DD;
                    break;
                }
                case 7: {
                    pattern = PATTERN_UUUU_MM;
                    break;
                }
                case 8: {
                    pattern = PATTERN_HH_MM_SS;
                    break;
                }
                case 5: {
                    pattern = PATTERN_HH_MM;
                    break;
                }
            }
            if (pattern != null) {
                return DateUtils.parseLocalDateTime(source, pattern);
            }
        }
        return null;
    }

    public static LocalTime parseLocalTime(@NotNull long timeStamp, @NotNull ZoneId zoneId) {
        return Instant.ofEpochMilli(timeStamp).atZone(zoneId).toLocalTime();
    }

    public static LocalTime parseLocalTime(@NotNull long timeStamp) {
        return DateUtils.parseLocalTime(timeStamp, SYSTEM_ZONE_ID);
    }

    public static LocalTime parseLocalTime(@NotNull String source, @NotNull String pattern, @NotNull ZoneId zoneId) {
        if (StringUtils.isBlank((CharSequence)source)) {
            return null;
        }
        source = DateUtils.convertByPattern(source, pattern);
        return LocalTime.parse(source, DateUtils.getDefaultFormatter(pattern, zoneId));
    }

    public static LocalTime parseLocalTime(@NotNull String source, @NotNull String pattern) {
        return DateUtils.parseLocalTime(source, pattern, SYSTEM_ZONE_ID);
    }

    public static LocalTime parseLocalTime(@NotNull String source, @NotNull ZoneId zoneId, String ... patterns) {
        LocalTime result = null;
        for (String pattern : patterns) {
            try {
                result = DateUtils.parseLocalTime(source, pattern, zoneId);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static LocalTime parseLocalTime(@NotNull String source, String ... patterns) {
        LocalTime result = null;
        for (String pattern : patterns) {
            try {
                result = DateUtils.parseLocalTime(source, pattern);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static LocalTime parseLocalTime(@NotNull String source) {
        String pattern = null;
        if (source.contains("-") || source.contains(":")) {
            switch (source.length()) {
                case 8: {
                    pattern = PATTERN_HH_MM_SS;
                    break;
                }
                case 5: {
                    pattern = PATTERN_HH_MM;
                    break;
                }
            }
            if (pattern != null) {
                return DateUtils.parseLocalTime(source, pattern);
            }
        }
        return null;
    }

    public static Date toDate(@NotNull Temporal temporal) {
        if (temporal instanceof LocalDate) {
            return Date.from(((LocalDate)temporal).atStartOfDay().atZone(SYSTEM_ZONE_ID).toInstant());
        }
        if (temporal instanceof LocalDateTime) {
            return Date.from(((LocalDateTime)temporal).atZone(SYSTEM_ZONE_ID).toInstant());
        }
        if (temporal instanceof LocalTime) {
            return Date.from(DateUtils.minLocalDateTime(temporal).atZone(SYSTEM_ZONE_ID).toInstant());
        }
        return null;
    }

    public static LocalDate toLocalDate(@NotNull Date date) {
        return DateUtils.parseLocalDate(date.getTime());
    }

    public static LocalDateTime toLocalDateTime(@NotNull Date date) {
        return DateUtils.parseLocalDateTime(date.getTime());
    }

    public static LocalTime toLocalTime(@NotNull Date date) {
        return DateUtils.parseLocalTime(date.getTime());
    }

    public static LocalDateTime minLocalDateTime(@NotNull Temporal temporal) {
        if (temporal instanceof LocalDateTime) {
            return (LocalDateTime)temporal;
        }
        LocalDateTime localDateTime = LocalDateTime.now();
        if (temporal instanceof LocalDate) {
            localDateTime.with(ChronoField.YEAR, ((LocalDate)temporal).getYear());
            localDateTime.with(ChronoField.MONTH_OF_YEAR, ((LocalDate)temporal).getMonthValue());
            localDateTime.with(ChronoField.DAY_OF_MONTH, ((LocalDate)temporal).getDayOfMonth());
        } else {
            localDateTime.with(ChronoField.YEAR, 1970L);
            localDateTime.with(ChronoField.MONTH_OF_YEAR, 1L);
            localDateTime.with(ChronoField.DAY_OF_MONTH, 1L);
        }
        if (temporal instanceof LocalTime) {
            localDateTime.with(ChronoField.HOUR_OF_DAY, ((LocalTime)temporal).getHour());
            localDateTime.with(ChronoField.MINUTE_OF_HOUR, ((LocalTime)temporal).getMinute());
            localDateTime.with(ChronoField.SECOND_OF_MINUTE, ((LocalTime)temporal).getSecond());
            localDateTime.with(ChronoField.MILLI_OF_SECOND, temporal.getLong(ChronoField.MILLI_OF_SECOND));
        } else {
            localDateTime.with(ChronoField.HOUR_OF_DAY, 0L);
            localDateTime.with(ChronoField.MINUTE_OF_HOUR, 0L);
            localDateTime.with(ChronoField.SECOND_OF_MINUTE, 0L);
            localDateTime.with(ChronoField.MILLI_OF_SECOND, 0L);
        }
        return localDateTime;
    }

    public static LocalDateTime minLocalDateTime() {
        LocalDateTime localDateTime = LocalDateTime.now();
        localDateTime.with(ChronoField.YEAR, 1970L);
        localDateTime.with(ChronoField.MONTH_OF_YEAR, 1L);
        localDateTime.with(ChronoField.DAY_OF_MONTH, 1L);
        localDateTime.with(ChronoField.HOUR_OF_DAY, 0L);
        localDateTime.with(ChronoField.MINUTE_OF_HOUR, 0L);
        localDateTime.with(ChronoField.SECOND_OF_MINUTE, 0L);
        localDateTime.with(ChronoField.MILLI_OF_SECOND, 0L);
        return localDateTime;
    }

    public static LocalDate withZoneInstant(@NotNull LocalDate localDate, @NotNull ZoneId oldZoneId, @NotNull ZoneId newZoneId) {
        return localDate.atStartOfDay().atZone(oldZoneId).withZoneSameInstant(newZoneId).toLocalDate();
    }

    public static LocalDateTime withZoneInstant(@NotNull LocalDateTime localDateTime, @NotNull ZoneId oldZoneId, @NotNull ZoneId newZoneId) {
        return localDateTime.atZone(oldZoneId).withZoneSameInstant(newZoneId).toLocalDateTime();
    }

    public static LocalTime withZoneInstant(@NotNull LocalTime localTime, @NotNull ZoneId oldZoneId, @NotNull ZoneId newZoneId) {
        return DateUtils.minLocalDateTime(localTime).atZone(oldZoneId).withZoneSameInstant(newZoneId).toLocalTime();
    }

    public static String now() {
        return DateUtils.format(new Date());
    }

    public static String now(@NotNull ZoneId zoneId) {
        return DateUtils.format(LocalDateTime.now().atZone(zoneId));
    }

    public static LocalDateTime todayMinDateTime() {
        return LocalDateTime.of(LocalDate.now(), LocalTime.MIN);
    }

    public static LocalDateTime todayMinDateTime(@NotNull ZoneId zoneId) {
        return DateUtils.todayMinDateTime().atZone(zoneId).toLocalDateTime();
    }

    public static LocalTime todayMinTime() {
        return DateUtils.todayMinDateTime().toLocalTime();
    }

    public static LocalTime todayMinTime(@NotNull ZoneId zoneId) {
        return DateUtils.todayMinDateTime(zoneId).toLocalTime();
    }

    public static String todayMinStr(@NotNull String pattern) {
        return DateUtils.format(LocalDateTime.of(LocalDate.now(), LocalTime.MIN), pattern);
    }

    public static String todayMinStr() {
        return DateUtils.format(LocalDateTime.of(LocalDate.now(), LocalTime.MIN), defaultLocalTimePattern);
    }

    public static LocalDateTime todayMaxDateTime() {
        return LocalDateTime.of(LocalDate.now(), LocalTime.MAX);
    }

    public static LocalDateTime todayMaxDateTime(@NotNull ZoneId zoneId) {
        return DateUtils.todayMaxDateTime().atZone(zoneId).toLocalDateTime();
    }

    public static LocalTime todayMaxTime() {
        return DateUtils.todayMaxDateTime().toLocalTime();
    }

    public static LocalTime todayMaxTime(@NotNull ZoneId zoneId) {
        return DateUtils.todayMaxDateTime(zoneId).toLocalTime();
    }

    public static String todayMaxStr(@NotNull String pattern) {
        return DateUtils.format(LocalDateTime.of(LocalDate.now(), LocalTime.MAX), pattern);
    }

    public static String todayMaxStr() {
        return DateUtils.format(LocalDateTime.of(LocalDate.now(), LocalTime.MAX), defaultLocalTimePattern);
    }

    public static <T extends Temporal> T plusOrMinus(@NotNull T temporal, @NotNull long augendOrMinuend, ChronoUnit chronoUnit) {
        if (chronoUnit == null) {
            chronoUnit = ChronoUnit.MILLIS;
        }
        if (augendOrMinuend < 0L) {
            return (T)temporal.minus(Math.abs(augendOrMinuend), chronoUnit);
        }
        if (augendOrMinuend > 0L) {
            return (T)temporal.plus(augendOrMinuend, chronoUnit);
        }
        return temporal;
    }

    public static boolean isIntersection(@NotNull LocalDateTime x1, @NotNull LocalDateTime y1, @NotNull LocalDateTime x2, @NotNull LocalDateTime y2) {
        return !y1.isBefore(x2) && !y2.isBefore(x1);
    }

    public static LocalDateTime[] getIntersection(@NotNull LocalDateTime x1, @NotNull LocalDateTime y1, @NotNull LocalDateTime x2, @NotNull LocalDateTime y2) {
        if (!DateUtils.isIntersection(x1, y1, x2, y2)) {
            return null;
        }
        LocalDateTime[] result = new LocalDateTime[2];
        if (x1.isBefore(x2) || x1.isEqual(x2)) {
            result[0] = x2;
        } else if (x1.isAfter(x2)) {
            result[0] = x1;
        }
        if (y1.isBefore(y2) || y1.isEqual(y2)) {
            result[1] = y1;
        } else if (y1.isAfter(y2)) {
            result[1] = y2;
        }
        return result;
    }

    public static List<LocalDateTime[]> getDifferenceSetsByIntersectional(@NotNull LocalDateTime x1, @NotNull LocalDateTime y1, @NotNull LocalDateTime x2, @NotNull LocalDateTime y2) {
        LocalDateTime[] intersections = DateUtils.getIntersection(x1, y1, x2, y2);
        if (intersections == null || intersections.length == 0) {
            return null;
        }
        ArrayList<LocalDateTime[]> result = new ArrayList<LocalDateTime[]>();
        if (x1.isBefore(x2)) {
            result.add(new LocalDateTime[]{x1, x2});
        } else if (x1.isAfter(x2)) {
            result.add(new LocalDateTime[]{x2, x1});
        }
        if (y1.isBefore(y2)) {
            result.add(new LocalDateTime[]{y1, y2});
        } else if (y1.isAfter(y2)) {
            result.add(new LocalDateTime[]{y2, y1});
        }
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            LocalDateTime[] localDateTimes = (LocalDateTime[])iterator.next();
            if (localDateTimes[0].equals(intersections[1])) {
                localDateTimes[0] = DateUtils.plusOrMinus(localDateTimes[0], 1L, ChronoUnit.DAYS);
            }
            if (localDateTimes[1].equals(intersections[0])) {
                localDateTimes[1] = DateUtils.plusOrMinus(localDateTimes[1], -1L, ChronoUnit.DAYS);
            }
            if (!localDateTimes[1].isBefore(localDateTimes[0])) continue;
            iterator.remove();
        }
        return result;
    }

    public static String[] convertWeeks(@NotNull String weeks, @NotNull String splitRegex) {
        if (RegExUtils.isMatch("[^,1-7]*", weeks)) {
            weeks = weeks.replaceAll("[^,1-7]*", "");
        }
        if (StringUtils.isBlank((CharSequence)weeks)) {
            return new String[0];
        }
        return weeks.split(splitRegex);
    }

    public static String[] convertWeeks(@NotNull String weeks) {
        String regex = ",";
        if (!weeks.contains(regex)) {
            regex = "";
        }
        return DateUtils.convertWeeks(weeks, regex);
    }

    public static List<LocalDateTime> getByWeeks(@NotNull String weeks, LocalDateTime ... times) {
        ArrayList<LocalDateTime> timeList = null;
        if (!CollectionUtils.sizeIsEmpty(times)) {
            List<String> weekList = Arrays.asList(DateUtils.convertWeeks(weeks));
            timeList = new ArrayList<LocalDateTime>(Arrays.asList(times));
            timeList.removeIf(time -> !weekList.contains(String.valueOf(time.getDayOfWeek().getValue())));
        }
        return timeList;
    }

    public static List<String> getByRange(@NotNull LocalDateTime startTime, @NotNull LocalDateTime endTime, @NotNull String pattern) {
        ArrayList<String> result = new ArrayList<String>();
        long distance = ChronoUnit.DAYS.between(startTime, endTime);
        if (distance >= 1L) {
            Stream.iterate(startTime, day -> day.plusDays(1L)).limit(distance + 1L).forEach(f -> result.add(DateUtils.format(f, pattern)));
        }
        return result;
    }

    public static List<String> getByRangeAndWeeks(@NotNull LocalDateTime startTime, @NotNull LocalDateTime endTime, @NotNull String weeks, @NotNull String pattern) {
        ArrayList<String> result = new ArrayList<String>();
        TemporalField field = WeekFields.of(DayOfWeek.of(1), 1).dayOfWeek();
        for (String week : DateUtils.convertWeeks(weeks)) {
            LocalDateTime dayByWeek = startTime.with(field, Long.parseLong(week));
            if (dayByWeek.isBefore(startTime)) {
                dayByWeek = dayByWeek.plusWeeks(1L);
            }
            while (dayByWeek.isBefore(endTime) || dayByWeek.isEqual(endTime)) {
                result.add(DateUtils.format(dayByWeek, pattern));
                dayByWeek = dayByWeek.plusWeeks(1L);
            }
        }
        return result;
    }

    public static List<LocalDateTime> getByRangeAndWeeks(@NotNull LocalDateTime startTime, @NotNull LocalDateTime endTime, @NotNull String weeks) {
        ArrayList<LocalDateTime> result = new ArrayList<LocalDateTime>();
        TemporalField field = WeekFields.of(DayOfWeek.of(1), 1).dayOfWeek();
        for (String week : DateUtils.convertWeeks(weeks)) {
            LocalDateTime tempDay = startTime.with(field, Long.parseLong(week));
            if (tempDay.isBefore(startTime)) {
                tempDay = tempDay.plusWeeks(1L);
            }
            while (tempDay.isBefore(endTime) || tempDay.isEqual(endTime)) {
                result.add(tempDay);
                tempDay = tempDay.plusWeeks(1L);
            }
        }
        return result;
    }
}

