/*
 * Decompiled with CFR 0.152.
 */
package top.zhogjianhao;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalField;
import java.time.temporal.WeekFields;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;
import lombok.NonNull;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.text.WordUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.zhogjianhao.CollectionUtils;
import top.zhogjianhao.RegExUtils;
import top.zhogjianhao.StringUtils;

public class DateUtils
extends org.apache.commons.lang3.time.DateUtils {
    private static final Logger log = LoggerFactory.getLogger(DateUtils.class);
    public static final String PATTERN_UUUU_MM_DD_HH_MM_SS = "uuuu-MM-dd HH:mm:ss";
    public static final String PATTERN_UUUUMMDDHHMMSS = "uuuuMMddHHmmss";
    public static final String PATTERN_UUUU_MM_DD_HH_MM = "uuuu-MM-dd HH:mm";
    public static final String PATTERN_UUUU_MM_DD = "uuuu-MM-dd";
    public static final String PATTERN_UUUU_MM = "uuuu-MM";
    public static final String PATTERN_YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    public static final String PATTERN_YYYYMMDDHHMMSS = "yyyyMMddHHmmss";
    public static final String PATTERN_YYYY_MM_DD_HH_MM = "yyyy-MM-dd HH:mm";
    public static final String PATTERN_YYYY_MM_DD = "yyyy-MM-dd";
    public static final String PATTERN_YYYY_MM = "yyyy-MM";
    public static final String PATTERN_MM_DD_HH_MM_SS = "MM-dd HH:mm:ss";
    public static final String PATTERN_MMDDHHMMSS = "MMddHHmmss";
    public static final String PATTERN_MM_DD_HH_MM = "MM-dd HH:mm";
    public static final String PATTERN_MM_DD = "MM-dd";
    public static final String PATTERN_HH_MM_SS = "HH:mm:ss";
    public static final String PATTERN_HH_MM = "HH:mm";
    private static final Locale DEFAULT_LOCALE = Locale.ENGLISH;
    private static final DateTimeFormatter DEFAULT_DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("uuuu-MM-dd HH:mm:ss", DEFAULT_LOCALE);
    public static final ZoneId SYSTEM_ZONE_ID = ZoneId.systemDefault();
    public static final ZoneOffset SYSTEM_ZONE_OFFSET = OffsetDateTime.now(SYSTEM_ZONE_ID).getOffset();
    public static final ResolverStyle DEFAULT_RESOLVER_STYLE = ResolverStyle.STRICT;
    public static String defaultDatePattern = "yyyy-MM-dd HH:mm:ss";
    public static String defaultLocalDatePattern = "uuuu-MM-dd";
    public static String defaultLocalDateTimePattern = "yyyy-MM-dd HH:mm:ss";
    public static String defaultLocalTimePattern = "HH:mm:ss";

    public static DateTimeFormatterBuilder getFormatterBuilder(@NonNull String pattern, Map<TemporalField, Long> fieldValueMap) {
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        DateTimeFormatterBuilder formatterBuilder = new DateTimeFormatterBuilder().appendPattern(pattern);
        String lowercasePattern = pattern.toLowerCase();
        if (MapUtils.isNotEmpty(fieldValueMap)) {
            ChronoField maybeExistTemporalField = ChronoField.YEAR_OF_ERA;
            if (pattern.contains("u") && fieldValueMap.containsKey(maybeExistTemporalField)) {
                fieldValueMap.remove(maybeExistTemporalField);
            }
            maybeExistTemporalField = ChronoField.YEAR;
            if (lowercasePattern.contains("y") && fieldValueMap.containsKey(maybeExistTemporalField)) {
                fieldValueMap.remove(maybeExistTemporalField);
            }
            maybeExistTemporalField = ChronoField.MONTH_OF_YEAR;
            if ((pattern.contains("M") || pattern.contains("L")) && fieldValueMap.containsKey(maybeExistTemporalField)) {
                fieldValueMap.remove(maybeExistTemporalField);
            }
            maybeExistTemporalField = ChronoField.DAY_OF_MONTH;
            if ((lowercasePattern.contains("d") || pattern.contains("F")) && fieldValueMap.containsKey(maybeExistTemporalField)) {
                fieldValueMap.remove(maybeExistTemporalField);
            }
            maybeExistTemporalField = ChronoField.HOUR_OF_DAY;
            if ((lowercasePattern.contains("h") || lowercasePattern.contains("k")) && fieldValueMap.containsKey(maybeExistTemporalField)) {
                fieldValueMap.remove(maybeExistTemporalField);
            }
        }
        for (TemporalField temporalField : fieldValueMap.keySet()) {
            formatterBuilder.parseDefaulting(temporalField, fieldValueMap.get(temporalField));
        }
        return formatterBuilder;
    }

    public static DateTimeFormatter getDefaultFormatter(@NonNull String pattern, Locale locale, ZoneId atZoneId) {
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        HashMap<TemporalField, Long> fieldValueMap = new HashMap<TemporalField, Long>();
        fieldValueMap.put(ChronoField.YEAR_OF_ERA, 1970L);
        fieldValueMap.put(ChronoField.YEAR, 1970L);
        fieldValueMap.put(ChronoField.MONTH_OF_YEAR, 1L);
        fieldValueMap.put(ChronoField.DAY_OF_MONTH, 1L);
        fieldValueMap.put(ChronoField.HOUR_OF_DAY, 0L);
        DateTimeFormatterBuilder formatterBuilder = DateUtils.getFormatterBuilder(pattern, fieldValueMap);
        DateTimeFormatter dateTimeFormatter = locale != null ? formatterBuilder.toFormatter(locale) : formatterBuilder.toFormatter();
        dateTimeFormatter.withResolverStyle(DEFAULT_RESOLVER_STYLE);
        if (atZoneId != null) {
            dateTimeFormatter = dateTimeFormatter.withZone(atZoneId);
        }
        return dateTimeFormatter;
    }

    public static DateTimeFormatter getDefaultFormatter(@NonNull String pattern, @NonNull Locale locale) {
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        if (locale == null) {
            throw new NullPointerException("locale is marked non-null but is null");
        }
        return DateUtils.getDefaultFormatter(pattern, locale, null);
    }

    public static DateTimeFormatter getDefaultFormatter(@NonNull String pattern, @NonNull ZoneId atZoneId) {
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        if (atZoneId == null) {
            throw new NullPointerException("atZoneId is marked non-null but is null");
        }
        return DateUtils.getDefaultFormatter(pattern, null, atZoneId);
    }

    public static DateTimeFormatter getDefaultFormatter(@NonNull String pattern) {
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        return DateUtils.getDefaultFormatter(pattern, DEFAULT_LOCALE);
    }

    private static String convertByPattern(@NonNull String source, @NonNull String pattern) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        int mmmIndex = pattern.indexOf("MMM");
        if (mmmIndex != -1) {
            String mmm = source.substring(mmmIndex, mmmIndex + 3);
            source = source.replaceAll(mmm, WordUtils.capitalize((String)mmm.toLowerCase()));
        }
        return source;
    }

    public static String format(@NonNull ZonedDateTime zonedDateTime, String pattern, ZoneId zoneId) {
        if (zonedDateTime == null) {
            throw new NullPointerException("zonedDateTime is marked non-null but is null");
        }
        if (StringUtils.isBlank((CharSequence)pattern)) {
            pattern = defaultLocalDateTimePattern;
        }
        if (zoneId != null) {
            zonedDateTime = zonedDateTime.withZoneSameInstant(zoneId);
        }
        return zonedDateTime.format(DateUtils.getDefaultFormatter(pattern));
    }

    public static String format(@NonNull ZonedDateTime zonedDateTime, @NonNull String pattern) {
        if (zonedDateTime == null) {
            throw new NullPointerException("zonedDateTime is marked non-null but is null");
        }
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        return DateUtils.format(zonedDateTime, pattern, null);
    }

    public static String format(@NonNull ZonedDateTime zonedDateTime, @NonNull ZoneId zoneId) {
        if (zonedDateTime == null) {
            throw new NullPointerException("zonedDateTime is marked non-null but is null");
        }
        if (zoneId == null) {
            throw new NullPointerException("zoneId is marked non-null but is null");
        }
        return DateUtils.format(zonedDateTime, null, zoneId);
    }

    public static String format(@NonNull ZonedDateTime zonedDateTime) {
        if (zonedDateTime == null) {
            throw new NullPointerException("zonedDateTime is marked non-null but is null");
        }
        return DateUtils.format(zonedDateTime, null, null);
    }

    public static String format(@NonNull Temporal temporal, @NonNull String pattern, ZoneId zoneId) {
        if (temporal == null) {
            throw new NullPointerException("temporal is marked non-null but is null");
        }
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        DateTimeFormatter dateTimeFormatter = DateUtils.getDefaultFormatter(pattern);
        if (zoneId != null) {
            LocalDateTime localDateTime = null;
            if (temporal instanceof LocalDateTime) {
                localDateTime = (LocalDateTime)temporal;
            } else if (temporal instanceof LocalDate) {
                localDateTime = ((LocalDate)temporal).atTime(LocalTime.now());
            } else if (temporal instanceof LocalTime) {
                localDateTime = ((LocalTime)temporal).atDate(LocalDate.now());
            }
            if (localDateTime != null) {
                return localDateTime.atZone(SYSTEM_ZONE_ID).withZoneSameInstant(zoneId).format(dateTimeFormatter);
            }
        }
        return dateTimeFormatter.format(temporal);
    }

    public static String format(@NonNull Temporal temporal, @NonNull String pattern) {
        if (temporal == null) {
            throw new NullPointerException("temporal is marked non-null but is null");
        }
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        return DateUtils.format(temporal, pattern, null);
    }

    public static String format(@NonNull Temporal temporal, ZoneId zoneId) {
        if (temporal == null) {
            throw new NullPointerException("temporal is marked non-null but is null");
        }
        String pattern = temporal instanceof LocalDateTime ? defaultLocalDateTimePattern : (temporal instanceof LocalDate ? defaultLocalDatePattern : (temporal instanceof LocalTime ? defaultLocalTimePattern : defaultLocalDateTimePattern));
        return DateUtils.format(temporal, pattern, zoneId);
    }

    public static String format(@NonNull Temporal temporal) {
        if (temporal == null) {
            throw new NullPointerException("temporal is marked non-null but is null");
        }
        return DateUtils.format(temporal, (ZoneId)null);
    }

    public static String format(@NonNull Date date, String pattern, ZoneId zoneId) {
        if (date == null) {
            throw new NullPointerException("date is marked non-null but is null");
        }
        if (StringUtils.isBlank((CharSequence)pattern)) {
            pattern = defaultDatePattern;
        }
        if (zoneId == null) {
            zoneId = SYSTEM_ZONE_ID;
        }
        return DateUtils.format((Temporal)date.toInstant().atZone(SYSTEM_ZONE_ID).withZoneSameInstant(zoneId).toLocalDateTime(), pattern);
    }

    public static String format(@NonNull Date date, @NonNull String pattern) {
        if (date == null) {
            throw new NullPointerException("date is marked non-null but is null");
        }
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        return DateUtils.format(date, pattern, null);
    }

    public static String format(@NonNull Date date, @NonNull ZoneId zoneId) {
        if (date == null) {
            throw new NullPointerException("date is marked non-null but is null");
        }
        if (zoneId == null) {
            throw new NullPointerException("zoneId is marked non-null but is null");
        }
        return DateUtils.format(date, null, zoneId);
    }

    public static String format(@NonNull Date date) {
        if (date == null) {
            throw new NullPointerException("date is marked non-null but is null");
        }
        return DateUtils.format(date, defaultDatePattern);
    }

    public static Date parseDate(@NonNull long timeStamp) {
        return new Date(timeStamp);
    }

    public static Date parseDate(@NonNull String source) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        try {
            if (source.contains("-") || source.contains(":")) {
                String pattern = null;
                switch (source.length()) {
                    case 19: {
                        pattern = PATTERN_UUUU_MM_DD_HH_MM_SS;
                        break;
                    }
                    case 16: {
                        pattern = PATTERN_UUUU_MM_DD_HH_MM;
                        break;
                    }
                    case 10: {
                        pattern = PATTERN_UUUU_MM_DD;
                        break;
                    }
                    case 7: {
                        pattern = PATTERN_UUUU_MM;
                        break;
                    }
                    case 8: {
                        pattern = PATTERN_HH_MM_SS;
                        break;
                    }
                    case 5: {
                        pattern = PATTERN_HH_MM;
                        break;
                    }
                }
                if (pattern != null) {
                    return new SimpleDateFormat(pattern).parse(source);
                }
            }
        }
        catch (ParseException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
        return null;
    }

    public static LocalDate parseLocalDate(@NonNull long timeStamp, @NonNull ZoneId zoneId) {
        if (zoneId == null) {
            throw new NullPointerException("zoneId is marked non-null but is null");
        }
        return Instant.ofEpochMilli(timeStamp).atZone(zoneId).toLocalDate();
    }

    public static LocalDate parseLocalDate(@NonNull long timeStamp) {
        return DateUtils.parseLocalDate(timeStamp, SYSTEM_ZONE_ID);
    }

    public static LocalDate parseLocalDate(@NonNull String source, @NonNull String pattern, @NonNull ZoneId zoneId) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        if (zoneId == null) {
            throw new NullPointerException("zoneId is marked non-null but is null");
        }
        source = DateUtils.convertByPattern(source, pattern);
        return LocalDate.parse(source, DateUtils.getDefaultFormatter(pattern, zoneId));
    }

    public static LocalDate parseLocalDate(@NonNull String source, @NonNull String pattern) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        return DateUtils.parseLocalDate(source, pattern, SYSTEM_ZONE_ID);
    }

    public static LocalDate parseLocalDate(@NonNull String source, @NonNull ZoneId zoneId, String ... patterns) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (zoneId == null) {
            throw new NullPointerException("zoneId is marked non-null but is null");
        }
        if (patterns == null) {
            throw new NullPointerException("patterns is marked non-null but is null");
        }
        LocalDate result = null;
        for (String pattern : patterns) {
            try {
                result = DateUtils.parseLocalDate(source, pattern, zoneId);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static LocalDate parseLocalDate(@NonNull String source, String ... patterns) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (patterns == null) {
            throw new NullPointerException("patterns is marked non-null but is null");
        }
        LocalDate result = null;
        for (String pattern : patterns) {
            try {
                result = DateUtils.parseLocalDate(source, pattern);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static LocalDate parseLocalDate(@NonNull String source) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        int length = source.length();
        String pattern = null;
        if (source.contains("-") || source.contains(":")) {
            switch (length) {
                case 10: {
                    pattern = PATTERN_UUUU_MM_DD;
                    break;
                }
                case 7: {
                    pattern = PATTERN_UUUU_MM;
                }
            }
            if (pattern != null) {
                return DateUtils.parseLocalDate(source, pattern);
            }
        }
        return null;
    }

    public static LocalDateTime parseLocalDateTime(@NonNull long timeStamp, @NonNull ZoneId zoneId) {
        if (zoneId == null) {
            throw new NullPointerException("zoneId is marked non-null but is null");
        }
        return Instant.ofEpochMilli(timeStamp).atZone(zoneId).toLocalDateTime();
    }

    public static LocalDateTime parseLocalDateTime(@NonNull long timeStamp) {
        return DateUtils.parseLocalDateTime(timeStamp, SYSTEM_ZONE_ID);
    }

    public static LocalDateTime parseLocalDateTime(@NonNull String source, @NonNull String pattern, @NonNull ZoneId zoneId) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        if (zoneId == null) {
            throw new NullPointerException("zoneId is marked non-null but is null");
        }
        if (StringUtils.isBlank((CharSequence)source)) {
            return null;
        }
        source = DateUtils.convertByPattern(source, pattern);
        return LocalDateTime.parse(source, DateUtils.getDefaultFormatter(pattern, zoneId));
    }

    public static LocalDateTime parseLocalDateTime(@NonNull String source, @NonNull String pattern) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        return DateUtils.parseLocalDateTime(source, pattern, SYSTEM_ZONE_ID);
    }

    public static LocalDateTime parseLocalDateTime(@NonNull String source, @NonNull ZoneId zoneId, String ... patterns) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (zoneId == null) {
            throw new NullPointerException("zoneId is marked non-null but is null");
        }
        if (patterns == null) {
            throw new NullPointerException("patterns is marked non-null but is null");
        }
        LocalDateTime result = null;
        for (String pattern : patterns) {
            try {
                result = DateUtils.parseLocalDateTime(source, pattern, zoneId);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static LocalDateTime parseLocalDateTime(@NonNull String source, String ... patterns) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (patterns == null) {
            throw new NullPointerException("patterns is marked non-null but is null");
        }
        LocalDateTime result = null;
        for (String pattern : patterns) {
            try {
                result = DateUtils.parseLocalDateTime(source, pattern);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static LocalDateTime parseLocalDateTime(@NonNull String source) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        String pattern = null;
        if (source.contains("-") || source.contains(":")) {
            switch (source.length()) {
                case 19: {
                    pattern = PATTERN_UUUU_MM_DD_HH_MM_SS;
                    break;
                }
                case 16: {
                    pattern = PATTERN_UUUU_MM_DD_HH_MM;
                    break;
                }
                case 10: {
                    pattern = PATTERN_UUUU_MM_DD;
                    break;
                }
                case 7: {
                    pattern = PATTERN_UUUU_MM;
                    break;
                }
                case 8: {
                    pattern = PATTERN_HH_MM_SS;
                    break;
                }
                case 5: {
                    pattern = PATTERN_HH_MM;
                    break;
                }
            }
            if (pattern != null) {
                return DateUtils.parseLocalDateTime(source, pattern);
            }
        }
        return null;
    }

    public static LocalTime parseLocalTime(@NonNull long timeStamp, @NonNull ZoneId zoneId) {
        if (zoneId == null) {
            throw new NullPointerException("zoneId is marked non-null but is null");
        }
        return Instant.ofEpochMilli(timeStamp).atZone(zoneId).toLocalTime();
    }

    public static LocalTime parseLocalTime(@NonNull long timeStamp) {
        return DateUtils.parseLocalTime(timeStamp, SYSTEM_ZONE_ID);
    }

    public static LocalTime parseLocalTime(@NonNull String source, @NonNull String pattern, @NonNull ZoneId zoneId) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        if (zoneId == null) {
            throw new NullPointerException("zoneId is marked non-null but is null");
        }
        if (StringUtils.isBlank((CharSequence)source)) {
            return null;
        }
        source = DateUtils.convertByPattern(source, pattern);
        return LocalTime.parse(source, DateUtils.getDefaultFormatter(pattern, zoneId));
    }

    public static LocalTime parseLocalTime(@NonNull String source, @NonNull String pattern) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        return DateUtils.parseLocalTime(source, pattern, SYSTEM_ZONE_ID);
    }

    public static LocalTime parseLocalTime(@NonNull String source, @NonNull ZoneId zoneId, String ... patterns) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (zoneId == null) {
            throw new NullPointerException("zoneId is marked non-null but is null");
        }
        if (patterns == null) {
            throw new NullPointerException("patterns is marked non-null but is null");
        }
        LocalTime result = null;
        for (String pattern : patterns) {
            try {
                result = DateUtils.parseLocalTime(source, pattern, zoneId);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static LocalTime parseLocalTime(@NonNull String source, String ... patterns) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (patterns == null) {
            throw new NullPointerException("patterns is marked non-null but is null");
        }
        LocalTime result = null;
        for (String pattern : patterns) {
            try {
                result = DateUtils.parseLocalTime(source, pattern);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static LocalTime parseLocalTime(@NonNull String source) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        String pattern = null;
        if (source.contains("-") || source.contains(":")) {
            switch (source.length()) {
                case 8: {
                    pattern = PATTERN_HH_MM_SS;
                    break;
                }
                case 5: {
                    pattern = PATTERN_HH_MM;
                    break;
                }
            }
            if (pattern != null) {
                return DateUtils.parseLocalTime(source, pattern);
            }
        }
        return null;
    }

    public static Date toDate(@NonNull Temporal temporal) {
        if (temporal == null) {
            throw new NullPointerException("temporal is marked non-null but is null");
        }
        if (temporal instanceof LocalDate) {
            return Date.from(((LocalDate)temporal).atStartOfDay().atZone(SYSTEM_ZONE_ID).toInstant());
        }
        if (temporal instanceof LocalDateTime) {
            return Date.from(((LocalDateTime)temporal).atZone(SYSTEM_ZONE_ID).toInstant());
        }
        if (temporal instanceof LocalTime) {
            return Date.from(DateUtils.minLocalDateTime(temporal).atZone(SYSTEM_ZONE_ID).toInstant());
        }
        return null;
    }

    public static LocalDate toLocalDate(@NonNull Date date) {
        if (date == null) {
            throw new NullPointerException("date is marked non-null but is null");
        }
        return DateUtils.parseLocalDate(date.getTime());
    }

    public static LocalDateTime toLocalDateTime(@NonNull Date date) {
        if (date == null) {
            throw new NullPointerException("date is marked non-null but is null");
        }
        return DateUtils.parseLocalDateTime(date.getTime());
    }

    public static LocalTime toLocalTime(@NonNull Date date) {
        if (date == null) {
            throw new NullPointerException("date is marked non-null but is null");
        }
        return DateUtils.parseLocalTime(date.getTime());
    }

    public static LocalDateTime minLocalDateTime(@NonNull Temporal temporal) {
        if (temporal == null) {
            throw new NullPointerException("temporal is marked non-null but is null");
        }
        if (temporal instanceof LocalDateTime) {
            return (LocalDateTime)temporal;
        }
        LocalDateTime localDateTime = LocalDateTime.now();
        if (temporal instanceof LocalDate) {
            localDateTime.with(ChronoField.YEAR, ((LocalDate)temporal).getYear());
            localDateTime.with(ChronoField.MONTH_OF_YEAR, ((LocalDate)temporal).getMonthValue());
            localDateTime.with(ChronoField.DAY_OF_MONTH, ((LocalDate)temporal).getDayOfMonth());
        } else {
            localDateTime.with(ChronoField.YEAR, 1970L);
            localDateTime.with(ChronoField.MONTH_OF_YEAR, 1L);
            localDateTime.with(ChronoField.DAY_OF_MONTH, 1L);
        }
        if (temporal instanceof LocalTime) {
            localDateTime.with(ChronoField.HOUR_OF_DAY, ((LocalTime)temporal).getHour());
            localDateTime.with(ChronoField.MINUTE_OF_HOUR, ((LocalTime)temporal).getMinute());
            localDateTime.with(ChronoField.SECOND_OF_MINUTE, ((LocalTime)temporal).getSecond());
            localDateTime.with(ChronoField.MILLI_OF_SECOND, temporal.getLong(ChronoField.MILLI_OF_SECOND));
        } else {
            localDateTime.with(ChronoField.HOUR_OF_DAY, 0L);
            localDateTime.with(ChronoField.MINUTE_OF_HOUR, 0L);
            localDateTime.with(ChronoField.SECOND_OF_MINUTE, 0L);
            localDateTime.with(ChronoField.MILLI_OF_SECOND, 0L);
        }
        return localDateTime;
    }

    public static LocalDateTime minLocalDateTime() {
        LocalDateTime localDateTime = LocalDateTime.now();
        localDateTime.with(ChronoField.YEAR, 1970L);
        localDateTime.with(ChronoField.MONTH_OF_YEAR, 1L);
        localDateTime.with(ChronoField.DAY_OF_MONTH, 1L);
        localDateTime.with(ChronoField.HOUR_OF_DAY, 0L);
        localDateTime.with(ChronoField.MINUTE_OF_HOUR, 0L);
        localDateTime.with(ChronoField.SECOND_OF_MINUTE, 0L);
        localDateTime.with(ChronoField.MILLI_OF_SECOND, 0L);
        return localDateTime;
    }

    public static LocalDate withZoneInstant(@NonNull LocalDate localDate, @NonNull ZoneId oldZoneId, @NonNull ZoneId newZoneId) {
        if (localDate == null) {
            throw new NullPointerException("localDate is marked non-null but is null");
        }
        if (oldZoneId == null) {
            throw new NullPointerException("oldZoneId is marked non-null but is null");
        }
        if (newZoneId == null) {
            throw new NullPointerException("newZoneId is marked non-null but is null");
        }
        return localDate.atStartOfDay().atZone(oldZoneId).withZoneSameInstant(newZoneId).toLocalDate();
    }

    public static LocalDateTime withZoneInstant(@NonNull LocalDateTime localDateTime, @NonNull ZoneId oldZoneId, @NonNull ZoneId newZoneId) {
        if (localDateTime == null) {
            throw new NullPointerException("localDateTime is marked non-null but is null");
        }
        if (oldZoneId == null) {
            throw new NullPointerException("oldZoneId is marked non-null but is null");
        }
        if (newZoneId == null) {
            throw new NullPointerException("newZoneId is marked non-null but is null");
        }
        return localDateTime.atZone(oldZoneId).withZoneSameInstant(newZoneId).toLocalDateTime();
    }

    public static LocalTime withZoneInstant(@NonNull LocalTime localTime, @NonNull ZoneId oldZoneId, @NonNull ZoneId newZoneId) {
        if (localTime == null) {
            throw new NullPointerException("localTime is marked non-null but is null");
        }
        if (oldZoneId == null) {
            throw new NullPointerException("oldZoneId is marked non-null but is null");
        }
        if (newZoneId == null) {
            throw new NullPointerException("newZoneId is marked non-null but is null");
        }
        return DateUtils.minLocalDateTime(localTime).atZone(oldZoneId).withZoneSameInstant(newZoneId).toLocalTime();
    }

    public static String now() {
        return DateUtils.format(LocalDateTime.now());
    }

    public static String now(@NonNull String pattern) {
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        return DateUtils.format((Temporal)LocalDateTime.now(), pattern);
    }

    public static String now(@NonNull ZoneId zoneId) {
        if (zoneId == null) {
            throw new NullPointerException("zoneId is marked non-null but is null");
        }
        return DateUtils.format(ZonedDateTime.now(zoneId).toLocalDateTime());
    }

    public static String now(@NonNull String pattern, ZoneId zoneId) {
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        return DateUtils.format(LocalDateTime.now(), pattern, zoneId);
    }

    public static LocalDateTime todayMinDateTime() {
        return LocalDateTime.of(LocalDate.now(), LocalTime.MIN);
    }

    public static LocalDateTime todayMinDateTime(@NonNull ZoneId zoneId) {
        if (zoneId == null) {
            throw new NullPointerException("zoneId is marked non-null but is null");
        }
        return DateUtils.todayMinDateTime().atZone(zoneId).toLocalDateTime();
    }

    public static String todayMinStr(@NonNull String pattern) {
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        return DateUtils.format((Temporal)LocalDateTime.of(LocalDate.now(), LocalTime.MIN), pattern);
    }

    public static String todayMinStr() {
        return DateUtils.format((Temporal)LocalDateTime.of(LocalDate.now(), LocalTime.MIN), defaultLocalTimePattern);
    }

    public static LocalDateTime todayMaxDateTime() {
        return LocalDateTime.of(LocalDate.now(), LocalTime.MAX);
    }

    public static LocalDateTime todayMaxDateTime(@NonNull ZoneId zoneId) {
        if (zoneId == null) {
            throw new NullPointerException("zoneId is marked non-null but is null");
        }
        return DateUtils.todayMaxDateTime().atZone(zoneId).toLocalDateTime();
    }

    public static LocalTime todayMaxTime() {
        return DateUtils.todayMaxDateTime().toLocalTime();
    }

    public static LocalTime todayMaxTime(@NonNull ZoneId zoneId) {
        if (zoneId == null) {
            throw new NullPointerException("zoneId is marked non-null but is null");
        }
        return DateUtils.todayMaxDateTime(zoneId).toLocalTime();
    }

    public static String todayMaxStr(@NonNull String pattern) {
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        return DateUtils.format((Temporal)LocalDateTime.of(LocalDate.now(), LocalTime.MAX), pattern);
    }

    public static String todayMaxStr() {
        return DateUtils.format((Temporal)LocalDateTime.of(LocalDate.now(), LocalTime.MAX), defaultLocalTimePattern);
    }

    public static <T extends Temporal> T plusOrMinus(@NonNull T temporal, @NonNull long augendOrMinuend, ChronoUnit chronoUnit) {
        if (temporal == null) {
            throw new NullPointerException("temporal is marked non-null but is null");
        }
        if (chronoUnit == null) {
            chronoUnit = ChronoUnit.MILLIS;
        }
        if (augendOrMinuend < 0L) {
            return (T)temporal.minus(Math.abs(augendOrMinuend), chronoUnit);
        }
        if (augendOrMinuend > 0L) {
            return (T)temporal.plus(augendOrMinuend, chronoUnit);
        }
        return temporal;
    }

    public static boolean isIntersection(@NonNull LocalDateTime x1, @NonNull LocalDateTime y1, @NonNull LocalDateTime x2, @NonNull LocalDateTime y2) {
        if (x1 == null) {
            throw new NullPointerException("x1 is marked non-null but is null");
        }
        if (y1 == null) {
            throw new NullPointerException("y1 is marked non-null but is null");
        }
        if (x2 == null) {
            throw new NullPointerException("x2 is marked non-null but is null");
        }
        if (y2 == null) {
            throw new NullPointerException("y2 is marked non-null but is null");
        }
        return !y1.isBefore(x2) && !y2.isBefore(x1);
    }

    public static LocalDateTime[] getIntersection(@NonNull LocalDateTime x1, @NonNull LocalDateTime y1, @NonNull LocalDateTime x2, @NonNull LocalDateTime y2) {
        if (x1 == null) {
            throw new NullPointerException("x1 is marked non-null but is null");
        }
        if (y1 == null) {
            throw new NullPointerException("y1 is marked non-null but is null");
        }
        if (x2 == null) {
            throw new NullPointerException("x2 is marked non-null but is null");
        }
        if (y2 == null) {
            throw new NullPointerException("y2 is marked non-null but is null");
        }
        if (!DateUtils.isIntersection(x1, y1, x2, y2)) {
            return null;
        }
        LocalDateTime[] result = new LocalDateTime[2];
        if (x1.isBefore(x2) || x1.isEqual(x2)) {
            result[0] = x2;
        } else if (x1.isAfter(x2)) {
            result[0] = x1;
        }
        if (y1.isBefore(y2) || y1.isEqual(y2)) {
            result[1] = y1;
        } else if (y1.isAfter(y2)) {
            result[1] = y2;
        }
        return result;
    }

    public static List<LocalDateTime[]> getDifferenceSetsByIntersectional(@NonNull LocalDateTime x1, @NonNull LocalDateTime y1, @NonNull LocalDateTime x2, @NonNull LocalDateTime y2) {
        if (x1 == null) {
            throw new NullPointerException("x1 is marked non-null but is null");
        }
        if (y1 == null) {
            throw new NullPointerException("y1 is marked non-null but is null");
        }
        if (x2 == null) {
            throw new NullPointerException("x2 is marked non-null but is null");
        }
        if (y2 == null) {
            throw new NullPointerException("y2 is marked non-null but is null");
        }
        LocalDateTime[] intersections = DateUtils.getIntersection(x1, y1, x2, y2);
        if (intersections == null || intersections.length == 0) {
            return null;
        }
        ArrayList<LocalDateTime[]> result = new ArrayList<LocalDateTime[]>();
        if (x1.isBefore(x2)) {
            result.add(new LocalDateTime[]{x1, x2});
        } else if (x1.isAfter(x2)) {
            result.add(new LocalDateTime[]{x2, x1});
        }
        if (y1.isBefore(y2)) {
            result.add(new LocalDateTime[]{y1, y2});
        } else if (y1.isAfter(y2)) {
            result.add(new LocalDateTime[]{y2, y1});
        }
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            LocalDateTime[] localDateTimes = (LocalDateTime[])iterator.next();
            if (localDateTimes[0].equals(intersections[1])) {
                localDateTimes[0] = DateUtils.plusOrMinus(localDateTimes[0], 1L, ChronoUnit.DAYS);
            }
            if (localDateTimes[1].equals(intersections[0])) {
                localDateTimes[1] = DateUtils.plusOrMinus(localDateTimes[1], -1L, ChronoUnit.DAYS);
            }
            if (!localDateTimes[1].isBefore(localDateTimes[0])) continue;
            iterator.remove();
        }
        return result;
    }

    public static String[] convertWeeks(@NonNull String weeks, @NonNull String splitRegex) {
        if (weeks == null) {
            throw new NullPointerException("weeks is marked non-null but is null");
        }
        if (splitRegex == null) {
            throw new NullPointerException("splitRegex is marked non-null but is null");
        }
        if (RegExUtils.isMatch("[^,1-7]*", weeks)) {
            weeks = weeks.replaceAll("[^,1-7]*", "");
        }
        if (StringUtils.isBlank((CharSequence)weeks)) {
            return new String[0];
        }
        return weeks.split(splitRegex);
    }

    public static String[] convertWeeks(@NonNull String weeks) {
        if (weeks == null) {
            throw new NullPointerException("weeks is marked non-null but is null");
        }
        String regex = ",";
        if (!weeks.contains(regex)) {
            regex = "";
        }
        return DateUtils.convertWeeks(weeks, regex);
    }

    public static List<LocalDateTime> getByWeeks(@NonNull String weeks, LocalDateTime ... times) {
        if (weeks == null) {
            throw new NullPointerException("weeks is marked non-null but is null");
        }
        if (times == null) {
            throw new NullPointerException("times is marked non-null but is null");
        }
        ArrayList<LocalDateTime> timeList = null;
        if (!CollectionUtils.sizeIsEmpty(times)) {
            List<String> weekList = Arrays.asList(DateUtils.convertWeeks(weeks));
            timeList = new ArrayList<LocalDateTime>(Arrays.asList(times));
            timeList.removeIf(time -> !weekList.contains(String.valueOf(time.getDayOfWeek().getValue())));
        }
        return timeList;
    }

    public static List<String> getByRange(@NonNull LocalDateTime startTime, @NonNull LocalDateTime endTime, @NonNull String pattern) {
        if (startTime == null) {
            throw new NullPointerException("startTime is marked non-null but is null");
        }
        if (endTime == null) {
            throw new NullPointerException("endTime is marked non-null but is null");
        }
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        ArrayList<String> result = new ArrayList<String>();
        long distance = ChronoUnit.DAYS.between(startTime, endTime);
        if (distance >= 1L) {
            Stream.iterate(startTime, day -> day.plusDays(1L)).limit(distance + 1L).forEach(f -> result.add(DateUtils.format((Temporal)f, pattern)));
        }
        return result;
    }

    public static List<String> getByRangeAndWeeks(@NonNull LocalDateTime startTime, @NonNull LocalDateTime endTime, @NonNull String weeks, @NonNull String pattern) {
        if (startTime == null) {
            throw new NullPointerException("startTime is marked non-null but is null");
        }
        if (endTime == null) {
            throw new NullPointerException("endTime is marked non-null but is null");
        }
        if (weeks == null) {
            throw new NullPointerException("weeks is marked non-null but is null");
        }
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        ArrayList<String> result = new ArrayList<String>();
        TemporalField field = WeekFields.of(DayOfWeek.of(1), 1).dayOfWeek();
        for (String week : DateUtils.convertWeeks(weeks)) {
            LocalDateTime dayByWeek = startTime.with(field, Long.parseLong(week));
            if (dayByWeek.isBefore(startTime)) {
                dayByWeek = dayByWeek.plusWeeks(1L);
            }
            while (dayByWeek.isBefore(endTime) || dayByWeek.isEqual(endTime)) {
                result.add(DateUtils.format((Temporal)dayByWeek, pattern));
                dayByWeek = dayByWeek.plusWeeks(1L);
            }
        }
        return result;
    }

    public static List<LocalDateTime> getByRangeAndWeeks(@NonNull LocalDateTime startTime, @NonNull LocalDateTime endTime, @NonNull String weeks) {
        if (startTime == null) {
            throw new NullPointerException("startTime is marked non-null but is null");
        }
        if (endTime == null) {
            throw new NullPointerException("endTime is marked non-null but is null");
        }
        if (weeks == null) {
            throw new NullPointerException("weeks is marked non-null but is null");
        }
        ArrayList<LocalDateTime> result = new ArrayList<LocalDateTime>();
        TemporalField field = WeekFields.of(DayOfWeek.of(1), 1).dayOfWeek();
        for (String week : DateUtils.convertWeeks(weeks)) {
            LocalDateTime tempDay = startTime.with(field, Long.parseLong(week));
            if (tempDay.isBefore(startTime)) {
                tempDay = tempDay.plusWeeks(1L);
            }
            while (tempDay.isBefore(endTime) || tempDay.isEqual(endTime)) {
                result.add(tempDay);
                tempDay = tempDay.plusWeeks(1L);
            }
        }
        return result;
    }
}

