/*
 * Decompiled with CFR 0.152.
 */
package top.zhogjianhao;

import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cglib.beans.BeanMap;
import top.zhogjianhao.StringUtils;

public class BeanUtils
extends org.springframework.beans.BeanUtils {
    private static final Logger log = LoggerFactory.getLogger(BeanUtils.class);

    public static HashMap<String, Object> toMap(Object obj) {
        return new HashMap<String, Object>((Map<String, Object>)BeanMap.create((Object)obj));
    }

    public static Object getProperty(Object bean, String name) {
        try {
            PropertyDescriptor propertyDescriptor = org.springframework.beans.BeanUtils.getPropertyDescriptor(bean.getClass(), (String)name);
            if (propertyDescriptor != null) {
                return propertyDescriptor.getReadMethod().invoke(bean, null);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public static String getPropertyStr(Object bean, String name) {
        Object obj = BeanUtils.getProperty(bean, name);
        if (obj != null) {
            return obj.toString();
        }
        return null;
    }

    public static boolean setProperty(Object bean, String name, Object value) {
        try {
            PropertyDescriptor propertyDescriptor = org.springframework.beans.BeanUtils.getPropertyDescriptor(bean.getClass(), (String)name);
            if (propertyDescriptor != null) {
                propertyDescriptor.getWriteMethod().invoke(bean, value);
                return true;
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public static <T> String getFieldName(FieldFunction<T, ?> fn) {
        try {
            Method method = fn.getClass().getDeclaredMethod("writeReplace", new Class[0]);
            method.setAccessible(Boolean.TRUE);
            SerializedLambda serializedLambda = (SerializedLambda)method.invoke(fn, new Object[0]);
            String implMethodName = serializedLambda.getImplMethodName();
            if (implMethodName.startsWith("get")) {
                implMethodName = implMethodName.substring(3);
            } else if (implMethodName.startsWith("is")) {
                implMethodName = implMethodName.substring(2);
            }
            if (StringUtils.isNotBlank((CharSequence)implMethodName)) {
                return implMethodName.substring(0, 1).toLowerCase() + implMethodName.substring(1);
            }
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
        return "";
    }

    public static <T> String getColumnName(FieldFunction<T, ?> fn) {
        return StringUtils.toUnderscore(BeanUtils.getFieldName(fn));
    }

    @FunctionalInterface
    public static interface FieldFunction<T, R>
    extends Function<T, R>,
    Serializable {
    }
}

