/*
 * Decompiled with CFR 0.152.
 */
package top.zhogjianhao;

import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import lombok.NonNull;

public class CollectionUtils {
    public static boolean isEmpty(Collection<?> coll) {
        return org.apache.commons.collections4.CollectionUtils.isEmpty(coll);
    }

    public static boolean isNotEmpty(Collection<?> coll) {
        return org.apache.commons.collections4.CollectionUtils.isNotEmpty(coll);
    }

    public static boolean sizeIsEmpty(Object obj) {
        return org.apache.commons.collections4.CollectionUtils.sizeIsEmpty((Object)obj);
    }

    public static boolean sizeIsNotEmpty(Object obj) {
        return !CollectionUtils.sizeIsEmpty(obj);
    }

    public static boolean isAllEmpty(Object obj) {
        if (CollectionUtils.sizeIsEmpty(obj)) {
            return true;
        }
        if (obj instanceof Collection) {
            Collection obj1 = (Collection)obj;
            obj1.removeIf(Objects::isNull);
            return obj1.size() == 0;
        }
        if (obj instanceof Iterable) {
            for (Object o : (Iterable)obj) {
                if (o == null) continue;
                return false;
            }
            return true;
        }
        if (obj instanceof Map) {
            Map obj1 = (Map)obj;
            return CollectionUtils.isAllEmpty(obj1.values());
        }
        if (obj instanceof Object[]) {
            Object[] obj1 = (Object[])obj;
            return Arrays.stream(obj1).noneMatch(Objects::nonNull);
        }
        if (obj instanceof Iterator) {
            Iterator obj1 = (Iterator)obj;
            while (obj1.hasNext()) {
                if (obj1.next() == null) continue;
                return false;
            }
            return true;
        }
        if (obj instanceof Enumeration) {
            Enumeration obj1 = (Enumeration)obj;
            while (obj1.hasMoreElements()) {
                if (obj1.nextElement() == null) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isNotAllEmpty(Object obj) {
        return !CollectionUtils.isAllEmpty(obj);
    }

    public static boolean isAnyEmpty(Object obj) {
        if (CollectionUtils.sizeIsEmpty(obj)) {
            return true;
        }
        if (obj instanceof Collection) {
            Collection obj1 = (Collection)obj;
            return obj1.contains(null);
        }
        if (obj instanceof Iterable) {
            for (Object o : (Iterable)obj) {
                if (o != null) continue;
                return true;
            }
            return false;
        }
        if (obj instanceof Map) {
            Map obj1 = (Map)obj;
            return obj1.containsValue(null);
        }
        if (obj instanceof Object[]) {
            Object[] obj1 = (Object[])obj;
            return Arrays.stream(obj1).anyMatch(Objects::isNull);
        }
        if (obj instanceof Iterator) {
            Iterator obj1 = (Iterator)obj;
            while (obj1.hasNext()) {
                if (obj1.next() != null) continue;
                return true;
            }
            return false;
        }
        if (obj instanceof Enumeration) {
            Enumeration obj1 = (Enumeration)obj;
            while (obj1.hasMoreElements()) {
                if (obj1.nextElement() != null) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean isNotAnyEmpty(Object obj) {
        return !CollectionUtils.isAnyEmpty(obj);
    }

    public static boolean moveForward(@NonNull Object arr, int arrLength, int startIndex, int length) {
        if (arr == null) {
            throw new NullPointerException("arr is marked non-null but is null");
        }
        if (!(arr instanceof Object[] || arr instanceof int[] || arr instanceof long[] || arr instanceof double[] || arr instanceof float[] || arr instanceof boolean[] || arr instanceof short[] || arr instanceof byte[] || arr instanceof char[])) {
            return false;
        }
        if (arrLength - length - startIndex >= 0) {
            System.arraycopy(arr, startIndex + length, arr, startIndex, arrLength - length - startIndex);
            return true;
        }
        return false;
    }

    public static boolean remove(@NonNull Object[] arr, int index, Object lastElementValue) {
        if (arr == null) {
            throw new NullPointerException("arr is marked non-null but is null");
        }
        if (index < 0) {
            return false;
        }
        CollectionUtils.moveForward(arr, arr.length, index, 1);
        arr[arr.length - 1] = lastElementValue;
        return true;
    }

    public static boolean remove(@NonNull Object[] arr, int index) {
        if (arr == null) {
            throw new NullPointerException("arr is marked non-null but is null");
        }
        return CollectionUtils.remove(arr, index, null);
    }

    public static <T> boolean remove(@NonNull T arr, int index, Object lastElementValue) {
        if (arr == null) {
            throw new NullPointerException("arr is marked non-null but is null");
        }
        if (arr instanceof int[]) {
            CollectionUtils.moveForward(arr, ((int[])arr).length, index, 1);
            if (lastElementValue != null) {
                ((int[])arr)[((int[])arr).length - 1] = (Integer)lastElementValue;
            }
        } else if (arr instanceof long[]) {
            CollectionUtils.moveForward(arr, ((long[])arr).length, index, 1);
            if (lastElementValue != null) {
                ((long[])arr)[((long[])arr).length - 1] = (Long)lastElementValue;
            }
        } else if (arr instanceof double[]) {
            CollectionUtils.moveForward(arr, ((double[])arr).length, index, 1);
            if (lastElementValue != null) {
                ((double[])arr)[((double[])arr).length - 1] = (Double)lastElementValue;
            }
        } else if (arr instanceof float[]) {
            CollectionUtils.moveForward(arr, ((float[])arr).length, index, 1);
            if (lastElementValue != null) {
                ((float[])arr)[((float[])arr).length - 1] = ((Float)lastElementValue).floatValue();
            }
        } else if (arr instanceof boolean[]) {
            CollectionUtils.moveForward(arr, ((boolean[])arr).length, index, 1);
            if (lastElementValue != null) {
                ((boolean[])arr)[((boolean[])arr).length - 1] = (Boolean)lastElementValue;
            }
        } else if (arr instanceof short[]) {
            CollectionUtils.moveForward(arr, ((short[])arr).length, index, 1);
            if (lastElementValue != null) {
                ((short[])arr)[((short[])arr).length - 1] = (Short)lastElementValue;
            }
        } else if (arr instanceof byte[]) {
            CollectionUtils.moveForward(arr, ((byte[])arr).length, index, 1);
            if (lastElementValue != null) {
                ((byte[])arr)[((byte[])arr).length - 1] = (Byte)lastElementValue;
            }
        } else if (arr instanceof char[]) {
            CollectionUtils.moveForward(arr, ((char[])arr).length, index, 1);
            if (lastElementValue != null) {
                ((char[])arr)[((char[])arr).length - 1] = ((Character)lastElementValue).charValue();
            }
        }
        return true;
    }

    public static <T> boolean remove(@NonNull T arr, int index) {
        if (arr == null) {
            throw new NullPointerException("arr is marked non-null but is null");
        }
        return CollectionUtils.remove(arr, index, null);
    }
}

