/*
 * Decompiled with CFR 0.152.
 */
package top.zhogjianhao;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.NavigableSet;
import java.util.TreeSet;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.zhogjianhao.StringUtils;
import top.zhogjianhao.charset.StandardCharsets;

public final class ArrayUtils
extends org.apache.commons.lang3.ArrayUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ArrayUtils.class);

    public static byte[] toBytes(@NonNull char[] chars, @NonNull Charset charsets) {
        if (chars == null) {
            throw new NullPointerException("chars is marked non-null but is null");
        }
        if (charsets == null) {
            throw new NullPointerException("charsets is marked non-null but is null");
        }
        return new String(chars).getBytes(charsets);
    }

    public static byte[] toBytes(@NonNull char[] chars, @NonNull String charsetName) {
        if (chars == null) {
            throw new NullPointerException("chars is marked non-null but is null");
        }
        if (charsetName == null) {
            throw new NullPointerException("charsetName is marked non-null but is null");
        }
        try {
            return new String(chars).getBytes(charsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] toBytes(@NonNull char[] chars) {
        if (chars == null) {
            throw new NullPointerException("chars is marked non-null but is null");
        }
        return new String(chars).getBytes(StandardCharsets.UTF_8);
    }

    public static String toString(@NonNull byte[] bytes, @NonNull Charset charsets) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        if (charsets == null) {
            throw new NullPointerException("charsets is marked non-null but is null");
        }
        return new String(bytes, charsets);
    }

    public static String toString(@NonNull byte[] bytes, @NonNull String charsetName) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        if (charsetName == null) {
            throw new NullPointerException("charsetName is marked non-null but is null");
        }
        try {
            return new String(bytes, charsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String toString(@NonNull byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        return new String(bytes);
    }

    public static char[] toChars(@NonNull byte[] bytes, @NonNull Charset charsets) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        if (charsets == null) {
            throw new NullPointerException("charsets is marked non-null but is null");
        }
        return ArrayUtils.toString(bytes, charsets).toCharArray();
    }

    public static char[] toChars(@NonNull byte[] bytes, @NonNull String charsetName) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        if (charsetName == null) {
            throw new NullPointerException("charsetName is marked non-null but is null");
        }
        return ArrayUtils.toString(bytes, charsetName).toCharArray();
    }

    public static char[] toChars(@NonNull byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        return ArrayUtils.toString(bytes).toCharArray();
    }

    private static Object moveForward(@NonNull Object array, int startIndex, int length) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        int arrayLen = ArrayUtils.getLength((Object)array);
        if (arrayLen == 0) {
            throw new IllegalArgumentException("Array: should not be empty");
        }
        if (startIndex < 0 || length < 1 || startIndex >= arrayLen || arrayLen - length < 0) {
            throw new IndexOutOfBoundsException("StartIndex: " + startIndex + ", Length:" + length);
        }
        Object result = Array.newInstance(array.getClass().getComponentType(), arrayLen);
        System.arraycopy(array, 0, result, 0, startIndex);
        System.arraycopy(array, startIndex + length, result, startIndex, arrayLen - length - startIndex);
        return result;
    }

    public static boolean[] moveForward(@NonNull boolean[] array, int startIndex, int length) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (boolean[])ArrayUtils.moveForward((Object)array, startIndex, length);
    }

    public static byte[] moveForward(@NonNull byte[] array, int startIndex, int length) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (byte[])ArrayUtils.moveForward((Object)array, startIndex, length);
    }

    public static char[] moveForward(@NonNull char[] array, int startIndex, int length) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (char[])ArrayUtils.moveForward((Object)array, startIndex, length);
    }

    public static short[] moveForward(@NonNull short[] array, int startIndex, int length) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (short[])ArrayUtils.moveForward((Object)array, startIndex, length);
    }

    public static int[] moveForward(@NonNull int[] array, int startIndex, int length) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (int[])ArrayUtils.moveForward((Object)array, startIndex, length);
    }

    public static long[] moveForward(@NonNull long[] array, int startIndex, int length) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (long[])ArrayUtils.moveForward((Object)array, startIndex, length);
    }

    public static float[] moveForward(@NonNull float[] array, int startIndex, int length) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (float[])ArrayUtils.moveForward((Object)array, startIndex, length);
    }

    public static double[] moveForward(@NonNull double[] array, int startIndex, int length) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (double[])ArrayUtils.moveForward((Object)array, startIndex, length);
    }

    public static <T> T[] moveForward(@NonNull T[] array, int startIndex, int length) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (Object[])ArrayUtils.moveForward(array, startIndex, length);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Object remove(@NonNull Object array, int index, @NonNull Object lastElementValue) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (lastElementValue == null) {
            throw new NullPointerException("lastElementValue is marked non-null but is null");
        }
        Object result = ArrayUtils.moveForward(array, index, 1);
        if (array instanceof boolean[]) {
            ((boolean[])result)[((boolean[])result).length - 1] = Boolean.parseBoolean(lastElementValue.toString());
            return result;
        } else if (array instanceof byte[]) {
            ((byte[])result)[((byte[])result).length - 1] = Byte.parseByte(lastElementValue.toString());
            return result;
        } else if (array instanceof char[]) {
            String s = lastElementValue.toString();
            if (s.length() != 1) throw new IllegalArgumentException("LastElementValue: should be a char");
            ((char[])result)[((char[])result).length - 1] = s.charAt(0);
            return result;
        } else if (array instanceof short[]) {
            ((short[])result)[((short[])result).length - 1] = Short.parseShort(lastElementValue.toString());
            return result;
        } else if (array instanceof int[]) {
            ((int[])result)[((int[])result).length - 1] = Integer.parseInt(lastElementValue.toString());
            return result;
        } else if (array instanceof long[]) {
            ((long[])result)[((long[])result).length - 1] = Long.parseLong(lastElementValue.toString());
            return result;
        } else if (array instanceof float[]) {
            ((float[])result)[((float[])result).length - 1] = Float.parseFloat(lastElementValue.toString());
            return result;
        } else if (array instanceof double[]) {
            ((double[])result)[((double[])result).length - 1] = Double.parseDouble(lastElementValue.toString());
            return result;
        } else {
            ((Object[])result)[((Object[])result).length - 1] = lastElementValue;
        }
        return result;
    }

    public static boolean[] remove(@NonNull boolean[] array, int index, boolean lastElementValue) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (boolean[])ArrayUtils.remove((Object)array, index, (Object)lastElementValue);
    }

    public static byte[] remove(@NonNull byte[] array, int index, byte lastElementValue) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (byte[])ArrayUtils.remove((Object)array, index, (Object)lastElementValue);
    }

    public static char[] remove(@NonNull char[] array, int index, char lastElementValue) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (char[])ArrayUtils.remove((Object)array, index, Character.valueOf(lastElementValue));
    }

    public static short[] remove(@NonNull short[] array, int index, short lastElementValue) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (short[])ArrayUtils.remove((Object)array, index, (Object)lastElementValue);
    }

    public static int[] remove(@NonNull int[] array, int index, int lastElementValue) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (int[])ArrayUtils.remove((Object)array, index, (Object)lastElementValue);
    }

    public static long[] remove(@NonNull long[] array, int index, long lastElementValue) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (long[])ArrayUtils.remove((Object)array, index, (Object)lastElementValue);
    }

    public static float[] remove(@NonNull float[] array, int index, float lastElementValue) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (float[])ArrayUtils.remove((Object)array, index, Float.valueOf(lastElementValue));
    }

    public static double[] remove(@NonNull double[] array, int index, double lastElementValue) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (double[])ArrayUtils.remove((Object)array, index, (Object)lastElementValue);
    }

    public static <T> T[] remove(@NonNull T[] array, int index, @NonNull T lastElementValue) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (lastElementValue == null) {
            throw new NullPointerException("lastElementValue is marked non-null but is null");
        }
        return (Object[])ArrayUtils.remove(array, index, lastElementValue);
    }

    private static Object fill(@NonNull Object array, int fromIndex, int toIndex, Object value) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        int arrayLen = ArrayUtils.getLength((Object)array);
        Object result = array;
        if (toIndex > arrayLen) {
            result = Array.newInstance(array.getClass().getComponentType(), toIndex);
            System.arraycopy(array, 0, result, 0, arrayLen);
        }
        if (result instanceof boolean[]) {
            if (!(value instanceof Boolean)) {
                throw new IllegalArgumentException("Value: should be Boolean");
            }
            Arrays.fill((boolean[])result, fromIndex, toIndex, (Boolean)value);
        } else if (result instanceof byte[]) {
            if (!(value instanceof Byte)) {
                throw new IllegalArgumentException("Value: should be Byte");
            }
            Arrays.fill((byte[])result, fromIndex, toIndex, (Byte)value);
        } else if (result instanceof char[]) {
            if (!(value instanceof Character)) {
                throw new IllegalArgumentException("Value: should be Character");
            }
            Arrays.fill((char[])result, fromIndex, toIndex, ((Character)value).charValue());
        } else if (result instanceof short[]) {
            if (!(value instanceof Short)) {
                throw new IllegalArgumentException("Value: should be Short");
            }
            Arrays.fill((short[])result, fromIndex, toIndex, (Short)value);
        } else if (result instanceof int[]) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("Value: should be Integer");
            }
            Arrays.fill((int[])result, fromIndex, toIndex, (Integer)value);
        } else if (result instanceof long[]) {
            if (!(value instanceof Long)) {
                throw new IllegalArgumentException("Value: should be Long");
            }
            Arrays.fill((long[])result, fromIndex, toIndex, (Long)value);
        } else if (result instanceof float[]) {
            if (!(value instanceof Float)) {
                throw new IllegalArgumentException("Value: should be Float");
            }
            Arrays.fill((float[])result, fromIndex, toIndex, ((Float)value).floatValue());
        } else if (result instanceof double[]) {
            if (!(value instanceof Double)) {
                throw new IllegalArgumentException("Value: should be Double");
            }
            Arrays.fill((double[])result, fromIndex, toIndex, (Double)value);
        } else {
            Arrays.fill((Object[])result, fromIndex, toIndex, value);
        }
        return result;
    }

    public static boolean[] fill(@NonNull boolean[] array, int fromIndex, int toIndex, boolean value) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (boolean[])ArrayUtils.fill((Object)array, fromIndex, toIndex, (Object)value);
    }

    public static byte[] fill(@NonNull byte[] array, int fromIndex, int toIndex, byte value) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (byte[])ArrayUtils.fill((Object)array, fromIndex, toIndex, (Object)value);
    }

    public static char[] fill(@NonNull char[] array, int fromIndex, int toIndex, char value) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (char[])ArrayUtils.fill((Object)array, fromIndex, toIndex, Character.valueOf(value));
    }

    public static short[] fill(@NonNull short[] array, int fromIndex, int toIndex, short value) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (short[])ArrayUtils.fill((Object)array, fromIndex, toIndex, (Object)value);
    }

    public static int[] fill(@NonNull int[] array, int fromIndex, int toIndex, int value) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (int[])ArrayUtils.fill((Object)array, fromIndex, toIndex, (Object)value);
    }

    public static long[] fill(@NonNull long[] array, int fromIndex, int toIndex, long value) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (long[])ArrayUtils.fill((Object)array, fromIndex, toIndex, (Object)value);
    }

    public static float[] fill(@NonNull float[] array, int fromIndex, int toIndex, float value) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (float[])ArrayUtils.fill((Object)array, fromIndex, toIndex, Float.valueOf(value));
    }

    public static double[] fill(@NonNull double[] array, int fromIndex, int toIndex, double value) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (double[])ArrayUtils.fill((Object)array, fromIndex, toIndex, (Object)value);
    }

    public static <T> T[] fill(@NonNull T[] array, int fromIndex, int toIndex, T value) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (Object[])ArrayUtils.fill(array, fromIndex, toIndex, value);
    }

    private static Object removeAllElements(@NonNull Object array, Object ... values) {
        Object[] result;
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        if (ArrayUtils.getLength((Object)array) == 0) {
            return array;
        }
        if (array instanceof int[]) {
            result = ((int[])array).clone();
            for (Object value : values) {
                if (!ArrayUtils.contains((int[])((int[])array), (int)((int[])value)[0])) continue;
                result = ArrayUtils.removeElement((int[])((int[])result), (int)((int[])value)[0]);
            }
        } else if (array instanceof long[]) {
            result = ((long[])array).clone();
            for (Object value : values) {
                if (!ArrayUtils.contains((long[])((long[])array), (long)((long[])value)[0])) continue;
                result = ArrayUtils.removeElement((long[])((long[])result), (long)((long[])value)[0]);
            }
        } else if (array instanceof double[]) {
            result = ((double[])array).clone();
            for (Object value : values) {
                if (!ArrayUtils.contains((double[])((double[])array), (double)((double[])value)[0])) continue;
                result = ArrayUtils.removeElement((double[])((double[])result), (double)((double[])value)[0]);
            }
        } else if (array instanceof float[]) {
            result = ((float[])array).clone();
            for (Object value : values) {
                if (!ArrayUtils.contains((float[])((float[])array), (float)((float[])value)[0])) continue;
                result = ArrayUtils.removeElement((float[])((float[])result), (float)((float[])value)[0]);
            }
        } else if (array instanceof byte[]) {
            result = ((byte[])array).clone();
            for (Object value : values) {
                if (!ArrayUtils.contains((byte[])((byte[])array), (byte)((byte[])value)[0])) continue;
                result = ArrayUtils.removeElement((byte[])((byte[])result), (byte)((byte[])value)[0]);
            }
        } else if (array instanceof char[]) {
            result = ((char[])array).clone();
            for (Object value : values) {
                if (!ArrayUtils.contains((char[])((char[])array), (char)((char[])value)[0])) continue;
                result = ArrayUtils.removeElement((char[])((char[])result), (char)((char[])value)[0]);
            }
        } else if (array instanceof boolean[]) {
            result = ((boolean[])array).clone();
            for (Object value : values) {
                if (!ArrayUtils.contains((boolean[])((boolean[])array), (boolean)((boolean[])value)[0])) continue;
                result = ArrayUtils.removeElement((boolean[])((boolean[])result), (boolean)((boolean[])value)[0]);
            }
        } else if (array instanceof short[]) {
            result = ((short[])array).clone();
            for (Object value : values) {
                if (!ArrayUtils.contains((short[])((short[])array), (short)((short[])value)[0])) continue;
                result = ArrayUtils.removeElement((short[])((short[])result), (short)((short[])value)[0]);
            }
        } else {
            result = ((Object[])array).clone();
            for (Object value : values) {
                if (!ArrayUtils.contains((Object[])((Object[])array), (Object)((Object[])value)[0])) continue;
                result = ArrayUtils.removeElement((Object[])result, (Object)((Object[])value)[0]);
            }
        }
        return result;
    }

    public static boolean[] removeAllElements(@NonNull boolean[] array, boolean ... values) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        return (boolean[])ArrayUtils.removeAllElements((Object)array, new Object[]{values});
    }

    public static byte[] removeAllElements(@NonNull byte[] array, byte ... values) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        return (byte[])ArrayUtils.removeAllElements((Object)array, new Object[]{values});
    }

    public static char[] removeAllElements(@NonNull char[] array, char ... values) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        return (char[])ArrayUtils.removeAllElements((Object)array, new Object[]{values});
    }

    public static short[] removeAllElements(@NonNull short[] array, short ... values) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        return (short[])ArrayUtils.removeAllElements((Object)array, new Object[]{values});
    }

    public static int[] removeAllElements(@NonNull int[] array, int ... values) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        return (int[])ArrayUtils.removeAllElements((Object)array, new Object[]{values});
    }

    public static long[] removeAllElements(@NonNull long[] array, long ... values) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        return (long[])ArrayUtils.removeAllElements((Object)array, new Object[]{values});
    }

    public static float[] removeAllElements(@NonNull float[] array, float ... values) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        return (float[])ArrayUtils.removeAllElements((Object)array, new Object[]{values});
    }

    public static double[] removeAllElements(@NonNull double[] array, double ... values) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        return (double[])ArrayUtils.removeAllElements((Object)array, new Object[]{values});
    }

    public static <T> T[] removeAllElements(@NonNull T[] array, T ... values) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        return (Object[])ArrayUtils.removeAllElements(array, new Object[]{values});
    }

    public static int indexOf(@NonNull char[] array, @NonNull String valueToFind, int startIndex) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (valueToFind == null) {
            throw new NullPointerException("valueToFind is marked non-null but is null");
        }
        if (ArrayUtils.isEmpty((char[])array)) {
            return -1;
        }
        if (StringUtils.isBlank((CharSequence)valueToFind)) {
            throw new IllegalArgumentException("ValueToFind: should not be blank");
        }
        if (startIndex < 0) {
            throw new IllegalArgumentException("StartIndex: should be greater than or equal to 0");
        }
        if (valueToFind.length() == 2) {
            int charsLastElementIndex = array.length - 1;
            char[] valChars = valueToFind.toCharArray();
            char lChar = valChars[0];
            char rChar = valChars[1];
            int lCharIndex = ArrayUtils.indexOf((char[])array, (char)lChar, (int)startIndex);
            if (lCharIndex == -1) {
                return -1;
            }
            if (lCharIndex == charsLastElementIndex) {
                return -1;
            }
            int rCharIndex = ArrayUtils.indexOf((char[])array, (char)rChar, (int)(lCharIndex + 1));
            if (rCharIndex == -1) {
                return -1;
            }
            if (rCharIndex == lCharIndex + 1) {
                return lCharIndex;
            }
        }
        return new String(array).indexOf(valueToFind, startIndex);
    }

    public static int indexOf(@NonNull char[] array, @NonNull String valueToFind) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (valueToFind == null) {
            throw new NullPointerException("valueToFind is marked non-null but is null");
        }
        return ArrayUtils.indexOf(array, valueToFind, 0);
    }

    public static int allLength(String ... strs) {
        if (strs == null) {
            throw new NullPointerException("strs is marked non-null but is null");
        }
        if (StringUtils.isAllBlank((CharSequence[])strs)) {
            return 0;
        }
        int result = 0;
        for (String str : strs) {
            result += str.length();
        }
        return result;
    }

    private static Object deduplicate(@NonNull Object array) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        Object[] array1 = (Object[])array;
        int arrayLen = array1.length;
        Object[] newArr = (Object[])Array.newInstance(array1.getClass().getComponentType(), arrayLen);
        int x = 0;
        for (int i = 0; i < arrayLen; ++i) {
            int j;
            for (j = 0; j < i && !array1[i].equals(array1[j]); ++j) {
            }
            if (i != j) continue;
            newArr[x] = array1[i];
            ++x;
        }
        return Arrays.copyOf(newArr, x);
    }

    public static boolean[] deduplicate(@NonNull boolean[] array) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (boolean[])ArrayUtils.deduplicate((Object)array);
    }

    public static byte[] deduplicate(@NonNull byte[] array) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (byte[])ArrayUtils.deduplicate((Object)array);
    }

    public static char[] deduplicate(@NonNull char[] array) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (char[])ArrayUtils.deduplicate((Object)array);
    }

    public static short[] deduplicate(@NonNull short[] array) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (short[])ArrayUtils.deduplicate((Object)array);
    }

    public static int[] deduplicate(@NonNull int[] array) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (int[])ArrayUtils.deduplicate((Object)array);
    }

    public static long[] deduplicate(@NonNull long[] array) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (long[])ArrayUtils.deduplicate((Object)array);
    }

    public static float[] deduplicate(@NonNull float[] array) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (float[])ArrayUtils.deduplicate((Object)array);
    }

    public static double[] deduplicate(@NonNull double[] array) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (double[])ArrayUtils.deduplicate((Object)array);
    }

    public static <T> T[] deduplicate(@NonNull T[] array) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (Object[])ArrayUtils.deduplicate(array);
    }

    public static Object deduplicatePreceding(@NonNull Object array) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        Object[] array1 = (Object[])array;
        int t = 0;
        int arrayLen = array1.length;
        Object[] tempArr = new Object[arrayLen];
        for (int i = 0; i < arrayLen; ++i) {
            boolean isTrue = true;
            for (int j = i + 1; j < arrayLen; ++j) {
                if (!array1[i].equals(array1[j])) continue;
                isTrue = false;
                break;
            }
            if (!isTrue) continue;
            tempArr[t] = array1[i];
            ++t;
        }
        Object[] newArr = new Object[t];
        System.arraycopy(tempArr, 0, newArr, 0, t);
        return newArr;
    }

    public static boolean[] deduplicatePreceding(@NonNull boolean[] array) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (boolean[])ArrayUtils.deduplicatePreceding((Object)array);
    }

    public static byte[] deduplicatePreceding(@NonNull byte[] array) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (byte[])ArrayUtils.deduplicatePreceding((Object)array);
    }

    public static char[] deduplicatePreceding(@NonNull char[] array) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (char[])ArrayUtils.deduplicatePreceding((Object)array);
    }

    public static short[] deduplicatePreceding(@NonNull short[] array) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (short[])ArrayUtils.deduplicatePreceding((Object)array);
    }

    public static int[] deduplicatePreceding(@NonNull int[] array) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (int[])ArrayUtils.deduplicatePreceding((Object)array);
    }

    public static long[] deduplicatePreceding(@NonNull long[] array) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (long[])ArrayUtils.deduplicatePreceding((Object)array);
    }

    public static float[] deduplicatePreceding(@NonNull float[] array) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (float[])ArrayUtils.deduplicatePreceding((Object)array);
    }

    public static double[] deduplicatePreceding(@NonNull double[] array) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (double[])ArrayUtils.deduplicatePreceding((Object)array);
    }

    public static <T> T[] deduplicatePreceding(@NonNull T[] array) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (Object[])ArrayUtils.deduplicatePreceding(array);
    }

    public static Object deduplicateReverse(@NonNull Object array) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        NavigableSet<Object> treeSet = new TreeSet<Object>(Arrays.asList((Object[])array)).descendingSet();
        return new ArrayList<Object>(treeSet).toArray(new Object[treeSet.size()]);
    }

    public static boolean[] deduplicateReverse(@NonNull boolean[] array) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (boolean[])ArrayUtils.deduplicateReverse((Object)array);
    }

    public static byte[] deduplicateReverse(@NonNull byte[] array) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (byte[])ArrayUtils.deduplicateReverse((Object)array);
    }

    public static char[] deduplicateReverse(@NonNull char[] array) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (char[])ArrayUtils.deduplicateReverse((Object)array);
    }

    public static short[] deduplicateReverse(@NonNull short[] array) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (short[])ArrayUtils.deduplicateReverse((Object)array);
    }

    public static int[] deduplicateReverse(@NonNull int[] array) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (int[])ArrayUtils.deduplicateReverse((Object)array);
    }

    public static long[] deduplicateReverse(@NonNull long[] array) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (long[])ArrayUtils.deduplicateReverse((Object)array);
    }

    public static float[] deduplicateReverse(@NonNull float[] array) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (float[])ArrayUtils.deduplicateReverse((Object)array);
    }

    public static double[] deduplicateReverse(@NonNull double[] array) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (double[])ArrayUtils.deduplicateReverse((Object)array);
    }

    public static <T> T[] deduplicateReverse(@NonNull T[] array) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (Object[])ArrayUtils.deduplicateReverse(array);
    }

    public static Object deduplicateHashSort(@NonNull Object array) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (Object item : (Object[])array) {
            if (map.containsKey(item)) continue;
            map.put(item, item);
        }
        return new ArrayList(map.values()).toArray(new Object[0]);
    }

    public static boolean[] deduplicateHashSort(@NonNull boolean[] array) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (boolean[])ArrayUtils.deduplicateHashSort((Object)array);
    }

    public static byte[] deduplicateHashSort(@NonNull byte[] array) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (byte[])ArrayUtils.deduplicateHashSort((Object)array);
    }

    public static char[] deduplicateHashSort(@NonNull char[] array) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (char[])ArrayUtils.deduplicateHashSort((Object)array);
    }

    public static short[] deduplicateHashSort(@NonNull short[] array) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (short[])ArrayUtils.deduplicateHashSort((Object)array);
    }

    public static int[] deduplicateHashSort(@NonNull int[] array) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (int[])ArrayUtils.deduplicateHashSort((Object)array);
    }

    public static long[] deduplicateHashSort(@NonNull long[] array) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (long[])ArrayUtils.deduplicateHashSort((Object)array);
    }

    public static float[] deduplicateHashSort(@NonNull float[] array) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (float[])ArrayUtils.deduplicateHashSort((Object)array);
    }

    public static double[] deduplicateHashSort(@NonNull double[] array) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (double[])ArrayUtils.deduplicateHashSort((Object)array);
    }

    public static <T> T[] deduplicateHashSort(@NonNull T[] array) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (Object[])ArrayUtils.deduplicateHashSort(array);
    }
}

