/*
 * Decompiled with CFR 0.152.
 */
package top.zhogjianhao.idcard;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Period;
import java.time.ZoneId;
import java.util.Date;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.zhogjianhao.date.DateUtils;
import top.zhogjianhao.idcard.IdCard;

public class IdCardUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IdCardUtils.class);
    private static final int NUMBER_LEN_CHINA1 = 15;
    private static final int NUMBER_LEN_CHINA2 = 18;

    public static boolean validateCheckCode(@NonNull String number) {
        if (number == null) {
            throw new NullPointerException("number is marked non-null but is null");
        }
        if (number.length() != 18) {
            throw new IllegalArgumentException("Number: ID Card number must be 18 digits");
        }
        int[] coefficient = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};
        char[] checkCode = new char[]{'1', '0', 'X', '9', '8', '7', '6', '5', '4', '3', '2'};
        int sum = 0;
        for (int i = 0; i < coefficient.length; ++i) {
            sum += (number.charAt(i) - 48) * coefficient[i];
        }
        return checkCode[sum % 11] == number.charAt(17);
    }

    public static void exceptionValidate(@NonNull String number) {
        char c;
        int i;
        if (number == null) {
            throw new NullPointerException("number is marked non-null but is null");
        }
        int len = number.length();
        if (len != 15 && len != 18) {
            throw new IllegalArgumentException("Number: length should be 15 or 18");
        }
        if (number.charAt(0) == '0') {
            throw new IllegalArgumentException("Number: cannot start with 0");
        }
        for (i = 1; i <= 5; ++i) {
            c = number.charAt(i);
            if (c >= '0' && c <= '9') continue;
            throw new IllegalArgumentException("Number: the provice/city/district code of index 1~5 should be 0~9");
        }
        if (len == 18) {
            for (i = 0; i < 17; ++i) {
                c = number.charAt(i);
                if (c >= '0' && c <= '9') continue;
                throw new IllegalArgumentException("Number: the first 17 digits of 18 digits ID Card number should be 0~9");
            }
            if (!DateUtils.validate(number.substring(6, 14), "yyyyMMdd")) {
                throw new IllegalArgumentException("Number: the date of index 6~14 is invalid");
            }
            if ("000".equals(number.substring(14, 17))) {
                throw new IllegalArgumentException("Number: the order code of index 14~17 cannot be 000");
            }
            if (!IdCardUtils.validateCheckCode(number)) {
                throw new IllegalArgumentException("Number: the check code of index 17 is invalid");
            }
        } else {
            for (i = 0; i < 15; ++i) {
                c = number.charAt(i);
                if (c >= '0' && c <= '9') continue;
                throw new IllegalArgumentException("Number: ID Card number should be 0~9");
            }
            if (!DateUtils.validate(number.substring(6, 12), "yyMMdd")) {
                throw new IllegalArgumentException("Number: the date of index 6~12 is invalid");
            }
            if ("000".equals(number.substring(12))) {
                throw new IllegalArgumentException("Number: the order code of index 12~15 cannot be 000");
            }
        }
    }

    public static boolean validate(@NonNull String number) {
        if (number == null) {
            throw new NullPointerException("number is marked non-null but is null");
        }
        try {
            IdCardUtils.exceptionValidate(number);
            return true;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return false;
        }
    }

    public static String getProvinceCode(@NonNull String number, boolean isValidate) {
        if (number == null) {
            throw new NullPointerException("number is marked non-null but is null");
        }
        if (isValidate && !IdCardUtils.validate(number)) {
            return null;
        }
        return number.substring(0, 2);
    }

    public static String getProvinceCode(@NonNull String number) {
        if (number == null) {
            throw new NullPointerException("number is marked non-null but is null");
        }
        return IdCardUtils.getProvinceCode(number, true);
    }

    public static String getCityCode(@NonNull String number, boolean isValidate) {
        if (number == null) {
            throw new NullPointerException("number is marked non-null but is null");
        }
        if (isValidate && !IdCardUtils.validate(number)) {
            return null;
        }
        return number.substring(2, 4);
    }

    public static String getCityCode(@NonNull String number) {
        if (number == null) {
            throw new NullPointerException("number is marked non-null but is null");
        }
        return IdCardUtils.getCityCode(number, true);
    }

    public static String getDistrictCode(@NonNull String number, boolean isValidate) {
        if (number == null) {
            throw new NullPointerException("number is marked non-null but is null");
        }
        if (isValidate && !IdCardUtils.validate(number)) {
            return null;
        }
        return number.substring(4, 6);
    }

    public static String getDistrictCode(@NonNull String number) {
        if (number == null) {
            throw new NullPointerException("number is marked non-null but is null");
        }
        return IdCardUtils.getDistrictCode(number, true);
    }

    public static <T> T getBirthday(@NonNull String number, @NonNull Class<T> clazz, boolean isValidate) {
        if (number == null) {
            throw new NullPointerException("number is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        if (isValidate && !IdCardUtils.validate(number)) {
            return null;
        }
        String year = null;
        String month = null;
        String day = null;
        if (number.length() == 15) {
            year = "19" + number.substring(6, 8);
            month = number.substring(8, 10);
            day = number.substring(10, 12);
        } else if (number.length() == 18) {
            year = number.substring(6, 10);
            month = number.substring(10, 12);
            day = number.substring(12, 14);
        }
        if (clazz == LocalDateTime.class) {
            return (T)LocalDateTime.of(Integer.parseInt(year), Integer.parseInt(month), Integer.parseInt(day), 0, 0, 0);
        }
        if (clazz == LocalDate.class) {
            return (T)LocalDate.of(Integer.parseInt(year), Integer.parseInt(month), Integer.parseInt(day));
        }
        if (clazz == Date.class) {
            return (T)DateUtils.parseDate(year + month + day, "yyyyMMdd");
        }
        if (clazz == String.class) {
            return (T)(year + "-" + month + "-" + day);
        }
        if (clazz == Long.class || clazz == Long.TYPE) {
            return (T)new Long(LocalDateTime.of(Integer.parseInt(year), Integer.parseInt(month), Integer.parseInt(day), 0, 0, 0).toEpochSecond(ZoneId.systemDefault().getRules().getOffset(Instant.now())) * 1000L);
        }
        return null;
    }

    public static <T> T getBirthday(@NonNull String number, @NonNull Class<T> clazz) {
        if (number == null) {
            throw new NullPointerException("number is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        return IdCardUtils.getBirthday(number, clazz, true);
    }

    public static int getAge(@NonNull String number, boolean isValidate) {
        if (number == null) {
            throw new NullPointerException("number is marked non-null but is null");
        }
        if (isValidate && !IdCardUtils.validate(number)) {
            return -1;
        }
        LocalDate birthday = IdCardUtils.getBirthday(number, LocalDate.class);
        return Period.between(birthday, LocalDate.now()).getYears();
    }

    public static int getAge(@NonNull String number) {
        if (number == null) {
            throw new NullPointerException("number is marked non-null but is null");
        }
        return IdCardUtils.getAge(number, true);
    }

    public static Integer getGenderCode(@NonNull String number, boolean isValidate) {
        if (number == null) {
            throw new NullPointerException("number is marked non-null but is null");
        }
        if (isValidate && !IdCardUtils.validate(number)) {
            return null;
        }
        if (number.length() == 15) {
            return Integer.valueOf(number.substring(number.length() - 2, number.length() - 1));
        }
        if (number.length() == 18) {
            return Integer.valueOf(number.substring(number.length() - 2, number.length() - 1));
        }
        return null;
    }

    public static Integer getGenderCode(@NonNull String number) {
        if (number == null) {
            throw new NullPointerException("number is marked non-null but is null");
        }
        return IdCardUtils.getGenderCode(number, true);
    }

    public static int getGender(@NonNull String number, boolean isValidate) {
        if (number == null) {
            throw new NullPointerException("number is marked non-null but is null");
        }
        Integer genderCode = IdCardUtils.getGenderCode(number, isValidate);
        if (genderCode == null) {
            return -1;
        }
        return genderCode % 2 != 0 ? 1 : 2;
    }

    public static int getGender(@NonNull String number) {
        if (number == null) {
            throw new NullPointerException("number is marked non-null but is null");
        }
        return IdCardUtils.getGender(number, true);
    }

    public static Boolean isMale(@NonNull String number, boolean isValidate) {
        if (number == null) {
            throw new NullPointerException("number is marked non-null but is null");
        }
        Integer gender = IdCardUtils.getGenderCode(number, isValidate);
        if (gender == null) {
            return null;
        }
        return gender % 2 != 0;
    }

    public static Boolean isMale(@NonNull String number) {
        if (number == null) {
            throw new NullPointerException("number is marked non-null but is null");
        }
        return IdCardUtils.isMale(number, true);
    }

    public static Boolean isFemale(@NonNull String number, boolean isValidate) {
        if (number == null) {
            throw new NullPointerException("number is marked non-null but is null");
        }
        Integer gender = IdCardUtils.getGenderCode(number, isValidate);
        if (gender == null) {
            return null;
        }
        return gender % 2 == 0;
    }

    public static Boolean isFemale(@NonNull String number) {
        if (number == null) {
            throw new NullPointerException("number is marked non-null but is null");
        }
        return IdCardUtils.isFemale(number, true);
    }

    public static String getCheckCode(@NonNull String number, boolean isValidate) {
        if (number == null) {
            throw new NullPointerException("number is marked non-null but is null");
        }
        if (isValidate && !IdCardUtils.validate(number)) {
            return null;
        }
        if (number.length() != 18) {
            return null;
        }
        return number.substring(number.length() - 1);
    }

    public static String getCheckCode(@NonNull String number) {
        if (number == null) {
            throw new NullPointerException("number is marked non-null but is null");
        }
        return IdCardUtils.getCheckCode(number, true);
    }

    public static IdCard get(@NonNull String number, boolean isValidate) {
        if (number == null) {
            throw new NullPointerException("number is marked non-null but is null");
        }
        if (isValidate && !IdCardUtils.validate(number)) {
            return null;
        }
        IdCard idCard = new IdCard();
        idCard.setNumber(number);
        idCard.setProvinceCode(IdCardUtils.getProvinceCode(number, false));
        idCard.setCityCode(IdCardUtils.getCityCode(number, false));
        idCard.setDistrictCode(IdCardUtils.getDistrictCode(number, false));
        idCard.setBirthday(IdCardUtils.getBirthday(number, LocalDate.class, false));
        idCard.setAge(IdCardUtils.getAge(number, false));
        idCard.setGender(IdCardUtils.getGender(number, false));
        idCard.setCheckCode(IdCardUtils.getCheckCode(number, false));
        return idCard;
    }

    public static IdCard get(@NonNull String number) {
        if (number == null) {
            throw new NullPointerException("number is marked non-null but is null");
        }
        return IdCardUtils.get(number, true);
    }
}

