/*
 * Decompiled with CFR 0.152.
 */
package top.zhogjianhao.regex;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.zhogjianhao.constant.CommonPattern;
import top.zhogjianhao.regex.enums.FlagsEnum;

public class RegExUtils
extends org.apache.commons.lang3.RegExUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RegExUtils.class);
    public static final Pattern SPECIAL_CHAR_PATTERN = Pattern.compile("([/\\\\()\\[\\]{},.?*+|^$])");

    public static String replaceAllSpecialChar(@NonNull CharSequence text) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        return SPECIAL_CHAR_PATTERN.matcher(text).replaceAll("\\\\$1");
    }

    public static Matcher getMatcher(@NonNull CharSequence text, @NonNull String regex, int flags) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (regex == null) {
            throw new NullPointerException("regex is marked non-null but is null");
        }
        Pattern pattern = Pattern.compile(regex, flags);
        return pattern.matcher(text);
    }

    public static Matcher getMatcher(@NonNull CharSequence text, @NonNull String regex, FlagsEnum ... flagsEnums) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (regex == null) {
            throw new NullPointerException("regex is marked non-null but is null");
        }
        if (flagsEnums == null) {
            throw new NullPointerException("flagsEnums is marked non-null but is null");
        }
        return RegExUtils.getMatcher(text, regex, Arrays.stream(flagsEnums).map(FlagsEnum::getValue).reduce(0, (a, b) -> a | b));
    }

    public static Matcher getMatcher(@NonNull CharSequence text, @NonNull String regex) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (regex == null) {
            throw new NullPointerException("regex is marked non-null but is null");
        }
        return RegExUtils.getMatcher(text, regex, 0);
    }

    public static int indexOf(@NonNull CharSequence text, @NonNull String regex, int flags) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (regex == null) {
            throw new NullPointerException("regex is marked non-null but is null");
        }
        Matcher matcher = RegExUtils.getMatcher(text, regex, flags);
        if (matcher.find()) {
            return matcher.start();
        }
        return -1;
    }

    public static int indexOf(@NonNull CharSequence text, @NonNull String regex, FlagsEnum ... flagsEnums) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (regex == null) {
            throw new NullPointerException("regex is marked non-null but is null");
        }
        return RegExUtils.indexOf(text, regex, Arrays.stream(flagsEnums).map(FlagsEnum::getValue).reduce(0, (a, b) -> a | b));
    }

    public static int indexOf(@NonNull CharSequence text, @NonNull String regex) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (regex == null) {
            throw new NullPointerException("regex is marked non-null but is null");
        }
        Matcher matcher = RegExUtils.getMatcher(text, regex);
        if (matcher.find()) {
            return matcher.start();
        }
        return -1;
    }

    public static int indexOf(@NonNull CharSequence text, @NonNull Pattern pattern) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        Matcher matcher = pattern.matcher(text);
        if (matcher.find()) {
            return matcher.start();
        }
        return -1;
    }

    public static String match(@NonNull CharSequence text, @NonNull String regex, int item, int group, int flags) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (regex == null) {
            throw new NullPointerException("regex is marked non-null but is null");
        }
        if (item < 0) {
            throw new IllegalArgumentException("Item: should be greater than 0");
        }
        if (group < 0) {
            throw new IllegalArgumentException("Group: should be greater than 0");
        }
        String result = null;
        Matcher matcher = RegExUtils.getMatcher(text, regex, flags);
        int i = 0;
        while (matcher.find()) {
            if (item == i) {
                return matcher.group(group);
            }
            ++i;
        }
        return result;
    }

    public static String match(@NonNull CharSequence text, @NonNull String regex, int item, int group, FlagsEnum ... flagsEnums) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (regex == null) {
            throw new NullPointerException("regex is marked non-null but is null");
        }
        return RegExUtils.match(text, regex, item, group, Arrays.stream(flagsEnums).map(FlagsEnum::getValue).reduce(0, (a, b) -> a | b));
    }

    public static String match(@NonNull CharSequence text, @NonNull String regex, int item, int group) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (regex == null) {
            throw new NullPointerException("regex is marked non-null but is null");
        }
        return RegExUtils.match(text, regex, item, group, 0);
    }

    public static String match(@NonNull CharSequence text, @NonNull Pattern pattern, int item, int group) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        if (item < 0) {
            throw new IllegalArgumentException("Item: should be greater than 0");
        }
        if (group < 0) {
            throw new IllegalArgumentException("Group: should be greater than 0");
        }
        String result = null;
        Matcher matcher = pattern.matcher(text);
        int i = 0;
        while (matcher.find()) {
            if (item == i) {
                return matcher.group(group);
            }
            ++i;
        }
        return result;
    }

    public static String match(@NonNull CharSequence text, @NonNull String regex, int item) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (regex == null) {
            throw new NullPointerException("regex is marked non-null but is null");
        }
        return RegExUtils.match(text, regex, item, 0);
    }

    public static String match(@NonNull CharSequence text, @NonNull Pattern pattern, int item) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        return RegExUtils.match(text, pattern, item, 0);
    }

    public static String matchFirst(@NonNull CharSequence text, @NonNull String regex, int group, int flags) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (regex == null) {
            throw new NullPointerException("regex is marked non-null but is null");
        }
        return RegExUtils.match(text, regex, 0, group, flags);
    }

    public static String matchFirst(@NonNull CharSequence text, @NonNull String regex, int group, FlagsEnum ... flagsEnums) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (regex == null) {
            throw new NullPointerException("regex is marked non-null but is null");
        }
        return RegExUtils.matchFirst(text, regex, group, Arrays.stream(flagsEnums).map(FlagsEnum::getValue).reduce(0, (a, b) -> a | b));
    }

    public static String matchFirst(@NonNull CharSequence text, @NonNull String regex, int group) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (regex == null) {
            throw new NullPointerException("regex is marked non-null but is null");
        }
        return RegExUtils.matchFirst(text, regex, group, 0);
    }

    public static String matchFirst(@NonNull CharSequence text, @NonNull Pattern pattern, int group) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        return RegExUtils.match(text, pattern, 0, group);
    }

    public static String matchFirst(@NonNull CharSequence text, @NonNull String regex) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (regex == null) {
            throw new NullPointerException("regex is marked non-null but is null");
        }
        return RegExUtils.matchFirst(text, regex, 0);
    }

    public static String matchFirst(@NonNull CharSequence text, @NonNull Pattern pattern) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        return RegExUtils.matchFirst(text, pattern, 0);
    }

    public static boolean isMatch(@NonNull CharSequence text, @NonNull String regex, int flags) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (regex == null) {
            throw new NullPointerException("regex is marked non-null but is null");
        }
        return StringUtils.isNotBlank((CharSequence)RegExUtils.matchFirst(text, regex, 0, flags));
    }

    public static boolean isMatch(@NonNull CharSequence text, @NonNull String regex, FlagsEnum ... flagsEnums) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (regex == null) {
            throw new NullPointerException("regex is marked non-null but is null");
        }
        return RegExUtils.isMatch(text, regex, Arrays.stream(flagsEnums).map(FlagsEnum::getValue).reduce(0, (a, b) -> a | b));
    }

    public static boolean isMatch(@NonNull CharSequence text, @NonNull String regex) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (regex == null) {
            throw new NullPointerException("regex is marked non-null but is null");
        }
        return Pattern.compile(regex).matcher(text).find();
    }

    public static boolean isMatch(@NonNull CharSequence text, @NonNull Pattern pattern) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        return pattern.matcher(text).find();
    }

    public static List<String> matches(@NonNull CharSequence text, @NonNull String regex, int group, int flags) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (regex == null) {
            throw new NullPointerException("regex is marked non-null but is null");
        }
        ArrayList<String> resultList = new ArrayList<String>();
        Matcher matcher = RegExUtils.getMatcher(text, regex, flags);
        while (matcher.find()) {
            resultList.add(matcher.group(group));
        }
        return resultList;
    }

    public static List<String> matches(@NonNull CharSequence text, @NonNull String regex, int group, FlagsEnum ... flagsEnums) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (regex == null) {
            throw new NullPointerException("regex is marked non-null but is null");
        }
        return RegExUtils.matches(text, regex, group, Arrays.stream(flagsEnums).map(FlagsEnum::getValue).reduce(0, (a, b) -> a | b));
    }

    public static List<String> matches(@NonNull CharSequence text, @NonNull String regex, int group) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (regex == null) {
            throw new NullPointerException("regex is marked non-null but is null");
        }
        return RegExUtils.matches(text, regex, group, 0);
    }

    public static List<String> matches(@NonNull CharSequence text, @NonNull Pattern pattern, int group) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        ArrayList<String> resultList = new ArrayList<String>();
        Matcher matcher = pattern.matcher(text);
        while (matcher.find()) {
            resultList.add(matcher.group(group));
        }
        return resultList;
    }

    public static List<String> matches(@NonNull CharSequence text, @NonNull String regex) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (regex == null) {
            throw new NullPointerException("regex is marked non-null but is null");
        }
        return RegExUtils.matches(text, regex, 0);
    }

    public static List<String> matches(@NonNull CharSequence text, @NonNull Pattern pattern) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        return RegExUtils.matches(text, pattern, 0);
    }

    public static String replace(@NonNull String text, @NonNull String regex, @NonNull String replacement, int item, int group, int flags) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (regex == null) {
            throw new NullPointerException("regex is marked non-null but is null");
        }
        if (replacement == null) {
            throw new NullPointerException("replacement is marked non-null but is null");
        }
        if (item < 0) {
            throw new IllegalArgumentException("Item: should be greater than 0");
        }
        if (group < 0) {
            throw new IllegalArgumentException("Group: should be greater than 0");
        }
        Matcher matcher = RegExUtils.getMatcher((CharSequence)text, regex, flags);
        int i = 0;
        while (matcher.find()) {
            if (i == item) {
                int startIndex = matcher.start(group);
                return text.substring(0, startIndex) + replacement + text.substring(startIndex + matcher.group(group).length());
            }
            ++i;
        }
        return null;
    }

    public static String replace(@NonNull String text, @NonNull String regex, @NonNull String replacement, int item, int group, FlagsEnum ... flagsEnums) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (regex == null) {
            throw new NullPointerException("regex is marked non-null but is null");
        }
        if (replacement == null) {
            throw new NullPointerException("replacement is marked non-null but is null");
        }
        return RegExUtils.replace(text, regex, replacement, item, group, Arrays.stream(flagsEnums).map(FlagsEnum::getValue).reduce(0, (a, b) -> a | b));
    }

    public static String replace(@NonNull String text, @NonNull String regex, @NonNull String replacement, int item, int flags) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (regex == null) {
            throw new NullPointerException("regex is marked non-null but is null");
        }
        if (replacement == null) {
            throw new NullPointerException("replacement is marked non-null but is null");
        }
        return RegExUtils.replace(text, regex, replacement, item, 0, flags);
    }

    public static String replace(@NonNull String text, @NonNull String regex, @NonNull String replacement, int item, FlagsEnum ... flagsEnums) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (regex == null) {
            throw new NullPointerException("regex is marked non-null but is null");
        }
        if (replacement == null) {
            throw new NullPointerException("replacement is marked non-null but is null");
        }
        return RegExUtils.replace(text, regex, replacement, item, 0, flagsEnums);
    }

    public static String replace(@NonNull String text, @NonNull String regex, @NonNull String replacement, int item) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (regex == null) {
            throw new NullPointerException("regex is marked non-null but is null");
        }
        if (replacement == null) {
            throw new NullPointerException("replacement is marked non-null but is null");
        }
        return RegExUtils.replace(text, regex, replacement, item, 0);
    }

    public static String replace(@NonNull String text, @NonNull Pattern pattern, @NonNull String replacement, int item) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        if (replacement == null) {
            throw new NullPointerException("replacement is marked non-null but is null");
        }
        if (item < 0) {
            throw new IllegalArgumentException("Item: should be greater than 0");
        }
        Matcher matcher = pattern.matcher(text);
        int i = 0;
        while (matcher.find()) {
            if (i == item) {
                int startIndex = matcher.start(0);
                return text.substring(0, startIndex) + replacement + text.substring(startIndex + matcher.group(0).length());
            }
            ++i;
        }
        return null;
    }

    public static String replaceFirst(@NonNull String text, @NonNull String regex, @NonNull String replacement, int group, int flags) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (regex == null) {
            throw new NullPointerException("regex is marked non-null but is null");
        }
        if (replacement == null) {
            throw new NullPointerException("replacement is marked non-null but is null");
        }
        return RegExUtils.replace(text, regex, replacement, 0, group, flags);
    }

    public static String replaceFirst(@NonNull String text, @NonNull String regex, @NonNull String replacement, int group, FlagsEnum ... flagsEnums) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (regex == null) {
            throw new NullPointerException("regex is marked non-null but is null");
        }
        if (replacement == null) {
            throw new NullPointerException("replacement is marked non-null but is null");
        }
        return RegExUtils.replace(text, regex, replacement, 0, group, Arrays.stream(flagsEnums).map(FlagsEnum::getValue).reduce(0, (a, b) -> a | b));
    }

    public static String replaceFirst(@NonNull String text, @NonNull String regex, @NonNull String replacement, int group) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (regex == null) {
            throw new NullPointerException("regex is marked non-null but is null");
        }
        if (replacement == null) {
            throw new NullPointerException("replacement is marked non-null but is null");
        }
        return RegExUtils.replaceFirst(text, regex, replacement, group, 0);
    }

    public static String replaceFirst(@NonNull String text, @NonNull Pattern regex, @NonNull String replacement, int group) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (regex == null) {
            throw new NullPointerException("regex is marked non-null but is null");
        }
        if (replacement == null) {
            throw new NullPointerException("replacement is marked non-null but is null");
        }
        return RegExUtils.replace(text, regex, replacement, group);
    }

    public static String replace(@NonNull String text, @NonNull String regex, @NonNull String replacement) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (regex == null) {
            throw new NullPointerException("regex is marked non-null but is null");
        }
        if (replacement == null) {
            throw new NullPointerException("replacement is marked non-null but is null");
        }
        return RegExUtils.replaceFirst(text, regex, replacement, 0, 0);
    }

    public static String replace(@NonNull String text, @NonNull Pattern pattern, @NonNull String replacement) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        if (replacement == null) {
            throw new NullPointerException("replacement is marked non-null but is null");
        }
        return RegExUtils.replaceFirst(text, pattern, replacement, 0);
    }

    public static String replaceAll(@NonNull String text, @NonNull String regex, @NonNull String replacement, int group, int flags) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (regex == null) {
            throw new NullPointerException("regex is marked non-null but is null");
        }
        if (replacement == null) {
            throw new NullPointerException("replacement is marked non-null but is null");
        }
        if (group < 0) {
            throw new IllegalArgumentException("Group: should be greater than 0");
        }
        StringBuilder result = new StringBuilder();
        Matcher matcher = RegExUtils.getMatcher((CharSequence)text, regex, flags);
        if (matcher.find()) {
            String text1;
            Matcher matcher1;
            int startIndex = matcher.start(group);
            String firstMatchText = text.substring(0, startIndex) + replacement + text.substring(startIndex + matcher.group(group).length());
            result.append(firstMatchText, 0, startIndex + replacement.length());
            int i = 0;
            while ((matcher1 = RegExUtils.getMatcher((CharSequence)(text1 = firstMatchText.substring(result.toString().length())), regex, flags)).find()) {
                int startIndex1 = matcher1.start(group);
                String nextMatchText = text1.substring(0, startIndex1) + replacement + text1.substring(startIndex1 + matcher1.group(group).length());
                firstMatchText = result + nextMatchText;
                result.append(nextMatchText, 0, startIndex1 + replacement.length());
                ++i;
            }
            matcher = RegExUtils.getMatcher((CharSequence)text, regex, flags);
            int j = 0;
            while (matcher.find()) {
                if (i == j) {
                    result.append(text.substring(matcher.start(group) + 1));
                }
                ++j;
            }
        }
        return result.toString();
    }

    public static String replaceAll(@NonNull String text, @NonNull String regex, @NonNull String replacement, int group, FlagsEnum ... flagsEnums) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (regex == null) {
            throw new NullPointerException("regex is marked non-null but is null");
        }
        if (replacement == null) {
            throw new NullPointerException("replacement is marked non-null but is null");
        }
        return RegExUtils.replaceAll(text, regex, replacement, group, Arrays.stream(flagsEnums).map(FlagsEnum::getValue).reduce(0, (a, b) -> a | b));
    }

    public static String replaceAll(@NonNull String text, @NonNull String regex, @NonNull String replacement, int group) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (regex == null) {
            throw new NullPointerException("regex is marked non-null but is null");
        }
        if (replacement == null) {
            throw new NullPointerException("replacement is marked non-null but is null");
        }
        return RegExUtils.replaceAll(text, regex, replacement, group, 0);
    }

    public static String replaceAll(@NonNull String text, @NonNull Pattern pattern, @NonNull String replacement, int group) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        if (replacement == null) {
            throw new NullPointerException("replacement is marked non-null but is null");
        }
        if (group < 0) {
            throw new IllegalArgumentException("Group: should be greater than 0");
        }
        StringBuilder result = new StringBuilder();
        Matcher matcher = pattern.matcher(text);
        if (matcher.find()) {
            String text1;
            Matcher matcher1;
            int startIndex = matcher.start(group);
            String firstMatchText = text.substring(0, startIndex) + replacement + text.substring(startIndex + matcher.group(group).length());
            result.append(firstMatchText, 0, startIndex + replacement.length());
            int i = 0;
            while ((matcher1 = pattern.matcher(text1 = firstMatchText.substring(result.toString().length()))).find()) {
                int startIndex1 = matcher1.start(group);
                String nextMatchText = text1.substring(0, startIndex1) + replacement + text1.substring(startIndex1 + matcher1.group(group).length());
                firstMatchText = result + nextMatchText;
                result.append(nextMatchText, 0, startIndex1 + replacement.length());
                ++i;
            }
            matcher = pattern.matcher(text);
            int j = 0;
            while (matcher.find()) {
                if (i == j) {
                    result.append(text.substring(matcher.start(group) + 1));
                }
                ++j;
            }
        }
        return result.toString();
    }

    public static boolean containsHanZi(@NonNull String source) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        return RegExUtils.isMatch((CharSequence)source, CommonPattern.MULTIPLE_CHINESE_CHAR);
    }
}

