/*
 * Decompiled with CFR 0.152.
 */
package top.zhogjianhao.id;

import java.security.SecureRandom;
import java.util.Random;

public class NanoIDUtils {
    public static final SecureRandom DEFAULT_ID_GENERATOR = new SecureRandom();
    public static final String DEFAULT_ALPHABET = "_-0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final int DEFAULT_SIZE = 21;

    public static String randomNanoId() {
        return NanoIDUtils.randomNanoId(21, DEFAULT_ALPHABET, DEFAULT_ID_GENERATOR);
    }

    public static String randomNanoId(int size) {
        return NanoIDUtils.randomNanoId(size, DEFAULT_ALPHABET, DEFAULT_ID_GENERATOR);
    }

    public static String randomNanoId(int size, String alphabet) {
        return NanoIDUtils.randomNanoId(size, alphabet, DEFAULT_ID_GENERATOR);
    }

    public static String randomNanoId(int size, String alphabet, Random generator) {
        if (alphabet.isEmpty() || alphabet.length() > 256) {
            throw new IllegalArgumentException("Alphabet must contain between 1 and 256 characters.");
        }
        if (size < 1) {
            throw new IllegalArgumentException("Size must be at least 1.");
        }
        int mask = (2 << (int)Math.floor(Math.log(alphabet.length() - 1) / Math.log(2.0))) - 1;
        int step = (int)Math.ceil(1.6 * (double)mask * (double)size / (double)alphabet.length());
        StringBuilder idBuilder = new StringBuilder(size);
        block0: while (true) {
            byte[] bytes = new byte[step];
            generator.nextBytes(bytes);
            int i = 0;
            while (true) {
                if (i >= step) continue block0;
                int alphabetIndex = bytes[i] & mask;
                if (alphabetIndex < alphabet.length()) {
                    idBuilder.append(alphabet.charAt(alphabetIndex));
                    if (idBuilder.length() == size) {
                        return idBuilder.toString();
                    }
                }
                ++i;
            }
            break;
        }
    }
}

