/*
 * Decompiled with CFR 0.152.
 */
package top.zhogjianhao;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.nio.charset.Charset;
import java.util.Arrays;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.zhogjianhao.StringUtils;
import top.zhogjianhao.charset.StandardCharsets;

public final class ArrayUtils
extends org.apache.commons.lang3.ArrayUtils {
    private static final Logger log = LoggerFactory.getLogger(ArrayUtils.class);

    public static byte[] toBytes(@NonNull char[] chars, @NonNull Charset charsets) {
        if (chars == null) {
            throw new NullPointerException("chars is marked non-null but is null");
        }
        if (charsets == null) {
            throw new NullPointerException("charsets is marked non-null but is null");
        }
        return new String(chars).getBytes(charsets);
    }

    public static byte[] toBytes(@NonNull char[] chars, @NonNull String charsetName) throws UnsupportedEncodingException {
        if (chars == null) {
            throw new NullPointerException("chars is marked non-null but is null");
        }
        if (charsetName == null) {
            throw new NullPointerException("charsetName is marked non-null but is null");
        }
        return new String(chars).getBytes(charsetName);
    }

    public static byte[] toBytes(@NonNull char[] chars) {
        if (chars == null) {
            throw new NullPointerException("chars is marked non-null but is null");
        }
        return new String(chars).getBytes(StandardCharsets.UTF_8);
    }

    public static char[] toChars(@NonNull byte[] bytes, @NonNull Charset charsets) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        if (charsets == null) {
            throw new NullPointerException("charsets is marked non-null but is null");
        }
        return new String(bytes, charsets).toCharArray();
    }

    public static char[] toChars(@NonNull byte[] bytes, @NonNull String charsetName) throws UnsupportedEncodingException {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        if (charsetName == null) {
            throw new NullPointerException("charsetName is marked non-null but is null");
        }
        return new String(bytes, charsetName).toCharArray();
    }

    public static char[] toChars(@NonNull byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        return new String(bytes).toCharArray();
    }

    public static Object moveForward(@NonNull Object array, int startIndex, int length) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (!(array instanceof Object[] || array instanceof int[] || array instanceof long[] || array instanceof double[] || array instanceof float[] || array instanceof boolean[] || array instanceof short[] || array instanceof byte[] || array instanceof char[])) {
            throw new IllegalArgumentException("Array: should be an array");
        }
        int arrayLen = ArrayUtils.getLength((Object)array);
        if (startIndex < 0 || length < 1 || startIndex >= arrayLen || arrayLen - length < 0) {
            throw new IndexOutOfBoundsException("StartIndex: " + startIndex + ", Length:" + length);
        }
        Object result = Array.newInstance(array.getClass().getComponentType(), arrayLen);
        System.arraycopy(array, 0, result, 0, startIndex);
        System.arraycopy(array, startIndex + length, result, startIndex, arrayLen - length - startIndex);
        return result;
    }

    private static Object remove(@NonNull Object array, int index, @NonNull Object lastElementValue) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (lastElementValue == null) {
            throw new NullPointerException("lastElementValue is marked non-null but is null");
        }
        Object result = ArrayUtils.moveForward(array, index, 1);
        if (array instanceof int[]) {
            ((int[])result)[((int[])result).length - 1] = (Integer)lastElementValue;
        } else if (array instanceof long[]) {
            ((long[])result)[((long[])result).length - 1] = (Long)lastElementValue;
        } else if (array instanceof double[]) {
            ((double[])result)[((double[])result).length - 1] = (Double)lastElementValue;
        } else if (array instanceof float[]) {
            ((float[])result)[((float[])result).length - 1] = ((Float)lastElementValue).floatValue();
        } else if (array instanceof byte[]) {
            ((byte[])result)[((byte[])result).length - 1] = (Byte)lastElementValue;
        } else if (array instanceof char[]) {
            ((char[])result)[((char[])result).length - 1] = ((Character)lastElementValue).charValue();
        } else if (array instanceof boolean[]) {
            ((boolean[])result)[((boolean[])result).length - 1] = (Boolean)lastElementValue;
        } else if (array instanceof short[]) {
            ((short[])result)[((short[])result).length - 1] = (Short)lastElementValue;
        } else {
            ((Object[])result)[((Object[])result).length - 1] = lastElementValue;
        }
        return result;
    }

    public static <T> T[] remove(@NonNull T[] array, int index, @NonNull Object lastElementValue) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (lastElementValue == null) {
            throw new NullPointerException("lastElementValue is marked non-null but is null");
        }
        return (Object[])ArrayUtils.remove(array, index, lastElementValue);
    }

    public static boolean[] remove(@NonNull boolean[] array, int index, @NonNull Object lastElementValue) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (lastElementValue == null) {
            throw new NullPointerException("lastElementValue is marked non-null but is null");
        }
        return (boolean[])ArrayUtils.remove((Object)array, index, lastElementValue);
    }

    public static byte[] remove(@NonNull byte[] array, int index, @NonNull Object lastElementValue) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (lastElementValue == null) {
            throw new NullPointerException("lastElementValue is marked non-null but is null");
        }
        return (byte[])ArrayUtils.remove((Object)array, index, lastElementValue);
    }

    public static char[] remove(@NonNull char[] array, int index, @NonNull Object lastElementValue) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (lastElementValue == null) {
            throw new NullPointerException("lastElementValue is marked non-null but is null");
        }
        return (char[])ArrayUtils.remove((Object)array, index, lastElementValue);
    }

    public static double[] remove(@NonNull double[] array, int index, @NonNull Object lastElementValue) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (lastElementValue == null) {
            throw new NullPointerException("lastElementValue is marked non-null but is null");
        }
        return (double[])ArrayUtils.remove((Object)array, index, lastElementValue);
    }

    public static float[] remove(@NonNull float[] array, int index, @NonNull Object lastElementValue) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (lastElementValue == null) {
            throw new NullPointerException("lastElementValue is marked non-null but is null");
        }
        return (float[])ArrayUtils.remove((Object)array, index, lastElementValue);
    }

    public static short[] remove(@NonNull short[] array, int index, @NonNull Object lastElementValue) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (lastElementValue == null) {
            throw new NullPointerException("lastElementValue is marked non-null but is null");
        }
        return (short[])ArrayUtils.remove((Object)array, index, lastElementValue);
    }

    public static int[] remove(@NonNull int[] array, int index, @NonNull Object lastElementValue) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (lastElementValue == null) {
            throw new NullPointerException("lastElementValue is marked non-null but is null");
        }
        return (int[])ArrayUtils.remove((Object)array, index, lastElementValue);
    }

    public static long[] remove(@NonNull long[] array, int index, @NonNull Object lastElementValue) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (lastElementValue == null) {
            throw new NullPointerException("lastElementValue is marked non-null but is null");
        }
        return (long[])ArrayUtils.remove((Object)array, index, lastElementValue);
    }

    private static Object fill(@NonNull Object array, int fromIndex, int toIndex, Object val) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        int arrayLen = ArrayUtils.getLength((Object)array);
        Object result = array;
        if (toIndex > arrayLen) {
            result = Array.newInstance(array.getClass().getComponentType(), toIndex);
            System.arraycopy(array, 0, result, 0, arrayLen);
        }
        if (result instanceof int[]) {
            Arrays.fill((int[])result, fromIndex, toIndex, (Integer)val);
        } else if (result instanceof long[]) {
            Arrays.fill((long[])result, fromIndex, toIndex, (Long)val);
        } else if (result instanceof double[]) {
            Arrays.fill((double[])result, fromIndex, toIndex, (Double)val);
        } else if (result instanceof float[]) {
            Arrays.fill((float[])result, fromIndex, toIndex, ((Float)val).floatValue());
        } else if (result instanceof byte[]) {
            Arrays.fill((byte[])result, fromIndex, toIndex, (Byte)val);
        } else if (result instanceof char[]) {
            Arrays.fill((char[])result, fromIndex, toIndex, ((Character)val).charValue());
        } else if (result instanceof boolean[]) {
            Arrays.fill((boolean[])result, fromIndex, toIndex, (Boolean)val);
        } else if (result instanceof short[]) {
            Arrays.fill((short[])result, fromIndex, toIndex, (Short)val);
        } else {
            Arrays.fill((Object[])result, fromIndex, toIndex, val);
        }
        return result;
    }

    public static <T> T[] fill(@NonNull T[] array, int fromIndex, int toIndex, Object val) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (Object[])ArrayUtils.fill(array, fromIndex, toIndex, val);
    }

    public static boolean[] fill(@NonNull boolean[] array, int fromIndex, int toIndex, Object val) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (boolean[])ArrayUtils.fill((Object)array, fromIndex, toIndex, val);
    }

    public static byte[] fill(@NonNull byte[] array, int fromIndex, int toIndex, Object val) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (byte[])ArrayUtils.fill((Object)array, fromIndex, toIndex, val);
    }

    public static char[] fill(@NonNull char[] array, int fromIndex, int toIndex, Object val) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (char[])ArrayUtils.fill((Object)array, fromIndex, toIndex, val);
    }

    public static double[] fill(@NonNull double[] array, int fromIndex, int toIndex, Object val) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (double[])ArrayUtils.fill((Object)array, fromIndex, toIndex, val);
    }

    public static float[] fill(@NonNull float[] array, int fromIndex, int toIndex, Object val) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (float[])ArrayUtils.fill((Object)array, fromIndex, toIndex, val);
    }

    public static short[] fill(@NonNull short[] array, int fromIndex, int toIndex, Object val) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (short[])ArrayUtils.fill((Object)array, fromIndex, toIndex, val);
    }

    public static int[] fill(@NonNull int[] array, int fromIndex, int toIndex, Object val) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (int[])ArrayUtils.fill((Object)array, fromIndex, toIndex, val);
    }

    public static long[] fill(@NonNull long[] array, int fromIndex, int toIndex, Object val) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (long[])ArrayUtils.fill((Object)array, fromIndex, toIndex, val);
    }

    private static boolean containsObject(@NonNull Object array, Object val) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (array instanceof int[]) {
            return ArrayUtils.contains((int[])((int[])array), (int)((int[])val)[0]);
        }
        if (array instanceof long[]) {
            return ArrayUtils.contains((long[])((long[])array), (long)((long[])val)[0]);
        }
        if (array instanceof double[]) {
            return ArrayUtils.contains((double[])((double[])array), (double)((double[])val)[0]);
        }
        if (array instanceof float[]) {
            return ArrayUtils.contains((float[])((float[])array), (float)((float[])val)[0]);
        }
        if (array instanceof byte[]) {
            return ArrayUtils.contains((byte[])((byte[])array), (byte)((byte[])val)[0]);
        }
        if (array instanceof char[]) {
            return ArrayUtils.contains((char[])((char[])array), (char)((char[])val)[0]);
        }
        if (array instanceof boolean[]) {
            return ArrayUtils.contains((boolean[])((boolean[])array), (boolean)((boolean[])val)[0]);
        }
        if (array instanceof short[]) {
            return ArrayUtils.contains((short[])((short[])array), (short)((short[])val)[0]);
        }
        return ArrayUtils.contains((Object[])((Object[])array), (Object)((Object[])val)[0]);
    }

    private static Object removeAllElements(@NonNull Object array, Object ... vals) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (vals == null) {
            throw new NullPointerException("vals is marked non-null but is null");
        }
        Object result = array instanceof int[] ? ((int[])array).clone() : (array instanceof long[] ? ((long[])array).clone() : (array instanceof double[] ? ((double[])array).clone() : (array instanceof float[] ? ((float[])array).clone() : (array instanceof byte[] ? ((byte[])array).clone() : (array instanceof char[] ? ((char[])array).clone() : (array instanceof boolean[] ? ((boolean[])array).clone() : (array instanceof short[] ? ((short[])array).clone() : ((Object[])array).clone())))))));
        for (Object val : vals) {
            while (ArrayUtils.containsObject(result, val)) {
                if (result instanceof int[]) {
                    result = ArrayUtils.removeElement((int[])((int[])result), (int)((int[])val)[0]);
                    continue;
                }
                if (array instanceof long[]) {
                    result = ArrayUtils.removeElement((long[])((long[])result), (long)((long[])val)[0]);
                    continue;
                }
                if (array instanceof double[]) {
                    result = ArrayUtils.removeElement((double[])((double[])result), (double)((double[])val)[0]);
                    continue;
                }
                if (array instanceof float[]) {
                    result = ArrayUtils.removeElement((float[])((float[])result), (float)((float[])val)[0]);
                    continue;
                }
                if (array instanceof byte[]) {
                    result = ArrayUtils.removeElement((byte[])((byte[])result), (byte)((byte[])val)[0]);
                    continue;
                }
                if (array instanceof char[]) {
                    result = ArrayUtils.removeElement((char[])((char[])result), (char)((char[])val)[0]);
                    continue;
                }
                if (array instanceof boolean[]) {
                    result = ArrayUtils.removeElement((boolean[])((boolean[])result), (boolean)((boolean[])val)[0]);
                    continue;
                }
                if (array instanceof short[]) {
                    result = ArrayUtils.removeElement((short[])((short[])result), (short)((short[])val)[0]);
                    continue;
                }
                result = ArrayUtils.removeElement((Object[])result, (Object)((Object[])val)[0]);
            }
        }
        return result;
    }

    public static <T> T[] removeAllElements(@NonNull T[] array, T ... vals) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (vals == null) {
            throw new NullPointerException("vals is marked non-null but is null");
        }
        return (Object[])ArrayUtils.removeAllElements(array, new Object[]{vals});
    }

    public static boolean[] removeAllElements(@NonNull boolean[] array, boolean ... vals) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (vals == null) {
            throw new NullPointerException("vals is marked non-null but is null");
        }
        return (boolean[])ArrayUtils.removeAllElements((Object)array, new Object[]{vals});
    }

    public static byte[] removeAllElements(@NonNull byte[] array, byte ... vals) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (vals == null) {
            throw new NullPointerException("vals is marked non-null but is null");
        }
        return (byte[])ArrayUtils.removeAllElements((Object)array, new Object[]{vals});
    }

    public static char[] removeAllElements(@NonNull char[] array, char ... vals) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (vals == null) {
            throw new NullPointerException("vals is marked non-null but is null");
        }
        return (char[])ArrayUtils.removeAllElements((Object)array, new Object[]{vals});
    }

    public static double[] removeAllElements(@NonNull double[] array, double ... vals) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (vals == null) {
            throw new NullPointerException("vals is marked non-null but is null");
        }
        return (double[])ArrayUtils.removeAllElements((Object)array, new Object[]{vals});
    }

    public static float[] removeAllElements(@NonNull float[] array, float ... vals) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (vals == null) {
            throw new NullPointerException("vals is marked non-null but is null");
        }
        return (float[])ArrayUtils.removeAllElements((Object)array, new Object[]{vals});
    }

    public static short[] removeAllElements(@NonNull short[] array, short ... vals) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (vals == null) {
            throw new NullPointerException("vals is marked non-null but is null");
        }
        return (short[])ArrayUtils.removeAllElements((Object)array, new Object[]{vals});
    }

    public static int[] removeAllElements(@NonNull int[] array, int ... vals) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (vals == null) {
            throw new NullPointerException("vals is marked non-null but is null");
        }
        return (int[])ArrayUtils.removeAllElements((Object)array, new Object[]{vals});
    }

    public static long[] removeAllElements(@NonNull long[] array, long ... vals) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (vals == null) {
            throw new NullPointerException("vals is marked non-null but is null");
        }
        return (long[])ArrayUtils.removeAllElements((Object)array, new Object[]{vals});
    }

    public static int indexOf(@NonNull char[] chars, @NonNull String valueToFind, int startIndex) {
        if (chars == null) {
            throw new NullPointerException("chars is marked non-null but is null");
        }
        if (valueToFind == null) {
            throw new NullPointerException("valueToFind is marked non-null but is null");
        }
        if (ArrayUtils.isEmpty((char[])chars)) {
            throw new IllegalArgumentException("Chars: should not be empty");
        }
        if (StringUtils.isBlank((CharSequence)valueToFind)) {
            throw new IllegalArgumentException("ValueToFind: should not be blank");
        }
        if (startIndex < 0) {
            throw new IllegalArgumentException("StartIndex: should be greater than or equal to 0");
        }
        char[] valChars = valueToFind.toCharArray();
        if (valChars.length == 2) {
            int rCharIndex;
            int charsLastElementIndex = chars.length - 1;
            char lChar = valChars[0];
            char rChar = valChars[1];
            int index = -1;
            int lCharIndex = 0;
            while ((lCharIndex = ArrayUtils.indexOf((char[])chars, (char)lChar, (int)lCharIndex)) != -1 && lCharIndex != charsLastElementIndex && (rCharIndex = ArrayUtils.indexOf((char[])chars, (char)rChar, (int)(lCharIndex + 1))) != -1) {
                if (rCharIndex == lCharIndex + 1) {
                    index = lCharIndex;
                    break;
                }
                ++lCharIndex;
            }
            return index;
        }
        for (int i = 0; i < valChars.length; ++i) {
            int index = ArrayUtils.indexOf((char[])chars, (char)valChars[i], (int)startIndex);
            if (index == -1) {
                return -1;
            }
            if (i == valChars.length - 1) {
                return index - valueToFind.length() + 1;
            }
            ++startIndex;
        }
        return -1;
    }

    public static int indexOf(@NonNull char[] chars, @NonNull String valueToFind) {
        if (chars == null) {
            throw new NullPointerException("chars is marked non-null but is null");
        }
        if (valueToFind == null) {
            throw new NullPointerException("valueToFind is marked non-null but is null");
        }
        return ArrayUtils.indexOf(chars, valueToFind, 0);
    }

    public static int indexOf(@NonNull String[] strs, @NonNull String valueToFind, int startIndex) {
        if (strs == null) {
            throw new NullPointerException("strs is marked non-null but is null");
        }
        if (valueToFind == null) {
            throw new NullPointerException("valueToFind is marked non-null but is null");
        }
        if (ArrayUtils.isEmpty((Object[])strs)) {
            throw new IllegalArgumentException("Chars: should not be empty");
        }
        if (StringUtils.isBlank((CharSequence)valueToFind)) {
            throw new IllegalArgumentException("ValueToFind: should not be blank");
        }
        if (startIndex < 0) {
            throw new IllegalArgumentException("StartIndex: should be greater than or equal to 0");
        }
        char[] valChars = valueToFind.toCharArray();
        if (valChars.length == 2) {
            int rCharIndex;
            int charsLastElementIndex = strs.length - 1;
            char lChar = valChars[0];
            char rChar = valChars[1];
            int index = -1;
            int lCharIndex = 0;
            while ((lCharIndex = ArrayUtils.indexOf((Object[])strs, (Object)Character.valueOf(lChar), (int)lCharIndex)) != -1 && lCharIndex != charsLastElementIndex && (rCharIndex = ArrayUtils.indexOf((Object[])strs, (Object)Character.valueOf(rChar), (int)(lCharIndex + 1))) != -1) {
                if (rCharIndex == lCharIndex + 1) {
                    index = lCharIndex;
                    break;
                }
                ++lCharIndex;
            }
            return index;
        }
        for (int i = 0; i < valChars.length; ++i) {
            int index = ArrayUtils.indexOf((Object[])strs, (Object)Character.valueOf(valChars[i]), (int)startIndex);
            if (index == -1) {
                return -1;
            }
            if (i == valChars.length - 1) {
                return index - valueToFind.length() + 1;
            }
            ++startIndex;
        }
        return -1;
    }

    public static int indexOf(@NonNull String[] strs, @NonNull String valueToFind) {
        if (strs == null) {
            throw new NullPointerException("strs is marked non-null but is null");
        }
        if (valueToFind == null) {
            throw new NullPointerException("valueToFind is marked non-null but is null");
        }
        return ArrayUtils.indexOf(strs, valueToFind, 0);
    }

    public static int allLength(String ... strs) {
        if (strs == null) {
            throw new NullPointerException("strs is marked non-null but is null");
        }
        if (StringUtils.isAllBlank((CharSequence[])strs)) {
            throw new IllegalArgumentException("Strs: should not be all blank");
        }
        int result = 0;
        for (String str : strs) {
            result += str.length();
        }
        return result;
    }
}

