/*
 * Decompiled with CFR 0.152.
 */
package top.zhogjianhao;

import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.function.Function;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cglib.beans.BeanMap;
import top.zhogjianhao.CollectionUtils;
import top.zhogjianhao.StringUtils;

public class BeanUtils
extends org.springframework.beans.BeanUtils {
    private static final Logger log = LoggerFactory.getLogger(BeanUtils.class);
    private static final String FIELD_METHOD_PREFIX_GET = "get";
    private static final String FIELD_METHOD_PREFIX_IS = "is";

    public static Map<String, Object> toMap(Object obj) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        BeanMap beanMap = BeanMap.create((Object)obj);
        for (Object key : beanMap.keySet()) {
            map.put(key.toString(), beanMap.get(key));
        }
        return map;
    }

    public static <T> List<Map<String, Object>> toMap(List<T> sourceList) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        if (CollectionUtils.isEmpty(sourceList)) {
            return result;
        }
        for (T t : sourceList) {
            result.add(BeanUtils.toMap(t));
        }
        return result;
    }

    public static Map<String, Object> deepToMap(Object obj) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        BeanMap beanMap = BeanMap.create((Object)obj);
        for (Object keyObj : beanMap.keySet()) {
            String key = keyObj.toString();
            Object value = beanMap.get((Object)key);
            if (!(value == null || value instanceof String || value instanceof Integer || value instanceof Long || value instanceof Double || value instanceof Boolean || value instanceof Float || value instanceof Byte || value instanceof Character || value instanceof Short)) {
                Vector collection = null;
                if (value.getClass().isArray()) {
                    collection = Arrays.asList(value);
                } else if (value instanceof List) {
                    collection = (List<Object>)value;
                } else if (value instanceof Set) {
                    collection = (Set)value;
                } else if (value instanceof Vector) {
                    collection = (Vector)value;
                }
                if (collection != null) {
                    ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
                    for (Object item : collection) {
                        list.add(BeanUtils.deepToMap(item));
                    }
                    result.put(key, list);
                    continue;
                }
                result.put(key, BeanUtils.deepToMap(value));
                continue;
            }
            result.put(key, value);
        }
        return result;
    }

    public static <T> List<Map<String, Object>> deepToMap(List<T> sourceList) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        if (CollectionUtils.isEmpty(sourceList)) {
            return result;
        }
        for (T t : sourceList) {
            result.add(BeanUtils.deepToMap(t));
        }
        return result;
    }

    public static Object getProperty(Object bean, String name) {
        try {
            PropertyDescriptor propertyDescriptor = org.springframework.beans.BeanUtils.getPropertyDescriptor(bean.getClass(), (String)name);
            if (propertyDescriptor != null) {
                return propertyDescriptor.getReadMethod().invoke(bean, new Object[]{null});
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public static String getPropertyStr(Object bean, String name) {
        Object obj = BeanUtils.getProperty(bean, name);
        if (obj != null) {
            return obj.toString();
        }
        return null;
    }

    public static boolean setProperty(Object bean, String name, Object value) {
        try {
            PropertyDescriptor propertyDescriptor = org.springframework.beans.BeanUtils.getPropertyDescriptor(bean.getClass(), (String)name);
            if (propertyDescriptor != null) {
                propertyDescriptor.getWriteMethod().invoke(bean, value);
                return true;
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public static <T> String getFieldName(FieldFunction<T, ?> fn) {
        try {
            Method method = fn.getClass().getDeclaredMethod("writeReplace", new Class[0]);
            method.setAccessible(true);
            SerializedLambda serializedLambda = (SerializedLambda)method.invoke(fn, new Object[0]);
            String implMethodName = serializedLambda.getImplMethodName();
            if (implMethodName.startsWith(FIELD_METHOD_PREFIX_GET)) {
                implMethodName = implMethodName.substring(3);
            } else if (implMethodName.startsWith(FIELD_METHOD_PREFIX_IS)) {
                implMethodName = implMethodName.substring(2);
            }
            if (StringUtils.isNotBlank((CharSequence)implMethodName)) {
                return implMethodName.substring(0, 1).toLowerCase() + implMethodName.substring(1);
            }
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
        return "";
    }

    public static <T> String getColumnName(FieldFunction<T, ?> fn) {
        return StringUtils.toUnderscore(BeanUtils.getFieldName(fn));
    }

    public static <T> T copyProperties(@NonNull Object source, @NonNull Class<T> targetClass) {
        Constructor<?>[] constructors;
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (targetClass == null) {
            throw new NullPointerException("targetClass is marked non-null but is null");
        }
        boolean hasNoArgsConstructor = false;
        for (Constructor<?> constructor : constructors = targetClass.getConstructors()) {
            if (constructor.getParameterCount() != 0) continue;
            hasNoArgsConstructor = true;
            break;
        }
        if (!hasNoArgsConstructor) {
            throw new IllegalArgumentException("targetClass: " + targetClass.getName() + " must have no args constructor");
        }
        T target = null;
        try {
            target = targetClass.newInstance();
            org.springframework.beans.BeanUtils.copyProperties((Object)source, target);
        }
        catch (IllegalAccessException | InstantiationException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return target;
    }

    public static <T> List<T> copyProperties(List<?> sourceList, Class<T> targetClass) {
        Constructor<?>[] constructors;
        boolean hasNoArgsConstructor = false;
        for (Constructor<?> constructor : constructors = targetClass.getConstructors()) {
            if (constructor.getParameterCount() != 0) continue;
            hasNoArgsConstructor = true;
            break;
        }
        if (!hasNoArgsConstructor) {
            throw new IllegalArgumentException("targetClass: " + targetClass.getName() + " must have no args constructor");
        }
        ArrayList<Object> targetList = new ArrayList<Object>();
        for (Object source : sourceList) {
            Object target = null;
            try {
                target = targetClass.newInstance();
                org.springframework.beans.BeanUtils.copyProperties(source, target);
            }
            catch (IllegalAccessException | InstantiationException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            targetList.add(target);
        }
        return targetList;
    }

    @FunctionalInterface
    public static interface FieldFunction<T, R>
    extends Function<T, R>,
    Serializable {
    }
}

