/*
 * Decompiled with CFR 0.152.
 */
package top.zhogjianhao;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.SecretKeySpec;
import lombok.NonNull;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.engines.DESEngine;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.paddings.BlockCipherPadding;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.pqc.math.linearalgebra.ByteUtils;
import top.zhogjianhao.ArrayUtils;

public class SecurityUtils {
    public static byte[] desEcb(@NonNull byte[] key, @NonNull byte[] in, boolean encrypting, BlockCipherPadding padding) throws InvalidCipherTextException {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (in == null) {
            throw new NullPointerException("in is marked non-null but is null");
        }
        if (key.length != 8) {
            throw new IllegalArgumentException("Key: should be 8 bytes");
        }
        int inLen = in.length;
        if (inLen == 0) {
            throw new IllegalArgumentException("In: should not be empty");
        }
        PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher((BlockCipher)new DESEngine(), padding);
        cipher.init(encrypting, (CipherParameters)new KeyParameter(key));
        byte[] out = new byte[cipher.getOutputSize(in.length)];
        int len = cipher.processBytes(in, 0, inLen, out, 0);
        len += cipher.doFinal(out, len);
        byte[] result = new byte[len];
        System.arraycopy(out, 0, result, 0, len);
        return result;
    }

    public static String desEcb(@NonNull String key, @NonNull String in, boolean encrypting, BlockCipherPadding padding) throws InvalidCipherTextException, InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (in == null) {
            throw new NullPointerException("in is marked non-null but is null");
        }
        byte[] keys = ArrayUtils.toBytes(key.toCharArray());
        if (keys.length < 8) {
            throw new IllegalArgumentException("Key: should be greater than 8 bytes");
        }
        DESKeySpec keySpec = new DESKeySpec(keys);
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
        SecretKeySpec secretKeySpec = new SecretKeySpec(keyFactory.generateSecret(keySpec).getEncoded(), "DES");
        keys = secretKeySpec.getEncoded();
        if (encrypting) {
            return ByteUtils.toHexString((byte[])SecurityUtils.desEcb(keys, ArrayUtils.toBytes(in.toCharArray()), encrypting, padding));
        }
        byte[] bytes = SecurityUtils.desEcb(keys, ByteUtils.fromHexString((String)in), encrypting, padding);
        return new String(ArrayUtils.toChars(bytes));
    }

    public static byte[] desCbc(@NonNull byte[] key, @NonNull byte[] icv, @NonNull byte[] in, boolean encrypting, BlockCipherPadding padding) throws InvalidCipherTextException {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (icv == null) {
            throw new NullPointerException("icv is marked non-null but is null");
        }
        if (in == null) {
            throw new NullPointerException("in is marked non-null but is null");
        }
        if (key.length != 8) {
            throw new IllegalArgumentException("Key: should be 8 bytes");
        }
        if (icv.length != 8) {
            throw new IllegalArgumentException("Icv: should be 8 bytes");
        }
        int inLen = in.length;
        if (inLen == 0) {
            throw new IllegalArgumentException("In: should not be empty");
        }
        PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)new DESEngine()), padding);
        cipher.init(encrypting, (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(key), icv));
        byte[] out = new byte[cipher.getOutputSize(in.length)];
        int len = cipher.processBytes(in, 0, inLen, out, 0);
        len += cipher.doFinal(out, len);
        byte[] result = new byte[len];
        System.arraycopy(out, 0, result, 0, len);
        return result;
    }

    public static String desCbc(@NonNull String key, @NonNull String icv, @NonNull String in, boolean encrypting, BlockCipherPadding padding) throws InvalidCipherTextException, InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (icv == null) {
            throw new NullPointerException("icv is marked non-null but is null");
        }
        if (in == null) {
            throw new NullPointerException("in is marked non-null but is null");
        }
        byte[] keys = ArrayUtils.toBytes(key.toCharArray());
        if (keys.length < 8) {
            throw new IllegalArgumentException("Key: should be greater than 8 bytes");
        }
        byte[] icvs = ArrayUtils.toBytes(icv.toCharArray());
        if (icvs.length < 8) {
            throw new IllegalArgumentException("Icv: should be greater than 8 bytes");
        }
        DESKeySpec keySpec = new DESKeySpec(keys);
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
        SecretKeySpec secretKeySpec = new SecretKeySpec(keyFactory.generateSecret(keySpec).getEncoded(), "DES");
        keys = secretKeySpec.getEncoded();
        if (encrypting) {
            return ByteUtils.toHexString((byte[])SecurityUtils.desCbc(keys, icvs, ArrayUtils.toBytes(in.toCharArray()), encrypting, padding));
        }
        byte[] bytes = SecurityUtils.desCbc(keys, icvs, ByteUtils.fromHexString((String)in), encrypting, padding);
        return new String(ArrayUtils.toChars(bytes));
    }
}

