/*
 * Decompiled with CFR 0.152.
 */
package top.zhogjianhao.date;

import java.text.ParseException;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.Year;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAdjusters;
import java.time.temporal.TemporalField;
import java.time.temporal.ValueRange;
import java.time.temporal.WeekFields;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;
import lombok.NonNull;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.commons.text.WordUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.zhogjianhao.CollectionUtils;
import top.zhogjianhao.RegExUtils;
import top.zhogjianhao.StringUtils;
import top.zhogjianhao.date.DateDuration;
import top.zhogjianhao.date.DatePattern;
import top.zhogjianhao.date.DatePatternRegex;

public class DateUtils
extends org.apache.commons.lang3.time.DateUtils {
    private static final Logger log = LoggerFactory.getLogger(DateUtils.class);
    public static final int MIN_DATE_YEAR = 1970;
    private static final Locale DEFAULT_LOCALE = Locale.ENGLISH;
    public static final ZoneId SYSTEM_ZONE_ID = ZoneId.systemDefault();
    public static final ZoneOffset SYSTEM_ZONE_OFFSET = OffsetDateTime.now(SYSTEM_ZONE_ID).getOffset();
    public static String defaultLocalDatePattern = "uuuu-MM-dd";
    public static String defaultLocalDateTimePattern = "yyyy-MM-dd HH:mm:ss";
    public static String defaultLocalTimePattern = "HH:mm:ss";

    public static DateTimeFormatterBuilder getFormatterBuilder(@NonNull String pattern, Map<TemporalField, Long> fieldValueMap) {
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        if (StringUtils.isBlank((CharSequence)pattern)) {
            throw new IllegalArgumentException("Pattern: should not be blank");
        }
        DateTimeFormatterBuilder formatterBuilder = new DateTimeFormatterBuilder().appendPattern(pattern);
        String lowercasePattern = pattern.toLowerCase();
        if (MapUtils.isNotEmpty(fieldValueMap)) {
            ChronoField maybeExistTemporalField = ChronoField.YEAR_OF_ERA;
            if (pattern.contains("u") && fieldValueMap.containsKey(maybeExistTemporalField)) {
                fieldValueMap.remove(maybeExistTemporalField);
            }
            maybeExistTemporalField = ChronoField.YEAR;
            if (lowercasePattern.contains("y") && fieldValueMap.containsKey(maybeExistTemporalField)) {
                fieldValueMap.remove(maybeExistTemporalField);
            }
            maybeExistTemporalField = ChronoField.MONTH_OF_YEAR;
            if ((pattern.contains("M") || pattern.contains("L")) && fieldValueMap.containsKey(maybeExistTemporalField)) {
                fieldValueMap.remove(maybeExistTemporalField);
            }
            maybeExistTemporalField = ChronoField.DAY_OF_MONTH;
            if (pattern.contains("d") && fieldValueMap.containsKey(maybeExistTemporalField)) {
                fieldValueMap.remove(maybeExistTemporalField);
            }
            maybeExistTemporalField = ChronoField.HOUR_OF_DAY;
            if ((lowercasePattern.contains("h") || lowercasePattern.contains("k")) && fieldValueMap.containsKey(maybeExistTemporalField)) {
                fieldValueMap.remove(maybeExistTemporalField);
            }
        }
        for (TemporalField temporalField : fieldValueMap.keySet()) {
            formatterBuilder.parseDefaulting(temporalField, fieldValueMap.get(temporalField));
        }
        return formatterBuilder;
    }

    public static DateTimeFormatter getDefaultFormatter(@NonNull String pattern, Locale locale, ZoneId atZoneId) {
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        if (StringUtils.isBlank((CharSequence)pattern)) {
            throw new IllegalArgumentException("Pattern: should not be blank");
        }
        HashMap<TemporalField, Long> fieldValueMap = new HashMap<TemporalField, Long>();
        fieldValueMap.put(ChronoField.YEAR_OF_ERA, 1L);
        fieldValueMap.put(ChronoField.YEAR, 0L);
        fieldValueMap.put(ChronoField.MONTH_OF_YEAR, 1L);
        fieldValueMap.put(ChronoField.DAY_OF_MONTH, 1L);
        fieldValueMap.put(ChronoField.HOUR_OF_DAY, 0L);
        DateTimeFormatterBuilder formatterBuilder = DateUtils.getFormatterBuilder(pattern, fieldValueMap);
        DateTimeFormatter dateTimeFormatter = locale != null ? formatterBuilder.toFormatter(locale) : formatterBuilder.toFormatter();
        dateTimeFormatter.withResolverStyle(DatePattern.DEFAULT_RESOLVER_STYLE);
        if (atZoneId != null) {
            dateTimeFormatter = dateTimeFormatter.withZone(atZoneId);
        }
        return dateTimeFormatter;
    }

    public static DateTimeFormatter getDefaultFormatter(@NonNull String pattern, @NonNull Locale locale) {
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        if (locale == null) {
            throw new NullPointerException("locale is marked non-null but is null");
        }
        return DateUtils.getDefaultFormatter(pattern, locale, null);
    }

    public static DateTimeFormatter getDefaultFormatter(@NonNull String pattern, @NonNull ZoneId atZoneId) {
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        if (atZoneId == null) {
            throw new NullPointerException("atZoneId is marked non-null but is null");
        }
        return DateUtils.getDefaultFormatter(pattern, null, atZoneId);
    }

    public static DateTimeFormatter getDefaultFormatter(@NonNull String pattern) {
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        return DateUtils.getDefaultFormatter(pattern, DEFAULT_LOCALE);
    }

    private static String convertByPattern(@NonNull String source, @NonNull String pattern) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        if (StringUtils.isBlank((CharSequence)pattern)) {
            throw new IllegalArgumentException("Pattern: should not be blank");
        }
        int mmmIndex = pattern.indexOf("MMM");
        if (mmmIndex != -1) {
            String mmm = source.substring(mmmIndex, mmmIndex + 3);
            source = source.replaceAll(mmm, WordUtils.capitalize((String)mmm.toLowerCase()));
        }
        return source;
    }

    public static String convertMonthShortText(@NonNull String monthNumber, @NonNull Locale locale) {
        if (monthNumber == null) {
            throw new NullPointerException("monthNumber is marked non-null but is null");
        }
        if (locale == null) {
            throw new NullPointerException("locale is marked non-null but is null");
        }
        if (StringUtils.isBlank((CharSequence)monthNumber)) {
            throw new IllegalArgumentException("MonthNumber: should not be all blank");
        }
        int monthNumberLen = monthNumber.length();
        if (monthNumberLen != 1 && monthNumberLen != 2) {
            throw new IllegalArgumentException("MonthNumber: Length should be 1 or 2");
        }
        try {
            FastDateFormat formatMm;
            FastDateFormat formatMmm;
            if (Locale.US.equals(locale)) {
                formatMmm = DatePattern.FORMAT_MMM_US;
                formatMm = DatePattern.FORMAT_MM_US;
            } else if (Locale.SIMPLIFIED_CHINESE.equals(locale)) {
                formatMmm = DatePattern.FORMAT_MMM_ZH_CN;
                formatMm = DatePattern.FORMAT_MM_ZH_CN;
            } else if (Locale.TRADITIONAL_CHINESE.equals(locale)) {
                formatMmm = DatePattern.FORMAT_MMM_ZH_TW;
                formatMm = DatePattern.FORMAT_MM_ZH_TW;
            } else {
                formatMmm = FastDateFormat.getInstance((String)"MMM", (Locale)locale);
                formatMm = FastDateFormat.getInstance((String)"MM", (Locale)locale);
            }
            return formatMmm.format(formatMm.parse(monthNumber));
        }
        catch (ParseException e) {
            log.warn(e.getMessage());
            return null;
        }
    }

    public static String convertMonthShortText(@NonNull String monthNumber) {
        if (monthNumber == null) {
            throw new NullPointerException("monthNumber is marked non-null but is null");
        }
        return DateUtils.convertMonthShortText(monthNumber, Locale.US);
    }

    public static String convertMonthText(@NonNull String monthNumber, @NonNull Locale locale) {
        if (monthNumber == null) {
            throw new NullPointerException("monthNumber is marked non-null but is null");
        }
        if (locale == null) {
            throw new NullPointerException("locale is marked non-null but is null");
        }
        if (StringUtils.isBlank((CharSequence)monthNumber)) {
            throw new IllegalArgumentException("MonthNumber: should not be all blank");
        }
        int monthNumberLen = monthNumber.length();
        if (monthNumberLen != 1 && monthNumberLen != 2) {
            throw new IllegalArgumentException("MonthNumber: Length should be 1 or 2");
        }
        try {
            FastDateFormat formatMm;
            FastDateFormat formatMmm;
            if (Locale.US.equals(locale)) {
                formatMmm = DatePattern.FORMAT_MMMM_US;
                formatMm = DatePattern.FORMAT_MM_US;
            } else if (Locale.SIMPLIFIED_CHINESE.equals(locale)) {
                formatMmm = DatePattern.FORMAT_MMMM_ZH_CN;
                formatMm = DatePattern.FORMAT_MM_ZH_CN;
            } else if (Locale.TRADITIONAL_CHINESE.equals(locale)) {
                formatMmm = DatePattern.FORMAT_MMMM_ZH_TW;
                formatMm = DatePattern.FORMAT_MM_ZH_TW;
            } else {
                formatMmm = FastDateFormat.getInstance((String)"MMMM", (Locale)locale);
                formatMm = FastDateFormat.getInstance((String)"MM", (Locale)locale);
            }
            return formatMmm.format(formatMm.parse(monthNumber));
        }
        catch (ParseException e) {
            log.warn(e.getMessage());
            return null;
        }
    }

    public static String convertMonthText(@NonNull String monthNumber) {
        if (monthNumber == null) {
            throw new NullPointerException("monthNumber is marked non-null but is null");
        }
        return DateUtils.convertMonthText(monthNumber, Locale.US);
    }

    public static String format(@NonNull Temporal temporal, ZoneId zoneId, @NonNull String pattern) {
        if (temporal == null) {
            throw new NullPointerException("temporal is marked non-null but is null");
        }
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        if (StringUtils.isBlank((CharSequence)pattern)) {
            throw new IllegalArgumentException("Pattern: should not be blank");
        }
        DateTimeFormatter dateTimeFormatter = defaultLocalDateTimePattern.equals(pattern) ? DatePattern.FORMATTER_YYYY_MM_DD_HH_MM_SS : (defaultLocalDatePattern.equals(pattern) ? DatePattern.FORMATTER_YYYY_MM_DD : (defaultLocalTimePattern.equals(pattern) ? DatePattern.FORMATTER_HH_MM_SS : DateUtils.getDefaultFormatter(pattern)));
        if (zoneId != null) {
            if (temporal instanceof LocalDateTime || temporal instanceof LocalDate || temporal instanceof LocalTime) {
                LocalDateTime localDateTime = temporal instanceof LocalDateTime ? (LocalDateTime)temporal : (temporal instanceof LocalDate ? ((LocalDate)temporal).atTime(LocalTime.now()) : ((LocalTime)temporal).atDate(LocalDate.now()));
                return localDateTime.atZone(SYSTEM_ZONE_ID).withZoneSameInstant(zoneId).format(dateTimeFormatter);
            }
            if (temporal instanceof ZonedDateTime) {
                return ((ZonedDateTime)temporal).withZoneSameInstant(zoneId).format(dateTimeFormatter);
            }
            throw new IllegalArgumentException("Temporal: should be ZonedDateTime, LocalDateTime, LocalDate, or LocalTime");
        }
        return dateTimeFormatter.format(temporal);
    }

    public static String format(@NonNull Temporal temporal, ZoneId zoneId) {
        String pattern;
        if (temporal == null) {
            throw new NullPointerException("temporal is marked non-null but is null");
        }
        if (temporal instanceof LocalDateTime || temporal instanceof ZonedDateTime) {
            pattern = defaultLocalDateTimePattern;
        } else if (temporal instanceof LocalDate) {
            pattern = defaultLocalDatePattern;
        } else if (temporal instanceof LocalTime) {
            pattern = defaultLocalTimePattern;
        } else {
            throw new IllegalArgumentException("Temporal: should be ZonedDateTime, LocalDateTime, LocalDate, or LocalTime");
        }
        return DateUtils.format(temporal, zoneId, pattern);
    }

    public static String format(@NonNull Temporal temporal, @NonNull String pattern) {
        if (temporal == null) {
            throw new NullPointerException("temporal is marked non-null but is null");
        }
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        return DateUtils.format(temporal, null, pattern);
    }

    public static String format(@NonNull Temporal temporal) {
        if (temporal == null) {
            throw new NullPointerException("temporal is marked non-null but is null");
        }
        return DateUtils.format(temporal, (ZoneId)null);
    }

    public static String format(@NonNull Date date, ZoneId zoneId, @NonNull String pattern) {
        if (date == null) {
            throw new NullPointerException("date is marked non-null but is null");
        }
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        if (StringUtils.isBlank((CharSequence)pattern)) {
            throw new IllegalArgumentException("Pattern: should not be blank");
        }
        if (zoneId != null) {
            ZonedDateTime zonedDateTime = date.toInstant().atZone(SYSTEM_ZONE_ID);
            zonedDateTime = zonedDateTime.withZoneSameInstant(zoneId);
            return DateUtils.format((Temporal)zonedDateTime.toLocalDateTime(), pattern);
        }
        FastDateFormat format = null;
        if (defaultLocalDateTimePattern.equals(pattern)) {
            format = DatePattern.FORMAT_YYYY_MM_DD_HH_MM_SS;
        } else if (defaultLocalDatePattern.equals(pattern)) {
            format = DatePattern.FORMAT_YYYY_MM_DD;
        } else if (defaultLocalTimePattern.equals(pattern)) {
            format = DatePattern.FORMAT_HH_MM_SS;
        }
        if (format != null) {
            return format.format(date);
        }
        ZonedDateTime zonedDateTime = date.toInstant().atZone(SYSTEM_ZONE_ID);
        return DateUtils.format((Temporal)zonedDateTime.toLocalDateTime(), pattern);
    }

    public static String format(@NonNull Date date, @NonNull ZoneId zoneId) {
        if (date == null) {
            throw new NullPointerException("date is marked non-null but is null");
        }
        if (zoneId == null) {
            throw new NullPointerException("zoneId is marked non-null but is null");
        }
        return DateUtils.format(date, zoneId, defaultLocalDateTimePattern);
    }

    public static String format(@NonNull Date date, @NonNull String pattern) {
        if (date == null) {
            throw new NullPointerException("date is marked non-null but is null");
        }
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        return DateUtils.format(date, null, pattern);
    }

    public static String format(@NonNull Date date) {
        if (date == null) {
            throw new NullPointerException("date is marked non-null but is null");
        }
        return DateUtils.format(date, defaultLocalDateTimePattern);
    }

    public static String format(long timeStamp, ZoneId zoneId, @NonNull String pattern) {
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        return DateUtils.format(new Date(timeStamp), zoneId, pattern);
    }

    public static String format(long timeStamp, @NonNull ZoneId zoneId) {
        if (zoneId == null) {
            throw new NullPointerException("zoneId is marked non-null but is null");
        }
        return DateUtils.format(timeStamp, zoneId, defaultLocalDateTimePattern);
    }

    public static String format(long timeStamp, @NonNull String pattern) {
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        return DateUtils.format(timeStamp, null, pattern);
    }

    public static String format(long timeStamp) {
        return DateUtils.format(timeStamp, defaultLocalDateTimePattern);
    }

    public static String formatCountdown(long timeStamp, @NonNull String pattern) {
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        if (timeStamp <= 0L) {
            throw new IllegalArgumentException("TimeStamp: should be greater than 0");
        }
        if (StringUtils.isBlank((CharSequence)pattern)) {
            throw new IllegalArgumentException("Pattern: should not be blank");
        }
        String lowerCasePattern = pattern.toLowerCase();
        if (pattern.contains("W")) {
            long week = timeStamp / DateDuration.WEEK_MILLIS;
            if (week > 0L) {
                timeStamp -= week * DateDuration.WEEK_MILLIS;
            }
            if ((pattern = DatePatternRegex.PATTERN_WEEK_OF_MONTH.matcher(pattern).replaceAll(String.valueOf(week))).contains("W")) {
                pattern = DatePatternRegex.PATTERN_WEEK_OF_MONTH2.matcher(pattern).replaceAll(String.format("%02d", week));
            }
        }
        if (lowerCasePattern.contains("d")) {
            long dayOfMonth = timeStamp / DateDuration.DAY_OF_MONTH_MILLIS;
            if (dayOfMonth > 0L) {
                timeStamp -= dayOfMonth * DateDuration.DAY_OF_MONTH_MILLIS;
            }
            if ((pattern = DatePatternRegex.PATTERN_DAY_OF_MONTH.matcher(pattern).replaceAll(String.valueOf(dayOfMonth))).contains("d")) {
                pattern = DatePatternRegex.PATTERN_DAY_OF_MONTH2.matcher(pattern).replaceAll(String.format("%02d", dayOfMonth));
            }
        }
        if (lowerCasePattern.contains("h") || lowerCasePattern.contains("k")) {
            long hour = timeStamp / DateDuration.HOUR_MILLIS;
            if (hour > 0L) {
                timeStamp -= hour * DateDuration.HOUR_MILLIS;
            }
            if (pattern.contains("H")) {
                pattern = DatePatternRegex.PATTERN_HOUR_OF_DAY.matcher(pattern).replaceAll(String.valueOf(hour));
            }
            if (pattern.contains("H")) {
                pattern = DatePatternRegex.PATTERN_HOUR_OF_DAY2.matcher(pattern).replaceAll(String.format("%02d", hour));
            }
            if (pattern.contains("h")) {
                pattern = DatePatternRegex.PATTERN_CLOCK_HOUR_OF_AM_PM12.matcher(pattern).replaceAll(String.valueOf((hour + 1L) / 2L));
            }
            if (pattern.contains("h")) {
                pattern = DatePatternRegex.PATTERN_CLOCK_HOUR_OF_AM_PM12_2.matcher(pattern).replaceAll(String.format("%02d", (hour + 1L) / 2L));
            }
            if (pattern.contains("K")) {
                pattern = DatePatternRegex.PATTERN_HOUR_OF_AM_PM.matcher(pattern).replaceAll(String.valueOf(hour / 2L));
            }
            if (pattern.contains("K")) {
                pattern = DatePatternRegex.PATTERN_HOUR_OF_AM_PM2.matcher(pattern).replaceAll(String.format("%02d", hour / 2L));
            }
            if (pattern.contains("k")) {
                pattern = DatePatternRegex.PATTERN_CLOCK_HOUR_OF_AM_PM24.matcher(pattern).replaceAll(String.valueOf(hour + 1L));
            }
            if (pattern.contains("k")) {
                pattern = DatePatternRegex.PATTERN_CLOCK_HOUR_OF_AM_PM24_2.matcher(pattern).replaceAll(String.format("%02d", hour + 1L));
            }
        }
        if (pattern.contains("m")) {
            long minute = timeStamp / DateDuration.MINUTE_MILLIS;
            if (minute > 0L) {
                timeStamp -= minute * DateDuration.MINUTE_MILLIS;
            }
            if (pattern.contains("m")) {
                pattern = DatePatternRegex.PATTERN_MINUTE_OF_HOUR.matcher(pattern).replaceAll(String.valueOf(minute));
            }
            if (pattern.contains("m")) {
                pattern = DatePatternRegex.PATTERN_MINUTE_OF_HOUR2.matcher(pattern).replaceAll(String.format("%02d", minute));
            }
        }
        if (pattern.contains("s")) {
            long second = timeStamp / DateDuration.SECOND_MILLIS;
            if (second > 0L) {
                timeStamp -= second * DateDuration.SECOND_MILLIS;
            }
            if (pattern.contains("s")) {
                pattern = DatePatternRegex.PATTERN_SECOND_OF_MINUTE.matcher(pattern).replaceAll(String.valueOf(second));
            }
            if (pattern.contains("s")) {
                pattern = DatePatternRegex.PATTERN_SECOND_OF_MINUTE2.matcher(pattern).replaceAll(String.format("%02d", second));
            }
        }
        if (pattern.contains("S")) {
            long millis = timeStamp / 1000L;
            if (pattern.contains("S")) {
                pattern = DatePatternRegex.PATTERN_FRACTION_OF_SECOND3.matcher(pattern).replaceAll(String.format("%03d", millis));
            }
        }
        return pattern;
    }

    public static String formatCountdown(long timeStamp, boolean isIgnoreZero, String weekSuffix, String dayOfMonthSuffix, String hourSuffix, String minuteSuffix, String secondSuffix, String millisSuffix) {
        long millis;
        String result = "";
        if (weekSuffix != null) {
            long week = timeStamp / DateDuration.WEEK_MILLIS;
            if (week > 0L) {
                timeStamp -= week * DateDuration.WEEK_MILLIS;
            }
            if (week > 0L || !isIgnoreZero) {
                result = result + week + weekSuffix;
            }
        }
        if (dayOfMonthSuffix != null) {
            long dayOfMonth = timeStamp / DateDuration.DAY_OF_MONTH_MILLIS;
            if (dayOfMonth > 0L) {
                timeStamp -= dayOfMonth * DateDuration.DAY_OF_MONTH_MILLIS;
            }
            if (dayOfMonth > 0L || !isIgnoreZero) {
                result = result + dayOfMonth + dayOfMonthSuffix;
            }
        }
        if (hourSuffix != null) {
            long hour = timeStamp / DateDuration.HOUR_MILLIS;
            if (hour > 0L) {
                timeStamp -= hour * DateDuration.HOUR_MILLIS;
            }
            if (hour > 0L || !isIgnoreZero) {
                result = result + hour + hourSuffix;
            }
        }
        if (minuteSuffix != null) {
            long minute = timeStamp / DateDuration.MINUTE_MILLIS;
            if (minute > 0L) {
                timeStamp -= minute * DateDuration.MINUTE_MILLIS;
            }
            if (minute > 0L || !isIgnoreZero) {
                result = result + minute + minuteSuffix;
            }
        }
        if (secondSuffix != null) {
            long second = timeStamp / DateDuration.SECOND_MILLIS;
            if (second > 0L) {
                timeStamp -= second * DateDuration.SECOND_MILLIS;
            }
            if (second > 0L || !isIgnoreZero) {
                result = result + second + secondSuffix;
            }
        }
        if (!(millisSuffix == null || (millis = timeStamp / 1000L) <= 0L && isIgnoreZero)) {
            result = result + millis + millisSuffix;
        }
        return result;
    }

    public static Date toDate(@NonNull Temporal temporal, ZoneId zoneId) {
        if (temporal == null) {
            throw new NullPointerException("temporal is marked non-null but is null");
        }
        if (temporal instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)temporal;
            ZonedDateTime[] zonedDateTime = new ZonedDateTime[1];
            if (zoneId != null) {
                zoneId.getRules().getOffset(localDateTime).query(temporal1 -> {
                    zonedDateTime[0] = localDateTime.atZone(ZoneOffset.ofTotalSeconds(SYSTEM_ZONE_OFFSET.getTotalSeconds() - (((ZoneOffset)temporal1).getTotalSeconds() - SYSTEM_ZONE_OFFSET.getTotalSeconds())));
                    return null;
                });
            } else {
                zonedDateTime[0] = localDateTime.atZone(SYSTEM_ZONE_ID);
            }
            return Date.from(zonedDateTime[0].toInstant());
        }
        if (temporal instanceof LocalDate) {
            return DateUtils.toDate(((LocalDate)temporal).atStartOfDay(), zoneId);
        }
        if (temporal instanceof LocalTime) {
            return DateUtils.toDate(((LocalTime)temporal).atDate(LocalDate.of(1970, 1, 1)), zoneId);
        }
        if (temporal instanceof ZonedDateTime) {
            ZonedDateTime[] zonedDateTime = new ZonedDateTime[]{(ZonedDateTime)temporal};
            if (zoneId != null) {
                LocalDateTime localDateTime = zonedDateTime[0].toLocalDateTime();
                int[] zonedDateTimeTotalSeconds = new int[]{0};
                zonedDateTime[0].getZone().getRules().getOffset(localDateTime).query(temporal1 -> {
                    zonedDateTimeTotalSeconds[0] = ((ZoneOffset)temporal1).getTotalSeconds();
                    return null;
                });
                zoneId.getRules().getOffset(localDateTime).query(temporal1 -> {
                    zonedDateTime[0] = localDateTime.atZone(ZoneOffset.ofTotalSeconds(zonedDateTimeTotalSeconds[0] - (((ZoneOffset)temporal1).getTotalSeconds() - zonedDateTimeTotalSeconds[0])));
                    return null;
                });
            }
            return Date.from(zonedDateTime[0].toInstant());
        }
        throw new IllegalArgumentException("Temporal: should be ZonedDateTime, LocalDateTime, LocalDate, or LocalTime");
    }

    public static Date toDate(@NonNull Temporal temporal) {
        if (temporal == null) {
            throw new NullPointerException("temporal is marked non-null but is null");
        }
        return DateUtils.toDate(temporal, null);
    }

    public static LocalDateTime toLocalDateTime(@NonNull Date date) {
        if (date == null) {
            throw new NullPointerException("date is marked non-null but is null");
        }
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public static LocalDate toLocalDate(@NonNull Date date) {
        if (date == null) {
            throw new NullPointerException("date is marked non-null but is null");
        }
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static LocalTime toLocalTime(@NonNull Date date) {
        if (date == null) {
            throw new NullPointerException("date is marked non-null but is null");
        }
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalTime();
    }

    public static <T extends Temporal> T toTemporal(@NonNull Date date, @NonNull Class<T> clazz) {
        if (date == null) {
            throw new NullPointerException("date is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        if (LocalDateTime.class.equals(clazz)) {
            return (T)DateUtils.toLocalDateTime(date);
        }
        if (LocalDate.class.equals(clazz)) {
            return (T)DateUtils.toLocalDate(date);
        }
        if (LocalTime.class.equals(clazz)) {
            return (T)DateUtils.toLocalTime(date);
        }
        return null;
    }

    public static LocalDateTime parseLocalDateTime(long timeStamp, ZoneId zoneId) {
        ZonedDateTime zonedDateTime = Instant.ofEpochMilli(timeStamp).atZone(SYSTEM_ZONE_ID);
        if (zoneId != null) {
            zonedDateTime = zonedDateTime.withZoneSameInstant(zoneId);
        }
        return zonedDateTime.toLocalDateTime();
    }

    public static LocalDateTime parseLocalDateTime(long timeStamp) {
        return DateUtils.parseLocalDateTime(timeStamp, null);
    }

    public static LocalDateTime parseLocalDateTime(@NonNull String source, ZoneId zoneId, String ... patterns) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (patterns == null) {
            throw new NullPointerException("patterns is marked non-null but is null");
        }
        if (StringUtils.isAllBlank((CharSequence[])patterns)) {
            throw new IllegalArgumentException("Patterns: should not be all blank");
        }
        int n = 0;
        String[] stringArray = patterns;
        int n2 = stringArray.length;
        if (n < n2) {
            String pattern = stringArray[n];
            source = DateUtils.convertByPattern(source, pattern);
            ZonedDateTime zonedDateTime = LocalDateTime.parse(source, DateUtils.getDefaultFormatter(pattern)).atZone(SYSTEM_ZONE_ID);
            if (zoneId != null) {
                zonedDateTime = zonedDateTime.withZoneSameInstant(zoneId);
            }
            return zonedDateTime.toLocalDateTime();
        }
        return null;
    }

    public static LocalDateTime parseLocalDateTime(@NonNull String source, ZoneId zoneId) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        String pattern = null;
        if (source.contains("-") || source.contains("/") || source.contains(".") || source.contains(":")) {
            switch (source.length()) {
                case 19: {
                    if (source.contains("-")) {
                        pattern = "uuuu-MM-dd HH:mm:ss";
                        break;
                    }
                    if (source.contains("/")) {
                        pattern = "uuuu/MM/dd HH:mm:ss";
                        break;
                    }
                    if (!source.contains(".")) break;
                    pattern = "uuuu.MM.dd HH:mm:ss";
                    break;
                }
                case 16: {
                    if (source.contains("-")) {
                        pattern = "uuuu-MM-dd HH:mm";
                        break;
                    }
                    if (source.contains("/")) {
                        pattern = "uuuu/MM/dd HH:mm";
                        break;
                    }
                    if (!source.contains(".")) break;
                    pattern = "uuuu.MM.dd HH:mm";
                    break;
                }
                case 10: {
                    if (source.contains("-")) {
                        pattern = "uuuu-MM-dd";
                        break;
                    }
                    if (source.contains("/")) {
                        pattern = "uuuu/MM/dd";
                        break;
                    }
                    if (!source.contains(".")) break;
                    pattern = "uuuu.MM.dd";
                    break;
                }
                case 7: {
                    if (source.contains("-")) {
                        pattern = "uuuu-MM";
                        break;
                    }
                    if (source.contains("/")) {
                        pattern = "uuuu/MM";
                        break;
                    }
                    if (!source.contains(".")) break;
                    pattern = "uuuu.MM";
                    break;
                }
                case 8: {
                    pattern = "HH:mm:ss";
                    break;
                }
                case 5: {
                    pattern = "HH:mm";
                    break;
                }
            }
            if (pattern == null) {
                return null;
            }
            return DateUtils.parseLocalDateTime(source, zoneId, pattern);
        }
        return null;
    }

    public static LocalDateTime parseLocalDateTime(@NonNull String source, String ... patterns) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (patterns == null) {
            throw new NullPointerException("patterns is marked non-null but is null");
        }
        return DateUtils.parseLocalDateTime(source, null, patterns);
    }

    public static LocalDateTime parseLocalDateTime(@NonNull String source) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        return DateUtils.parseLocalDateTime(source, (ZoneId)null);
    }

    public static LocalDate parseLocalDate(long timeStamp, ZoneId zoneId) {
        ZonedDateTime zonedDateTime = Instant.ofEpochMilli(timeStamp).atZone(SYSTEM_ZONE_ID);
        if (zoneId != null) {
            zonedDateTime = zonedDateTime.withZoneSameInstant(zoneId);
        }
        return zonedDateTime.toLocalDate();
    }

    public static LocalDate parseLocalDate(long timeStamp) {
        return DateUtils.parseLocalDate(timeStamp, null);
    }

    public static LocalDate parseLocalDate(@NonNull String source, ZoneId zoneId, String ... patterns) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (patterns == null) {
            throw new NullPointerException("patterns is marked non-null but is null");
        }
        if (StringUtils.isAllBlank((CharSequence[])patterns)) {
            throw new IllegalArgumentException("Patterns: should not be all blank");
        }
        int n = 0;
        String[] stringArray = patterns;
        int n2 = stringArray.length;
        if (n < n2) {
            String pattern = stringArray[n];
            source = DateUtils.convertByPattern(source, pattern);
            LocalDate localDate = LocalDate.parse(source, DateUtils.getDefaultFormatter(pattern));
            if (zoneId != null) {
                return localDate.atTime(LocalTime.MIN).atZone(SYSTEM_ZONE_ID).withZoneSameInstant(zoneId).toLocalDate();
            }
            return localDate;
        }
        return null;
    }

    public static LocalDate parseLocalDate(@NonNull String source, ZoneId zoneId) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        String pattern = null;
        if (source.contains("-") || source.contains("/") || source.contains(".") || source.contains(":")) {
            switch (source.length()) {
                case 10: {
                    if (source.contains("-")) {
                        pattern = "uuuu-MM-dd";
                        break;
                    }
                    if (source.contains("/")) {
                        pattern = "uuuu/MM/dd";
                        break;
                    }
                    if (!source.contains(".")) break;
                    pattern = "uuuu.MM.dd";
                    break;
                }
                case 7: {
                    if (source.contains("-")) {
                        pattern = "uuuu-MM";
                        break;
                    }
                    if (source.contains("/")) {
                        pattern = "uuuu/MM";
                        break;
                    }
                    if (!source.contains(".")) break;
                    pattern = "uuuu.MM";
                    break;
                }
                case 8: {
                    pattern = "HH:mm:ss";
                    break;
                }
                case 5: {
                    pattern = "HH:mm";
                    break;
                }
            }
            if (pattern == null) {
                return null;
            }
            return DateUtils.parseLocalDate(source, zoneId, pattern);
        }
        return null;
    }

    public static LocalDate parseLocalDate(@NonNull String source, String ... pattern) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        return DateUtils.parseLocalDate(source, null, pattern);
    }

    public static LocalDate parseLocalDate(@NonNull String source) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        return DateUtils.parseLocalDate(source, (ZoneId)null);
    }

    public static LocalTime parseLocalTime(long timeStamp, ZoneId zoneId) {
        ZonedDateTime zonedDateTime = Instant.ofEpochMilli(timeStamp).atZone(SYSTEM_ZONE_ID);
        if (zoneId != null) {
            zonedDateTime = zonedDateTime.withZoneSameInstant(zoneId);
        }
        return zonedDateTime.toLocalTime();
    }

    public static LocalTime parseLocalTime(long timeStamp) {
        return DateUtils.parseLocalTime(timeStamp, null);
    }

    public static LocalTime parseLocalTime(@NonNull String source, ZoneId zoneId, String ... patterns) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (patterns == null) {
            throw new NullPointerException("patterns is marked non-null but is null");
        }
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{source})) {
            return null;
        }
        int n = 0;
        String[] stringArray = patterns;
        int n2 = stringArray.length;
        if (n < n2) {
            String pattern = stringArray[n];
            source = DateUtils.convertByPattern(source, pattern);
            LocalTime localTime = LocalTime.parse(source, DateUtils.getDefaultFormatter(pattern));
            if (zoneId != null) {
                return localTime.atDate(LocalDate.now()).atZone(SYSTEM_ZONE_ID).withZoneSameInstant(zoneId).toLocalTime();
            }
            return localTime;
        }
        return null;
    }

    public static LocalTime parseLocalTime(@NonNull String source, ZoneId zoneId) {
        int srcLen;
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        String pattern = null;
        if (source.contains(":") && ((srcLen = source.length()) == 8 || srcLen == 5)) {
            switch (srcLen) {
                case 8: {
                    pattern = "HH:mm:ss";
                    break;
                }
                case 5: {
                    pattern = "HH:mm";
                    break;
                }
            }
            return DateUtils.parseLocalTime(source, zoneId, pattern);
        }
        return null;
    }

    public static LocalTime parseLocalTime(@NonNull String source, String ... patterns) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (patterns == null) {
            throw new NullPointerException("patterns is marked non-null but is null");
        }
        return DateUtils.parseLocalTime(source, null, patterns);
    }

    public static LocalTime parseLocalTime(@NonNull String source) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        return DateUtils.parseLocalTime(source, (ZoneId)null);
    }

    public static Date parseDate(long timeStamp, ZoneId zoneId) {
        Date date = new Date(timeStamp);
        if (zoneId != null) {
            date = Date.from(date.toInstant().atZone(SYSTEM_ZONE_ID).withZoneSameInstant(zoneId).toInstant());
        }
        return date;
    }

    public static Date parseDate(long timeStamp) {
        return DateUtils.parseDate(timeStamp, null);
    }

    public static Date parseDate(@NonNull String source, ZoneId zoneId, String ... patterns) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (patterns == null) {
            throw new NullPointerException("patterns is marked non-null but is null");
        }
        LocalDateTime localDateTime = DateUtils.parseLocalDateTime(source, zoneId, patterns);
        if (localDateTime != null) {
            return DateUtils.toDate(localDateTime);
        }
        return null;
    }

    public static Date parseDate(@NonNull String source, @NonNull ZoneId zoneId) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (zoneId == null) {
            throw new NullPointerException("zoneId is marked non-null but is null");
        }
        LocalDateTime localDateTime = DateUtils.parseLocalDateTime(source, zoneId);
        if (localDateTime != null) {
            return DateUtils.toDate(localDateTime);
        }
        return null;
    }

    public static Date parseDate(@NonNull String source, String ... patterns) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (patterns == null) {
            throw new NullPointerException("patterns is marked non-null but is null");
        }
        if (StringUtils.isAllBlank((CharSequence[])patterns)) {
            throw new IllegalArgumentException("Patterns: should not be all blank");
        }
        try {
            return org.apache.commons.lang3.time.DateUtils.parseDate((String)source, (String[])patterns);
        }
        catch (ParseException e) {
            log.warn(e.getMessage());
            return null;
        }
    }

    public static Date parseDate(@NonNull String source) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        LocalDateTime localDateTime = DateUtils.parseLocalDateTime(source);
        if (localDateTime != null) {
            return DateUtils.toDate(localDateTime);
        }
        return null;
    }

    public static <T> T parse(long timeStamp, ZoneId zoneId, @NonNull Class<T> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        if (LocalDateTime.class.equals(clazz)) {
            return (T)DateUtils.parseLocalDateTime(timeStamp, zoneId);
        }
        if (LocalDate.class.equals(clazz)) {
            return (T)DateUtils.parseLocalDate(timeStamp, zoneId);
        }
        if (LocalTime.class.equals(clazz)) {
            return (T)DateUtils.parseLocalTime(timeStamp, zoneId);
        }
        if (Date.class.equals(clazz)) {
            return (T)DateUtils.parseDate(timeStamp, zoneId);
        }
        return null;
    }

    public static <T> T parse(long timeStamp, @NonNull Class<T> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        return DateUtils.parse(timeStamp, null, clazz);
    }

    public static <T> T parse(@NonNull String source, ZoneId zoneId, @NonNull Class<T> clazz, String ... patterns) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        if (patterns == null) {
            throw new NullPointerException("patterns is marked non-null but is null");
        }
        if (LocalDateTime.class.equals(clazz)) {
            return (T)DateUtils.parseLocalDateTime(source, zoneId, patterns);
        }
        if (LocalDate.class.equals(clazz)) {
            return (T)DateUtils.parseLocalDate(source, zoneId, patterns);
        }
        if (LocalTime.class.equals(clazz)) {
            return (T)DateUtils.parseLocalTime(source, zoneId, patterns);
        }
        if (Date.class.equals(clazz)) {
            return (T)DateUtils.parseDate(source, zoneId, patterns);
        }
        return null;
    }

    public static <T> T parse(@NonNull String source, @NonNull ZoneId zoneId, @NonNull Class<T> clazz) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (zoneId == null) {
            throw new NullPointerException("zoneId is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        if (LocalDateTime.class.equals(clazz)) {
            return (T)DateUtils.parseLocalDateTime(source, zoneId);
        }
        if (LocalDate.class.equals(clazz)) {
            return (T)DateUtils.parseLocalDate(source, zoneId);
        }
        if (LocalTime.class.equals(clazz)) {
            return (T)DateUtils.parseLocalTime(source, zoneId);
        }
        if (Date.class.equals(clazz)) {
            return (T)DateUtils.parseDate(source, zoneId);
        }
        return null;
    }

    public static <T> T parse(@NonNull String source, @NonNull Class<T> clazz, String ... patterns) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        if (patterns == null) {
            throw new NullPointerException("patterns is marked non-null but is null");
        }
        return DateUtils.parse(source, null, clazz, patterns);
    }

    public static <T> T parse(@NonNull String source, @NonNull Class<T> clazz) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        if (LocalDateTime.class.equals(clazz)) {
            return (T)DateUtils.parseLocalDateTime(source);
        }
        if (LocalDate.class.equals(clazz)) {
            return (T)DateUtils.parseLocalDate(source);
        }
        if (LocalTime.class.equals(clazz)) {
            return (T)DateUtils.parseLocalTime(source);
        }
        if (Date.class.equals(clazz)) {
            return (T)DateUtils.parseDate(source);
        }
        return null;
    }

    public static <T extends Temporal> T withZoneInstant(@NonNull T temporal, @NonNull ZoneId oldZoneId, @NonNull ZoneId newZoneId) {
        if (temporal == null) {
            throw new NullPointerException("temporal is marked non-null but is null");
        }
        if (oldZoneId == null) {
            throw new NullPointerException("oldZoneId is marked non-null but is null");
        }
        if (newZoneId == null) {
            throw new NullPointerException("newZoneId is marked non-null but is null");
        }
        if (temporal instanceof LocalDateTime) {
            return (T)((LocalDateTime)temporal).atZone(oldZoneId).withZoneSameInstant(newZoneId).toLocalDateTime();
        }
        if (temporal instanceof LocalDate) {
            return (T)((LocalDate)temporal).atStartOfDay().atZone(oldZoneId).withZoneSameInstant(newZoneId).toLocalDate();
        }
        if (temporal instanceof LocalTime) {
            return (T)((LocalTime)temporal).atDate(LocalDate.of(0, 1, 1)).atZone(oldZoneId).withZoneSameInstant(newZoneId).toLocalTime();
        }
        return null;
    }

    public static <T extends Temporal> T withZoneInstant(@NonNull T temporal, @NonNull ZoneId newZoneId) {
        if (temporal == null) {
            throw new NullPointerException("temporal is marked non-null but is null");
        }
        if (newZoneId == null) {
            throw new NullPointerException("newZoneId is marked non-null but is null");
        }
        return DateUtils.withZoneInstant(temporal, SYSTEM_ZONE_ID, newZoneId);
    }

    public static Date withZoneInstant(@NonNull Date date, @NonNull ZoneId oldZoneId, @NonNull ZoneId newZoneId) {
        if (date == null) {
            throw new NullPointerException("date is marked non-null but is null");
        }
        if (oldZoneId == null) {
            throw new NullPointerException("oldZoneId is marked non-null but is null");
        }
        if (newZoneId == null) {
            throw new NullPointerException("newZoneId is marked non-null but is null");
        }
        LocalDateTime localDateTime = DateUtils.withZoneInstant(LocalDateTime.ofInstant(date.toInstant(), SYSTEM_ZONE_ID), oldZoneId, newZoneId);
        if (localDateTime == null) {
            return null;
        }
        return DateUtils.toDate(localDateTime);
    }

    public static Date withZoneInstant(@NonNull Date date, @NonNull ZoneId newZoneId) {
        if (date == null) {
            throw new NullPointerException("date is marked non-null but is null");
        }
        if (newZoneId == null) {
            throw new NullPointerException("newZoneId is marked non-null but is null");
        }
        return DateUtils.withZoneInstant(date, SYSTEM_ZONE_ID, newZoneId);
    }

    public static String today() {
        return DatePattern.FORMAT_YYYY_MM_DD.format(new Date());
    }

    public static String now() {
        return DatePattern.FORMAT_YYYY_MM_DD_HH_MM_SS.format(new Date());
    }

    public static String now(@NonNull String pattern) {
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        return FastDateFormat.getInstance((String)pattern).format(new Date());
    }

    public static String now(@NonNull ZoneId zoneId) {
        if (zoneId == null) {
            throw new NullPointerException("zoneId is marked non-null but is null");
        }
        return DateTimeFormatter.ofPattern(defaultLocalDateTimePattern).format(ZonedDateTime.now(zoneId));
    }

    public static String now(@NonNull ZoneId zoneId, @NonNull String pattern) {
        if (zoneId == null) {
            throw new NullPointerException("zoneId is marked non-null but is null");
        }
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        return DateTimeFormatter.ofPattern(pattern).format(ZonedDateTime.now(zoneId));
    }

    public static <T extends Temporal> T min(@NonNull Temporal temporal, TemporalField ... temporalFields) {
        if (temporal == null) {
            throw new NullPointerException("temporal is marked non-null but is null");
        }
        if (temporalFields == null) {
            throw new NullPointerException("temporalFields is marked non-null but is null");
        }
        if (CollectionUtils.isAllEmpty(temporalFields)) {
            return null;
        }
        for (TemporalField temporalField : temporalFields) {
            temporal = temporal.with(temporalField, temporalField.range().getMinimum());
        }
        return (T)temporal;
    }

    public static <T extends Temporal> T max(@NonNull Temporal temporal, TemporalField ... temporalFields) {
        if (temporal == null) {
            throw new NullPointerException("temporal is marked non-null but is null");
        }
        if (temporalFields == null) {
            throw new NullPointerException("temporalFields is marked non-null but is null");
        }
        if (CollectionUtils.isAllEmpty(temporalFields)) {
            return null;
        }
        for (TemporalField temporalField : temporalFields) {
            if (ChronoField.DAY_OF_MONTH.equals(temporalField)) {
                temporal = temporal.with(TemporalAdjusters.lastDayOfMonth());
                continue;
            }
            if (ChronoField.DAY_OF_YEAR.equals(temporalField)) {
                temporal = temporal.with(TemporalAdjusters.lastDayOfYear());
                continue;
            }
            ValueRange valueRange = temporalField.range();
            long newValue = valueRange.getMaximum();
            temporal = temporal.with(temporalField, newValue);
        }
        return (T)temporal;
    }

    public static Date minDate(@NonNull Temporal temporal, TemporalField ... temporalFields) {
        if (temporal == null) {
            throw new NullPointerException("temporal is marked non-null but is null");
        }
        if (temporalFields == null) {
            throw new NullPointerException("temporalFields is marked non-null but is null");
        }
        Object temporal1 = DateUtils.min(temporal, temporalFields);
        if (temporal1 == null) {
            return null;
        }
        return DateUtils.toDate(temporal1);
    }

    public static Date maxDate(@NonNull Temporal temporal, TemporalField ... temporalFields) {
        if (temporal == null) {
            throw new NullPointerException("temporal is marked non-null but is null");
        }
        if (temporalFields == null) {
            throw new NullPointerException("temporalFields is marked non-null but is null");
        }
        Object temporal1 = DateUtils.max(temporal, temporalFields);
        if (temporal1 == null) {
            return null;
        }
        return DateUtils.toDate(temporal1);
    }

    public static LocalDateTime todayMinTime(ZoneId zoneId, Long addOrSubtractDays) {
        LocalDateTime localDateTime = DateUtils.todayMinTime();
        if (addOrSubtractDays != null && addOrSubtractDays != 0L) {
            localDateTime = DateUtils.plusOrMinus(localDateTime, addOrSubtractDays, ChronoUnit.DAYS);
        }
        if (zoneId != null) {
            return localDateTime.atZone(SYSTEM_ZONE_ID).withZoneSameInstant(zoneId).toLocalDateTime();
        }
        return localDateTime;
    }

    public static LocalDateTime todayMinTime(@NonNull ZoneId zoneId) {
        if (zoneId == null) {
            throw new NullPointerException("zoneId is marked non-null but is null");
        }
        return DateUtils.todayMinTime(zoneId, null);
    }

    public static LocalDateTime todayMinTime(long days) {
        return DateUtils.todayMinTime(null, days);
    }

    public static LocalDateTime todayMinTime() {
        return LocalDate.now().atStartOfDay();
    }

    public static String todayMinTimeStr(ZoneId zoneId, @NonNull String pattern, Long addOrSubtractDays) {
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        return DateUtils.format((Temporal)DateUtils.todayMinTime(zoneId, addOrSubtractDays), pattern);
    }

    public static String todayMinTimeStr(@NonNull ZoneId zoneId, @NonNull String pattern) {
        if (zoneId == null) {
            throw new NullPointerException("zoneId is marked non-null but is null");
        }
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        return DateUtils.todayMinTimeStr(zoneId, pattern, null);
    }

    public static String todayMinTimeStr(@NonNull String pattern) {
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        return DateUtils.todayMinTimeStr(null, pattern, null);
    }

    public static String todayMinTimeStr() {
        return DateUtils.todayMinTimeStr(defaultLocalDateTimePattern);
    }

    public static LocalDateTime todayMaxTime(ZoneId zoneId, Long addOrSubtractDays) {
        LocalDateTime localDateTime = DateUtils.todayMaxTime();
        if (addOrSubtractDays != null && addOrSubtractDays != 0L) {
            localDateTime = DateUtils.plusOrMinus(localDateTime, addOrSubtractDays, ChronoUnit.DAYS);
        }
        if (zoneId != null) {
            return localDateTime.atZone(SYSTEM_ZONE_ID).withZoneSameInstant(zoneId).toLocalDateTime();
        }
        return localDateTime;
    }

    public static LocalDateTime todayMaxTime(@NonNull ZoneId zoneId) {
        if (zoneId == null) {
            throw new NullPointerException("zoneId is marked non-null but is null");
        }
        return DateUtils.todayMaxTime(zoneId, null);
    }

    public static LocalDateTime todayMaxTime(long days) {
        return DateUtils.todayMaxTime(null, days);
    }

    public static LocalDateTime todayMaxTime() {
        return LocalDate.now().atTime(LocalTime.MAX);
    }

    public static String todayMaxTimeStr(ZoneId zoneId, @NonNull String pattern, Long addOrSubtractDays) {
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        return DateUtils.format((Temporal)DateUtils.todayMaxTime(zoneId, addOrSubtractDays), pattern);
    }

    public static String todayMaxTimeStr(@NonNull ZoneId zoneId, @NonNull String pattern) {
        if (zoneId == null) {
            throw new NullPointerException("zoneId is marked non-null but is null");
        }
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        return DateUtils.todayMaxTimeStr(zoneId, pattern, null);
    }

    public static String todayMaxTimeStr(@NonNull String pattern) {
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        return DateUtils.todayMaxTimeStr(null, pattern, null);
    }

    public static String todayMaxTimeStr() {
        return DateUtils.todayMaxTimeStr(defaultLocalDateTimePattern);
    }

    public static <T extends Temporal> T plusOrMinus(@NonNull T temporal, long augendOrMinuend, ChronoUnit ... chronoUnits) {
        if (temporal == null) {
            throw new NullPointerException("temporal is marked non-null but is null");
        }
        if (chronoUnits == null) {
            throw new NullPointerException("chronoUnits is marked non-null but is null");
        }
        for (ChronoUnit chronoUnit : chronoUnits) {
            if (augendOrMinuend < 0L) {
                temporal = temporal.minus(Math.abs(augendOrMinuend), chronoUnit);
                continue;
            }
            if (augendOrMinuend <= 0L) continue;
            temporal = temporal.plus(augendOrMinuend, chronoUnit);
        }
        return temporal;
    }

    public static <T extends Temporal> T plusOrMinus(@NonNull T temporal, long augendOrMinuend) {
        if (temporal == null) {
            throw new NullPointerException("temporal is marked non-null but is null");
        }
        return DateUtils.plusOrMinus(temporal, augendOrMinuend, ChronoUnit.MILLIS);
    }

    public static long toChronoUnit(long milli, @NonNull ChronoUnit chronoUnit) {
        if (chronoUnit == null) {
            throw new NullPointerException("chronoUnit is marked non-null but is null");
        }
        if (ChronoUnit.MILLIS.equals(chronoUnit)) {
            return milli;
        }
        return milli / (chronoUnit.getDuration().getSeconds() * 1000L);
    }

    public static Duration between(@NonNull Temporal startInclusive, @NonNull Temporal endExclusive) {
        if (startInclusive == null) {
            throw new NullPointerException("startInclusive is marked non-null but is null");
        }
        if (endExclusive == null) {
            throw new NullPointerException("endExclusive is marked non-null but is null");
        }
        return Duration.between(startInclusive, endExclusive);
    }

    public static long between(@NonNull Temporal startInclusive, @NonNull Temporal endExclusive, @NonNull ChronoUnit chronoUnit) {
        if (startInclusive == null) {
            throw new NullPointerException("startInclusive is marked non-null but is null");
        }
        if (endExclusive == null) {
            throw new NullPointerException("endExclusive is marked non-null but is null");
        }
        if (chronoUnit == null) {
            throw new NullPointerException("chronoUnit is marked non-null but is null");
        }
        return chronoUnit.between(startInclusive, endExclusive);
    }

    public static Duration between(@NonNull Date startInclusive, @NonNull Date endExclusive) {
        if (startInclusive == null) {
            throw new NullPointerException("startInclusive is marked non-null but is null");
        }
        if (endExclusive == null) {
            throw new NullPointerException("endExclusive is marked non-null but is null");
        }
        return DateUtils.between(DateUtils.toLocalDateTime(startInclusive), DateUtils.toLocalDateTime(endExclusive));
    }

    public static long between(@NonNull Date startInclusive, @NonNull Date endExclusive, @NonNull ChronoUnit chronoUnit) {
        if (startInclusive == null) {
            throw new NullPointerException("startInclusive is marked non-null but is null");
        }
        if (endExclusive == null) {
            throw new NullPointerException("endExclusive is marked non-null but is null");
        }
        if (chronoUnit == null) {
            throw new NullPointerException("chronoUnit is marked non-null but is null");
        }
        return DateUtils.toChronoUnit(startInclusive.getTime() - endExclusive.getTime(), chronoUnit);
    }

    public static String formatBetween(@NonNull Temporal startInclusive, @NonNull Temporal endExclusive, @NonNull String pattern) {
        if (startInclusive == null) {
            throw new NullPointerException("startInclusive is marked non-null but is null");
        }
        if (endExclusive == null) {
            throw new NullPointerException("endExclusive is marked non-null but is null");
        }
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        return DateUtils.formatCountdown(Math.abs(DateUtils.between(startInclusive, endExclusive, ChronoUnit.MILLIS)), pattern);
    }

    public static String formatBetween(@NonNull Date startInclusive, @NonNull Date endExclusive, @NonNull String pattern) {
        if (startInclusive == null) {
            throw new NullPointerException("startInclusive is marked non-null but is null");
        }
        if (endExclusive == null) {
            throw new NullPointerException("endExclusive is marked non-null but is null");
        }
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        return DateUtils.formatCountdown(Math.abs(DateUtils.between(startInclusive, endExclusive, ChronoUnit.MILLIS)), pattern);
    }

    public static String formatBetween(@NonNull Date startInclusive, @NonNull Date endExclusive, boolean isIgnoreZero, String weekSuffix, String dayOfMonthSuffix, String hourSuffix, String minuteSuffix, String secondSuffix, String millisSuffix) {
        if (startInclusive == null) {
            throw new NullPointerException("startInclusive is marked non-null but is null");
        }
        if (endExclusive == null) {
            throw new NullPointerException("endExclusive is marked non-null but is null");
        }
        return DateUtils.formatCountdown(Math.abs(DateUtils.between(startInclusive, endExclusive, ChronoUnit.MILLIS)), isIgnoreZero, weekSuffix, dayOfMonthSuffix, hourSuffix, minuteSuffix, secondSuffix, millisSuffix);
    }

    public static boolean isLeapYear(@NonNull Temporal temporal) {
        if (temporal == null) {
            throw new NullPointerException("temporal is marked non-null but is null");
        }
        if (temporal instanceof LocalDateTime) {
            return ((LocalDateTime)temporal).toLocalDate().isLeapYear();
        }
        if (temporal instanceof LocalDate) {
            return ((LocalDate)temporal).isLeapYear();
        }
        if (temporal instanceof ZonedDateTime) {
            return ((ZonedDateTime)temporal).toLocalDate().isLeapYear();
        }
        throw new IllegalArgumentException("Temporal: should be ZonedDateTime, LocalDateTime, LocalDate, or LocalTime");
    }

    public static boolean isLeapYear(@NonNull Date date) {
        if (date == null) {
            throw new NullPointerException("date is marked non-null but is null");
        }
        return DateUtils.toLocalDate(date).isLeapYear();
    }

    public static boolean isLeapYear(@NonNull int isoYear) {
        return Year.of(isoYear).isLeap();
    }

    public static boolean isIntersection(@NonNull LocalDateTime x1, @NonNull LocalDateTime y1, @NonNull LocalDateTime x2, @NonNull LocalDateTime y2) {
        if (x1 == null) {
            throw new NullPointerException("x1 is marked non-null but is null");
        }
        if (y1 == null) {
            throw new NullPointerException("y1 is marked non-null but is null");
        }
        if (x2 == null) {
            throw new NullPointerException("x2 is marked non-null but is null");
        }
        if (y2 == null) {
            throw new NullPointerException("y2 is marked non-null but is null");
        }
        return !y1.isBefore(x2) && !y2.isBefore(x1);
    }

    public static LocalDateTime[] getIntersection(@NonNull LocalDateTime x1, @NonNull LocalDateTime y1, @NonNull LocalDateTime x2, @NonNull LocalDateTime y2) {
        if (x1 == null) {
            throw new NullPointerException("x1 is marked non-null but is null");
        }
        if (y1 == null) {
            throw new NullPointerException("y1 is marked non-null but is null");
        }
        if (x2 == null) {
            throw new NullPointerException("x2 is marked non-null but is null");
        }
        if (y2 == null) {
            throw new NullPointerException("y2 is marked non-null but is null");
        }
        if (!DateUtils.isIntersection(x1, y1, x2, y2)) {
            return null;
        }
        LocalDateTime[] result = new LocalDateTime[2];
        if (x1.isBefore(x2) || x1.isEqual(x2)) {
            result[0] = x2;
        } else if (x1.isAfter(x2) || x1.isEqual(x2)) {
            result[0] = x1;
        }
        if (y1.isBefore(y2) || y1.isEqual(y2)) {
            result[1] = y1;
        } else if (y1.isAfter(y2) || y1.isEqual(y2)) {
            result[1] = y2;
        }
        if (result[0] == null || result[1] == null) {
            return null;
        }
        return result;
    }

    public static LocalDateTime[][] getDifferenceSetsByIntersection(@NonNull LocalDateTime x1, @NonNull LocalDateTime y1, @NonNull LocalDateTime x2, @NonNull LocalDateTime y2, int augendOrMinuendType, long augendOrMinuend, ChronoUnit ... chronoUnits) {
        if (x1 == null) {
            throw new NullPointerException("x1 is marked non-null but is null");
        }
        if (y1 == null) {
            throw new NullPointerException("y1 is marked non-null but is null");
        }
        if (x2 == null) {
            throw new NullPointerException("x2 is marked non-null but is null");
        }
        if (y2 == null) {
            throw new NullPointerException("y2 is marked non-null but is null");
        }
        if (chronoUnits == null) {
            throw new NullPointerException("chronoUnits is marked non-null but is null");
        }
        LocalDateTime[] intersections = DateUtils.getIntersection(x1, y1, x2, y2);
        if (intersections == null) {
            return null;
        }
        LocalDateTime[][] result = new LocalDateTime[2][2];
        if (x1.isBefore(x2)) {
            result[0] = new LocalDateTime[]{x1, x2};
        } else if (x1.isAfter(x2)) {
            result[0] = new LocalDateTime[]{x2, x1};
        }
        if (y1.isBefore(y2)) {
            result[1] = new LocalDateTime[]{y1, y2};
        } else if (y1.isAfter(y2)) {
            result[1] = new LocalDateTime[]{y2, y1};
        }
        if (augendOrMinuend > 0L && CollectionUtils.sizeIsNotEmpty(chronoUnits)) {
            boolean isPlusOrMinus = augendOrMinuendType != 1 && augendOrMinuendType != 2;
            for (LocalDateTime[] localDateTimes : result) {
                if (localDateTimes[1].equals(intersections[0])) {
                    if (isPlusOrMinus) {
                        localDateTimes[1] = DateUtils.plusOrMinus(localDateTimes[1], -augendOrMinuend, chronoUnits);
                        break;
                    }
                    if (augendOrMinuendType == 1) {
                        result[0][1] = DateUtils.plusOrMinus(result[0][1], -augendOrMinuend, chronoUnits);
                        break;
                    }
                    result[1][0] = DateUtils.plusOrMinus(result[1][0], augendOrMinuend, chronoUnits);
                    break;
                }
                if (!localDateTimes[0].equals(intersections[1])) continue;
                if (isPlusOrMinus) {
                    localDateTimes[0] = DateUtils.plusOrMinus(localDateTimes[0], augendOrMinuend, chronoUnits);
                    break;
                }
                if (augendOrMinuendType == 1) {
                    result[0][1] = DateUtils.plusOrMinus(result[0][1], -augendOrMinuend, chronoUnits);
                    break;
                }
                result[1][0] = DateUtils.plusOrMinus(result[1][0], augendOrMinuend, chronoUnits);
                break;
            }
        }
        return result;
    }

    public static LocalDateTime[][] getDifferenceSetsByIntersection(@NonNull LocalDateTime x1, @NonNull LocalDateTime y1, @NonNull LocalDateTime x2, @NonNull LocalDateTime y2, long augendOrMinuend, ChronoUnit ... chronoUnits) {
        if (x1 == null) {
            throw new NullPointerException("x1 is marked non-null but is null");
        }
        if (y1 == null) {
            throw new NullPointerException("y1 is marked non-null but is null");
        }
        if (x2 == null) {
            throw new NullPointerException("x2 is marked non-null but is null");
        }
        if (y2 == null) {
            throw new NullPointerException("y2 is marked non-null but is null");
        }
        if (chronoUnits == null) {
            throw new NullPointerException("chronoUnits is marked non-null but is null");
        }
        return DateUtils.getDifferenceSetsByIntersection(x1, y1, x2, y2, 0, augendOrMinuend, chronoUnits);
    }

    public static LocalDateTime[][] getDifferenceSetsByIntersection(@NonNull LocalDateTime x1, @NonNull LocalDateTime y1, @NonNull LocalDateTime x2, @NonNull LocalDateTime y2) {
        if (x1 == null) {
            throw new NullPointerException("x1 is marked non-null but is null");
        }
        if (y1 == null) {
            throw new NullPointerException("y1 is marked non-null but is null");
        }
        if (x2 == null) {
            throw new NullPointerException("x2 is marked non-null but is null");
        }
        if (y2 == null) {
            throw new NullPointerException("y2 is marked non-null but is null");
        }
        return DateUtils.getDifferenceSetsByIntersection(x1, y1, x2, y2, 1L, ChronoUnit.MILLIS);
    }

    public static String[] convertWeeks(@NonNull String weeks, @NonNull String splitRegex) {
        if (weeks == null) {
            throw new NullPointerException("weeks is marked non-null but is null");
        }
        if (splitRegex == null) {
            throw new NullPointerException("splitRegex is marked non-null but is null");
        }
        if (RegExUtils.isMatch("[^,1-7]*", weeks)) {
            weeks = weeks.replaceAll("[^,1-7]*", "");
        }
        if (StringUtils.isBlank((CharSequence)weeks)) {
            return new String[0];
        }
        return weeks.split(splitRegex);
    }

    public static String[] convertWeeks(@NonNull String weeks) {
        if (weeks == null) {
            throw new NullPointerException("weeks is marked non-null but is null");
        }
        String regex = ",";
        if (!weeks.contains(regex)) {
            regex = "";
        }
        return DateUtils.convertWeeks(weeks, regex);
    }

    public static List<LocalDateTime> getByWeeks(@NonNull String weeks, LocalDateTime ... times) {
        if (weeks == null) {
            throw new NullPointerException("weeks is marked non-null but is null");
        }
        if (times == null) {
            throw new NullPointerException("times is marked non-null but is null");
        }
        if (CollectionUtils.isAllEmpty(times)) {
            return null;
        }
        ArrayList<LocalDateTime> timeList = null;
        if (!CollectionUtils.sizeIsEmpty(times)) {
            List<String> weekList = Arrays.asList(DateUtils.convertWeeks(weeks));
            timeList = new ArrayList<LocalDateTime>(Arrays.asList(times));
            timeList.removeIf(time -> !weekList.contains(String.valueOf(time.getDayOfWeek().getValue())));
        }
        return timeList;
    }

    public static List<String> getByRange(@NonNull LocalDateTime startTime, @NonNull LocalDateTime endTime, @NonNull String pattern) {
        if (startTime == null) {
            throw new NullPointerException("startTime is marked non-null but is null");
        }
        if (endTime == null) {
            throw new NullPointerException("endTime is marked non-null but is null");
        }
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        if (StringUtils.isBlank((CharSequence)pattern)) {
            throw new IllegalArgumentException("Pattern: should not be blank");
        }
        ArrayList<String> result = new ArrayList<String>();
        long distance = ChronoUnit.DAYS.between(startTime, endTime);
        if (distance >= 1L) {
            Stream.iterate(startTime, day -> day.plusDays(1L)).limit(distance + 1L).forEach(f -> result.add(DateUtils.format((Temporal)f, pattern)));
        }
        return result;
    }

    public static List<String> getByRangeAndWeeks(@NonNull LocalDateTime startTime, @NonNull LocalDateTime endTime, @NonNull String weeks, @NonNull String pattern) {
        if (startTime == null) {
            throw new NullPointerException("startTime is marked non-null but is null");
        }
        if (endTime == null) {
            throw new NullPointerException("endTime is marked non-null but is null");
        }
        if (weeks == null) {
            throw new NullPointerException("weeks is marked non-null but is null");
        }
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        if (StringUtils.isBlank((CharSequence)pattern)) {
            throw new IllegalArgumentException("Pattern: should not be blank");
        }
        ArrayList<String> result = new ArrayList<String>();
        TemporalField field = WeekFields.of(DayOfWeek.of(1), 1).dayOfWeek();
        for (String week : DateUtils.convertWeeks(weeks)) {
            LocalDateTime dayByWeek = startTime.with(field, Long.parseLong(week));
            if (dayByWeek.isBefore(startTime)) {
                dayByWeek = dayByWeek.plusWeeks(1L);
            }
            while (dayByWeek.isBefore(endTime) || dayByWeek.isEqual(endTime)) {
                result.add(DateUtils.format((Temporal)dayByWeek, pattern));
                dayByWeek = dayByWeek.plusWeeks(1L);
            }
        }
        return result;
    }

    public static List<LocalDateTime> getByRangeAndWeeks(@NonNull LocalDateTime startTime, @NonNull LocalDateTime endTime, @NonNull String weeks) {
        if (startTime == null) {
            throw new NullPointerException("startTime is marked non-null but is null");
        }
        if (endTime == null) {
            throw new NullPointerException("endTime is marked non-null but is null");
        }
        if (weeks == null) {
            throw new NullPointerException("weeks is marked non-null but is null");
        }
        ArrayList<LocalDateTime> result = new ArrayList<LocalDateTime>();
        TemporalField field = WeekFields.of(DayOfWeek.of(1), 1).dayOfWeek();
        for (String week : DateUtils.convertWeeks(weeks)) {
            LocalDateTime tempDay = startTime.with(field, Long.parseLong(week));
            if (tempDay.isBefore(startTime)) {
                tempDay = tempDay.plusWeeks(1L);
            }
            while (tempDay.isBefore(endTime) || tempDay.isEqual(endTime)) {
                result.add(tempDay);
                tempDay = tempDay.plusWeeks(1L);
            }
        }
        return result;
    }
}

