/*
 * Decompiled with CFR 0.152.
 */
package top.zhogjianhao;

import lombok.NonNull;

public class StringUtils
extends org.apache.commons.lang3.StringUtils {
    private static final String FORMAT_REPLACE_STR = "{}";

    public static String removeStartIgnoreCase(@NonNull String str, @NonNull String remove) {
        if (str == null) {
            throw new NullPointerException("str is marked non-null but is null");
        }
        if (remove == null) {
            throw new NullPointerException("remove is marked non-null but is null");
        }
        if (StringUtils.isBlank((CharSequence)str)) {
            throw new IllegalArgumentException("Str: should not be blank");
        }
        if (StringUtils.isBlank((CharSequence)remove)) {
            throw new IllegalArgumentException("Remove: should not be blank");
        }
        if (str.toLowerCase().startsWith(remove.toLowerCase())) {
            return StringUtils.substring((String)str, (int)remove.length());
        }
        return str;
    }

    public static String removeEndIgnoreCase(@NonNull String str, @NonNull String remove) {
        if (str == null) {
            throw new NullPointerException("str is marked non-null but is null");
        }
        if (remove == null) {
            throw new NullPointerException("remove is marked non-null but is null");
        }
        if (StringUtils.isBlank((CharSequence)str)) {
            throw new IllegalArgumentException("Str: should not be blank");
        }
        if (StringUtils.isBlank((CharSequence)remove)) {
            throw new IllegalArgumentException("Remove: should not be blank");
        }
        if (str.toLowerCase().endsWith(remove.toLowerCase())) {
            return StringUtils.substring((String)str, (int)0, (int)(str.length() - remove.length()));
        }
        return str;
    }

    public static String format(@NonNull String str, String ... vals) {
        int index;
        if (str == null) {
            throw new NullPointerException("str is marked non-null but is null");
        }
        if (vals == null) {
            throw new NullPointerException("vals is marked non-null but is null");
        }
        if (StringUtils.isBlank((CharSequence)str)) {
            throw new IllegalArgumentException("Str: should not be blank");
        }
        if (StringUtils.isAllBlank((CharSequence[])vals)) {
            throw new IllegalArgumentException("Vals: should not be all blank");
        }
        StringBuilder result = new StringBuilder();
        int i = 0;
        int fromIndex = 0;
        while ((index = str.indexOf(FORMAT_REPLACE_STR, fromIndex)) != -1) {
            String val = vals[i];
            result.append(StringUtils.substring((String)str, (int)fromIndex, (int)index)).append(val);
            fromIndex = index + 2;
            ++i;
        }
        return result.toString();
    }

    public static String toUnderscore(@NonNull String source) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (StringUtils.isBlank((CharSequence)source)) {
            return null;
        }
        StringBuilder sb = new StringBuilder(source);
        int temp = 0;
        if (!source.contains(" ")) {
            for (int i = 0; i < source.length(); ++i) {
                if (!Character.isUpperCase(source.charAt(i)) || source.startsWith(String.valueOf(source.charAt(i)))) continue;
                sb.insert(i + temp, "_");
                ++temp;
            }
        }
        return sb.toString().toLowerCase();
    }

    public static String nCopies(@NonNull String source, long n) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (StringUtils.isBlank((CharSequence)source) || n < 1L) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while ((long)i < n) {
            sb.append(source);
            ++i;
        }
        return sb.toString();
    }
}

