/*
 * Decompiled with CFR 0.152.
 */
package top.zhogjianhao;

import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import top.zhogjianhao.JsonUtils;

public class XmlUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(XmlUtils.class);

    protected static Document commonRead(SAXReader saxReader, Object arg1, Object arg2) {
        if (saxReader == null) {
            saxReader = new SAXReader();
        }
        try {
            if (arg1 instanceof URL) {
                return saxReader.read((URL)arg1);
            }
            if (arg1 instanceof File) {
                return saxReader.read((File)arg1);
            }
            if (arg1 instanceof Reader) {
                if (arg2 instanceof String) {
                    return saxReader.read((Reader)arg1, (String)arg2);
                }
                return saxReader.read((Reader)arg1);
            }
            if (arg1 instanceof InputSource) {
                return saxReader.read((InputSource)arg1);
            }
            if (arg1 instanceof InputStream) {
                if (arg2 instanceof String) {
                    return saxReader.read((InputStream)arg1, (String)arg2);
                }
                return saxReader.read((InputStream)arg1);
            }
            if (arg1 instanceof String) {
                return saxReader.read((String)arg1);
            }
            throw new IllegalArgumentException("Arg1, Arg2: should be URL, File, Reader, InputSource, InputStream, String, Reader + String or InputStream + String");
        }
        catch (DocumentException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static Document read(SAXReader saxReader, @NonNull URL url) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        return XmlUtils.commonRead(saxReader, url, null);
    }

    public static Document read(SAXReader saxReader, @NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        return XmlUtils.commonRead(saxReader, file, null);
    }

    public static Document read(SAXReader saxReader, @NonNull Reader reader) {
        if (reader == null) {
            throw new NullPointerException("reader is marked non-null but is null");
        }
        return XmlUtils.commonRead(saxReader, reader, null);
    }

    public static Document read(SAXReader saxReader, @NonNull InputSource in) {
        if (in == null) {
            throw new NullPointerException("in is marked non-null but is null");
        }
        return XmlUtils.commonRead(saxReader, in, null);
    }

    public static Document read(SAXReader saxReader, @NonNull InputStream in) {
        if (in == null) {
            throw new NullPointerException("in is marked non-null but is null");
        }
        return XmlUtils.commonRead(saxReader, in, null);
    }

    public static Document read(SAXReader saxReader, @NonNull String systemId) {
        if (systemId == null) {
            throw new NullPointerException("systemId is marked non-null but is null");
        }
        return XmlUtils.commonRead(saxReader, systemId, null);
    }

    public static Document read(SAXReader saxReader, @NonNull Reader reader, @NonNull String systemId) {
        if (reader == null) {
            throw new NullPointerException("reader is marked non-null but is null");
        }
        if (systemId == null) {
            throw new NullPointerException("systemId is marked non-null but is null");
        }
        return XmlUtils.commonRead(saxReader, reader, systemId);
    }

    public static Document read(SAXReader saxReader, @NonNull InputStream in, @NonNull String systemId) {
        if (in == null) {
            throw new NullPointerException("in is marked non-null but is null");
        }
        if (systemId == null) {
            throw new NullPointerException("systemId is marked non-null but is null");
        }
        return XmlUtils.commonRead(saxReader, in, systemId);
    }

    public static Document read(@NonNull URL url) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        return XmlUtils.commonRead(null, url, null);
    }

    public static Document read(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        return XmlUtils.commonRead(null, file, null);
    }

    public static Document read(@NonNull Reader reader) {
        if (reader == null) {
            throw new NullPointerException("reader is marked non-null but is null");
        }
        return XmlUtils.commonRead(null, reader, null);
    }

    public static Document read(@NonNull InputSource in) {
        if (in == null) {
            throw new NullPointerException("in is marked non-null but is null");
        }
        return XmlUtils.commonRead(null, in, null);
    }

    public static Document read(@NonNull InputStream in) {
        if (in == null) {
            throw new NullPointerException("in is marked non-null but is null");
        }
        return XmlUtils.commonRead(null, in, null);
    }

    public static Document read(@NonNull String systemId) {
        if (systemId == null) {
            throw new NullPointerException("systemId is marked non-null but is null");
        }
        return XmlUtils.commonRead(null, systemId, null);
    }

    public static Document read(@NonNull Reader reader, @NonNull String systemId) {
        if (reader == null) {
            throw new NullPointerException("reader is marked non-null but is null");
        }
        if (systemId == null) {
            throw new NullPointerException("systemId is marked non-null but is null");
        }
        return XmlUtils.commonRead(null, reader, systemId);
    }

    public static Document read(@NonNull InputStream in, @NonNull String systemId) {
        if (in == null) {
            throw new NullPointerException("in is marked non-null but is null");
        }
        if (systemId == null) {
            throw new NullPointerException("systemId is marked non-null but is null");
        }
        return XmlUtils.commonRead(null, in, systemId);
    }

    public static Document parse(@NonNull String text) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        try {
            return DocumentHelper.parseText((String)text);
        }
        catch (DocumentException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static void toFile(@NonNull Document doc, @NonNull OutputFormat format, @NonNull File dir) {
        if (doc == null) {
            throw new NullPointerException("doc is marked non-null but is null");
        }
        if (format == null) {
            throw new NullPointerException("format is marked non-null but is null");
        }
        if (dir == null) {
            throw new NullPointerException("dir is marked non-null but is null");
        }
        try {
            XMLWriter writer = new XMLWriter((OutputStream)new FileOutputStream(dir), format);
            writer.write(doc);
            writer.close();
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void toFile(@NonNull Document doc, @NonNull OutputFormat format, @NonNull String dirPath) {
        if (doc == null) {
            throw new NullPointerException("doc is marked non-null but is null");
        }
        if (format == null) {
            throw new NullPointerException("format is marked non-null but is null");
        }
        if (dirPath == null) {
            throw new NullPointerException("dirPath is marked non-null but is null");
        }
        try {
            XMLWriter writer = new XMLWriter((OutputStream)new FileOutputStream(dirPath), format);
            writer.write(doc);
            writer.close();
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void toFile(@NonNull Document doc, @NonNull File dir) {
        if (doc == null) {
            throw new NullPointerException("doc is marked non-null but is null");
        }
        if (dir == null) {
            throw new NullPointerException("dir is marked non-null but is null");
        }
        try {
            XMLWriter writer = new XMLWriter((OutputStream)new FileOutputStream(dir));
            writer.write(doc);
            writer.close();
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void toFile(@NonNull Document doc, @NonNull String dirPath) {
        if (doc == null) {
            throw new NullPointerException("doc is marked non-null but is null");
        }
        if (dirPath == null) {
            throw new NullPointerException("dirPath is marked non-null but is null");
        }
        try {
            XMLWriter writer = new XMLWriter((OutputStream)new FileOutputStream(dirPath));
            writer.write(doc);
            writer.close();
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    protected static Object toJsonRecursion(@NonNull Element element, boolean isTrim) {
        if (element == null) {
            throw new NullPointerException("element is marked non-null but is null");
        }
        HashMap map = new HashMap();
        List elementList = element.elements();
        if (elementList.size() == 0) {
            return isTrim ? element.getTextTrim() : element.getText();
        }
        if (elementList.size() != 1) {
            if (!((Element)elementList.get(0)).getName().equals(((Element)elementList.get(1)).getName())) {
                HashMap<String, Object> map1 = new HashMap<String, Object>();
                for (Element element1 : elementList) {
                    map1.put(element1.getName(), XmlUtils.toJsonRecursion(element1, isTrim));
                }
                return map1;
            }
            ArrayList<Object> list = new ArrayList<Object>();
            for (Element element1 : elementList) {
                list.add(XmlUtils.toJsonRecursion(element1, isTrim));
            }
            return list;
        }
        HashMap<String, Object> map1 = new HashMap<String, Object>();
        Element element1 = (Element)element.elements().get(0);
        map1.put(element1.getName(), XmlUtils.toJsonRecursion(element1, isTrim));
        map.put(element.getName(), map1);
        return map;
    }

    public static String toJson(@NonNull Element element, boolean isTrim, SerializerFeature ... features) {
        Map.Entry entry;
        if (element == null) {
            throw new NullPointerException("element is marked non-null but is null");
        }
        Object object = XmlUtils.toJsonRecursion(element, isTrim);
        if (object instanceof Map && (entry = ((Map)object).entrySet().iterator().next()).getKey().equals(element.getName())) {
            return JsonUtils.toJson(entry.getValue(), features);
        }
        return JsonUtils.toJson(object, features);
    }

    public static <T> T parseObject(@NonNull Element element, boolean isTrim, @NonNull Class<T> clazz, Feature ... features) {
        if (element == null) {
            throw new NullPointerException("element is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        return JsonUtils.parseObject(XmlUtils.toJson(element, isTrim, new SerializerFeature[0]), clazz, features);
    }

    public static <T> List<T> parseArray(@NonNull Element element, boolean isTrim, @NonNull Class<T> clazz, ParserConfig parserConfig) {
        if (element == null) {
            throw new NullPointerException("element is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        return JsonUtils.parseArray(XmlUtils.toJson(element, isTrim, new SerializerFeature[0]), clazz, parserConfig);
    }

    public static <T> List<T> parseArray(@NonNull Element element, boolean isTrim, @NonNull Class<T> clazz) {
        if (element == null) {
            throw new NullPointerException("element is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        return JsonUtils.parseArray(XmlUtils.toJson(element, isTrim, new SerializerFeature[0]), clazz);
    }
}

