/*
 * Decompiled with CFR 0.152.
 */
package top.zhogjianhao;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.nio.charset.Charset;
import java.util.Arrays;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.zhogjianhao.StringUtils;
import top.zhogjianhao.charset.StandardCharsets;

public final class ArrayUtils
extends org.apache.commons.lang3.ArrayUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ArrayUtils.class);

    public static byte[] toBytes(@NonNull char[] chars, @NonNull Charset charsets) {
        if (chars == null) {
            throw new NullPointerException("chars is marked non-null but is null");
        }
        if (charsets == null) {
            throw new NullPointerException("charsets is marked non-null but is null");
        }
        return new String(chars).getBytes(charsets);
    }

    public static byte[] toBytes(@NonNull char[] chars, @NonNull String charsetName) throws UnsupportedEncodingException {
        if (chars == null) {
            throw new NullPointerException("chars is marked non-null but is null");
        }
        if (charsetName == null) {
            throw new NullPointerException("charsetName is marked non-null but is null");
        }
        return new String(chars).getBytes(charsetName);
    }

    public static byte[] toBytes(@NonNull char[] chars) {
        if (chars == null) {
            throw new NullPointerException("chars is marked non-null but is null");
        }
        return new String(chars).getBytes(StandardCharsets.UTF_8);
    }

    public static String toString(@NonNull byte[] bytes, @NonNull Charset charsets) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        if (charsets == null) {
            throw new NullPointerException("charsets is marked non-null but is null");
        }
        return new String(bytes, charsets);
    }

    public static String toString(@NonNull byte[] bytes, @NonNull String charsetName) throws UnsupportedEncodingException {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        if (charsetName == null) {
            throw new NullPointerException("charsetName is marked non-null but is null");
        }
        return new String(bytes, charsetName);
    }

    public static String toString(@NonNull byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        return new String(bytes);
    }

    public static char[] toChars(@NonNull byte[] bytes, @NonNull Charset charsets) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        if (charsets == null) {
            throw new NullPointerException("charsets is marked non-null but is null");
        }
        return ArrayUtils.toString(bytes, charsets).toCharArray();
    }

    public static char[] toChars(@NonNull byte[] bytes, @NonNull String charsetName) throws UnsupportedEncodingException {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        if (charsetName == null) {
            throw new NullPointerException("charsetName is marked non-null but is null");
        }
        return ArrayUtils.toString(bytes, charsetName).toCharArray();
    }

    public static char[] toChars(@NonNull byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        return ArrayUtils.toString(bytes).toCharArray();
    }

    public static Object moveForward(@NonNull Object array, int startIndex, int length) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (!(array instanceof Object[] || array instanceof int[] || array instanceof long[] || array instanceof double[] || array instanceof float[] || array instanceof boolean[] || array instanceof short[] || array instanceof byte[] || array instanceof char[])) {
            throw new IllegalArgumentException("Array: should be an array");
        }
        int arrayLen = ArrayUtils.getLength((Object)array);
        if (startIndex < 0 || length < 1 || startIndex >= arrayLen || arrayLen - length < 0) {
            throw new IndexOutOfBoundsException("StartIndex: " + startIndex + ", Length:" + length);
        }
        Object result = Array.newInstance(array.getClass().getComponentType(), arrayLen);
        System.arraycopy(array, 0, result, 0, startIndex);
        System.arraycopy(array, startIndex + length, result, startIndex, arrayLen - length - startIndex);
        return result;
    }

    private static Object remove(@NonNull Object array, int index, @NonNull Object lastElementValue) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (lastElementValue == null) {
            throw new NullPointerException("lastElementValue is marked non-null but is null");
        }
        Object result = ArrayUtils.moveForward(array, index, 1);
        if (array instanceof int[]) {
            if (!(lastElementValue instanceof Integer)) {
                throw new IllegalArgumentException("LastElementValue: should be an Integer");
            }
            ((int[])result)[((int[])result).length - 1] = (Integer)lastElementValue;
        } else if (array instanceof long[]) {
            if (!(lastElementValue instanceof Long)) {
                throw new IllegalArgumentException("LastElementValue: should be a Long");
            }
            ((long[])result)[((long[])result).length - 1] = (Long)lastElementValue;
        } else if (array instanceof double[]) {
            if (!(lastElementValue instanceof Double)) {
                throw new IllegalArgumentException("LastElementValue: should be a Double");
            }
            ((double[])result)[((double[])result).length - 1] = (Double)lastElementValue;
        } else if (array instanceof float[]) {
            if (!(lastElementValue instanceof Float)) {
                throw new IllegalArgumentException("LastElementValue: should be a Float");
            }
            ((float[])result)[((float[])result).length - 1] = ((Float)lastElementValue).floatValue();
        } else if (array instanceof byte[]) {
            if (!(lastElementValue instanceof Byte)) {
                throw new IllegalArgumentException("LastElementValue: should be a Byte");
            }
            ((byte[])result)[((byte[])result).length - 1] = (Byte)lastElementValue;
        } else if (array instanceof char[]) {
            if (!(lastElementValue instanceof Character)) {
                throw new IllegalArgumentException("LastElementValue: should be a Character");
            }
            ((char[])result)[((char[])result).length - 1] = ((Character)lastElementValue).charValue();
        } else if (array instanceof boolean[]) {
            if (!(lastElementValue instanceof Boolean)) {
                throw new IllegalArgumentException("LastElementValue: should be a Boolean");
            }
            ((boolean[])result)[((boolean[])result).length - 1] = (Boolean)lastElementValue;
        } else if (array instanceof short[]) {
            if (!(lastElementValue instanceof Short)) {
                throw new IllegalArgumentException("LastElementValue: should be a Short");
            }
            ((short[])result)[((short[])result).length - 1] = (Short)lastElementValue;
        } else {
            ((Object[])result)[((Object[])result).length - 1] = lastElementValue;
        }
        return result;
    }

    public static <T> T[] remove(@NonNull T[] array, int index, @NonNull T lastElementValue) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (lastElementValue == null) {
            throw new NullPointerException("lastElementValue is marked non-null but is null");
        }
        return (Object[])ArrayUtils.remove(array, index, lastElementValue);
    }

    public static boolean[] remove(@NonNull boolean[] array, int index, boolean lastElementValue) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (boolean[])ArrayUtils.remove((Object)array, index, (Object)lastElementValue);
    }

    public static byte[] remove(@NonNull byte[] array, int index, byte lastElementValue) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (byte[])ArrayUtils.remove((Object)array, index, (Object)lastElementValue);
    }

    public static char[] remove(@NonNull char[] array, int index, char lastElementValue) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (char[])ArrayUtils.remove((Object)array, index, Character.valueOf(lastElementValue));
    }

    public static double[] remove(@NonNull double[] array, int index, double lastElementValue) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (double[])ArrayUtils.remove((Object)array, index, (Object)lastElementValue);
    }

    public static float[] remove(@NonNull float[] array, int index, float lastElementValue) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (float[])ArrayUtils.remove((Object)array, index, Float.valueOf(lastElementValue));
    }

    public static short[] remove(@NonNull short[] array, int index, short lastElementValue) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (short[])ArrayUtils.remove((Object)array, index, (Object)lastElementValue);
    }

    public static int[] remove(@NonNull int[] array, int index, int lastElementValue) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (int[])ArrayUtils.remove((Object)array, index, (Object)lastElementValue);
    }

    public static long[] remove(@NonNull long[] array, int index, long lastElementValue) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (long[])ArrayUtils.remove((Object)array, index, (Object)lastElementValue);
    }

    private static Object fill(@NonNull Object array, int fromIndex, int toIndex, Object value) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (!(array instanceof Object[] || array instanceof int[] || array instanceof long[] || array instanceof double[] || array instanceof float[] || array instanceof boolean[] || array instanceof short[] || array instanceof byte[] || array instanceof char[])) {
            throw new IllegalArgumentException("Array: should be an array");
        }
        int arrayLen = ArrayUtils.getLength((Object)array);
        Object result = array;
        if (toIndex > arrayLen) {
            result = Array.newInstance(array.getClass().getComponentType(), toIndex);
            System.arraycopy(array, 0, result, 0, arrayLen);
        }
        if (result instanceof int[]) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("Value: should be Integer");
            }
            Arrays.fill((int[])result, fromIndex, toIndex, (Integer)value);
        } else if (result instanceof long[]) {
            if (!(value instanceof Long)) {
                throw new IllegalArgumentException("Value: should be Long");
            }
            Arrays.fill((long[])result, fromIndex, toIndex, (Long)value);
        } else if (result instanceof double[]) {
            if (!(value instanceof Double)) {
                throw new IllegalArgumentException("Value: should be Double");
            }
            Arrays.fill((double[])result, fromIndex, toIndex, (Double)value);
        } else if (result instanceof float[]) {
            if (!(value instanceof Float)) {
                throw new IllegalArgumentException("Value: should be Float");
            }
            Arrays.fill((float[])result, fromIndex, toIndex, ((Float)value).floatValue());
        } else if (result instanceof byte[]) {
            if (!(value instanceof Byte)) {
                throw new IllegalArgumentException("Value: should be Byte");
            }
            Arrays.fill((byte[])result, fromIndex, toIndex, (Byte)value);
        } else if (result instanceof char[]) {
            if (!(value instanceof Character)) {
                throw new IllegalArgumentException("Value: should be Character");
            }
            Arrays.fill((char[])result, fromIndex, toIndex, ((Character)value).charValue());
        } else if (result instanceof boolean[]) {
            if (!(value instanceof Boolean)) {
                throw new IllegalArgumentException("Value: should be Boolean");
            }
            Arrays.fill((boolean[])result, fromIndex, toIndex, (Boolean)value);
        } else if (result instanceof short[]) {
            if (!(value instanceof Short)) {
                throw new IllegalArgumentException("Value: should be Short");
            }
            Arrays.fill((short[])result, fromIndex, toIndex, (Short)value);
        } else {
            Arrays.fill((Object[])result, fromIndex, toIndex, value);
        }
        return result;
    }

    public static <T> T[] fill(@NonNull T[] array, int fromIndex, int toIndex, T val) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (Object[])ArrayUtils.fill(array, fromIndex, toIndex, val);
    }

    public static boolean[] fill(@NonNull boolean[] array, int fromIndex, int toIndex, boolean val) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (boolean[])ArrayUtils.fill((Object)array, fromIndex, toIndex, (Object)val);
    }

    public static byte[] fill(@NonNull byte[] array, int fromIndex, int toIndex, byte val) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (byte[])ArrayUtils.fill((Object)array, fromIndex, toIndex, (Object)val);
    }

    public static char[] fill(@NonNull char[] array, int fromIndex, int toIndex, char val) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (char[])ArrayUtils.fill((Object)array, fromIndex, toIndex, Character.valueOf(val));
    }

    public static double[] fill(@NonNull double[] array, int fromIndex, int toIndex, double val) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (double[])ArrayUtils.fill((Object)array, fromIndex, toIndex, (Object)val);
    }

    public static float[] fill(@NonNull float[] array, int fromIndex, int toIndex, float val) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (float[])ArrayUtils.fill((Object)array, fromIndex, toIndex, Float.valueOf(val));
    }

    public static short[] fill(@NonNull short[] array, int fromIndex, int toIndex, short val) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (short[])ArrayUtils.fill((Object)array, fromIndex, toIndex, (Object)val);
    }

    public static int[] fill(@NonNull int[] array, int fromIndex, int toIndex, int val) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (int[])ArrayUtils.fill((Object)array, fromIndex, toIndex, (Object)val);
    }

    public static long[] fill(@NonNull long[] array, int fromIndex, int toIndex, long val) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (long[])ArrayUtils.fill((Object)array, fromIndex, toIndex, (Object)val);
    }

    private static boolean containsObject(@NonNull Object array, Object val) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (array instanceof int[]) {
            return ArrayUtils.contains((int[])((int[])array), (int)((int[])val)[0]);
        }
        if (array instanceof long[]) {
            return ArrayUtils.contains((long[])((long[])array), (long)((long[])val)[0]);
        }
        if (array instanceof double[]) {
            return ArrayUtils.contains((double[])((double[])array), (double)((double[])val)[0]);
        }
        if (array instanceof float[]) {
            return ArrayUtils.contains((float[])((float[])array), (float)((float[])val)[0]);
        }
        if (array instanceof byte[]) {
            return ArrayUtils.contains((byte[])((byte[])array), (byte)((byte[])val)[0]);
        }
        if (array instanceof char[]) {
            return ArrayUtils.contains((char[])((char[])array), (char)((char[])val)[0]);
        }
        if (array instanceof boolean[]) {
            return ArrayUtils.contains((boolean[])((boolean[])array), (boolean)((boolean[])val)[0]);
        }
        if (array instanceof short[]) {
            return ArrayUtils.contains((short[])((short[])array), (short)((short[])val)[0]);
        }
        return ArrayUtils.contains((Object[])((Object[])array), (Object)((Object[])val)[0]);
    }

    private static Object removeAllElements(@NonNull Object array, Object ... vals) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (vals == null) {
            throw new NullPointerException("vals is marked non-null but is null");
        }
        Object result = array instanceof int[] ? ((int[])array).clone() : (array instanceof long[] ? ((long[])array).clone() : (array instanceof double[] ? ((double[])array).clone() : (array instanceof float[] ? ((float[])array).clone() : (array instanceof byte[] ? ((byte[])array).clone() : (array instanceof char[] ? ((char[])array).clone() : (array instanceof boolean[] ? ((boolean[])array).clone() : (array instanceof short[] ? ((short[])array).clone() : ((Object[])array).clone())))))));
        for (Object val : vals) {
            while (ArrayUtils.containsObject(result, val)) {
                if (result instanceof int[]) {
                    result = ArrayUtils.removeElement((int[])((int[])result), (int)((int[])val)[0]);
                    continue;
                }
                if (array instanceof long[]) {
                    result = ArrayUtils.removeElement((long[])((long[])result), (long)((long[])val)[0]);
                    continue;
                }
                if (array instanceof double[]) {
                    result = ArrayUtils.removeElement((double[])((double[])result), (double)((double[])val)[0]);
                    continue;
                }
                if (array instanceof float[]) {
                    result = ArrayUtils.removeElement((float[])((float[])result), (float)((float[])val)[0]);
                    continue;
                }
                if (array instanceof byte[]) {
                    result = ArrayUtils.removeElement((byte[])((byte[])result), (byte)((byte[])val)[0]);
                    continue;
                }
                if (array instanceof char[]) {
                    result = ArrayUtils.removeElement((char[])((char[])result), (char)((char[])val)[0]);
                    continue;
                }
                if (array instanceof boolean[]) {
                    result = ArrayUtils.removeElement((boolean[])((boolean[])result), (boolean)((boolean[])val)[0]);
                    continue;
                }
                if (array instanceof short[]) {
                    result = ArrayUtils.removeElement((short[])((short[])result), (short)((short[])val)[0]);
                    continue;
                }
                result = ArrayUtils.removeElement((Object[])result, (Object)((Object[])val)[0]);
            }
        }
        return result;
    }

    public static <T> T[] removeAllElements(@NonNull T[] array, T ... vals) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (vals == null) {
            throw new NullPointerException("vals is marked non-null but is null");
        }
        return (Object[])ArrayUtils.removeAllElements(array, new Object[]{vals});
    }

    public static boolean[] removeAllElements(@NonNull boolean[] array, boolean ... vals) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (vals == null) {
            throw new NullPointerException("vals is marked non-null but is null");
        }
        return (boolean[])ArrayUtils.removeAllElements((Object)array, new Object[]{vals});
    }

    public static byte[] removeAllElements(@NonNull byte[] array, byte ... vals) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (vals == null) {
            throw new NullPointerException("vals is marked non-null but is null");
        }
        return (byte[])ArrayUtils.removeAllElements((Object)array, new Object[]{vals});
    }

    public static char[] removeAllElements(@NonNull char[] array, char ... vals) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (vals == null) {
            throw new NullPointerException("vals is marked non-null but is null");
        }
        return (char[])ArrayUtils.removeAllElements((Object)array, new Object[]{vals});
    }

    public static double[] removeAllElements(@NonNull double[] array, double ... vals) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (vals == null) {
            throw new NullPointerException("vals is marked non-null but is null");
        }
        return (double[])ArrayUtils.removeAllElements((Object)array, new Object[]{vals});
    }

    public static float[] removeAllElements(@NonNull float[] array, float ... vals) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (vals == null) {
            throw new NullPointerException("vals is marked non-null but is null");
        }
        return (float[])ArrayUtils.removeAllElements((Object)array, new Object[]{vals});
    }

    public static short[] removeAllElements(@NonNull short[] array, short ... vals) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (vals == null) {
            throw new NullPointerException("vals is marked non-null but is null");
        }
        return (short[])ArrayUtils.removeAllElements((Object)array, new Object[]{vals});
    }

    public static int[] removeAllElements(@NonNull int[] array, int ... vals) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (vals == null) {
            throw new NullPointerException("vals is marked non-null but is null");
        }
        return (int[])ArrayUtils.removeAllElements((Object)array, new Object[]{vals});
    }

    public static long[] removeAllElements(@NonNull long[] array, long ... vals) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (vals == null) {
            throw new NullPointerException("vals is marked non-null but is null");
        }
        return (long[])ArrayUtils.removeAllElements((Object)array, new Object[]{vals});
    }

    public static int indexOf(@NonNull char[] array, @NonNull String valueToFind, int startIndex) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (valueToFind == null) {
            throw new NullPointerException("valueToFind is marked non-null but is null");
        }
        if (ArrayUtils.isEmpty((char[])array)) {
            throw new IllegalArgumentException("Array: should not be empty");
        }
        if (StringUtils.isBlank((CharSequence)valueToFind)) {
            throw new IllegalArgumentException("ValueToFind: should not be blank");
        }
        if (startIndex < 0) {
            throw new IllegalArgumentException("StartIndex: should be greater than or equal to 0");
        }
        if (valueToFind.length() == 2) {
            int charsLastElementIndex = array.length - 1;
            char[] valChars = valueToFind.toCharArray();
            char lChar = valChars[0];
            char rChar = valChars[1];
            int index = -1;
            int lCharIndex = ArrayUtils.indexOf((char[])array, (char)lChar, (int)startIndex);
            if (lCharIndex == -1) {
                return -1;
            }
            if (lCharIndex == charsLastElementIndex) {
                return -1;
            }
            int rCharIndex = ArrayUtils.indexOf((char[])array, (char)rChar, (int)(lCharIndex + 1));
            if (rCharIndex == -1) {
                return -1;
            }
            if (rCharIndex == lCharIndex + 1) {
                return lCharIndex;
            }
        }
        return new String(array).indexOf(valueToFind, startIndex);
    }

    public static int indexOf(@NonNull char[] array, @NonNull String valueToFind) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (valueToFind == null) {
            throw new NullPointerException("valueToFind is marked non-null but is null");
        }
        return ArrayUtils.indexOf(array, valueToFind, 0);
    }

    public static int allLength(String ... strs) {
        if (strs == null) {
            throw new NullPointerException("strs is marked non-null but is null");
        }
        if (StringUtils.isAllBlank((CharSequence[])strs)) {
            throw new IllegalArgumentException("Strs: should not be all blank");
        }
        int result = 0;
        for (String str : strs) {
            result += str.length();
        }
        return result;
    }
}

