/*
 * Decompiled with CFR 0.152.
 */
package top.zhogjianhao.id;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class SnowFlake {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SnowFlake.class);
    private static final long START_TIME_MILLIS = 1640966400000L;
    private static final long DEFAULT_DATA_CENTER_OR_MACHINE_BIT = 5L;
    private static final long MAX_DATA_CENTER_AND_MACHINE_BIT = 10L;
    private static final long SEQUENCE_BIT = 12L;
    private static final long SEQUENCE_MAX_NUMBER = SnowFlake.getMaxNumberByBit(12L);
    private static long MACHINE_LEFT = 12L;
    private static final long DATA_CENTER_LEFT = MACHINE_LEFT + 5L;
    private static final long TIME_MILLIS_LEFT = DATA_CENTER_LEFT + 5L;
    private long dataCenterBit = 5L;
    private long machineBit = 5L;
    private long dataCenterId;
    private long machineId;
    private long sequence = 0L;
    private long lastTimeMillis = -1L;

    private static long getMaxNumberByBit(long bit) {
        return -1L << (int)bit ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public SnowFlake(SnowFlakeBuilder snowFlakeBuilder) {
        this.dataCenterBit = snowFlakeBuilder.dataCenterBit;
        this.machineBit = snowFlakeBuilder.machineBit;
    }

    public static SnowFlakeBuilder builder() {
        return new SnowFlakeBuilder();
    }

    public SnowFlake(long dataCenterId, long machineId) {
        long dataCenterMaxNumber = SnowFlake.getMaxNumberByBit(this.dataCenterBit);
        if (dataCenterId > dataCenterMaxNumber || dataCenterId < 0L) {
            throw new IllegalArgumentException("dataCenterId cannot be greater than " + dataCenterMaxNumber + " or less than 0");
        }
        long machineMaxNumber = SnowFlake.getMaxNumberByBit(this.machineBit);
        if (machineId > machineMaxNumber || machineId < 0L) {
            throw new IllegalArgumentException("machineId cannot be greater than " + machineMaxNumber + " or less than 0");
        }
        this.dataCenterId = dataCenterId;
        this.machineId = machineId;
    }

    public synchronized long next() {
        long currentTimeMillis = System.currentTimeMillis();
        if (currentTimeMillis < this.lastTimeMillis) {
            throw new RuntimeException("The clock was moved forward and refused to generate ID.");
        }
        if (currentTimeMillis == this.lastTimeMillis) {
            this.sequence = this.sequence + 1L & SEQUENCE_MAX_NUMBER;
            if (this.sequence == 0L) {
                long l = System.currentTimeMillis();
                while (l <= this.lastTimeMillis) {
                    currentTimeMillis = System.currentTimeMillis();
                }
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimeMillis = currentTimeMillis;
        long dataCenterLeft = DATA_CENTER_LEFT;
        if (this.machineBit != 5L) {
            dataCenterLeft = MACHINE_LEFT + this.machineBit;
        }
        long timeMillisLeft = TIME_MILLIS_LEFT;
        if (this.dataCenterBit != 5L) {
            timeMillisLeft = dataCenterLeft + this.dataCenterBit;
        }
        return currentTimeMillis - 1640966400000L << (int)dataCenterLeft | this.dataCenterId << (int)dataCenterLeft | this.machineId << (int)MACHINE_LEFT | this.sequence;
    }

    @Generated
    public void setDataCenterId(long dataCenterId) {
        this.dataCenterId = dataCenterId;
    }

    @Generated
    public void setMachineId(long machineId) {
        this.machineId = machineId;
    }

    public static class SnowFlakeBuilder {
        private Long dataCenterBit;
        private Long machineBit;
        private long dataCenterId;
        private long machineId;

        public SnowFlakeBuilder() {
            this.dataCenterBit = 5L;
            this.machineBit = 5L;
        }

        public SnowFlakeBuilder(long dataCenterBit, long machineBit) {
            this.dataCenterBit = dataCenterBit;
            this.machineBit = machineBit;
        }

        public SnowFlakeBuilder dataCenterBit(long dataCenterBit) {
            if (dataCenterBit > 10L || dataCenterBit < 0L) {
                throw new IllegalArgumentException("dataCenterBit cannot be greater than 10 or less than 0");
            }
            this.dataCenterBit = dataCenterBit;
            this.machineBit = 10L - dataCenterBit;
            return this;
        }

        public SnowFlakeBuilder machineBit(long machineBit) {
            if (machineBit > 10L || machineBit < 0L) {
                throw new IllegalArgumentException("machineBit cannot be greater than 10 or less than 0");
            }
            this.dataCenterBit = 10L - machineBit;
            this.machineBit = machineBit;
            return this;
        }

        public SnowFlakeBuilder dataCenterId(long dataCenterId) {
            this.dataCenterId = dataCenterId;
            return this;
        }

        public SnowFlakeBuilder machineId(long machineId) {
            this.machineId = machineId;
            return this;
        }

        public SnowFlake build() {
            return new SnowFlake(this);
        }
    }
}

