/*
 * Decompiled with CFR 0.152.
 */
package top.zhogjianhao.http;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.ejlchina.okhttps.HttpResult;
import com.ejlchina.okhttps.SHttpTask;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.zhogjianhao.JsonUtils;
import top.zhogjianhao.MapUtils;
import top.zhogjianhao.StringUtils;
import top.zhogjianhao.constant.CommonPattern;

public class HttpUtils
extends com.ejlchina.okhttps.HttpUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpUtils.class);

    public static String toUrlParams(@NonNull String prefix, @NonNull Map<String, Object> params) {
        if (prefix == null) {
            throw new NullPointerException("prefix is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        if (MapUtils.isEmpty(params)) {
            return prefix;
        }
        Set<Map.Entry<String, Object>> entrySet = params.entrySet();
        StringBuilder result = new StringBuilder();
        Map.Entry<String, Object> firstEntry = null;
        Iterator<Map.Entry<String, Object>> iterator = entrySet.iterator();
        if (iterator.hasNext()) {
            Map.Entry<String, Object> entry;
            firstEntry = entry = iterator.next();
            result.append(entry.getKey()).append("=").append(entry.getValue());
        }
        entrySet.remove(firstEntry);
        for (Map.Entry<String, Object> entry : entrySet) {
            result.append("&").append(entry.getKey()).append("=").append(entry.getValue());
        }
        return prefix + result;
    }

    public static String toUrlParams(@NonNull Map<String, Object> params) {
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        return HttpUtils.toUrlParams("?", params);
    }

    private static int getContentLength(@NonNull Map<String, Object> bodyParams) {
        if (bodyParams == null) {
            throw new NullPointerException("bodyParams is marked non-null but is null");
        }
        if (MapUtils.isEmpty(bodyParams)) {
            return 0;
        }
        String s = JsonUtils.toJson(bodyParams, new JSONWriter.Feature[0]);
        s = CommonPattern.LEFT_CURLY_BRACES.matcher(s).replaceAll("%7B");
        s = CommonPattern.DOUBLE_QUOTATION_MARK.matcher(s).replaceAll("%22");
        s = CommonPattern.COLON.matcher(s).replaceAll("%3A");
        s = CommonPattern.LEFT_SQUARE_BRACKET.matcher(s).replaceAll("%5B");
        s = CommonPattern.RIGHT_SQUARE_BRACKET.matcher(s).replaceAll("%5D");
        s = CommonPattern.COMMA.matcher(s).replaceAll("%2C");
        s = CommonPattern.RIGHT_CURLY_BRACES.matcher(s).replaceAll("%7D");
        return s.length();
    }

    protected static <T> T sync(@NonNull String requestMethod, @NonNull String url, String contentType, Map<String, Object> params, Map<String, String> headers, @NonNull Class<T> resultClass) {
        HttpResult result;
        if (requestMethod == null) {
            throw new NullPointerException("requestMethod is marked non-null but is null");
        }
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (resultClass == null) {
            throw new NullPointerException("resultClass is marked non-null but is null");
        }
        if (StringUtils.isBlank((CharSequence)url)) {
            throw new IllegalArgumentException("Url: should not be blank");
        }
        SHttpTask task = HttpUtils.sync((String)url);
        if (StringUtils.isNotBlank((CharSequence)contentType)) {
            task.bodyType(contentType);
        }
        if (MapUtils.isNotEmpty(params)) {
            if ("GET".equals(requestMethod) || "DELETE".equals(requestMethod)) {
                task = (SHttpTask)task.addUrlPara(params);
            } else if ("POST".equals(requestMethod) || "PATCH".equals(requestMethod) || "PUT".equals(requestMethod)) {
                task.addBodyPara(params);
            }
        }
        if (MapUtils.isNotEmpty(headers)) {
            task.addHeader(headers);
        }
        if (MapUtils.isEmpty(headers) || headers.get("User-Agent") == null) {
            task.addHeader("User-Agent", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/xxx.xx (KHTML, like Gecko) Chrome/xx.x.xxxx.xxx Safari/xxx.xx");
        }
        if ((result = task.request(requestMethod)).getState() != HttpResult.State.RESPONSED) {
            IOException error = result.getError();
            log.error(error.getMessage(), (Throwable)error);
            return null;
        }
        HttpResult.Body body = result.getBody();
        if (HttpResult.Body.class.equals(resultClass)) {
            return (T)body;
        }
        if (String.class.equals(resultClass)) {
            return (T)body.toString();
        }
        if (ObjectNode.class.equals(resultClass) || JsonNode.class.equals(resultClass) || ArrayNode.class.equals(resultClass)) {
            try {
                return (T)new ObjectMapper().readTree(body.toString());
            }
            catch (JsonProcessingException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        } else {
            if (JSON.class.equals(resultClass)) {
                return (T)JSON.parseObject((String)body.toString());
            }
            if (JSONObject.class.equals(resultClass)) {
                return (T)JSON.parseObject((String)body.toString());
            }
            if (JSONArray.class.equals(resultClass)) {
                return (T)JSON.parseArray((String)body.toString());
            }
            if (JsonElement.class.equals(resultClass)) {
                return (T)JsonParser.parseString((String)body.toString());
            }
            if (JsonObject.class.equals(resultClass)) {
                JsonElement jsonElement = JsonParser.parseString((String)body.toString());
                return (T)jsonElement.getAsJsonObject();
            }
            if (JsonArray.class.equals(resultClass)) {
                JsonElement jsonElement = JsonParser.parseString((String)body.toString());
                return (T)jsonElement.getAsJsonArray();
            }
        }
        return (T)body.toBean(resultClass);
    }

    public static <T> T getByHeader(@NonNull String url, @NonNull String contentType, @NonNull Map<String, Object> params, @NonNull Map<String, String> headers, @NonNull Class<T> resultClass) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (contentType == null) {
            throw new NullPointerException("contentType is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        if (headers == null) {
            throw new NullPointerException("headers is marked non-null but is null");
        }
        if (resultClass == null) {
            throw new NullPointerException("resultClass is marked non-null but is null");
        }
        return HttpUtils.sync("GET", url, contentType, params, headers, resultClass);
    }

    public static <T> T getByHeader(@NonNull String url, @NonNull Map<String, Object> params, @NonNull Map<String, String> headers, @NonNull Class<T> resultClass) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        if (headers == null) {
            throw new NullPointerException("headers is marked non-null but is null");
        }
        if (resultClass == null) {
            throw new NullPointerException("resultClass is marked non-null but is null");
        }
        return HttpUtils.sync("GET", url, null, params, headers, resultClass);
    }

    public static <T> T getByHeader(@NonNull String url, @NonNull Map<String, String> headers, @NonNull Class<T> resultClass) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (headers == null) {
            throw new NullPointerException("headers is marked non-null but is null");
        }
        if (resultClass == null) {
            throw new NullPointerException("resultClass is marked non-null but is null");
        }
        return HttpUtils.sync("GET", url, null, null, headers, resultClass);
    }

    public static HttpResult.Body getByHeader(@NonNull String url, @NonNull Map<String, Object> params, @NonNull Map<String, String> headers) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        if (headers == null) {
            throw new NullPointerException("headers is marked non-null but is null");
        }
        return HttpUtils.sync("GET", url, null, params, headers, HttpResult.Body.class);
    }

    public static HttpResult.Body getByHeader(@NonNull String url, @NonNull Map<String, String> headers) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (headers == null) {
            throw new NullPointerException("headers is marked non-null but is null");
        }
        return HttpUtils.sync("GET", url, null, null, headers, HttpResult.Body.class);
    }

    public static <T> T get(@NonNull String url, @NonNull String contentType, @NonNull Map<String, Object> params, @NonNull Class<T> resultClass) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (contentType == null) {
            throw new NullPointerException("contentType is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        if (resultClass == null) {
            throw new NullPointerException("resultClass is marked non-null but is null");
        }
        return HttpUtils.sync("GET", url, contentType, params, null, resultClass);
    }

    public static <T> T get(@NonNull String url, @NonNull Map<String, Object> params, @NonNull Class<T> resultClass) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        if (resultClass == null) {
            throw new NullPointerException("resultClass is marked non-null but is null");
        }
        return HttpUtils.sync("GET", url, null, params, null, resultClass);
    }

    public static <T> T get(@NonNull String url, @NonNull Class<T> resultClass) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (resultClass == null) {
            throw new NullPointerException("resultClass is marked non-null but is null");
        }
        return HttpUtils.sync("GET", url, null, null, null, resultClass);
    }

    public static HttpResult.Body get(@NonNull String url, @NonNull Map<String, Object> params) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        return HttpUtils.sync("GET", url, null, params, null, HttpResult.Body.class);
    }

    public static HttpResult.Body get(@NonNull String url) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        return HttpUtils.sync("GET", url, null, null, null, HttpResult.Body.class);
    }

    public static <T> T postByHeader(@NonNull String url, @NonNull String contentType, @NonNull Map<String, Object> params, @NonNull Map<String, String> headers, @NonNull Class<T> resultClass) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (contentType == null) {
            throw new NullPointerException("contentType is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        if (headers == null) {
            throw new NullPointerException("headers is marked non-null but is null");
        }
        if (resultClass == null) {
            throw new NullPointerException("resultClass is marked non-null but is null");
        }
        return HttpUtils.sync("POST", url, contentType, params, headers, resultClass);
    }

    public static <T> T postByHeader(@NonNull String url, @NonNull Map<String, Object> params, @NonNull Map<String, String> headers, @NonNull Class<T> resultClass) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        if (headers == null) {
            throw new NullPointerException("headers is marked non-null but is null");
        }
        if (resultClass == null) {
            throw new NullPointerException("resultClass is marked non-null but is null");
        }
        return HttpUtils.sync("POST", url, null, params, headers, resultClass);
    }

    public static <T> T postByHeader(@NonNull String url, @NonNull Map<String, String> headers, @NonNull Class<T> resultClass) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (headers == null) {
            throw new NullPointerException("headers is marked non-null but is null");
        }
        if (resultClass == null) {
            throw new NullPointerException("resultClass is marked non-null but is null");
        }
        return HttpUtils.sync("POST", url, null, null, headers, resultClass);
    }

    public static HttpResult.Body postByHeader(@NonNull String url, @NonNull String contentType, @NonNull Map<String, Object> params, @NonNull Map<String, String> headers) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (contentType == null) {
            throw new NullPointerException("contentType is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        if (headers == null) {
            throw new NullPointerException("headers is marked non-null but is null");
        }
        return HttpUtils.sync("POST", url, contentType, params, headers, HttpResult.Body.class);
    }

    public static HttpResult.Body postByHeader(@NonNull String url, @NonNull Map<String, Object> params, @NonNull Map<String, String> headers) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        if (headers == null) {
            throw new NullPointerException("headers is marked non-null but is null");
        }
        return HttpUtils.sync("POST", url, null, params, headers, HttpResult.Body.class);
    }

    public static HttpResult.Body postByHeader(@NonNull String url, @NonNull Map<String, String> headers) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (headers == null) {
            throw new NullPointerException("headers is marked non-null but is null");
        }
        return HttpUtils.sync("POST", url, null, null, headers, HttpResult.Body.class);
    }

    public static <T> T post(@NonNull String url, @NonNull String contentType, @NonNull Map<String, Object> params, @NonNull Class<T> resultClass) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (contentType == null) {
            throw new NullPointerException("contentType is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        if (resultClass == null) {
            throw new NullPointerException("resultClass is marked non-null but is null");
        }
        return HttpUtils.sync("POST", url, contentType, params, null, resultClass);
    }

    public static <T> T post(@NonNull String url, @NonNull Map<String, Object> params, @NonNull Class<T> resultClass) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        if (resultClass == null) {
            throw new NullPointerException("resultClass is marked non-null but is null");
        }
        return HttpUtils.sync("POST", url, null, params, null, resultClass);
    }

    public static <T> T post(@NonNull String url, @NonNull Class<T> resultClass) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (resultClass == null) {
            throw new NullPointerException("resultClass is marked non-null but is null");
        }
        return HttpUtils.sync("POST", url, null, null, null, resultClass);
    }

    public static HttpResult.Body post(@NonNull String url, @NonNull String contentType, @NonNull Map<String, Object> params) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (contentType == null) {
            throw new NullPointerException("contentType is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        return HttpUtils.sync("POST", url, contentType, params, null, HttpResult.Body.class);
    }

    public static HttpResult.Body post(@NonNull String url, @NonNull Map<String, Object> params) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        return HttpUtils.sync("POST", url, null, params, null, HttpResult.Body.class);
    }

    public static HttpResult.Body post(@NonNull String url) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        return HttpUtils.sync("POST", url, null, null, null, HttpResult.Body.class);
    }

    public static <T> T putByHeader(@NonNull String url, @NonNull String contentType, @NonNull Map<String, Object> params, @NonNull Map<String, String> headers, @NonNull Class<T> resultClass) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (contentType == null) {
            throw new NullPointerException("contentType is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        if (headers == null) {
            throw new NullPointerException("headers is marked non-null but is null");
        }
        if (resultClass == null) {
            throw new NullPointerException("resultClass is marked non-null but is null");
        }
        return HttpUtils.sync("PUT", url, contentType, params, headers, resultClass);
    }

    public static <T> T putByHeader(@NonNull String url, @NonNull Map<String, Object> params, @NonNull Map<String, String> headers, @NonNull Class<T> resultClass) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        if (headers == null) {
            throw new NullPointerException("headers is marked non-null but is null");
        }
        if (resultClass == null) {
            throw new NullPointerException("resultClass is marked non-null but is null");
        }
        return HttpUtils.sync("PUT", url, null, params, headers, resultClass);
    }

    public static <T> T putByHeader(@NonNull String url, @NonNull Map<String, String> headers, @NonNull Class<T> resultClass) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (headers == null) {
            throw new NullPointerException("headers is marked non-null but is null");
        }
        if (resultClass == null) {
            throw new NullPointerException("resultClass is marked non-null but is null");
        }
        return HttpUtils.sync("PUT", url, null, null, headers, resultClass);
    }

    public static HttpResult.Body putByHeader(@NonNull String url, @NonNull String contentType, @NonNull Map<String, Object> params, @NonNull Map<String, String> headers) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (contentType == null) {
            throw new NullPointerException("contentType is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        if (headers == null) {
            throw new NullPointerException("headers is marked non-null but is null");
        }
        return HttpUtils.sync("PUT", url, contentType, params, headers, HttpResult.Body.class);
    }

    public static HttpResult.Body putByHeader(@NonNull String url, @NonNull Map<String, Object> params, @NonNull Map<String, String> headers) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        if (headers == null) {
            throw new NullPointerException("headers is marked non-null but is null");
        }
        return HttpUtils.sync("PUT", url, null, params, headers, HttpResult.Body.class);
    }

    public static HttpResult.Body putByHeader(@NonNull String url, @NonNull Map<String, String> headers) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (headers == null) {
            throw new NullPointerException("headers is marked non-null but is null");
        }
        return HttpUtils.sync("PUT", url, null, null, headers, HttpResult.Body.class);
    }

    public static <T> T put(@NonNull String url, @NonNull String contentType, @NonNull Map<String, Object> params, @NonNull Class<T> resultClass) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (contentType == null) {
            throw new NullPointerException("contentType is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        if (resultClass == null) {
            throw new NullPointerException("resultClass is marked non-null but is null");
        }
        return HttpUtils.sync("PUT", url, contentType, params, null, resultClass);
    }

    public static <T> T put(@NonNull String url, @NonNull Map<String, Object> params, @NonNull Class<T> resultClass) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        if (resultClass == null) {
            throw new NullPointerException("resultClass is marked non-null but is null");
        }
        return HttpUtils.sync("PUT", url, null, params, null, resultClass);
    }

    public static <T> T put(@NonNull String url, @NonNull Class<T> resultClass) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (resultClass == null) {
            throw new NullPointerException("resultClass is marked non-null but is null");
        }
        return HttpUtils.sync("PUT", url, null, null, null, resultClass);
    }

    public static HttpResult.Body put(@NonNull String url, @NonNull String contentType, @NonNull Map<String, Object> params) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (contentType == null) {
            throw new NullPointerException("contentType is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        return HttpUtils.sync("PUT", url, contentType, params, null, HttpResult.Body.class);
    }

    public static HttpResult.Body put(@NonNull String url, @NonNull Map<String, Object> params) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        return HttpUtils.sync("PUT", url, null, params, null, HttpResult.Body.class);
    }

    public static HttpResult.Body put(@NonNull String url) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        return HttpUtils.sync("PUT", url, null, null, null, HttpResult.Body.class);
    }

    public static <T> T patchByHeader(@NonNull String url, @NonNull String contentType, @NonNull Map<String, Object> params, @NonNull Map<String, String> headers, @NonNull Class<T> resultClass) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (contentType == null) {
            throw new NullPointerException("contentType is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        if (headers == null) {
            throw new NullPointerException("headers is marked non-null but is null");
        }
        if (resultClass == null) {
            throw new NullPointerException("resultClass is marked non-null but is null");
        }
        return HttpUtils.sync("PATCH", url, contentType, params, headers, resultClass);
    }

    public static <T> T patchByHeader(@NonNull String url, @NonNull Map<String, Object> params, @NonNull Map<String, String> headers, @NonNull Class<T> resultClass) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        if (headers == null) {
            throw new NullPointerException("headers is marked non-null but is null");
        }
        if (resultClass == null) {
            throw new NullPointerException("resultClass is marked non-null but is null");
        }
        return HttpUtils.sync("PATCH", url, null, params, headers, resultClass);
    }

    public static <T> T patchByHeader(@NonNull String url, @NonNull Map<String, String> headers, @NonNull Class<T> resultClass) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (headers == null) {
            throw new NullPointerException("headers is marked non-null but is null");
        }
        if (resultClass == null) {
            throw new NullPointerException("resultClass is marked non-null but is null");
        }
        return HttpUtils.sync("PATCH", url, null, null, headers, resultClass);
    }

    public static HttpResult.Body patchByHeader(@NonNull String url, @NonNull String contentType, @NonNull Map<String, Object> params, @NonNull Map<String, String> headers) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (contentType == null) {
            throw new NullPointerException("contentType is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        if (headers == null) {
            throw new NullPointerException("headers is marked non-null but is null");
        }
        return HttpUtils.sync("PATCH", url, contentType, params, headers, HttpResult.Body.class);
    }

    public static HttpResult.Body patchByHeader(@NonNull String url, @NonNull Map<String, Object> params, @NonNull Map<String, String> headers) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        if (headers == null) {
            throw new NullPointerException("headers is marked non-null but is null");
        }
        return HttpUtils.sync("PATCH", url, null, params, headers, HttpResult.Body.class);
    }

    public static HttpResult.Body patchByHeader(@NonNull String url, @NonNull Map<String, String> headers) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (headers == null) {
            throw new NullPointerException("headers is marked non-null but is null");
        }
        return HttpUtils.sync("PATCH", url, null, null, headers, HttpResult.Body.class);
    }

    public static <T> T patch(@NonNull String url, @NonNull String contentType, @NonNull Map<String, Object> params, @NonNull Class<T> resultClass) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (contentType == null) {
            throw new NullPointerException("contentType is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        if (resultClass == null) {
            throw new NullPointerException("resultClass is marked non-null but is null");
        }
        return HttpUtils.sync("PATCH", url, contentType, params, null, resultClass);
    }

    public static <T> T patch(@NonNull String url, @NonNull Map<String, Object> params, @NonNull Class<T> resultClass) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        if (resultClass == null) {
            throw new NullPointerException("resultClass is marked non-null but is null");
        }
        return HttpUtils.sync("PATCH", url, null, params, null, resultClass);
    }

    public static <T> T patch(@NonNull String url, @NonNull Class<T> resultClass) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (resultClass == null) {
            throw new NullPointerException("resultClass is marked non-null but is null");
        }
        return HttpUtils.sync("PATCH", url, null, null, null, resultClass);
    }

    public static HttpResult.Body patch(@NonNull String url, @NonNull String contentType, @NonNull Map<String, Object> params) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (contentType == null) {
            throw new NullPointerException("contentType is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        return HttpUtils.sync("PATCH", url, contentType, params, null, HttpResult.Body.class);
    }

    public static HttpResult.Body patch(@NonNull String url, @NonNull Map<String, Object> params) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        return HttpUtils.sync("PATCH", url, null, params, null, HttpResult.Body.class);
    }

    public static HttpResult.Body patch(@NonNull String url) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        return HttpUtils.sync("PATCH", url, null, null, null, HttpResult.Body.class);
    }

    public static <T> T deleteByHeader(@NonNull String url, @NonNull String contentType, @NonNull Map<String, Object> params, @NonNull Map<String, String> headers, @NonNull Class<T> resultClass) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (contentType == null) {
            throw new NullPointerException("contentType is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        if (headers == null) {
            throw new NullPointerException("headers is marked non-null but is null");
        }
        if (resultClass == null) {
            throw new NullPointerException("resultClass is marked non-null but is null");
        }
        return HttpUtils.sync("DELETE", url, contentType, params, headers, resultClass);
    }

    public static <T> T deleteByHeader(@NonNull String url, @NonNull Map<String, Object> params, @NonNull Map<String, String> headers, @NonNull Class<T> resultClass) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        if (headers == null) {
            throw new NullPointerException("headers is marked non-null but is null");
        }
        if (resultClass == null) {
            throw new NullPointerException("resultClass is marked non-null but is null");
        }
        return HttpUtils.sync("DELETE", url, null, params, headers, resultClass);
    }

    public static <T> T deleteByHeader(@NonNull String url, @NonNull Map<String, String> headers, @NonNull Class<T> resultClass) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (headers == null) {
            throw new NullPointerException("headers is marked non-null but is null");
        }
        if (resultClass == null) {
            throw new NullPointerException("resultClass is marked non-null but is null");
        }
        return HttpUtils.sync("DELETE", url, null, null, headers, resultClass);
    }

    public static HttpResult.Body deleteByHeader(@NonNull String url, @NonNull Map<String, Object> params, @NonNull Map<String, String> headers) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        if (headers == null) {
            throw new NullPointerException("headers is marked non-null but is null");
        }
        return HttpUtils.sync("DELETE", url, null, params, headers, HttpResult.Body.class);
    }

    public static HttpResult.Body deleteByHeader(@NonNull String url, @NonNull Map<String, String> headers) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (headers == null) {
            throw new NullPointerException("headers is marked non-null but is null");
        }
        return HttpUtils.sync("DELETE", url, null, null, headers, HttpResult.Body.class);
    }

    public static <T> T delete(@NonNull String url, @NonNull String contentType, @NonNull Map<String, Object> params, @NonNull Class<T> resultClass) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (contentType == null) {
            throw new NullPointerException("contentType is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        if (resultClass == null) {
            throw new NullPointerException("resultClass is marked non-null but is null");
        }
        return HttpUtils.sync("DELETE", url, contentType, params, null, resultClass);
    }

    public static <T> T delete(@NonNull String url, @NonNull Map<String, Object> params, @NonNull Class<T> resultClass) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        if (resultClass == null) {
            throw new NullPointerException("resultClass is marked non-null but is null");
        }
        return HttpUtils.sync("DELETE", url, null, params, null, resultClass);
    }

    public static <T> T delete(@NonNull String url, @NonNull Class<T> resultClass) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (resultClass == null) {
            throw new NullPointerException("resultClass is marked non-null but is null");
        }
        return HttpUtils.sync("DELETE", url, null, null, null, resultClass);
    }

    public static HttpResult.Body delete(@NonNull String url, @NonNull Map<String, Object> params) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        return HttpUtils.sync("DELETE", url, null, params, null, HttpResult.Body.class);
    }

    public static HttpResult.Body delete(@NonNull String url) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        return HttpUtils.sync("DELETE", url, null, null, null, HttpResult.Body.class);
    }
}

