/*
 * Decompiled with CFR 0.152.
 */
package top.zhogjianhao;

import java.io.File;
import java.io.IOException;
import java.util.regex.Pattern;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.zhogjianhao.StringUtils;
import top.zhogjianhao.constant.CommonPattern;
import top.zhogjianhao.regex.RegExUtils;

public class FileUtils
extends org.apache.commons.io.FileUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileUtils.class);
    public static final Pattern PATTERN_REVERSE_FILE_EXTENSION = Pattern.compile("^([A-Za-z\\d]+)\\.");
    public static final Pattern PATTERN_REVERSE_SLASH_FILE_NAME = Pattern.compile("^(.*?\\..*?)[\\\\\\/]");

    public static String getUserDir() {
        return System.getProperty("user.dir");
    }

    public static String getProjectPath() {
        File projectDir = new File("");
        try {
            return projectDir.getCanonicalPath();
        }
        catch (IOException e) {
            log.warn(e.getMessage());
            return null;
        }
    }

    public static String getClassRootPath(@NonNull Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        return clazz.getClassLoader().getResource("").getPath();
    }

    public static String getClassRootPath() {
        return Thread.currentThread().getContextClassLoader().getResource("").getPath();
    }

    public static String getClassPath(@NonNull Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        return clazz.getResource("").getPath();
    }

    public static String getFileExtension(@NonNull String filePath) {
        if (filePath == null) {
            throw new NullPointerException("filePath is marked non-null but is null");
        }
        return new StringBuffer(RegExUtils.match(new StringBuffer(filePath).reverse().toString(), PATTERN_REVERSE_FILE_EXTENSION, 0, 1)).reverse().toString();
    }

    public static String getFileExtension(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        return FileUtils.getFileExtension(file.getPath());
    }

    public static String[] getDirPathAndNameByPath(@NonNull String filePath) {
        if (filePath == null) {
            throw new NullPointerException("filePath is marked non-null but is null");
        }
        int lastFileSeparatorIndex = CommonPattern.BACKSLASH.matcher(filePath).replaceAll("/").lastIndexOf("/");
        if (lastFileSeparatorIndex == -1) {
            if (PATTERN_REVERSE_FILE_EXTENSION.matcher(new StringBuffer(filePath).reverse().toString()).find()) {
                return new String[]{"", filePath};
            }
            return new String[]{filePath, ""};
        }
        return new String[]{filePath.substring(0, lastFileSeparatorIndex + 1), filePath.substring(lastFileSeparatorIndex + 1)};
    }

    public static String getDirPathByPath(@NonNull String filePath) {
        if (filePath == null) {
            throw new NullPointerException("filePath is marked non-null but is null");
        }
        int index = filePath.lastIndexOf("/");
        if (index == -1) {
            index = filePath.lastIndexOf("\\");
        }
        if (index != -1) {
            return filePath.substring(0, index + 1);
        }
        return null;
    }

    public static String getNameByPath(@NonNull String filePath) {
        if (filePath == null) {
            throw new NullPointerException("filePath is marked non-null but is null");
        }
        return new StringBuffer(RegExUtils.matchFirst(new StringBuffer(filePath).reverse().append("/").toString(), PATTERN_REVERSE_SLASH_FILE_NAME, 1)).reverse().toString();
    }

    public static String replace(@NonNull String filePath, @NonNull String newFilePath) {
        if (filePath == null) {
            throw new NullPointerException("filePath is marked non-null but is null");
        }
        if (newFilePath == null) {
            throw new NullPointerException("newFilePath is marked non-null but is null");
        }
        String[] dirPathAndName = FileUtils.getDirPathAndNameByPath(filePath);
        String fileName = dirPathAndName[1];
        if (StringUtils.isBlank((CharSequence)fileName)) {
            throw new IllegalArgumentException("FilePath: should be a file name and file extension");
        }
        String newDirPath = FileUtils.getDirPathByPath(newFilePath);
        boolean hasNewDirPath = StringUtils.isNotBlank((CharSequence)newDirPath);
        String[] fileNameAndExtension = fileName.split("\\.");
        return (hasNewDirPath ? newDirPath : dirPathAndName[0]) + (hasNewDirPath ? FileUtils.getNameByPath(newFilePath) : newFilePath).replaceAll("\\$1", fileNameAndExtension[0]).replaceAll("\\$2", fileNameAndExtension[1]);
    }
}

