/*
 * Decompiled with CFR 0.152.
 */
package top.zhogjianhao;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class YamlUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(YamlUtils.class);

    public static Map<String, Object> load(@NonNull Reader io) {
        if (io == null) {
            throw new NullPointerException("io is marked non-null but is null");
        }
        return (Map)new Yaml().loadAs(io, Map.class);
    }

    public static Map<String, Object> load(@NonNull String filePath) {
        if (filePath == null) {
            throw new NullPointerException("filePath is marked non-null but is null");
        }
        try {
            return (Map)new Yaml().loadAs(Files.newInputStream(Paths.get(filePath, new String[0]), new OpenOption[0]), Map.class);
        }
        catch (IOException e) {
            log.error("load yaml file error", (Throwable)e);
            return null;
        }
    }

    public static Map<String, Object> load(@NonNull InputStream input) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        return (Map)new Yaml().loadAs(input, Map.class);
    }

    public static Object get(@NonNull Map<String, Object> yamlMap, @NonNull String key) {
        if (yamlMap == null) {
            throw new NullPointerException("yamlMap is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        String[] keys = key.split("\\.");
        Map searchMap = yamlMap;
        for (int i = 0; i < keys.length; ++i) {
            Object value = searchMap.get(keys[i]);
            if (value == null) {
                return null;
            }
            if (value instanceof Map) {
                searchMap = (Map)value;
            }
            if (i != keys.length - 1) continue;
            return value;
        }
        return null;
    }

    public static Object get(@NonNull Reader io, @NonNull String key) {
        if (io == null) {
            throw new NullPointerException("io is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return YamlUtils.get(YamlUtils.load(io), key);
    }

    public static Object get(@NonNull String filePath, @NonNull String key) {
        if (filePath == null) {
            throw new NullPointerException("filePath is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return YamlUtils.get(YamlUtils.load(filePath), key);
    }

    public static Object get(@NonNull InputStream input, @NonNull String key) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return YamlUtils.get(YamlUtils.load(input), key);
    }
}

