package top.zhogjianhao.http;

/**
 * 内容类型常量类
 * <p>
 * 通过 top.zhogjianhao.HttpUtilsTest#getMediaTypes() 获取
 * <p>
 * Media Types：https://www.iana.org/assignments/media-types/media-types.xhtml
 */
public class ContentTypeConstant {

  private ContentTypeConstant() {
  }

  public static final String _1D_INTERLEAVED_PARITYFEC_APPLICATION = "application/1d-interleaved-parityfec";
  public static final String _3GPDASH_QOE_REPORT_XML = "application/3gpdash-qoe-report+xml";
  public static final String _3GPPHAL_JSON = "application/3gppHal+json";
  public static final String _3GPPHALFORMS_JSON = "application/3gppHalForms+json";
  public static final String _3GPP_IMS_XML = "application/3gpp-ims+xml";
  public static final String A2L = "application/A2L";
  public static final String ACE_CBOR = "application/ace+cbor";
  public static final String ACTIVEMESSAGE = "application/activemessage";
  public static final String ACTIVITY_JSON = "application/activity+json";
  public static final String AIF_CBOR = "application/aif+cbor";
  public static final String AIF_JSON = "application/aif+json";
  public static final String ALTO_CDNI_JSON = "application/alto-cdni+json";
  public static final String ALTO_CDNIFILTER_JSON = "application/alto-cdnifilter+json";
  public static final String ALTO_COSTMAP_JSON = "application/alto-costmap+json";
  public static final String ALTO_COSTMAPFILTER_JSON = "application/alto-costmapfilter+json";
  public static final String ALTO_DIRECTORY_JSON = "application/alto-directory+json";
  public static final String ALTO_ENDPOINTPROP_JSON = "application/alto-endpointprop+json";
  public static final String ALTO_ENDPOINTPROPPARAMS_JSON = "application/alto-endpointpropparams+json";
  public static final String ALTO_ENDPOINTCOST_JSON = "application/alto-endpointcost+json";
  public static final String ALTO_ENDPOINTCOSTPARAMS_JSON = "application/alto-endpointcostparams+json";
  public static final String ALTO_ERROR_JSON = "application/alto-error+json";
  public static final String ALTO_NETWORKMAPFILTER_JSON = "application/alto-networkmapfilter+json";
  public static final String ALTO_NETWORKMAP_JSON = "application/alto-networkmap+json";
  public static final String ALTO_PROPMAP_JSON = "application/alto-propmap+json";
  public static final String ALTO_PROPMAPPARAMS_JSON = "application/alto-propmapparams+json";
  public static final String ALTO_UPDATESTREAMCONTROL_JSON = "application/alto-updatestreamcontrol+json";
  public static final String ALTO_UPDATESTREAMPARAMS_JSON = "application/alto-updatestreamparams+json";
  public static final String AML = "application/AML";
  public static final String ANDREW_INSET = "application/andrew-inset";
  public static final String APPLEFILE = "application/applefile";
  public static final String AT_JWT = "application/at+jwt";
  public static final String ATF = "application/ATF";
  public static final String ATFX = "application/ATFX";
  public static final String ATOM_XML = "application/atom+xml";
  public static final String ATOMCAT_XML = "application/atomcat+xml";
  public static final String ATOMDELETED_XML = "application/atomdeleted+xml";
  public static final String ATOMICMAIL = "application/atomicmail";
  public static final String ATOMSVC_XML = "application/atomsvc+xml";
  public static final String ATSC_DWD_XML = "application/atsc-dwd+xml";
  public static final String ATSC_DYNAMIC_EVENT_MESSAGE = "application/atsc-dynamic-event-message";
  public static final String ATSC_HELD_XML = "application/atsc-held+xml";
  public static final String ATSC_RDT_JSON = "application/atsc-rdt+json";
  public static final String ATSC_RSAT_XML = "application/atsc-rsat+xml";
  public static final String ATXML = "application/ATXML";
  public static final String AUTH_POLICY_XML = "application/auth-policy+xml";
  public static final String BACNET_XDD_ZIP = "application/bacnet-xdd+zip";
  public static final String BATCH_SMTP = "application/batch-SMTP";
  public static final String BEEP_XML = "application/beep+xml";
  public static final String CALENDAR_JSON = "application/calendar+json";
  public static final String CALENDAR_XML = "application/calendar+xml";
  public static final String CALL_COMPLETION = "application/call-completion";
  public static final String CALS_1840 = "application/CALS-1840";
  public static final String CAPTIVE_JSON = "application/captive+json";
  public static final String CBOR = "application/cbor";
  public static final String CBOR_SEQ = "application/cbor-seq";
  public static final String CCCEX = "application/cccex";
  public static final String CCMP_XML = "application/ccmp+xml";
  public static final String CCXML_XML = "application/ccxml+xml";
  public static final String CDFX_XML = "application/CDFX+XML";
  public static final String CDMI_CAPABILITY = "application/cdmi-capability";
  public static final String CDMI_CONTAINER = "application/cdmi-container";
  public static final String CDMI_DOMAIN = "application/cdmi-domain";
  public static final String CDMI_OBJECT = "application/cdmi-object";
  public static final String CDMI_QUEUE = "application/cdmi-queue";
  public static final String CDNI = "application/cdni";
  public static final String CEA = "application/CEA";
  public static final String CEA_2018_XML = "application/cea-2018+xml";
  public static final String CELLML_XML = "application/cellml+xml";
  public static final String CFW = "application/cfw";
  public static final String CITY_JSON = "application/city+json";
  public static final String CLR = "application/clr";
  public static final String CLUE_INFO_XML = "application/clue_info+xml";
  public static final String CLUE_XML = "application/clue+xml";
  public static final String CMS = "application/cms";
  public static final String CNRP_XML = "application/cnrp+xml";
  public static final String COAP_GROUP_JSON = "application/coap-group+json";
  public static final String COAP_PAYLOAD = "application/coap-payload";
  public static final String COMMONGROUND = "application/commonground";
  public static final String CONFERENCE_INFO_XML = "application/conference-info+xml";
  public static final String CPL_XML = "application/cpl+xml";
  public static final String COSE = "application/cose";
  public static final String COSE_KEY = "application/cose-key";
  public static final String COSE_KEY_SET = "application/cose-key-set";
  public static final String CSRATTRS = "application/csrattrs";
  public static final String CSTA_XML = "application/csta+xml";
  public static final String CSTADATA_XML = "application/CSTAdata+xml";
  public static final String CSVM_JSON = "application/csvm+json";
  public static final String CWT = "application/cwt";
  public static final String CYBERCASH = "application/cybercash";
  public static final String DASH_XML = "application/dash+xml";
  public static final String DASH_PATCH_XML = "application/dash-patch+xml";
  public static final String DASHDELTA = "application/dashdelta";
  public static final String DAVMOUNT_XML = "application/davmount+xml";
  public static final String DCA_RFT = "application/dca-rft";
  public static final String DCD = "application/DCD";
  public static final String DEC_DX = "application/dec-dx";
  public static final String DIALOG_INFO_XML = "application/dialog-info+xml";
  public static final String DICOM = "application/dicom";
  public static final String DICOM_JSON = "application/dicom+json";
  public static final String DICOM_XML = "application/dicom+xml";
  public static final String DII = "application/DII";
  public static final String DIT = "application/DIT";
  public static final String DNS_APPLICATION = "application/dns";
  public static final String DNS_JSON = "application/dns+json";
  public static final String DNS_MESSAGE = "application/dns-message";
  public static final String DOTS_CBOR = "application/dots+cbor";
  public static final String DSKPP_XML = "application/dskpp+xml";
  public static final String DSSC_DER = "application/dssc+der";
  public static final String DSSC_XML = "application/dssc+xml";
  public static final String DVCS = "application/dvcs";
  public static final String ECMASCRIPT_APPLICATION = "application/ecmascript";
  public static final String EDI_CONSENT = "application/EDI-consent";
  public static final String EDIFACT = "application/EDIFACT";
  public static final String EDI_X12 = "application/EDI-X12";
  public static final String EFI = "application/efi";
  public static final String ELM_JSON = "application/elm+json";
  public static final String ELM_XML = "application/elm+xml";
  public static final String EMERGENCYCALLDATA_CAP_XML = "application/EmergencyCallData.cap+xml";
  public static final String EMERGENCYCALLDATA_COMMENT_XML = "application/EmergencyCallData.Comment+xml";
  public static final String EMERGENCYCALLDATA_CONTROL_XML = "application/EmergencyCallData.Control+xml";
  public static final String EMERGENCYCALLDATA_DEVICEINFO_XML = "application/EmergencyCallData.DeviceInfo+xml";
  public static final String EMERGENCYCALLDATA_ECALL_MSD = "application/EmergencyCallData.eCall.MSD";
  public static final String EMERGENCYCALLDATA_PROVIDERINFO_XML = "application/EmergencyCallData.ProviderInfo+xml";
  public static final String EMERGENCYCALLDATA_SERVICEINFO_XML = "application/EmergencyCallData.ServiceInfo+xml";
  public static final String EMERGENCYCALLDATA_SUBSCRIBERINFO_XML = "application/EmergencyCallData.SubscriberInfo+xml";
  public static final String EMERGENCYCALLDATA_VEDS_XML = "application/EmergencyCallData.VEDS+xml";
  public static final String EMMA_XML = "application/emma+xml";
  public static final String EMOTIONML_XML = "application/emotionml+xml";
  public static final String ENCAPRTP_APPLICATION = "application/encaprtp";
  public static final String EPP_XML = "application/epp+xml";
  public static final String EPUB_ZIP = "application/epub+zip";
  public static final String ESHOP = "application/eshop";
  public static final String EXAMPLE_APPLICATION = "application/example";
  public static final String EXI = "application/exi";
  public static final String EXPECT_CT_REPORT_JSON = "application/expect-ct-report+json";
  public static final String EXPRESS = "application/express";
  public static final String FASTINFOSET = "application/fastinfoset";
  public static final String FASTSOAP = "application/fastsoap";
  public static final String FDT_XML = "application/fdt+xml";
  public static final String FHIR_JSON = "application/fhir+json";
  public static final String FHIR_XML = "application/fhir+xml";
  public static final String FITS_APPLICATION = "application/fits";
  public static final String FLEXFEC_APPLICATION = "application/flexfec";
  public static final String FONT_SFNT = "application/font-sfnt";
  public static final String FONT_TDPFR = "application/font-tdpfr";
  public static final String FONT_WOFF = "application/font-woff";
  public static final String FRAMEWORK_ATTRIBUTES_XML = "application/framework-attributes+xml";
  public static final String GEO_JSON = "application/geo+json";
  public static final String GEO_JSON_SEQ = "application/geo+json-seq";
  public static final String GEOPACKAGE_SQLITE3 = "application/geopackage+sqlite3";
  public static final String GEOXACML_XML = "application/geoxacml+xml";
  public static final String GLTF_BUFFER = "application/gltf-buffer";
  public static final String GML_XML = "application/gml+xml";
  public static final String GZIP = "application/gzip";
  public static final String H224 = "application/H224";
  public static final String HELD_XML = "application/held+xml";
  public static final String HTTP_APPLICATION = "application/http";
  public static final String HYPERSTUDIO = "application/hyperstudio";
  public static final String IBE_KEY_REQUEST_XML = "application/ibe-key-request+xml";
  public static final String IBE_PKG_REPLY_XML = "application/ibe-pkg-reply+xml";
  public static final String IBE_PP_DATA = "application/ibe-pp-data";
  public static final String IGES_APPLICATION = "application/iges";
  public static final String IM_ISCOMPOSING_XML = "application/im-iscomposing+xml";
  public static final String INDEX = "application/index";
  public static final String INDEX_CMD = "application/index.cmd";
  public static final String INDEX_OBJ = "application/index.obj";
  public static final String INDEX_RESPONSE = "application/index.response";
  public static final String INDEX_VND = "application/index.vnd";
  public static final String INKML_XML = "application/inkml+xml";
  public static final String IOTP = "application/IOTP";
  public static final String IPFIX = "application/ipfix";
  public static final String IPP = "application/ipp";
  public static final String ISUP = "application/ISUP";
  public static final String ITS_XML = "application/its+xml";
  public static final String JAVASCRIPT_APPLICATION = "application/javascript";
  public static final String JF2FEED_JSON = "application/jf2feed+json";
  public static final String JOSE = "application/jose";
  public static final String JOSE_JSON = "application/jose+json";
  public static final String JRD_JSON = "application/jrd+json";
  public static final String JSCALENDAR_JSON = "application/jscalendar+json";
  public static final String JSON = "application/json";
  public static final String JSON_PATCH_JSON = "application/json-patch+json";
  public static final String JSON_SEQ = "application/json-seq";
  public static final String JWK_JSON = "application/jwk+json";
  public static final String JWK_SET_JSON = "application/jwk-set+json";
  public static final String JWT = "application/jwt";
  public static final String KPML_REQUEST_XML = "application/kpml-request+xml";
  public static final String KPML_RESPONSE_XML = "application/kpml-response+xml";
  public static final String LD_JSON = "application/ld+json";
  public static final String LGR_XML = "application/lgr+xml";
  public static final String LINK_FORMAT = "application/link-format";
  public static final String LOAD_CONTROL_XML = "application/load-control+xml";
  public static final String LOST_XML = "application/lost+xml";
  public static final String LOSTSYNC_XML = "application/lostsync+xml";
  public static final String LPF_ZIP = "application/lpf+zip";
  public static final String LXF = "application/LXF";
  public static final String MAC_BINHEX40 = "application/mac-binhex40";
  public static final String MACWRITEII = "application/macwriteii";
  public static final String MADS_XML = "application/mads+xml";
  public static final String MANIFEST_JSON = "application/manifest+json";
  public static final String MARC = "application/marc";
  public static final String MARCXML_XML = "application/marcxml+xml";
  public static final String MATHEMATICA = "application/mathematica";
  public static final String MATHML_XML = "application/mathml+xml";
  public static final String MATHML_CONTENT_XML = "application/mathml-content+xml";
  public static final String MATHML_PRESENTATION_XML = "application/mathml-presentation+xml";
  public static final String MBMS_ASSOCIATED_PROCEDURE_DESCRIPTION_XML = "application/mbms-associated-procedure-description+xml";
  public static final String MBMS_DEREGISTER_XML = "application/mbms-deregister+xml";
  public static final String MBMS_ENVELOPE_XML = "application/mbms-envelope+xml";
  public static final String MBMS_MSK_RESPONSE_XML = "application/mbms-msk-response+xml";
  public static final String MBMS_MSK_XML = "application/mbms-msk+xml";
  public static final String MBMS_PROTECTION_DESCRIPTION_XML = "application/mbms-protection-description+xml";
  public static final String MBMS_RECEPTION_REPORT_XML = "application/mbms-reception-report+xml";
  public static final String MBMS_REGISTER_RESPONSE_XML = "application/mbms-register-response+xml";
  public static final String MBMS_REGISTER_XML = "application/mbms-register+xml";
  public static final String MBMS_SCHEDULE_XML = "application/mbms-schedule+xml";
  public static final String MBMS_USER_SERVICE_DESCRIPTION_XML = "application/mbms-user-service-description+xml";
  public static final String MBOX = "application/mbox";
  public static final String MEDIA_CONTROL_XML = "application/media_control+xml";
  public static final String MEDIA_POLICY_DATASET_XML = "application/media-policy-dataset+xml";
  public static final String MEDIASERVERCONTROL_XML = "application/mediaservercontrol+xml";
  public static final String MERGE_PATCH_JSON = "application/merge-patch+json";
  public static final String METALINK4_XML = "application/metalink4+xml";
  public static final String METS_XML = "application/mets+xml";
  public static final String MF4 = "application/MF4";
  public static final String MIKEY = "application/mikey";
  public static final String MIPC = "application/mipc";
  public static final String MISSING_BLOCKS_CBOR_SEQ = "application/missing-blocks+cbor-seq";
  public static final String MMT_AEI_XML = "application/mmt-aei+xml";
  public static final String MMT_USD_XML = "application/mmt-usd+xml";
  public static final String MODS_XML = "application/mods+xml";
  public static final String MOSS_KEYS = "application/moss-keys";
  public static final String MOSS_SIGNATURE = "application/moss-signature";
  public static final String MOSSKEY_DATA = "application/mosskey-data";
  public static final String MOSSKEY_REQUEST = "application/mosskey-request";
  public static final String MP21 = "application/mp21";
  public static final String MP4_APPLICATION = "application/mp4";
  public static final String MPEG4_GENERIC_APPLICATION = "application/mpeg4-generic";
  public static final String MPEG4_IOD = "application/mpeg4-iod";
  public static final String MPEG4_IOD_XMT = "application/mpeg4-iod-xmt";
  public static final String MRB_CONSUMER_XML = "application/mrb-consumer+xml";
  public static final String MRB_PUBLISH_XML = "application/mrb-publish+xml";
  public static final String MSC_IVR_XML = "application/msc-ivr+xml";
  public static final String MSC_MIXER_XML = "application/msc-mixer+xml";
  public static final String MSWORD = "application/msword";
  public static final String MUD_JSON = "application/mud+json";
  public static final String MULTIPART_CORE = "application/multipart-core";
  public static final String MXF = "application/mxf";
  public static final String N_QUADS = "application/n-quads";
  public static final String N_TRIPLES = "application/n-triples";
  public static final String NASDATA = "application/nasdata";
  public static final String NEWS_CHECKGROUPS = "application/news-checkgroups";
  public static final String NEWS_GROUPINFO = "application/news-groupinfo";
  public static final String NEWS_TRANSMISSION = "application/news-transmission";
  public static final String NLSML_XML = "application/nlsml+xml";
  public static final String NODE = "application/node";
  public static final String NSS = "application/nss";
  public static final String OAUTH_AUTHZ_REQ_JWT = "application/oauth-authz-req+jwt";
  public static final String OBLIVIOUS_DNS_MESSAGE = "application/oblivious-dns-message";
  public static final String OCSP_REQUEST = "application/ocsp-request";
  public static final String OCSP_RESPONSE = "application/ocsp-response";
  public static final String OCTET_STREAM = "application/octet-stream";
  public static final String ODA = "application/ODA";
  public static final String ODM_XML = "application/odm+xml";
  public static final String ODX = "application/ODX";
  public static final String OEBPS_PACKAGE_XML = "application/oebps-package+xml";
  public static final String OGG_APPLICATION = "application/ogg";
  public static final String OPC_NODESET_XML = "application/opc-nodeset+xml";
  public static final String OSCORE = "application/oscore";
  public static final String OXPS = "application/oxps";
  public static final String P21 = "application/p21";
  public static final String P21_ZIP = "application/p21+zip";
  public static final String P2P_OVERLAY_XML = "application/p2p-overlay+xml";
  public static final String PARITYFEC_APPLICATION = "application/parityfec";
  public static final String PASSPORT = "application/passport";
  public static final String PATCH_OPS_ERROR_XML = "application/patch-ops-error+xml";
  public static final String PDF = "application/pdf";
  public static final String PDX = "application/PDX";
  public static final String PEM_CERTIFICATE_CHAIN = "application/pem-certificate-chain";
  public static final String PGP_ENCRYPTED = "application/pgp-encrypted";
  public static final String PGP_KEYS = "application/pgp-keys";
  public static final String PGP_SIGNATURE = "application/pgp-signature";
  public static final String PIDF_DIFF_XML = "application/pidf-diff+xml";
  public static final String PIDF_XML = "application/pidf+xml";
  public static final String PKCS10 = "application/pkcs10";
  public static final String PKCS7_MIME = "application/pkcs7-mime";
  public static final String PKCS7_SIGNATURE = "application/pkcs7-signature";
  public static final String PKCS8 = "application/pkcs8";
  public static final String PKCS8_ENCRYPTED = "application/pkcs8-encrypted";
  public static final String PKCS12 = "application/pkcs12";
  public static final String PKIX_ATTR_CERT = "application/pkix-attr-cert";
  public static final String PKIX_CERT = "application/pkix-cert";
  public static final String PKIX_CRL = "application/pkix-crl";
  public static final String PKIX_PKIPATH = "application/pkix-pkipath";
  public static final String PKIXCMP = "application/pkixcmp";
  public static final String PLS_XML = "application/pls+xml";
  public static final String POC_SETTINGS_XML = "application/poc-settings+xml";
  public static final String POSTSCRIPT = "application/postscript";
  public static final String PPSP_TRACKER_JSON = "application/ppsp-tracker+json";
  public static final String PROBLEM_JSON = "application/problem+json";
  public static final String PROBLEM_XML = "application/problem+xml";
  public static final String PROVENANCE_XML = "application/provenance+xml";
  public static final String PRS_ALVESTRAND_TITRAX_SHEET = "application/prs.alvestrand.titrax-sheet";
  public static final String PRS_CWW = "application/prs.cww";
  public static final String PRS_CYN = "application/prs.cyn";
  public static final String PRS_HPUB_ZIP = "application/prs.hpub+zip";
  public static final String PRS_NPREND = "application/prs.nprend";
  public static final String PRS_PLUCKER = "application/prs.plucker";
  public static final String PRS_RDF_XML_CRYPT = "application/prs.rdf-xml-crypt";
  public static final String PRS_XSF_XML = "application/prs.xsf+xml";
  public static final String PSKC_XML = "application/pskc+xml";
  public static final String PVD_JSON = "application/pvd+json";
  public static final String RDF_XML = "application/rdf+xml";
  public static final String ROUTE_APD_XML = "application/route-apd+xml";
  public static final String ROUTE_S_TSID_XML = "application/route-s-tsid+xml";
  public static final String ROUTE_USD_XML = "application/route-usd+xml";
  public static final String QSIG = "application/QSIG";
  public static final String RAPTORFEC_APPLICATION = "application/raptorfec";
  public static final String RDAP_JSON = "application/rdap+json";
  public static final String REGINFO_XML = "application/reginfo+xml";
  public static final String RELAX_NG_COMPACT_SYNTAX = "application/relax-ng-compact-syntax";
  public static final String REMOTE_PRINTING = "application/remote-printing";
  public static final String REPUTON_JSON = "application/reputon+json";
  public static final String RESOURCE_LISTS_DIFF_XML = "application/resource-lists-diff+xml";
  public static final String RESOURCE_LISTS_XML = "application/resource-lists+xml";
  public static final String RFC_XML = "application/rfc+xml";
  public static final String RISCOS = "application/riscos";
  public static final String RLMI_XML = "application/rlmi+xml";
  public static final String RLS_SERVICES_XML = "application/rls-services+xml";
  public static final String RPKI_GHOSTBUSTERS = "application/rpki-ghostbusters";
  public static final String RPKI_MANIFEST = "application/rpki-manifest";
  public static final String RPKI_PUBLICATION = "application/rpki-publication";
  public static final String RPKI_ROA = "application/rpki-roa";
  public static final String RPKI_UPDOWN = "application/rpki-updown";
  public static final String RTF_APPLICATION = "application/rtf";
  public static final String RTPLOOPBACK_APPLICATION = "application/rtploopback";
  public static final String RTX_APPLICATION = "application/rtx";
  public static final String SAMLASSERTION_XML = "application/samlassertion+xml";
  public static final String SAMLMETADATA_XML = "application/samlmetadata+xml";
  public static final String SARIF_EXTERNAL_PROPERTIES_JSON = "application/sarif-external-properties+json";
  public static final String SARIF_JSON = "application/sarif+json";
  public static final String SBE = "application/sbe";
  public static final String SBML_XML = "application/sbml+xml";
  public static final String SCAIP_XML = "application/scaip+xml";
  public static final String SCIM_JSON = "application/scim+json";
  public static final String SCVP_CV_REQUEST = "application/scvp-cv-request";
  public static final String SCVP_CV_RESPONSE = "application/scvp-cv-response";
  public static final String SCVP_VP_REQUEST = "application/scvp-vp-request";
  public static final String SCVP_VP_RESPONSE = "application/scvp-vp-response";
  public static final String SDP = "application/sdp";
  public static final String SECEVENT_JWT = "application/secevent+jwt";
  public static final String SENML_ETCH_CBOR = "application/senml-etch+cbor";
  public static final String SENML_ETCH_JSON = "application/senml-etch+json";
  public static final String SENML_EXI = "application/senml-exi";
  public static final String SENML_CBOR = "application/senml+cbor";
  public static final String SENML_JSON = "application/senml+json";
  public static final String SENML_XML = "application/senml+xml";
  public static final String SENSML_EXI = "application/sensml-exi";
  public static final String SENSML_CBOR = "application/sensml+cbor";
  public static final String SENSML_JSON = "application/sensml+json";
  public static final String SENSML_XML = "application/sensml+xml";
  public static final String SEP_EXI = "application/sep-exi";
  public static final String SEP_XML = "application/sep+xml";
  public static final String SESSION_INFO = "application/session-info";
  public static final String SET_PAYMENT = "application/set-payment";
  public static final String SET_PAYMENT_INITIATION = "application/set-payment-initiation";
  public static final String SET_REGISTRATION = "application/set-registration";
  public static final String SET_REGISTRATION_INITIATION = "application/set-registration-initiation";
  public static final String SGML_APPLICATION = "application/SGML";
  public static final String SGML_OPEN_CATALOG = "application/sgml-open-catalog";
  public static final String SHF_XML = "application/shf+xml";
  public static final String SIEVE = "application/sieve";
  public static final String SIMPLE_FILTER_XML = "application/simple-filter+xml";
  public static final String SIMPLE_MESSAGE_SUMMARY = "application/simple-message-summary";
  public static final String SIMPLESYMBOLCONTAINER = "application/simpleSymbolContainer";
  public static final String SIPC = "application/sipc";
  public static final String SLATE = "application/slate";
  public static final String SMIL = "application/smil";
  public static final String SMIL_XML = "application/smil+xml";
  public static final String SMPTE336M = "application/smpte336m";
  public static final String SOAP_FASTINFOSET = "application/soap+fastinfoset";
  public static final String SOAP_XML = "application/soap+xml";
  public static final String SPARQL_QUERY = "application/sparql-query";
  public static final String SPDX_JSON = "application/spdx+json";
  public static final String SPARQL_RESULTS_XML = "application/sparql-results+xml";
  public static final String SPIRITS_EVENT_XML = "application/spirits-event+xml";
  public static final String SQL = "application/sql";
  public static final String SRGS = "application/srgs";
  public static final String SRGS_XML = "application/srgs+xml";
  public static final String SRU_XML = "application/sru+xml";
  public static final String SSML_XML = "application/ssml+xml";
  public static final String STIX_JSON = "application/stix+json";
  public static final String SWID_XML = "application/swid+xml";
  public static final String TAMP_APEX_UPDATE = "application/tamp-apex-update";
  public static final String TAMP_APEX_UPDATE_CONFIRM = "application/tamp-apex-update-confirm";
  public static final String TAMP_COMMUNITY_UPDATE = "application/tamp-community-update";
  public static final String TAMP_COMMUNITY_UPDATE_CONFIRM = "application/tamp-community-update-confirm";
  public static final String TAMP_ERROR = "application/tamp-error";
  public static final String TAMP_SEQUENCE_ADJUST = "application/tamp-sequence-adjust";
  public static final String TAMP_SEQUENCE_ADJUST_CONFIRM = "application/tamp-sequence-adjust-confirm";
  public static final String TAMP_STATUS_QUERY = "application/tamp-status-query";
  public static final String TAMP_STATUS_RESPONSE = "application/tamp-status-response";
  public static final String TAMP_UPDATE = "application/tamp-update";
  public static final String TAMP_UPDATE_CONFIRM = "application/tamp-update-confirm";
  public static final String TAXII_JSON = "application/taxii+json";
  public static final String TD_JSON = "application/td+json";
  public static final String TEI_XML = "application/tei+xml";
  public static final String TETRA_ISI = "application/TETRA_ISI";
  public static final String THRAUD_XML = "application/thraud+xml";
  public static final String TIMESTAMP_QUERY = "application/timestamp-query";
  public static final String TIMESTAMP_REPLY = "application/timestamp-reply";
  public static final String TIMESTAMPED_DATA = "application/timestamped-data";
  public static final String TLSRPT_GZIP = "application/tlsrpt+gzip";
  public static final String TLSRPT_JSON = "application/tlsrpt+json";
  public static final String TNAUTHLIST = "application/tnauthlist";
  public static final String TOKEN_INTROSPECTION_JWT = "application/token-introspection+jwt";
  public static final String TRICKLE_ICE_SDPFRAG = "application/trickle-ice-sdpfrag";
  public static final String TRIG = "application/trig";
  public static final String TTML_XML = "application/ttml+xml";
  public static final String TVE_TRIGGER = "application/tve-trigger";
  public static final String TZIF = "application/tzif";
  public static final String TZIF_LEAP = "application/tzif-leap";
  public static final String ULPFEC_APPLICATION = "application/ulpfec";
  public static final String URC_GRPSHEET_XML = "application/urc-grpsheet+xml";
  public static final String URC_RESSHEET_XML = "application/urc-ressheet+xml";
  public static final String URC_TARGETDESC_XML = "application/urc-targetdesc+xml";
  public static final String URC_UISOCKETDESC_XML = "application/urc-uisocketdesc+xml";
  public static final String VCARD_JSON = "application/vcard+json";
  public static final String VCARD_XML = "application/vcard+xml";
  public static final String VEMMI = "application/vemmi";
  public static final String VND_1000MINDS_DECISION_MODEL_XML = "application/vnd.1000minds.decision-model+xml";
  public static final String VND_3GPP_5GNAS = "application/vnd.3gpp.5gnas";
  public static final String VND_3GPP_ACCESS_TRANSFER_EVENTS_XML = "application/vnd.3gpp.access-transfer-events+xml";
  public static final String VND_3GPP_BSF_XML = "application/vnd.3gpp.bsf+xml";
  public static final String VND_3GPP_GMOP_XML = "application/vnd.3gpp.GMOP+xml";
  public static final String VND_3GPP_GTPC = "application/vnd.3gpp.gtpc";
  public static final String VND_3GPP_INTERWORKING_DATA = "application/vnd.3gpp.interworking-data";
  public static final String VND_3GPP_LPP = "application/vnd.3gpp.lpp";
  public static final String VND_3GPP_MC_SIGNALLING_EAR = "application/vnd.3gpp.mc-signalling-ear";
  public static final String VND_3GPP_MCDATA_AFFILIATION_COMMAND_XML = "application/vnd.3gpp.mcdata-affiliation-command+xml";
  public static final String VND_3GPP_MCDATA_INFO_XML = "application/vnd.3gpp.mcdata-info+xml";
  public static final String VND_3GPP_MCDATA_PAYLOAD = "application/vnd.3gpp.mcdata-payload";
  public static final String VND_3GPP_MCDATA_SERVICE_CONFIG_XML = "application/vnd.3gpp.mcdata-service-config+xml";
  public static final String VND_3GPP_MCDATA_SIGNALLING = "application/vnd.3gpp.mcdata-signalling";
  public static final String VND_3GPP_MCDATA_UE_CONFIG_XML = "application/vnd.3gpp.mcdata-ue-config+xml";
  public static final String VND_3GPP_MCDATA_USER_PROFILE_XML = "application/vnd.3gpp.mcdata-user-profile+xml";
  public static final String VND_3GPP_MCPTT_AFFILIATION_COMMAND_XML = "application/vnd.3gpp.mcptt-affiliation-command+xml";
  public static final String VND_3GPP_MCPTT_FLOOR_REQUEST_XML = "application/vnd.3gpp.mcptt-floor-request+xml";
  public static final String VND_3GPP_MCPTT_INFO_XML = "application/vnd.3gpp.mcptt-info+xml";
  public static final String VND_3GPP_MCPTT_LOCATION_INFO_XML = "application/vnd.3gpp.mcptt-location-info+xml";
  public static final String VND_3GPP_MCPTT_MBMS_USAGE_INFO_XML = "application/vnd.3gpp.mcptt-mbms-usage-info+xml";
  public static final String VND_3GPP_MCPTT_SERVICE_CONFIG_XML = "application/vnd.3gpp.mcptt-service-config+xml";
  public static final String VND_3GPP_MCPTT_SIGNED_XML = "application/vnd.3gpp.mcptt-signed+xml";
  public static final String VND_3GPP_MCPTT_UE_CONFIG_XML = "application/vnd.3gpp.mcptt-ue-config+xml";
  public static final String VND_3GPP_MCPTT_UE_INIT_CONFIG_XML = "application/vnd.3gpp.mcptt-ue-init-config+xml";
  public static final String VND_3GPP_MCPTT_USER_PROFILE_XML = "application/vnd.3gpp.mcptt-user-profile+xml";
  public static final String VND_3GPP_MCVIDEO_AFFILIATION_COMMAND_XML = "application/vnd.3gpp.mcvideo-affiliation-command+xml";
  public static final String VND_3GPP_MCVIDEO_AFFILIATION_INFO_XML = "application/vnd.3gpp.mcvideo-affiliation-info+xml";
  public static final String VND_3GPP_MCVIDEO_INFO_XML = "application/vnd.3gpp.mcvideo-info+xml";
  public static final String VND_3GPP_MCVIDEO_LOCATION_INFO_XML = "application/vnd.3gpp.mcvideo-location-info+xml";
  public static final String VND_3GPP_MCVIDEO_MBMS_USAGE_INFO_XML = "application/vnd.3gpp.mcvideo-mbms-usage-info+xml";
  public static final String VND_3GPP_MCVIDEO_SERVICE_CONFIG_XML = "application/vnd.3gpp.mcvideo-service-config+xml";
  public static final String VND_3GPP_MCVIDEO_TRANSMISSION_REQUEST_XML = "application/vnd.3gpp.mcvideo-transmission-request+xml";
  public static final String VND_3GPP_MCVIDEO_UE_CONFIG_XML = "application/vnd.3gpp.mcvideo-ue-config+xml";
  public static final String VND_3GPP_MCVIDEO_USER_PROFILE_XML = "application/vnd.3gpp.mcvideo-user-profile+xml";
  public static final String VND_3GPP_MID_CALL_XML = "application/vnd.3gpp.mid-call+xml";
  public static final String VND_3GPP_NGAP = "application/vnd.3gpp.ngap";
  public static final String VND_3GPP_PFCP = "application/vnd.3gpp.pfcp";
  public static final String VND_3GPP_PIC_BW_LARGE = "application/vnd.3gpp.pic-bw-large";
  public static final String VND_3GPP_PIC_BW_SMALL = "application/vnd.3gpp.pic-bw-small";
  public static final String VND_3GPP_PIC_BW_VAR = "application/vnd.3gpp.pic-bw-var";
  public static final String VND_3GPP_PROSE_PC3CH_XML = "application/vnd.3gpp-prose-pc3ch+xml";
  public static final String VND_3GPP_PROSE_XML = "application/vnd.3gpp-prose+xml";
  public static final String VND_3GPP_S1AP = "application/vnd.3gpp.s1ap";
  public static final String VND_3GPP_SMS = "application/vnd.3gpp.sms";
  public static final String VND_3GPP_SMS_XML = "application/vnd.3gpp.sms+xml";
  public static final String VND_3GPP_SRVCC_EXT_XML = "application/vnd.3gpp.srvcc-ext+xml";
  public static final String VND_3GPP_SRVCC_INFO_XML = "application/vnd.3gpp.SRVCC-info+xml";
  public static final String VND_3GPP_STATE_AND_EVENT_INFO_XML = "application/vnd.3gpp.state-and-event-info+xml";
  public static final String VND_3GPP_USSD_XML = "application/vnd.3gpp.ussd+xml";
  public static final String VND_3GPP_V2X_LOCAL_SERVICE_INFORMATION = "application/vnd.3gpp-v2x-local-service-information";
  public static final String VND_3GPP2_BCMCSINFO_XML = "application/vnd.3gpp2.bcmcsinfo+xml";
  public static final String VND_3GPP2_SMS = "application/vnd.3gpp2.sms";
  public static final String VND_3GPP2_TCAP = "application/vnd.3gpp2.tcap";
  public static final String VND_3LIGHTSSOFTWARE_IMAGESCAL = "application/vnd.3lightssoftware.imagescal";
  public static final String VND_3M_POST_IT_NOTES = "application/vnd.3M.Post-it-Notes";
  public static final String VND_ACCPAC_SIMPLY_ASO = "application/vnd.accpac.simply.aso";
  public static final String VND_ACCPAC_SIMPLY_IMP = "application/vnd.accpac.simply.imp";
  public static final String VND_ACUCOBOL = "application/vnd.acucobol";
  public static final String VND_ACUCORP = "application/vnd.acucorp";
  public static final String VND_ADOBE_FLASH_MOVIE = "application/vnd.adobe.flash.movie";
  public static final String VND_ADOBE_FORMSCENTRAL_FCDT = "application/vnd.adobe.formscentral.fcdt";
  public static final String VND_ADOBE_FXP = "application/vnd.adobe.fxp";
  public static final String VND_ADOBE_PARTIAL_UPLOAD = "application/vnd.adobe.partial-upload";
  public static final String VND_ADOBE_XDP_XML = "application/vnd.adobe.xdp+xml";
  public static final String VND_ADOBE_XFDF = "application/vnd.adobe.xfdf";
  public static final String VND_AETHER_IMP = "application/vnd.aether.imp";
  public static final String VND_AFPC_AFPLINEDATA = "application/vnd.afpc.afplinedata";
  public static final String VND_AFPC_AFPLINEDATA_PAGEDEF = "application/vnd.afpc.afplinedata-pagedef";
  public static final String VND_AFPC_CMOCA_CMRESOURCE = "application/vnd.afpc.cmoca-cmresource";
  public static final String VND_AFPC_FOCA_CHARSET = "application/vnd.afpc.foca-charset";
  public static final String VND_AFPC_FOCA_CODEDFONT = "application/vnd.afpc.foca-codedfont";
  public static final String VND_AFPC_FOCA_CODEPAGE = "application/vnd.afpc.foca-codepage";
  public static final String VND_AFPC_MODCA = "application/vnd.afpc.modca";
  public static final String VND_AFPC_MODCA_CMTABLE = "application/vnd.afpc.modca-cmtable";
  public static final String VND_AFPC_MODCA_FORMDEF = "application/vnd.afpc.modca-formdef";
  public static final String VND_AFPC_MODCA_MEDIUMMAP = "application/vnd.afpc.modca-mediummap";
  public static final String VND_AFPC_MODCA_OBJECTCONTAINER = "application/vnd.afpc.modca-objectcontainer";
  public static final String VND_AFPC_MODCA_OVERLAY = "application/vnd.afpc.modca-overlay";
  public static final String VND_AFPC_MODCA_PAGESEGMENT = "application/vnd.afpc.modca-pagesegment";
  public static final String VND_AGE = "application/vnd.age";
  public static final String VND_AH_BARCODE = "application/vnd.ah-barcode";
  public static final String VND_AHEAD_SPACE = "application/vnd.ahead.space";
  public static final String VND_AIRZIP_FILESECURE_AZF = "application/vnd.airzip.filesecure.azf";
  public static final String VND_AIRZIP_FILESECURE_AZS = "application/vnd.airzip.filesecure.azs";
  public static final String VND_AMADEUS_JSON = "application/vnd.amadeus+json";
  public static final String VND_AMAZON_MOBI8_EBOOK = "application/vnd.amazon.mobi8-ebook";
  public static final String VND_AMERICANDYNAMICS_ACC = "application/vnd.americandynamics.acc";
  public static final String VND_AMIGA_AMI = "application/vnd.amiga.ami";
  public static final String VND_AMUNDSEN_MAZE_XML = "application/vnd.amundsen.maze+xml";
  public static final String VND_ANDROID_OTA = "application/vnd.android.ota";
  public static final String VND_ANKI = "application/vnd.anki";
  public static final String VND_ANSER_WEB_CERTIFICATE_ISSUE_INITIATION = "application/vnd.anser-web-certificate-issue-initiation";
  public static final String VND_ANTIX_GAME_COMPONENT = "application/vnd.antix.game-component";
  public static final String VND_APACHE_ARROW_FILE = "application/vnd.apache.arrow.file";
  public static final String VND_APACHE_ARROW_STREAM = "application/vnd.apache.arrow.stream";
  public static final String VND_APACHE_THRIFT_BINARY = "application/vnd.apache.thrift.binary";
  public static final String VND_APACHE_THRIFT_COMPACT = "application/vnd.apache.thrift.compact";
  public static final String VND_APACHE_THRIFT_JSON = "application/vnd.apache.thrift.json";
  public static final String VND_API_JSON = "application/vnd.api+json";
  public static final String VND_APLEXTOR_WARRP_JSON = "application/vnd.aplextor.warrp+json";
  public static final String VND_APOTHEKENDE_RESERVATION_JSON = "application/vnd.apothekende.reservation+json";
  public static final String VND_APPLE_INSTALLER_XML = "application/vnd.apple.installer+xml";
  public static final String VND_APPLE_KEYNOTE = "application/vnd.apple.keynote";
  public static final String VND_APPLE_MPEGURL = "application/vnd.apple.mpegurl";
  public static final String VND_APPLE_NUMBERS = "application/vnd.apple.numbers";
  public static final String VND_APPLE_PAGES = "application/vnd.apple.pages";
  public static final String VND_ARASTRA_SWI = "application/vnd.arastra.swi";
  public static final String VND_ARISTANETWORKS_SWI = "application/vnd.aristanetworks.swi";
  public static final String VND_ARTISAN_JSON = "application/vnd.artisan+json";
  public static final String VND_ARTSQUARE = "application/vnd.artsquare";
  public static final String VND_ASTRAEA_SOFTWARE_IOTA = "application/vnd.astraea-software.iota";
  public static final String VND_AUDIOGRAPH = "application/vnd.audiograph";
  public static final String VND_AUTOPACKAGE = "application/vnd.autopackage";
  public static final String VND_AVALON_JSON = "application/vnd.avalon+json";
  public static final String VND_AVISTAR_XML = "application/vnd.avistar+xml";
  public static final String VND_BALSAMIQ_BMML_XML = "application/vnd.balsamiq.bmml+xml";
  public static final String VND_BANANA_ACCOUNTING = "application/vnd.banana-accounting";
  public static final String VND_BBF_USP_ERROR = "application/vnd.bbf.usp.error";
  public static final String VND_BBF_USP_MSG = "application/vnd.bbf.usp.msg";
  public static final String VND_BBF_USP_MSG_JSON = "application/vnd.bbf.usp.msg+json";
  public static final String VND_BALSAMIQ_BMPR = "application/vnd.balsamiq.bmpr";
  public static final String VND_BEKITZUR_STECH_JSON = "application/vnd.bekitzur-stech+json";
  public static final String VND_BINT_MED_CONTENT = "application/vnd.bint.med-content";
  public static final String VND_BIOPAX_RDF_XML = "application/vnd.biopax.rdf+xml";
  public static final String VND_BLINK_IDB_VALUE_WRAPPER = "application/vnd.blink-idb-value-wrapper";
  public static final String VND_BLUEICE_MULTIPASS = "application/vnd.blueice.multipass";
  public static final String VND_BLUETOOTH_EP_OOB = "application/vnd.bluetooth.ep.oob";
  public static final String VND_BLUETOOTH_LE_OOB = "application/vnd.bluetooth.le.oob";
  public static final String VND_BMI = "application/vnd.bmi";
  public static final String VND_BPF = "application/vnd.bpf";
  public static final String VND_BPF3 = "application/vnd.bpf3";
  public static final String VND_BUSINESSOBJECTS = "application/vnd.businessobjects";
  public static final String VND_BYU_UAPI_JSON = "application/vnd.byu.uapi+json";
  public static final String VND_CAB_JSCRIPT = "application/vnd.cab-jscript";
  public static final String VND_CANON_CPDL = "application/vnd.canon-cpdl";
  public static final String VND_CANON_LIPS = "application/vnd.canon-lips";
  public static final String VND_CAPASYSTEMS_PG_JSON = "application/vnd.capasystems-pg+json";
  public static final String VND_CENDIO_THINLINC_CLIENTCONF = "application/vnd.cendio.thinlinc.clientconf";
  public static final String VND_CENTURY_SYSTEMS_TCP_STREAM = "application/vnd.century-systems.tcp_stream";
  public static final String VND_CHEMDRAW_XML = "application/vnd.chemdraw+xml";
  public static final String VND_CHESS_PGN = "application/vnd.chess-pgn";
  public static final String VND_CHIPNUTS_KARAOKE_MMD = "application/vnd.chipnuts.karaoke-mmd";
  public static final String VND_CIEDI = "application/vnd.ciedi";
  public static final String VND_CINDERELLA = "application/vnd.cinderella";
  public static final String VND_CIRPACK_ISDN_EXT = "application/vnd.cirpack.isdn-ext";
  public static final String VND_CITATIONSTYLES_STYLE_XML = "application/vnd.citationstyles.style+xml";
  public static final String VND_CLAYMORE = "application/vnd.claymore";
  public static final String VND_CLOANTO_RP9 = "application/vnd.cloanto.rp9";
  public static final String VND_CLONK_C4GROUP = "application/vnd.clonk.c4group";
  public static final String VND_CLUETRUST_CARTOMOBILE_CONFIG = "application/vnd.cluetrust.cartomobile-config";
  public static final String VND_CLUETRUST_CARTOMOBILE_CONFIG_PKG = "application/vnd.cluetrust.cartomobile-config-pkg";
  public static final String VND_COFFEESCRIPT = "application/vnd.coffeescript";
  public static final String VND_COLLABIO_XODOCUMENTS_DOCUMENT = "application/vnd.collabio.xodocuments.document";
  public static final String VND_COLLABIO_XODOCUMENTS_DOCUMENT_TEMPLATE = "application/vnd.collabio.xodocuments.document-template";
  public static final String VND_COLLABIO_XODOCUMENTS_PRESENTATION = "application/vnd.collabio.xodocuments.presentation";
  public static final String VND_COLLABIO_XODOCUMENTS_PRESENTATION_TEMPLATE = "application/vnd.collabio.xodocuments.presentation-template";
  public static final String VND_COLLABIO_XODOCUMENTS_SPREADSHEET = "application/vnd.collabio.xodocuments.spreadsheet";
  public static final String VND_COLLABIO_XODOCUMENTS_SPREADSHEET_TEMPLATE = "application/vnd.collabio.xodocuments.spreadsheet-template";
  public static final String VND_COLLECTION_DOC_JSON = "application/vnd.collection.doc+json";
  public static final String VND_COLLECTION_JSON = "application/vnd.collection+json";
  public static final String VND_COLLECTION_NEXT_JSON = "application/vnd.collection.next+json";
  public static final String VND_COMICBOOK_RAR = "application/vnd.comicbook-rar";
  public static final String VND_COMICBOOK_ZIP = "application/vnd.comicbook+zip";
  public static final String VND_COMMERCE_BATTELLE = "application/vnd.commerce-battelle";
  public static final String VND_COMMONSPACE = "application/vnd.commonspace";
  public static final String VND_COREOS_IGNITION_JSON = "application/vnd.coreos.ignition+json";
  public static final String VND_COSMOCALLER = "application/vnd.cosmocaller";
  public static final String VND_CONTACT_CMSG = "application/vnd.contact.cmsg";
  public static final String VND_CRICK_CLICKER = "application/vnd.crick.clicker";
  public static final String VND_CRICK_CLICKER_KEYBOARD = "application/vnd.crick.clicker.keyboard";
  public static final String VND_CRICK_CLICKER_PALETTE = "application/vnd.crick.clicker.palette";
  public static final String VND_CRICK_CLICKER_TEMPLATE = "application/vnd.crick.clicker.template";
  public static final String VND_CRICK_CLICKER_WORDBANK = "application/vnd.crick.clicker.wordbank";
  public static final String VND_CRITICALTOOLS_WBS_XML = "application/vnd.criticaltools.wbs+xml";
  public static final String VND_CRYPTII_PIPE_JSON = "application/vnd.cryptii.pipe+json";
  public static final String VND_CRYPTO_SHADE_FILE = "application/vnd.crypto-shade-file";
  public static final String VND_CRYPTOMATOR_ENCRYPTED = "application/vnd.cryptomator.encrypted";
  public static final String VND_CRYPTOMATOR_VAULT = "application/vnd.cryptomator.vault";
  public static final String VND_CTC_POSML = "application/vnd.ctc-posml";
  public static final String VND_CTCT_WS_XML = "application/vnd.ctct.ws+xml";
  public static final String VND_CUPS_PDF = "application/vnd.cups-pdf";
  public static final String VND_CUPS_POSTSCRIPT = "application/vnd.cups-postscript";
  public static final String VND_CUPS_PPD = "application/vnd.cups-ppd";
  public static final String VND_CUPS_RASTER = "application/vnd.cups-raster";
  public static final String VND_CUPS_RAW = "application/vnd.cups-raw";
  public static final String VND_CURL_APPLICATION = "application/vnd.curl";
  public static final String VND_CYAN_DEAN_ROOT_XML = "application/vnd.cyan.dean.root+xml";
  public static final String VND_CYBANK = "application/vnd.cybank";
  public static final String VND_CYCLONEDX_JSON = "application/vnd.cyclonedx+json";
  public static final String VND_CYCLONEDX_XML = "application/vnd.cyclonedx+xml";
  public static final String VND_D2L_COURSEPACKAGE1P0_ZIP = "application/vnd.d2l.coursepackage1p0+zip";
  public static final String VND_D3M_DATASET = "application/vnd.d3m-dataset";
  public static final String VND_D3M_PROBLEM = "application/vnd.d3m-problem";
  public static final String VND_DART = "application/vnd.dart";
  public static final String VND_DATA_VISION_RDZ = "application/vnd.data-vision.rdz";
  public static final String VND_DATAPACKAGE_JSON = "application/vnd.datapackage+json";
  public static final String VND_DATARESOURCE_JSON = "application/vnd.dataresource+json";
  public static final String VND_DBF = "application/vnd.dbf";
  public static final String VND_DEBIAN_BINARY_PACKAGE = "application/vnd.debian.binary-package";
  public static final String VND_DECE_DATA = "application/vnd.dece.data";
  public static final String VND_DECE_TTML_XML = "application/vnd.dece.ttml+xml";
  public static final String VND_DECE_UNSPECIFIED = "application/vnd.dece.unspecified";
  public static final String VND_DECE_ZIP = "application/vnd.dece.zip";
  public static final String VND_DENOVO_FCSELAYOUT_LINK = "application/vnd.denovo.fcselayout-link";
  public static final String VND_DESMUME_MOVIE = "application/vnd.desmume.movie";
  public static final String VND_DIR_BI_PLATE_DL_NOSUFFIX = "application/vnd.dir-bi.plate-dl-nosuffix";
  public static final String VND_DM_DELEGATION_XML = "application/vnd.dm.delegation+xml";
  public static final String VND_DNA = "application/vnd.dna";
  public static final String VND_DOCUMENT_JSON = "application/vnd.document+json";
  public static final String VND_DOLBY_MOBILE_1 = "application/vnd.dolby.mobile.1";
  public static final String VND_DOLBY_MOBILE_2 = "application/vnd.dolby.mobile.2";
  public static final String VND_DOREMIR_SCORECLOUD_BINARY_DOCUMENT = "application/vnd.doremir.scorecloud-binary-document";
  public static final String VND_DPGRAPH = "application/vnd.dpgraph";
  public static final String VND_DREAMFACTORY = "application/vnd.dreamfactory";
  public static final String VND_DRIVE_JSON = "application/vnd.drive+json";
  public static final String VND_DTG_LOCAL = "application/vnd.dtg.local";
  public static final String VND_DTG_LOCAL_FLASH = "application/vnd.dtg.local.flash";
  public static final String VND_DTG_LOCAL_HTML = "application/vnd.dtg.local.html";
  public static final String VND_DVB_AIT = "application/vnd.dvb.ait";
  public static final String VND_DVB_DVBISL_XML = "application/vnd.dvb.dvbisl+xml";
  public static final String VND_DVB_DVBJ = "application/vnd.dvb.dvbj";
  public static final String VND_DVB_ESGCONTAINER = "application/vnd.dvb.esgcontainer";
  public static final String VND_DVB_IPDCDFTNOTIFACCESS = "application/vnd.dvb.ipdcdftnotifaccess";
  public static final String VND_DVB_IPDCESGACCESS = "application/vnd.dvb.ipdcesgaccess";
  public static final String VND_DVB_IPDCESGACCESS2 = "application/vnd.dvb.ipdcesgaccess2";
  public static final String VND_DVB_IPDCESGPDD = "application/vnd.dvb.ipdcesgpdd";
  public static final String VND_DVB_IPDCROAMING = "application/vnd.dvb.ipdcroaming";
  public static final String VND_DVB_IPTV_ALFEC_BASE = "application/vnd.dvb.iptv.alfec-base";
  public static final String VND_DVB_IPTV_ALFEC_ENHANCEMENT = "application/vnd.dvb.iptv.alfec-enhancement";
  public static final String VND_DVB_NOTIF_AGGREGATE_ROOT_XML = "application/vnd.dvb.notif-aggregate-root+xml";
  public static final String VND_DVB_NOTIF_CONTAINER_XML = "application/vnd.dvb.notif-container+xml";
  public static final String VND_DVB_NOTIF_GENERIC_XML = "application/vnd.dvb.notif-generic+xml";
  public static final String VND_DVB_NOTIF_IA_MSGLIST_XML = "application/vnd.dvb.notif-ia-msglist+xml";
  public static final String VND_DVB_NOTIF_IA_REGISTRATION_REQUEST_XML = "application/vnd.dvb.notif-ia-registration-request+xml";
  public static final String VND_DVB_NOTIF_IA_REGISTRATION_RESPONSE_XML = "application/vnd.dvb.notif-ia-registration-response+xml";
  public static final String VND_DVB_NOTIF_INIT_XML = "application/vnd.dvb.notif-init+xml";
  public static final String VND_DVB_PFR = "application/vnd.dvb.pfr";
  public static final String VND_DVB_SERVICE = "application/vnd.dvb.service";
  public static final String VND_DXR = "application/vnd.dxr";
  public static final String VND_DYNAGEO = "application/vnd.dynageo";
  public static final String VND_DZR = "application/vnd.dzr";
  public static final String VND_EASYKARAOKE_CDGDOWNLOAD = "application/vnd.easykaraoke.cdgdownload";
  public static final String VND_ECIP_RLP = "application/vnd.ecip.rlp";
  public static final String VND_ECDIS_UPDATE = "application/vnd.ecdis-update";
  public static final String VND_ECLIPSE_DITTO_JSON = "application/vnd.eclipse.ditto+json";
  public static final String VND_ECOWIN_CHART = "application/vnd.ecowin.chart";
  public static final String VND_ECOWIN_FILEREQUEST = "application/vnd.ecowin.filerequest";
  public static final String VND_ECOWIN_FILEUPDATE = "application/vnd.ecowin.fileupdate";
  public static final String VND_ECOWIN_SERIES = "application/vnd.ecowin.series";
  public static final String VND_ECOWIN_SERIESREQUEST = "application/vnd.ecowin.seriesrequest";
  public static final String VND_ECOWIN_SERIESUPDATE = "application/vnd.ecowin.seriesupdate";
  public static final String VND_EFI_IMG = "application/vnd.efi.img";
  public static final String VND_EFI_ISO = "application/vnd.efi.iso";
  public static final String VND_EMCLIENT_ACCESSREQUEST_XML = "application/vnd.emclient.accessrequest+xml";
  public static final String VND_ENLIVEN = "application/vnd.enliven";
  public static final String VND_ENPHASE_ENVOY = "application/vnd.enphase.envoy";
  public static final String VND_EPRINTS_DATA_XML = "application/vnd.eprints.data+xml";
  public static final String VND_EPSON_ESF = "application/vnd.epson.esf";
  public static final String VND_EPSON_MSF = "application/vnd.epson.msf";
  public static final String VND_EPSON_QUICKANIME = "application/vnd.epson.quickanime";
  public static final String VND_EPSON_SALT = "application/vnd.epson.salt";
  public static final String VND_EPSON_SSF = "application/vnd.epson.ssf";
  public static final String VND_ERICSSON_QUICKCALL = "application/vnd.ericsson.quickcall";
  public static final String VND_ESPASS_ESPASS_ZIP = "application/vnd.espass-espass+zip";
  public static final String VND_ESZIGNO3_XML = "application/vnd.eszigno3+xml";
  public static final String VND_ETSI_AOC_XML = "application/vnd.etsi.aoc+xml";
  public static final String VND_ETSI_ASIC_S_ZIP = "application/vnd.etsi.asic-s+zip";
  public static final String VND_ETSI_ASIC_E_ZIP = "application/vnd.etsi.asic-e+zip";
  public static final String VND_ETSI_CUG_XML = "application/vnd.etsi.cug+xml";
  public static final String VND_ETSI_IPTVCOMMAND_XML = "application/vnd.etsi.iptvcommand+xml";
  public static final String VND_ETSI_IPTVDISCOVERY_XML = "application/vnd.etsi.iptvdiscovery+xml";
  public static final String VND_ETSI_IPTVPROFILE_XML = "application/vnd.etsi.iptvprofile+xml";
  public static final String VND_ETSI_IPTVSAD_BC_XML = "application/vnd.etsi.iptvsad-bc+xml";
  public static final String VND_ETSI_IPTVSAD_COD_XML = "application/vnd.etsi.iptvsad-cod+xml";
  public static final String VND_ETSI_IPTVSAD_NPVR_XML = "application/vnd.etsi.iptvsad-npvr+xml";
  public static final String VND_ETSI_IPTVSERVICE_XML = "application/vnd.etsi.iptvservice+xml";
  public static final String VND_ETSI_IPTVSYNC_XML = "application/vnd.etsi.iptvsync+xml";
  public static final String VND_ETSI_IPTVUEPROFILE_XML = "application/vnd.etsi.iptvueprofile+xml";
  public static final String VND_ETSI_MCID_XML = "application/vnd.etsi.mcid+xml";
  public static final String VND_ETSI_MHEG5 = "application/vnd.etsi.mheg5";
  public static final String VND_ETSI_OVERLOAD_CONTROL_POLICY_DATASET_XML = "application/vnd.etsi.overload-control-policy-dataset+xml";
  public static final String VND_ETSI_PSTN_XML = "application/vnd.etsi.pstn+xml";
  public static final String VND_ETSI_SCI_XML = "application/vnd.etsi.sci+xml";
  public static final String VND_ETSI_SIMSERVS_XML = "application/vnd.etsi.simservs+xml";
  public static final String VND_ETSI_TIMESTAMP_TOKEN = "application/vnd.etsi.timestamp-token";
  public static final String VND_ETSI_TSL_XML = "application/vnd.etsi.tsl+xml";
  public static final String VND_ETSI_TSL_DER = "application/vnd.etsi.tsl.der";
  public static final String VND_EU_KASPARIAN_CAR_JSON = "application/vnd.eu.kasparian.car+json";
  public static final String VND_EUDORA_DATA = "application/vnd.eudora.data";
  public static final String VND_EVOLV_ECIG_PROFILE = "application/vnd.evolv.ecig.profile";
  public static final String VND_EVOLV_ECIG_SETTINGS = "application/vnd.evolv.ecig.settings";
  public static final String VND_EVOLV_ECIG_THEME = "application/vnd.evolv.ecig.theme";
  public static final String VND_EXSTREAM_EMPOWER_ZIP = "application/vnd.exstream-empower+zip";
  public static final String VND_EXSTREAM_PACKAGE = "application/vnd.exstream-package";
  public static final String VND_EZPIX_ALBUM = "application/vnd.ezpix-album";
  public static final String VND_EZPIX_PACKAGE = "application/vnd.ezpix-package";
  public static final String VND_F_SECURE_MOBILE = "application/vnd.f-secure.mobile";
  public static final String VND_FASTCOPY_DISK_IMAGE = "application/vnd.fastcopy-disk-image";
  public static final String VND_FAMILYSEARCH_GEDCOM_ZIP = "application/vnd.familysearch.gedcom+zip";
  public static final String VND_FDF = "application/vnd.fdf";
  public static final String VND_FDSN_MSEED = "application/vnd.fdsn.mseed";
  public static final String VND_FDSN_SEED = "application/vnd.fdsn.seed";
  public static final String VND_FFSNS = "application/vnd.ffsns";
  public static final String VND_FICLAB_FLB_ZIP = "application/vnd.ficlab.flb+zip";
  public static final String VND_FILMIT_ZFC = "application/vnd.filmit.zfc";
  public static final String VND_FINTS = "application/vnd.fints";
  public static final String VND_FIREMONKEYS_CLOUDCELL = "application/vnd.firemonkeys.cloudcell";
  public static final String VND_FLOGRAPHIT = "application/vnd.FloGraphIt";
  public static final String VND_FLUXTIME_CLIP = "application/vnd.fluxtime.clip";
  public static final String VND_FONT_FONTFORGE_SFD = "application/vnd.font-fontforge-sfd";
  public static final String VND_FRAMEMAKER = "application/vnd.framemaker";
  public static final String VND_FROGANS_FNC = "application/vnd.frogans.fnc";
  public static final String VND_FROGANS_LTF = "application/vnd.frogans.ltf";
  public static final String VND_FSC_WEBLAUNCH = "application/vnd.fsc.weblaunch";
  public static final String VND_FUJIFILM_FB_DOCUWORKS = "application/vnd.fujifilm.fb.docuworks";
  public static final String VND_FUJIFILM_FB_DOCUWORKS_BINDER = "application/vnd.fujifilm.fb.docuworks.binder";
  public static final String VND_FUJIFILM_FB_DOCUWORKS_CONTAINER = "application/vnd.fujifilm.fb.docuworks.container";
  public static final String VND_FUJIFILM_FB_JFI_XML = "application/vnd.fujifilm.fb.jfi+xml";
  public static final String VND_FUJITSU_OASYS = "application/vnd.fujitsu.oasys";
  public static final String VND_FUJITSU_OASYS2 = "application/vnd.fujitsu.oasys2";
  public static final String VND_FUJITSU_OASYS3 = "application/vnd.fujitsu.oasys3";
  public static final String VND_FUJITSU_OASYSGP = "application/vnd.fujitsu.oasysgp";
  public static final String VND_FUJITSU_OASYSPRS = "application/vnd.fujitsu.oasysprs";
  public static final String VND_FUJIXEROX_ART4 = "application/vnd.fujixerox.ART4";
  public static final String VND_FUJIXEROX_ART_EX = "application/vnd.fujixerox.ART-EX";
  public static final String VND_FUJIXEROX_DDD = "application/vnd.fujixerox.ddd";
  public static final String VND_FUJIXEROX_DOCUWORKS = "application/vnd.fujixerox.docuworks";
  public static final String VND_FUJIXEROX_DOCUWORKS_BINDER = "application/vnd.fujixerox.docuworks.binder";
  public static final String VND_FUJIXEROX_DOCUWORKS_CONTAINER = "application/vnd.fujixerox.docuworks.container";
  public static final String VND_FUJIXEROX_HBPL = "application/vnd.fujixerox.HBPL";
  public static final String VND_FUT_MISNET = "application/vnd.fut-misnet";
  public static final String VND_FUTOIN_CBOR = "application/vnd.futoin+cbor";
  public static final String VND_FUTOIN_JSON = "application/vnd.futoin+json";
  public static final String VND_FUZZYSHEET = "application/vnd.fuzzysheet";
  public static final String VND_GENOMATIX_TUXEDO = "application/vnd.genomatix.tuxedo";
  public static final String VND_GENTICS_GRD_JSON = "application/vnd.gentics.grd+json";
  public static final String VND_GEO_JSON = "application/vnd.geo+json";
  public static final String VND_GEOCUBE_XML = "application/vnd.geocube+xml";
  public static final String VND_GEOGEBRA_FILE = "application/vnd.geogebra.file";
  public static final String VND_GEOGEBRA_SLIDES = "application/vnd.geogebra.slides";
  public static final String VND_GEOGEBRA_TOOL = "application/vnd.geogebra.tool";
  public static final String VND_GEOMETRY_EXPLORER = "application/vnd.geometry-explorer";
  public static final String VND_GEONEXT = "application/vnd.geonext";
  public static final String VND_GEOPLAN = "application/vnd.geoplan";
  public static final String VND_GEOSPACE = "application/vnd.geospace";
  public static final String VND_GERBER = "application/vnd.gerber";
  public static final String VND_GLOBALPLATFORM_CARD_CONTENT_MGT = "application/vnd.globalplatform.card-content-mgt";
  public static final String VND_GLOBALPLATFORM_CARD_CONTENT_MGT_RESPONSE = "application/vnd.globalplatform.card-content-mgt-response";
  public static final String VND_GMX = "application/vnd.gmx";
  public static final String VND_GNU_TALER_EXCHANGE_JSON = "application/vnd.gnu.taler.exchange+json";
  public static final String VND_GNU_TALER_MERCHANT_JSON = "application/vnd.gnu.taler.merchant+json";
  public static final String VND_GOOGLE_EARTH_KML_XML = "application/vnd.google-earth.kml+xml";
  public static final String VND_GOOGLE_EARTH_KMZ = "application/vnd.google-earth.kmz";
  public static final String VND_GOV_SK_E_FORM_XML = "application/vnd.gov.sk.e-form+xml";
  public static final String VND_GOV_SK_E_FORM_ZIP = "application/vnd.gov.sk.e-form+zip";
  public static final String VND_GOV_SK_XMLDATACONTAINER_XML = "application/vnd.gov.sk.xmldatacontainer+xml";
  public static final String VND_GRAFEQ = "application/vnd.grafeq";
  public static final String VND_GRIDMP = "application/vnd.gridmp";
  public static final String VND_GROOVE_ACCOUNT = "application/vnd.groove-account";
  public static final String VND_GROOVE_HELP = "application/vnd.groove-help";
  public static final String VND_GROOVE_IDENTITY_MESSAGE = "application/vnd.groove-identity-message";
  public static final String VND_GROOVE_INJECTOR = "application/vnd.groove-injector";
  public static final String VND_GROOVE_TOOL_MESSAGE = "application/vnd.groove-tool-message";
  public static final String VND_GROOVE_TOOL_TEMPLATE = "application/vnd.groove-tool-template";
  public static final String VND_GROOVE_VCARD = "application/vnd.groove-vcard";
  public static final String VND_HAL_JSON = "application/vnd.hal+json";
  public static final String VND_HAL_XML = "application/vnd.hal+xml";
  public static final String VND_HANDHELD_ENTERTAINMENT_XML = "application/vnd.HandHeld-Entertainment+xml";
  public static final String VND_HBCI = "application/vnd.hbci";
  public static final String VND_HC_JSON = "application/vnd.hc+json";
  public static final String VND_HCL_BIREPORTS = "application/vnd.hcl-bireports";
  public static final String VND_HDT = "application/vnd.hdt";
  public static final String VND_HEROKU_JSON = "application/vnd.heroku+json";
  public static final String VND_HHE_LESSON_PLAYER = "application/vnd.hhe.lesson-player";
  public static final String VND_HL7CDA_XML = "application/vnd.hl7cda+xml";
  public static final String VND_HL7V2_XML = "application/vnd.hl7v2+xml";
  public static final String VND_HP_HPGL = "application/vnd.hp-HPGL";
  public static final String VND_HP_HPID = "application/vnd.hp-hpid";
  public static final String VND_HP_HPS = "application/vnd.hp-hps";
  public static final String VND_HP_JLYT = "application/vnd.hp-jlyt";
  public static final String VND_HP_PCL = "application/vnd.hp-PCL";
  public static final String VND_HP_PCLXL = "application/vnd.hp-PCLXL";
  public static final String VND_HTTPHONE = "application/vnd.httphone";
  public static final String VND_HYDROSTATIX_SOF_DATA = "application/vnd.hydrostatix.sof-data";
  public static final String VND_HYPER_ITEM_JSON = "application/vnd.hyper-item+json";
  public static final String VND_HYPER_JSON = "application/vnd.hyper+json";
  public static final String VND_HYPERDRIVE_JSON = "application/vnd.hyperdrive+json";
  public static final String VND_HZN_3D_CROSSWORD = "application/vnd.hzn-3d-crossword";
  public static final String VND_IBM_AFPLINEDATA = "application/vnd.ibm.afplinedata";
  public static final String VND_IBM_ELECTRONIC_MEDIA = "application/vnd.ibm.electronic-media";
  public static final String VND_IBM_MINIPAY = "application/vnd.ibm.MiniPay";
  public static final String VND_IBM_MODCAP = "application/vnd.ibm.modcap";
  public static final String VND_IBM_RIGHTS_MANAGEMENT = "application/vnd.ibm.rights-management";
  public static final String VND_IBM_SECURE_CONTAINER = "application/vnd.ibm.secure-container";
  public static final String VND_ICCPROFILE = "application/vnd.iccprofile";
  public static final String VND_IEEE_1905 = "application/vnd.ieee.1905";
  public static final String VND_IGLOADER = "application/vnd.igloader";
  public static final String VND_IMAGEMETER_FOLDER_ZIP = "application/vnd.imagemeter.folder+zip";
  public static final String VND_IMAGEMETER_IMAGE_ZIP = "application/vnd.imagemeter.image+zip";
  public static final String VND_IMMERVISION_IVP = "application/vnd.immervision-ivp";
  public static final String VND_IMMERVISION_IVU = "application/vnd.immervision-ivu";
  public static final String VND_IMS_IMSCCV1P1 = "application/vnd.ims.imsccv1p1";
  public static final String VND_IMS_IMSCCV1P2 = "application/vnd.ims.imsccv1p2";
  public static final String VND_IMS_IMSCCV1P3 = "application/vnd.ims.imsccv1p3";
  public static final String VND_IMS_LIS_V2_RESULT_JSON = "application/vnd.ims.lis.v2.result+json";
  public static final String VND_IMS_LTI_V2_TOOLCONSUMERPROFILE_JSON = "application/vnd.ims.lti.v2.toolconsumerprofile+json";
  public static final String VND_IMS_LTI_V2_TOOLPROXY_ID_JSON = "application/vnd.ims.lti.v2.toolproxy.id+json";
  public static final String VND_IMS_LTI_V2_TOOLPROXY_JSON = "application/vnd.ims.lti.v2.toolproxy+json";
  public static final String VND_IMS_LTI_V2_TOOLSETTINGS_JSON = "application/vnd.ims.lti.v2.toolsettings+json";
  public static final String VND_IMS_LTI_V2_TOOLSETTINGS_SIMPLE_JSON = "application/vnd.ims.lti.v2.toolsettings.simple+json";
  public static final String VND_INFORMEDCONTROL_RMS_XML = "application/vnd.informedcontrol.rms+xml";
  public static final String VND_INFOTECH_PROJECT = "application/vnd.infotech.project";
  public static final String VND_INFOTECH_PROJECT_XML = "application/vnd.infotech.project+xml";
  public static final String VND_INFORMIX_VISIONARY = "application/vnd.informix-visionary";
  public static final String VND_INNOPATH_WAMP_NOTIFICATION = "application/vnd.innopath.wamp.notification";
  public static final String VND_INSORS_IGM = "application/vnd.insors.igm";
  public static final String VND_INTERCON_FORMNET = "application/vnd.intercon.formnet";
  public static final String VND_INTERGEO = "application/vnd.intergeo";
  public static final String VND_INTERTRUST_DIGIBOX = "application/vnd.intertrust.digibox";
  public static final String VND_INTERTRUST_NNCP = "application/vnd.intertrust.nncp";
  public static final String VND_INTU_QBO = "application/vnd.intu.qbo";
  public static final String VND_INTU_QFX = "application/vnd.intu.qfx";
  public static final String VND_IPTC_G2_CATALOGITEM_XML = "application/vnd.iptc.g2.catalogitem+xml";
  public static final String VND_IPTC_G2_CONCEPTITEM_XML = "application/vnd.iptc.g2.conceptitem+xml";
  public static final String VND_IPTC_G2_KNOWLEDGEITEM_XML = "application/vnd.iptc.g2.knowledgeitem+xml";
  public static final String VND_IPTC_G2_NEWSITEM_XML = "application/vnd.iptc.g2.newsitem+xml";
  public static final String VND_IPTC_G2_NEWSMESSAGE_XML = "application/vnd.iptc.g2.newsmessage+xml";
  public static final String VND_IPTC_G2_PACKAGEITEM_XML = "application/vnd.iptc.g2.packageitem+xml";
  public static final String VND_IPTC_G2_PLANNINGITEM_XML = "application/vnd.iptc.g2.planningitem+xml";
  public static final String VND_IPUNPLUGGED_RCPROFILE = "application/vnd.ipunplugged.rcprofile";
  public static final String VND_IREPOSITORY_PACKAGE_XML = "application/vnd.irepository.package+xml";
  public static final String VND_IS_XPR = "application/vnd.is-xpr";
  public static final String VND_ISAC_FCS = "application/vnd.isac.fcs";
  public static final String VND_JAM = "application/vnd.jam";
  public static final String VND_ISO11783_10_ZIP = "application/vnd.iso11783-10+zip";
  public static final String VND_JAPANNET_DIRECTORY_SERVICE = "application/vnd.japannet-directory-service";
  public static final String VND_JAPANNET_JPNSTORE_WAKEUP = "application/vnd.japannet-jpnstore-wakeup";
  public static final String VND_JAPANNET_PAYMENT_WAKEUP = "application/vnd.japannet-payment-wakeup";
  public static final String VND_JAPANNET_REGISTRATION = "application/vnd.japannet-registration";
  public static final String VND_JAPANNET_REGISTRATION_WAKEUP = "application/vnd.japannet-registration-wakeup";
  public static final String VND_JAPANNET_SETSTORE_WAKEUP = "application/vnd.japannet-setstore-wakeup";
  public static final String VND_JAPANNET_VERIFICATION = "application/vnd.japannet-verification";
  public static final String VND_JAPANNET_VERIFICATION_WAKEUP = "application/vnd.japannet-verification-wakeup";
  public static final String VND_JCP_JAVAME_MIDLET_RMS = "application/vnd.jcp.javame.midlet-rms";
  public static final String VND_JISP = "application/vnd.jisp";
  public static final String VND_JOOST_JODA_ARCHIVE = "application/vnd.joost.joda-archive";
  public static final String VND_JSK_ISDN_NGN = "application/vnd.jsk.isdn-ngn";
  public static final String VND_KAHOOTZ = "application/vnd.kahootz";
  public static final String VND_KDE_KARBON = "application/vnd.kde.karbon";
  public static final String VND_KDE_KCHART = "application/vnd.kde.kchart";
  public static final String VND_KDE_KFORMULA = "application/vnd.kde.kformula";
  public static final String VND_KDE_KIVIO = "application/vnd.kde.kivio";
  public static final String VND_KDE_KONTOUR = "application/vnd.kde.kontour";
  public static final String VND_KDE_KPRESENTER = "application/vnd.kde.kpresenter";
  public static final String VND_KDE_KSPREAD = "application/vnd.kde.kspread";
  public static final String VND_KDE_KWORD = "application/vnd.kde.kword";
  public static final String VND_KENAMEAAPP = "application/vnd.kenameaapp";
  public static final String VND_KIDSPIRATION = "application/vnd.kidspiration";
  public static final String VND_KINAR = "application/vnd.Kinar";
  public static final String VND_KOAN = "application/vnd.koan";
  public static final String VND_KODAK_DESCRIPTOR = "application/vnd.kodak-descriptor";
  public static final String VND_LAS = "application/vnd.las";
  public static final String VND_LAS_LAS_JSON = "application/vnd.las.las+json";
  public static final String VND_LAS_LAS_XML = "application/vnd.las.las+xml";
  public static final String VND_LASZIP = "application/vnd.laszip";
  public static final String VND_LEAP_JSON = "application/vnd.leap+json";
  public static final String VND_LIBERTY_REQUEST_XML = "application/vnd.liberty-request+xml";
  public static final String VND_LLAMAGRAPHICS_LIFE_BALANCE_DESKTOP = "application/vnd.llamagraphics.life-balance.desktop";
  public static final String VND_LLAMAGRAPHICS_LIFE_BALANCE_EXCHANGE_XML = "application/vnd.llamagraphics.life-balance.exchange+xml";
  public static final String VND_LOGIPIPE_CIRCUIT_ZIP = "application/vnd.logipipe.circuit+zip";
  public static final String VND_LOOM = "application/vnd.loom";
  public static final String VND_LOTUS_1_2_3 = "application/vnd.lotus-1-2-3";
  public static final String VND_LOTUS_APPROACH = "application/vnd.lotus-approach";
  public static final String VND_LOTUS_FREELANCE = "application/vnd.lotus-freelance";
  public static final String VND_LOTUS_NOTES = "application/vnd.lotus-notes";
  public static final String VND_LOTUS_ORGANIZER = "application/vnd.lotus-organizer";
  public static final String VND_LOTUS_SCREENCAM = "application/vnd.lotus-screencam";
  public static final String VND_LOTUS_WORDPRO = "application/vnd.lotus-wordpro";
  public static final String VND_MACPORTS_PORTPKG = "application/vnd.macports.portpkg";
  public static final String VND_MAPBOX_VECTOR_TILE = "application/vnd.mapbox-vector-tile";
  public static final String VND_MARLIN_DRM_ACTIONTOKEN_XML = "application/vnd.marlin.drm.actiontoken+xml";
  public static final String VND_MARLIN_DRM_CONFTOKEN_XML = "application/vnd.marlin.drm.conftoken+xml";
  public static final String VND_MARLIN_DRM_LICENSE_XML = "application/vnd.marlin.drm.license+xml";
  public static final String VND_MARLIN_DRM_MDCF = "application/vnd.marlin.drm.mdcf";
  public static final String VND_MASON_JSON = "application/vnd.mason+json";
  public static final String VND_MAXAR_ARCHIVE_3TZ_ZIP = "application/vnd.maxar.archive.3tz+zip";
  public static final String VND_MAXMIND_MAXMIND_DB = "application/vnd.maxmind.maxmind-db";
  public static final String VND_MCD = "application/vnd.mcd";
  public static final String VND_MEDCALCDATA = "application/vnd.medcalcdata";
  public static final String VND_MEDIASTATION_CDKEY = "application/vnd.mediastation.cdkey";
  public static final String VND_MERIDIAN_SLINGSHOT = "application/vnd.meridian-slingshot";
  public static final String VND_MFER = "application/vnd.MFER";
  public static final String VND_MFMP = "application/vnd.mfmp";
  public static final String VND_MICRO_JSON = "application/vnd.micro+json";
  public static final String VND_MICROGRAFX_FLO = "application/vnd.micrografx.flo";
  public static final String VND_MICROGRAFX_IGX = "application/vnd.micrografx.igx";
  public static final String VND_MICROSOFT_PORTABLE_EXECUTABLE = "application/vnd.microsoft.portable-executable";
  public static final String VND_MICROSOFT_WINDOWS_THUMBNAIL_CACHE = "application/vnd.microsoft.windows.thumbnail-cache";
  public static final String VND_MIELE_JSON = "application/vnd.miele+json";
  public static final String VND_MIF = "application/vnd.mif";
  public static final String VND_MINISOFT_HP3000_SAVE = "application/vnd.minisoft-hp3000-save";
  public static final String VND_MITSUBISHI_MISTY_GUARD_TRUSTWEB = "application/vnd.mitsubishi.misty-guard.trustweb";
  public static final String VND_MOBIUS_DAF = "application/vnd.Mobius.DAF";
  public static final String VND_MOBIUS_DIS = "application/vnd.Mobius.DIS";
  public static final String VND_MOBIUS_MBK = "application/vnd.Mobius.MBK";
  public static final String VND_MOBIUS_MQY = "application/vnd.Mobius.MQY";
  public static final String VND_MOBIUS_MSL = "application/vnd.Mobius.MSL";
  public static final String VND_MOBIUS_PLC = "application/vnd.Mobius.PLC";
  public static final String VND_MOBIUS_TXF = "application/vnd.Mobius.TXF";
  public static final String VND_MOPHUN_APPLICATION = "application/vnd.mophun.application";
  public static final String VND_MOPHUN_CERTIFICATE = "application/vnd.mophun.certificate";
  public static final String VND_MOTOROLA_FLEXSUITE = "application/vnd.motorola.flexsuite";
  public static final String VND_MOTOROLA_FLEXSUITE_ADSI = "application/vnd.motorola.flexsuite.adsi";
  public static final String VND_MOTOROLA_FLEXSUITE_FIS = "application/vnd.motorola.flexsuite.fis";
  public static final String VND_MOTOROLA_FLEXSUITE_GOTAP = "application/vnd.motorola.flexsuite.gotap";
  public static final String VND_MOTOROLA_FLEXSUITE_KMR = "application/vnd.motorola.flexsuite.kmr";
  public static final String VND_MOTOROLA_FLEXSUITE_TTC = "application/vnd.motorola.flexsuite.ttc";
  public static final String VND_MOTOROLA_FLEXSUITE_WEM = "application/vnd.motorola.flexsuite.wem";
  public static final String VND_MOTOROLA_IPRM = "application/vnd.motorola.iprm";
  public static final String VND_MOZILLA_XUL_XML = "application/vnd.mozilla.xul+xml";
  public static final String VND_MS_ARTGALRY = "application/vnd.ms-artgalry";
  public static final String VND_MS_ASF = "application/vnd.ms-asf";
  public static final String VND_MS_CAB_COMPRESSED = "application/vnd.ms-cab-compressed";
  public static final String VND_MS_3MFDOCUMENT = "application/vnd.ms-3mfdocument";
  public static final String VND_MS_EXCEL = "application/vnd.ms-excel";
  public static final String VND_MS_EXCEL_ADDIN_MACROENABLED_12 = "application/vnd.ms-excel.addin.macroEnabled.12";
  public static final String VND_MS_EXCEL_SHEET_BINARY_MACROENABLED_12 = "application/vnd.ms-excel.sheet.binary.macroEnabled.12";
  public static final String VND_MS_EXCEL_SHEET_MACROENABLED_12 = "application/vnd.ms-excel.sheet.macroEnabled.12";
  public static final String VND_MS_EXCEL_TEMPLATE_MACROENABLED_12 = "application/vnd.ms-excel.template.macroEnabled.12";
  public static final String VND_MS_FONTOBJECT = "application/vnd.ms-fontobject";
  public static final String VND_MS_HTMLHELP = "application/vnd.ms-htmlhelp";
  public static final String VND_MS_IMS = "application/vnd.ms-ims";
  public static final String VND_MS_LRM = "application/vnd.ms-lrm";
  public static final String VND_MS_OFFICE_ACTIVEX_XML = "application/vnd.ms-office.activeX+xml";
  public static final String VND_MS_OFFICETHEME = "application/vnd.ms-officetheme";
  public static final String VND_MS_PLAYREADY_INITIATOR_XML = "application/vnd.ms-playready.initiator+xml";
  public static final String VND_MS_POWERPOINT = "application/vnd.ms-powerpoint";
  public static final String VND_MS_POWERPOINT_ADDIN_MACROENABLED_12 = "application/vnd.ms-powerpoint.addin.macroEnabled.12";
  public static final String VND_MS_POWERPOINT_PRESENTATION_MACROENABLED_12 = "application/vnd.ms-powerpoint.presentation.macroEnabled.12";
  public static final String VND_MS_POWERPOINT_SLIDE_MACROENABLED_12 = "application/vnd.ms-powerpoint.slide.macroEnabled.12";
  public static final String VND_MS_POWERPOINT_SLIDESHOW_MACROENABLED_12 = "application/vnd.ms-powerpoint.slideshow.macroEnabled.12";
  public static final String VND_MS_POWERPOINT_TEMPLATE_MACROENABLED_12 = "application/vnd.ms-powerpoint.template.macroEnabled.12";
  public static final String VND_MS_PRINTDEVICECAPABILITIES_XML = "application/vnd.ms-PrintDeviceCapabilities+xml";
  public static final String VND_MS_PRINTSCHEMATICKET_XML = "application/vnd.ms-PrintSchemaTicket+xml";
  public static final String VND_MS_PROJECT = "application/vnd.ms-project";
  public static final String VND_MS_TNEF = "application/vnd.ms-tnef";
  public static final String VND_MS_WINDOWS_DEVICEPAIRING = "application/vnd.ms-windows.devicepairing";
  public static final String VND_MS_WINDOWS_NWPRINTING_OOB = "application/vnd.ms-windows.nwprinting.oob";
  public static final String VND_MS_WINDOWS_PRINTERPAIRING = "application/vnd.ms-windows.printerpairing";
  public static final String VND_MS_WINDOWS_WSD_OOB = "application/vnd.ms-windows.wsd.oob";
  public static final String VND_MS_WMDRM_LIC_CHLG_REQ = "application/vnd.ms-wmdrm.lic-chlg-req";
  public static final String VND_MS_WMDRM_LIC_RESP = "application/vnd.ms-wmdrm.lic-resp";
  public static final String VND_MS_WMDRM_METER_CHLG_REQ = "application/vnd.ms-wmdrm.meter-chlg-req";
  public static final String VND_MS_WMDRM_METER_RESP = "application/vnd.ms-wmdrm.meter-resp";
  public static final String VND_MS_WORD_DOCUMENT_MACROENABLED_12 = "application/vnd.ms-word.document.macroEnabled.12";
  public static final String VND_MS_WORD_TEMPLATE_MACROENABLED_12 = "application/vnd.ms-word.template.macroEnabled.12";
  public static final String VND_MS_WORKS = "application/vnd.ms-works";
  public static final String VND_MS_WPL = "application/vnd.ms-wpl";
  public static final String VND_MS_XPSDOCUMENT = "application/vnd.ms-xpsdocument";
  public static final String VND_MSA_DISK_IMAGE = "application/vnd.msa-disk-image";
  public static final String VND_MSEQ = "application/vnd.mseq";
  public static final String VND_MSIGN = "application/vnd.msign";
  public static final String VND_MULTIAD_CREATOR = "application/vnd.multiad.creator";
  public static final String VND_MULTIAD_CREATOR_CIF = "application/vnd.multiad.creator.cif";
  public static final String VND_MUSICIAN = "application/vnd.musician";
  public static final String VND_MUSIC_NIFF = "application/vnd.music-niff";
  public static final String VND_MUVEE_STYLE = "application/vnd.muvee.style";
  public static final String VND_MYNFC = "application/vnd.mynfc";
  public static final String VND_NACAMAR_YBRID_JSON = "application/vnd.nacamar.ybrid+json";
  public static final String VND_NCD_CONTROL = "application/vnd.ncd.control";
  public static final String VND_NCD_REFERENCE = "application/vnd.ncd.reference";
  public static final String VND_NEARST_INV_JSON = "application/vnd.nearst.inv+json";
  public static final String VND_NEBUMIND_LINE = "application/vnd.nebumind.line";
  public static final String VND_NERVANA = "application/vnd.nervana";
  public static final String VND_NETFPX = "application/vnd.netfpx";
  public static final String VND_NEUROLANGUAGE_NLU = "application/vnd.neurolanguage.nlu";
  public static final String VND_NIMN = "application/vnd.nimn";
  public static final String VND_NINTENDO_SNES_ROM = "application/vnd.nintendo.snes.rom";
  public static final String VND_NINTENDO_NITRO_ROM = "application/vnd.nintendo.nitro.rom";
  public static final String VND_NITF = "application/vnd.nitf";
  public static final String VND_NOBLENET_DIRECTORY = "application/vnd.noblenet-directory";
  public static final String VND_NOBLENET_SEALER = "application/vnd.noblenet-sealer";
  public static final String VND_NOBLENET_WEB = "application/vnd.noblenet-web";
  public static final String VND_NOKIA_CATALOGS = "application/vnd.nokia.catalogs";
  public static final String VND_NOKIA_CONML_WBXML = "application/vnd.nokia.conml+wbxml";
  public static final String VND_NOKIA_CONML_XML = "application/vnd.nokia.conml+xml";
  public static final String VND_NOKIA_IPTV_CONFIG_XML = "application/vnd.nokia.iptv.config+xml";
  public static final String VND_NOKIA_ISDS_RADIO_PRESETS = "application/vnd.nokia.iSDS-radio-presets";
  public static final String VND_NOKIA_LANDMARK_WBXML = "application/vnd.nokia.landmark+wbxml";
  public static final String VND_NOKIA_LANDMARK_XML = "application/vnd.nokia.landmark+xml";
  public static final String VND_NOKIA_LANDMARKCOLLECTION_XML = "application/vnd.nokia.landmarkcollection+xml";
  public static final String VND_NOKIA_NCD = "application/vnd.nokia.ncd";
  public static final String VND_NOKIA_N_GAGE_AC_XML = "application/vnd.nokia.n-gage.ac+xml";
  public static final String VND_NOKIA_N_GAGE_DATA = "application/vnd.nokia.n-gage.data";
  public static final String VND_NOKIA_N_GAGE_SYMBIAN_INSTALL = "application/vnd.nokia.n-gage.symbian.install";
  public static final String VND_NOKIA_PCD_WBXML = "application/vnd.nokia.pcd+wbxml";
  public static final String VND_NOKIA_PCD_XML = "application/vnd.nokia.pcd+xml";
  public static final String VND_NOKIA_RADIO_PRESET = "application/vnd.nokia.radio-preset";
  public static final String VND_NOKIA_RADIO_PRESETS = "application/vnd.nokia.radio-presets";
  public static final String VND_NOVADIGM_EDM = "application/vnd.novadigm.EDM";
  public static final String VND_NOVADIGM_EDX = "application/vnd.novadigm.EDX";
  public static final String VND_NOVADIGM_EXT = "application/vnd.novadigm.EXT";
  public static final String VND_NTT_LOCAL_CONTENT_SHARE = "application/vnd.ntt-local.content-share";
  public static final String VND_NTT_LOCAL_FILE_TRANSFER = "application/vnd.ntt-local.file-transfer";
  public static final String VND_NTT_LOCAL_OGW_REMOTE_ACCESS = "application/vnd.ntt-local.ogw_remote-access";
  public static final String VND_NTT_LOCAL_SIP_TA_REMOTE = "application/vnd.ntt-local.sip-ta_remote";
  public static final String VND_NTT_LOCAL_SIP_TA_TCP_STREAM = "application/vnd.ntt-local.sip-ta_tcp_stream";
  public static final String VND_OASIS_OPENDOCUMENT_CHART = "application/vnd.oasis.opendocument.chart";
  public static final String VND_OASIS_OPENDOCUMENT_CHART_TEMPLATE = "application/vnd.oasis.opendocument.chart-template";
  public static final String VND_OASIS_OPENDOCUMENT_DATABASE = "application/vnd.oasis.opendocument.database";
  public static final String VND_OASIS_OPENDOCUMENT_FORMULA = "application/vnd.oasis.opendocument.formula";
  public static final String VND_OASIS_OPENDOCUMENT_FORMULA_TEMPLATE = "application/vnd.oasis.opendocument.formula-template";
  public static final String VND_OASIS_OPENDOCUMENT_GRAPHICS = "application/vnd.oasis.opendocument.graphics";
  public static final String VND_OASIS_OPENDOCUMENT_GRAPHICS_TEMPLATE = "application/vnd.oasis.opendocument.graphics-template";
  public static final String VND_OASIS_OPENDOCUMENT_IMAGE = "application/vnd.oasis.opendocument.image";
  public static final String VND_OASIS_OPENDOCUMENT_IMAGE_TEMPLATE = "application/vnd.oasis.opendocument.image-template";
  public static final String VND_OASIS_OPENDOCUMENT_PRESENTATION = "application/vnd.oasis.opendocument.presentation";
  public static final String VND_OASIS_OPENDOCUMENT_PRESENTATION_TEMPLATE = "application/vnd.oasis.opendocument.presentation-template";
  public static final String VND_OASIS_OPENDOCUMENT_SPREADSHEET = "application/vnd.oasis.opendocument.spreadsheet";
  public static final String VND_OASIS_OPENDOCUMENT_SPREADSHEET_TEMPLATE = "application/vnd.oasis.opendocument.spreadsheet-template";
  public static final String VND_OASIS_OPENDOCUMENT_TEXT = "application/vnd.oasis.opendocument.text";
  public static final String VND_OASIS_OPENDOCUMENT_TEXT_MASTER = "application/vnd.oasis.opendocument.text-master";
  public static final String VND_OASIS_OPENDOCUMENT_TEXT_TEMPLATE = "application/vnd.oasis.opendocument.text-template";
  public static final String VND_OASIS_OPENDOCUMENT_TEXT_WEB = "application/vnd.oasis.opendocument.text-web";
  public static final String VND_OBN = "application/vnd.obn";
  public static final String VND_OCF_CBOR = "application/vnd.ocf+cbor";
  public static final String VND_OCI_IMAGE_MANIFEST_V1_JSON = "application/vnd.oci.image.manifest.v1+json";
  public static final String VND_OFTN_L10N_JSON = "application/vnd.oftn.l10n+json";
  public static final String VND_OIPF_CONTENTACCESSDOWNLOAD_XML = "application/vnd.oipf.contentaccessdownload+xml";
  public static final String VND_OIPF_CONTENTACCESSSTREAMING_XML = "application/vnd.oipf.contentaccessstreaming+xml";
  public static final String VND_OIPF_CSPG_HEXBINARY = "application/vnd.oipf.cspg-hexbinary";
  public static final String VND_OIPF_DAE_SVG_XML = "application/vnd.oipf.dae.svg+xml";
  public static final String VND_OIPF_DAE_XHTML_XML = "application/vnd.oipf.dae.xhtml+xml";
  public static final String VND_OIPF_MIPPVCONTROLMESSAGE_XML = "application/vnd.oipf.mippvcontrolmessage+xml";
  public static final String VND_OIPF_PAE_GEM = "application/vnd.oipf.pae.gem";
  public static final String VND_OIPF_SPDISCOVERY_XML = "application/vnd.oipf.spdiscovery+xml";
  public static final String VND_OIPF_SPDLIST_XML = "application/vnd.oipf.spdlist+xml";
  public static final String VND_OIPF_UEPROFILE_XML = "application/vnd.oipf.ueprofile+xml";
  public static final String VND_OIPF_USERPROFILE_XML = "application/vnd.oipf.userprofile+xml";
  public static final String VND_OLPC_SUGAR = "application/vnd.olpc-sugar";
  public static final String VND_OMA_BCAST_ASSOCIATED_PROCEDURE_PARAMETER_XML = "application/vnd.oma.bcast.associated-procedure-parameter+xml";
  public static final String VND_OMA_BCAST_DRM_TRIGGER_XML = "application/vnd.oma.bcast.drm-trigger+xml";
  public static final String VND_OMA_BCAST_IMD_XML = "application/vnd.oma.bcast.imd+xml";
  public static final String VND_OMA_BCAST_LTKM = "application/vnd.oma.bcast.ltkm";
  public static final String VND_OMA_BCAST_NOTIFICATION_XML = "application/vnd.oma.bcast.notification+xml";
  public static final String VND_OMA_BCAST_PROVISIONINGTRIGGER = "application/vnd.oma.bcast.provisioningtrigger";
  public static final String VND_OMA_BCAST_SGBOOT = "application/vnd.oma.bcast.sgboot";
  public static final String VND_OMA_BCAST_SGDD_XML = "application/vnd.oma.bcast.sgdd+xml";
  public static final String VND_OMA_BCAST_SGDU = "application/vnd.oma.bcast.sgdu";
  public static final String VND_OMA_BCAST_SIMPLE_SYMBOL_CONTAINER = "application/vnd.oma.bcast.simple-symbol-container";
  public static final String VND_OMA_BCAST_SMARTCARD_TRIGGER_XML = "application/vnd.oma.bcast.smartcard-trigger+xml";
  public static final String VND_OMA_BCAST_SPROV_XML = "application/vnd.oma.bcast.sprov+xml";
  public static final String VND_OMA_BCAST_STKM = "application/vnd.oma.bcast.stkm";
  public static final String VND_OMA_CAB_ADDRESS_BOOK_XML = "application/vnd.oma.cab-address-book+xml";
  public static final String VND_OMA_CAB_FEATURE_HANDLER_XML = "application/vnd.oma.cab-feature-handler+xml";
  public static final String VND_OMA_CAB_PCC_XML = "application/vnd.oma.cab-pcc+xml";
  public static final String VND_OMA_CAB_SUBS_INVITE_XML = "application/vnd.oma.cab-subs-invite+xml";
  public static final String VND_OMA_CAB_USER_PREFS_XML = "application/vnd.oma.cab-user-prefs+xml";
  public static final String VND_OMA_DCD = "application/vnd.oma.dcd";
  public static final String VND_OMA_DCDC = "application/vnd.oma.dcdc";
  public static final String VND_OMA_DD2_XML = "application/vnd.oma.dd2+xml";
  public static final String VND_OMA_DRM_RISD_XML = "application/vnd.oma.drm.risd+xml";
  public static final String VND_OMA_GROUP_USAGE_LIST_XML = "application/vnd.oma.group-usage-list+xml";
  public static final String VND_OMA_LWM2M_CBOR = "application/vnd.oma.lwm2m+cbor";
  public static final String VND_OMA_LWM2M_JSON = "application/vnd.oma.lwm2m+json";
  public static final String VND_OMA_LWM2M_TLV = "application/vnd.oma.lwm2m+tlv";
  public static final String VND_OMA_PAL_XML = "application/vnd.oma.pal+xml";
  public static final String VND_OMA_POC_DETAILED_PROGRESS_REPORT_XML = "application/vnd.oma.poc.detailed-progress-report+xml";
  public static final String VND_OMA_POC_FINAL_REPORT_XML = "application/vnd.oma.poc.final-report+xml";
  public static final String VND_OMA_POC_GROUPS_XML = "application/vnd.oma.poc.groups+xml";
  public static final String VND_OMA_POC_INVOCATION_DESCRIPTOR_XML = "application/vnd.oma.poc.invocation-descriptor+xml";
  public static final String VND_OMA_POC_OPTIMIZED_PROGRESS_REPORT_XML = "application/vnd.oma.poc.optimized-progress-report+xml";
  public static final String VND_OMA_PUSH = "application/vnd.oma.push";
  public static final String VND_OMA_SCIDM_MESSAGES_XML = "application/vnd.oma.scidm.messages+xml";
  public static final String VND_OMA_XCAP_DIRECTORY_XML = "application/vnd.oma.xcap-directory+xml";
  public static final String VND_OMADS_EMAIL_XML = "application/vnd.omads-email+xml";
  public static final String VND_OMADS_FILE_XML = "application/vnd.omads-file+xml";
  public static final String VND_OMADS_FOLDER_XML = "application/vnd.omads-folder+xml";
  public static final String VND_OMALOC_SUPL_INIT = "application/vnd.omaloc-supl-init";
  public static final String VND_OMA_SCWS_CONFIG = "application/vnd.oma-scws-config";
  public static final String VND_OMA_SCWS_HTTP_REQUEST = "application/vnd.oma-scws-http-request";
  public static final String VND_OMA_SCWS_HTTP_RESPONSE = "application/vnd.oma-scws-http-response";
  public static final String VND_ONEPAGER = "application/vnd.onepager";
  public static final String VND_ONEPAGERTAMP = "application/vnd.onepagertamp";
  public static final String VND_ONEPAGERTAMX = "application/vnd.onepagertamx";
  public static final String VND_ONEPAGERTAT = "application/vnd.onepagertat";
  public static final String VND_ONEPAGERTATP = "application/vnd.onepagertatp";
  public static final String VND_ONEPAGERTATX = "application/vnd.onepagertatx";
  public static final String VND_ONVIF_METADATA = "application/vnd.onvif.metadata";
  public static final String VND_OPENBLOX_GAME_BINARY = "application/vnd.openblox.game-binary";
  public static final String VND_OPENBLOX_GAME_XML = "application/vnd.openblox.game+xml";
  public static final String VND_OPENEYE_OEB = "application/vnd.openeye.oeb";
  public static final String VND_OPENSTREETMAP_DATA_XML = "application/vnd.openstreetmap.data+xml";
  public static final String VND_OPENTIMESTAMPS_OTS = "application/vnd.opentimestamps.ots";
  public static final String VND_OPENXMLFORMATS_OFFICEDOCUMENT_CUSTOM_PROPERTIES_XML = "application/vnd.openxmlformats-officedocument.custom-properties+xml";
  public static final String VND_OPENXMLFORMATS_OFFICEDOCUMENT_CUSTOMXMLPROPERTIES_XML = "application/vnd.openxmlformats-officedocument.customXmlProperties+xml";
  public static final String VND_OPENXMLFORMATS_OFFICEDOCUMENT_DRAWING_XML = "application/vnd.openxmlformats-officedocument.drawing+xml";
  public static final String VND_OPENXMLFORMATS_OFFICEDOCUMENT_DRAWINGML_CHART_XML = "application/vnd.openxmlformats-officedocument.drawingml.chart+xml";
  public static final String VND_OPENXMLFORMATS_OFFICEDOCUMENT_DRAWINGML_CHARTSHAPES_XML = "application/vnd.openxmlformats-officedocument.drawingml.chartshapes+xml";
  public static final String VND_OPENXMLFORMATS_OFFICEDOCUMENT_DRAWINGML_DIAGRAMCOLORS_XML = "application/vnd.openxmlformats-officedocument.drawingml.diagramColors+xml";
  public static final String VND_OPENXMLFORMATS_OFFICEDOCUMENT_DRAWINGML_DIAGRAMDATA_XML = "application/vnd.openxmlformats-officedocument.drawingml.diagramData+xml";
  public static final String VND_OPENXMLFORMATS_OFFICEDOCUMENT_DRAWINGML_DIAGRAMLAYOUT_XML = "application/vnd.openxmlformats-officedocument.drawingml.diagramLayout+xml";
  public static final String VND_OPENXMLFORMATS_OFFICEDOCUMENT_DRAWINGML_DIAGRAMSTYLE_XML = "application/vnd.openxmlformats-officedocument.drawingml.diagramStyle+xml";
  public static final String VND_OPENXMLFORMATS_OFFICEDOCUMENT_EXTENDED_PROPERTIES_XML = "application/vnd.openxmlformats-officedocument.extended-properties+xml";
  public static final String VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_COMMENTAUTHORS_XML = "application/vnd.openxmlformats-officedocument.presentationml.commentAuthors+xml";
  public static final String VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_COMMENTS_XML = "application/vnd.openxmlformats-officedocument.presentationml.comments+xml";
  public static final String VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_HANDOUTMASTER_XML = "application/vnd.openxmlformats-officedocument.presentationml.handoutMaster+xml";
  public static final String VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_NOTESMASTER_XML = "application/vnd.openxmlformats-officedocument.presentationml.notesMaster+xml";
  public static final String VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_NOTESSLIDE_XML = "application/vnd.openxmlformats-officedocument.presentationml.notesSlide+xml";
  public static final String VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_PRESENTATION = "application/vnd.openxmlformats-officedocument.presentationml.presentation";
  public static final String VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_PRESENTATION_MAIN_XML = "application/vnd.openxmlformats-officedocument.presentationml.presentation.main+xml";
  public static final String VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_PRESPROPS_XML = "application/vnd.openxmlformats-officedocument.presentationml.presProps+xml";
  public static final String VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_SLIDE = "application/vnd.openxmlformats-officedocument.presentationml.slide";
  public static final String VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_SLIDE_XML = "application/vnd.openxmlformats-officedocument.presentationml.slide+xml";
  public static final String VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_SLIDELAYOUT_XML = "application/vnd.openxmlformats-officedocument.presentationml.slideLayout+xml";
  public static final String VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_SLIDEMASTER_XML = "application/vnd.openxmlformats-officedocument.presentationml.slideMaster+xml";
  public static final String VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_SLIDESHOW = "application/vnd.openxmlformats-officedocument.presentationml.slideshow";
  public static final String VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_SLIDESHOW_MAIN_XML = "application/vnd.openxmlformats-officedocument.presentationml.slideshow.main+xml";
  public static final String VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_SLIDEUPDATEINFO_XML = "application/vnd.openxmlformats-officedocument.presentationml.slideUpdateInfo+xml";
  public static final String VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_TABLESTYLES_XML = "application/vnd.openxmlformats-officedocument.presentationml.tableStyles+xml";
  public static final String VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_TAGS_XML = "application/vnd.openxmlformats-officedocument.presentationml.tags+xml";
  public static final String VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_TEMPLATE = "application/vnd.openxmlformats-officedocument.presentationml.template";
  public static final String VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_TEMPLATE_MAIN_XML = "application/vnd.openxmlformats-officedocument.presentationml.template.main+xml";
  public static final String VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_VIEWPROPS_XML = "application/vnd.openxmlformats-officedocument.presentationml.viewProps+xml";
  public static final String VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_CALCCHAIN_XML = "application/vnd.openxmlformats-officedocument.spreadsheetml.calcChain+xml";
  public static final String VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_CHARTSHEET_XML = "application/vnd.openxmlformats-officedocument.spreadsheetml.chartsheet+xml";
  public static final String VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_COMMENTS_XML = "application/vnd.openxmlformats-officedocument.spreadsheetml.comments+xml";
  public static final String VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_CONNECTIONS_XML = "application/vnd.openxmlformats-officedocument.spreadsheetml.connections+xml";
  public static final String VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_DIALOGSHEET_XML = "application/vnd.openxmlformats-officedocument.spreadsheetml.dialogsheet+xml";
  public static final String VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_EXTERNALLINK_XML = "application/vnd.openxmlformats-officedocument.spreadsheetml.externalLink+xml";
  public static final String VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_PIVOTCACHEDEFINITION_XML = "application/vnd.openxmlformats-officedocument.spreadsheetml.pivotCacheDefinition+xml";
  public static final String VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_PIVOTCACHERECORDS_XML = "application/vnd.openxmlformats-officedocument.spreadsheetml.pivotCacheRecords+xml";
  public static final String VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_PIVOTTABLE_XML = "application/vnd.openxmlformats-officedocument.spreadsheetml.pivotTable+xml";
  public static final String VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_QUERYTABLE_XML = "application/vnd.openxmlformats-officedocument.spreadsheetml.queryTable+xml";
  public static final String VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_REVISIONHEADERS_XML = "application/vnd.openxmlformats-officedocument.spreadsheetml.revisionHeaders+xml";
  public static final String VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_REVISIONLOG_XML = "application/vnd.openxmlformats-officedocument.spreadsheetml.revisionLog+xml";
  public static final String VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_SHAREDSTRINGS_XML = "application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml";
  public static final String VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_SHEET = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
  public static final String VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_SHEET_MAIN_XML = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml";
  public static final String VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_SHEETMETADATA_XML = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheetMetadata+xml";
  public static final String VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_STYLES_XML = "application/vnd.openxmlformats-officedocument.spreadsheetml.styles+xml";
  public static final String VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_TABLE_XML = "application/vnd.openxmlformats-officedocument.spreadsheetml.table+xml";
  public static final String VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_TABLESINGLECELLS_XML = "application/vnd.openxmlformats-officedocument.spreadsheetml.tableSingleCells+xml";
  public static final String VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_TEMPLATE = "application/vnd.openxmlformats-officedocument.spreadsheetml.template";
  public static final String VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_TEMPLATE_MAIN_XML = "application/vnd.openxmlformats-officedocument.spreadsheetml.template.main+xml";
  public static final String VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_USERNAMES_XML = "application/vnd.openxmlformats-officedocument.spreadsheetml.userNames+xml";
  public static final String VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_VOLATILEDEPENDENCIES_XML = "application/vnd.openxmlformats-officedocument.spreadsheetml.volatileDependencies+xml";
  public static final String VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_WORKSHEET_XML = "application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml";
  public static final String VND_OPENXMLFORMATS_OFFICEDOCUMENT_THEME_XML = "application/vnd.openxmlformats-officedocument.theme+xml";
  public static final String VND_OPENXMLFORMATS_OFFICEDOCUMENT_THEMEOVERRIDE_XML = "application/vnd.openxmlformats-officedocument.themeOverride+xml";
  public static final String VND_OPENXMLFORMATS_OFFICEDOCUMENT_VMLDRAWING = "application/vnd.openxmlformats-officedocument.vmlDrawing";
  public static final String VND_OPENXMLFORMATS_OFFICEDOCUMENT_WORDPROCESSINGML_COMMENTS_XML = "application/vnd.openxmlformats-officedocument.wordprocessingml.comments+xml";
  public static final String VND_OPENXMLFORMATS_OFFICEDOCUMENT_WORDPROCESSINGML_DOCUMENT = "application/vnd.openxmlformats-officedocument.wordprocessingml.document";
  public static final String VND_OPENXMLFORMATS_OFFICEDOCUMENT_WORDPROCESSINGML_DOCUMENT_GLOSSARY_XML = "application/vnd.openxmlformats-officedocument.wordprocessingml.document.glossary+xml";
  public static final String VND_OPENXMLFORMATS_OFFICEDOCUMENT_WORDPROCESSINGML_DOCUMENT_MAIN_XML = "application/vnd.openxmlformats-officedocument.wordprocessingml.document.main+xml";
  public static final String VND_OPENXMLFORMATS_OFFICEDOCUMENT_WORDPROCESSINGML_ENDNOTES_XML = "application/vnd.openxmlformats-officedocument.wordprocessingml.endnotes+xml";
  public static final String VND_OPENXMLFORMATS_OFFICEDOCUMENT_WORDPROCESSINGML_FONTTABLE_XML = "application/vnd.openxmlformats-officedocument.wordprocessingml.fontTable+xml";
  public static final String VND_OPENXMLFORMATS_OFFICEDOCUMENT_WORDPROCESSINGML_FOOTER_XML = "application/vnd.openxmlformats-officedocument.wordprocessingml.footer+xml";
  public static final String VND_OPENXMLFORMATS_OFFICEDOCUMENT_WORDPROCESSINGML_FOOTNOTES_XML = "application/vnd.openxmlformats-officedocument.wordprocessingml.footnotes+xml";
  public static final String VND_OPENXMLFORMATS_OFFICEDOCUMENT_WORDPROCESSINGML_NUMBERING_XML = "application/vnd.openxmlformats-officedocument.wordprocessingml.numbering+xml";
  public static final String VND_OPENXMLFORMATS_OFFICEDOCUMENT_WORDPROCESSINGML_SETTINGS_XML = "application/vnd.openxmlformats-officedocument.wordprocessingml.settings+xml";
  public static final String VND_OPENXMLFORMATS_OFFICEDOCUMENT_WORDPROCESSINGML_STYLES_XML = "application/vnd.openxmlformats-officedocument.wordprocessingml.styles+xml";
  public static final String VND_OPENXMLFORMATS_OFFICEDOCUMENT_WORDPROCESSINGML_TEMPLATE = "application/vnd.openxmlformats-officedocument.wordprocessingml.template";
  public static final String VND_OPENXMLFORMATS_OFFICEDOCUMENT_WORDPROCESSINGML_TEMPLATE_MAIN_XML = "application/vnd.openxmlformats-officedocument.wordprocessingml.template.main+xml";
  public static final String VND_OPENXMLFORMATS_OFFICEDOCUMENT_WORDPROCESSINGML_WEBSETTINGS_XML = "application/vnd.openxmlformats-officedocument.wordprocessingml.webSettings+xml";
  public static final String VND_OPENXMLFORMATS_PACKAGE_CORE_PROPERTIES_XML = "application/vnd.openxmlformats-package.core-properties+xml";
  public static final String VND_OPENXMLFORMATS_PACKAGE_DIGITAL_SIGNATURE_XMLSIGNATURE_XML = "application/vnd.openxmlformats-package.digital-signature-xmlsignature+xml";
  public static final String VND_OPENXMLFORMATS_PACKAGE_RELATIONSHIPS_XML = "application/vnd.openxmlformats-package.relationships+xml";
  public static final String VND_ORACLE_RESOURCE_JSON = "application/vnd.oracle.resource+json";
  public static final String VND_ORANGE_INDATA = "application/vnd.orange.indata";
  public static final String VND_OSA_NETDEPLOY = "application/vnd.osa.netdeploy";
  public static final String VND_OSGEO_MAPGUIDE_PACKAGE = "application/vnd.osgeo.mapguide.package";
  public static final String VND_OSGI_BUNDLE = "application/vnd.osgi.bundle";
  public static final String VND_OSGI_DP = "application/vnd.osgi.dp";
  public static final String VND_OSGI_SUBSYSTEM = "application/vnd.osgi.subsystem";
  public static final String VND_OTPS_CT_KIP_XML = "application/vnd.otps.ct-kip+xml";
  public static final String VND_OXLI_COUNTGRAPH = "application/vnd.oxli.countgraph";
  public static final String VND_PAGERDUTY_JSON = "application/vnd.pagerduty+json";
  public static final String VND_PALM = "application/vnd.palm";
  public static final String VND_PANOPLY = "application/vnd.panoply";
  public static final String VND_PAOS_XML = "application/vnd.paos.xml";
  public static final String VND_PATENTDIVE = "application/vnd.patentdive";
  public static final String VND_PATIENTECOMMSDOC = "application/vnd.patientecommsdoc";
  public static final String VND_PAWAAFILE = "application/vnd.pawaafile";
  public static final String VND_PCOS = "application/vnd.pcos";
  public static final String VND_PG_FORMAT = "application/vnd.pg.format";
  public static final String VND_PG_OSASLI = "application/vnd.pg.osasli";
  public static final String VND_PIACCESS_APPLICATION_LICENCE = "application/vnd.piaccess.application-licence";
  public static final String VND_PICSEL = "application/vnd.picsel";
  public static final String VND_PMI_WIDGET = "application/vnd.pmi.widget";
  public static final String VND_POC_GROUP_ADVERTISEMENT_XML = "application/vnd.poc.group-advertisement+xml";
  public static final String VND_POCKETLEARN = "application/vnd.pocketlearn";
  public static final String VND_POWERBUILDER6 = "application/vnd.powerbuilder6";
  public static final String VND_POWERBUILDER6_S = "application/vnd.powerbuilder6-s";
  public static final String VND_POWERBUILDER7 = "application/vnd.powerbuilder7";
  public static final String VND_POWERBUILDER75 = "application/vnd.powerbuilder75";
  public static final String VND_POWERBUILDER75_S = "application/vnd.powerbuilder75-s";
  public static final String VND_POWERBUILDER7_S = "application/vnd.powerbuilder7-s";
  public static final String VND_PREMINET = "application/vnd.preminet";
  public static final String VND_PREVIEWSYSTEMS_BOX = "application/vnd.previewsystems.box";
  public static final String VND_PROTEUS_MAGAZINE = "application/vnd.proteus.magazine";
  public static final String VND_PSFS = "application/vnd.psfs";
  public static final String VND_PUBLISHARE_DELTA_TREE = "application/vnd.publishare-delta-tree";
  public static final String VND_PVI_PTID1 = "application/vnd.pvi.ptid1";
  public static final String VND_PWG_MULTIPLEXED = "application/vnd.pwg-multiplexed";
  public static final String VND_PWG_XHTML_PRINT_XML = "application/vnd.pwg-xhtml-print+xml";
  public static final String VND_QUALCOMM_BREW_APP_RES = "application/vnd.qualcomm.brew-app-res";
  public static final String VND_QUARANTAINENET = "application/vnd.quarantainenet";
  public static final String VND_QUARK_QUARKXPRESS = "application/vnd.Quark.QuarkXPress";
  public static final String VND_QUOBJECT_QUOXDOCUMENT = "application/vnd.quobject-quoxdocument";
  public static final String VND_RADISYS_MOML_XML = "application/vnd.radisys.moml+xml";
  public static final String VND_RADISYS_MSML_AUDIT_CONF_XML = "application/vnd.radisys.msml-audit-conf+xml";
  public static final String VND_RADISYS_MSML_AUDIT_CONN_XML = "application/vnd.radisys.msml-audit-conn+xml";
  public static final String VND_RADISYS_MSML_AUDIT_DIALOG_XML = "application/vnd.radisys.msml-audit-dialog+xml";
  public static final String VND_RADISYS_MSML_AUDIT_STREAM_XML = "application/vnd.radisys.msml-audit-stream+xml";
  public static final String VND_RADISYS_MSML_AUDIT_XML = "application/vnd.radisys.msml-audit+xml";
  public static final String VND_RADISYS_MSML_CONF_XML = "application/vnd.radisys.msml-conf+xml";
  public static final String VND_RADISYS_MSML_DIALOG_BASE_XML = "application/vnd.radisys.msml-dialog-base+xml";
  public static final String VND_RADISYS_MSML_DIALOG_FAX_DETECT_XML = "application/vnd.radisys.msml-dialog-fax-detect+xml";
  public static final String VND_RADISYS_MSML_DIALOG_FAX_SENDRECV_XML = "application/vnd.radisys.msml-dialog-fax-sendrecv+xml";
  public static final String VND_RADISYS_MSML_DIALOG_GROUP_XML = "application/vnd.radisys.msml-dialog-group+xml";
  public static final String VND_RADISYS_MSML_DIALOG_SPEECH_XML = "application/vnd.radisys.msml-dialog-speech+xml";
  public static final String VND_RADISYS_MSML_DIALOG_TRANSFORM_XML = "application/vnd.radisys.msml-dialog-transform+xml";
  public static final String VND_RADISYS_MSML_DIALOG_XML = "application/vnd.radisys.msml-dialog+xml";
  public static final String VND_RADISYS_MSML_XML = "application/vnd.radisys.msml+xml";
  public static final String VND_RAINSTOR_DATA = "application/vnd.rainstor.data";
  public static final String VND_RAPID = "application/vnd.rapid";
  public static final String VND_RAR = "application/vnd.rar";
  public static final String VND_REALVNC_BED = "application/vnd.realvnc.bed";
  public static final String VND_RECORDARE_MUSICXML = "application/vnd.recordare.musicxml";
  public static final String VND_RECORDARE_MUSICXML_XML = "application/vnd.recordare.musicxml+xml";
  public static final String VND_RENLEARN_RLPRINT = "application/vnd.RenLearn.rlprint";
  public static final String VND_RESILIENT_LOGIC = "application/vnd.resilient.logic";
  public static final String VND_RESTFUL_JSON = "application/vnd.restful+json";
  public static final String VND_RIG_CRYPTONOTE = "application/vnd.rig.cryptonote";
  public static final String VND_ROUTE66_LINK66_XML = "application/vnd.route66.link66+xml";
  public static final String VND_RS_274X = "application/vnd.rs-274x";
  public static final String VND_RUCKUS_DOWNLOAD = "application/vnd.ruckus.download";
  public static final String VND_S3SMS = "application/vnd.s3sms";
  public static final String VND_SAILINGTRACKER_TRACK = "application/vnd.sailingtracker.track";
  public static final String VND_SAR = "application/vnd.sar";
  public static final String VND_SBM_CID = "application/vnd.sbm.cid";
  public static final String VND_SBM_MID2 = "application/vnd.sbm.mid2";
  public static final String VND_SCRIBUS = "application/vnd.scribus";
  public static final String VND_SEALED_3DF = "application/vnd.sealed.3df";
  public static final String VND_SEALED_CSF = "application/vnd.sealed.csf";
  public static final String VND_SEALED_DOC = "application/vnd.sealed.doc";
  public static final String VND_SEALED_EML = "application/vnd.sealed.eml";
  public static final String VND_SEALED_MHT = "application/vnd.sealed.mht";
  public static final String VND_SEALED_NET = "application/vnd.sealed.net";
  public static final String VND_SEALED_PPT = "application/vnd.sealed.ppt";
  public static final String VND_SEALED_TIFF = "application/vnd.sealed.tiff";
  public static final String VND_SEALED_XLS = "application/vnd.sealed.xls";
  public static final String VND_SEALEDMEDIA_SOFTSEAL_HTML = "application/vnd.sealedmedia.softseal.html";
  public static final String VND_SEALEDMEDIA_SOFTSEAL_PDF = "application/vnd.sealedmedia.softseal.pdf";
  public static final String VND_SEEMAIL = "application/vnd.seemail";
  public static final String VND_SEIS_JSON = "application/vnd.seis+json";
  public static final String VND_SEMA = "application/vnd.sema";
  public static final String VND_SEMD = "application/vnd.semd";
  public static final String VND_SEMF = "application/vnd.semf";
  public static final String VND_SHADE_SAVE_FILE = "application/vnd.shade-save-file";
  public static final String VND_SHANA_INFORMED_FORMDATA = "application/vnd.shana.informed.formdata";
  public static final String VND_SHANA_INFORMED_FORMTEMPLATE = "application/vnd.shana.informed.formtemplate";
  public static final String VND_SHANA_INFORMED_INTERCHANGE = "application/vnd.shana.informed.interchange";
  public static final String VND_SHANA_INFORMED_PACKAGE = "application/vnd.shana.informed.package";
  public static final String VND_SHOOTPROOF_JSON = "application/vnd.shootproof+json";
  public static final String VND_SHOPKICK_JSON = "application/vnd.shopkick+json";
  public static final String VND_SHP = "application/vnd.shp";
  public static final String VND_SHX = "application/vnd.shx";
  public static final String VND_SIGROK_SESSION = "application/vnd.sigrok.session";
  public static final String VND_SIMTECH_MINDMAPPER = "application/vnd.SimTech-MindMapper";
  public static final String VND_SIREN_JSON = "application/vnd.siren+json";
  public static final String VND_SMAF = "application/vnd.smaf";
  public static final String VND_SMART_NOTEBOOK = "application/vnd.smart.notebook";
  public static final String VND_SMART_TEACHER = "application/vnd.smart.teacher";
  public static final String VND_SNESDEV_PAGE_TABLE = "application/vnd.snesdev-page-table";
  public static final String VND_SOFTWARE602_FILLER_FORM_XML = "application/vnd.software602.filler.form+xml";
  public static final String VND_SOFTWARE602_FILLER_FORM_XML_ZIP = "application/vnd.software602.filler.form-xml-zip";
  public static final String VND_SOLENT_SDKM_XML = "application/vnd.solent.sdkm+xml";
  public static final String VND_SPOTFIRE_DXP = "application/vnd.spotfire.dxp";
  public static final String VND_SPOTFIRE_SFS = "application/vnd.spotfire.sfs";
  public static final String VND_SQLITE3 = "application/vnd.sqlite3";
  public static final String VND_SSS_COD = "application/vnd.sss-cod";
  public static final String VND_SSS_DTF = "application/vnd.sss-dtf";
  public static final String VND_SSS_NTF = "application/vnd.sss-ntf";
  public static final String VND_STEPMANIA_PACKAGE = "application/vnd.stepmania.package";
  public static final String VND_STEPMANIA_STEPCHART = "application/vnd.stepmania.stepchart";
  public static final String VND_STREET_STREAM = "application/vnd.street-stream";
  public static final String VND_SUN_WADL_XML = "application/vnd.sun.wadl+xml";
  public static final String VND_SUS_CALENDAR = "application/vnd.sus-calendar";
  public static final String VND_SVD = "application/vnd.svd";
  public static final String VND_SWIFTVIEW_ICS = "application/vnd.swiftview-ics";
  public static final String VND_SYCLE_XML = "application/vnd.sycle+xml";
  public static final String VND_SYFT_JSON = "application/vnd.syft+json";
  public static final String VND_SYNCML_DM_NOTIFICATION = "application/vnd.syncml.dm.notification";
  public static final String VND_SYNCML_DMDDF_XML = "application/vnd.syncml.dmddf+xml";
  public static final String VND_SYNCML_DMTNDS_WBXML = "application/vnd.syncml.dmtnds+wbxml";
  public static final String VND_SYNCML_DMTNDS_XML = "application/vnd.syncml.dmtnds+xml";
  public static final String VND_SYNCML_DMDDF_WBXML = "application/vnd.syncml.dmddf+wbxml";
  public static final String VND_SYNCML_DM_WBXML = "application/vnd.syncml.dm+wbxml";
  public static final String VND_SYNCML_DM_XML = "application/vnd.syncml.dm+xml";
  public static final String VND_SYNCML_DS_NOTIFICATION = "application/vnd.syncml.ds.notification";
  public static final String VND_SYNCML_XML = "application/vnd.syncml+xml";
  public static final String VND_TABLESCHEMA_JSON = "application/vnd.tableschema+json";
  public static final String VND_TAO_INTENT_MODULE_ARCHIVE = "application/vnd.tao.intent-module-archive";
  public static final String VND_TCPDUMP_PCAP = "application/vnd.tcpdump.pcap";
  public static final String VND_THINK_CELL_PPTTC_JSON = "application/vnd.think-cell.ppttc+json";
  public static final String VND_TML = "application/vnd.tml";
  public static final String VND_TMD_MEDIAFLEX_API_XML = "application/vnd.tmd.mediaflex.api+xml";
  public static final String VND_TMOBILE_LIVETV = "application/vnd.tmobile-livetv";
  public static final String VND_TRI_ONESOURCE = "application/vnd.tri.onesource";
  public static final String VND_TRID_TPT = "application/vnd.trid.tpt";
  public static final String VND_TRISCAPE_MXS = "application/vnd.triscape.mxs";
  public static final String VND_TRUEAPP = "application/vnd.trueapp";
  public static final String VND_TRUEDOC = "application/vnd.truedoc";
  public static final String VND_UBISOFT_WEBPLAYER = "application/vnd.ubisoft.webplayer";
  public static final String VND_UFDL = "application/vnd.ufdl";
  public static final String VND_UIQ_THEME = "application/vnd.uiq.theme";
  public static final String VND_UMAJIN = "application/vnd.umajin";
  public static final String VND_UNITY = "application/vnd.unity";
  public static final String VND_UOML_XML = "application/vnd.uoml+xml";
  public static final String VND_UPLANET_ALERT = "application/vnd.uplanet.alert";
  public static final String VND_UPLANET_ALERT_WBXML = "application/vnd.uplanet.alert-wbxml";
  public static final String VND_UPLANET_BEARER_CHOICE = "application/vnd.uplanet.bearer-choice";
  public static final String VND_UPLANET_BEARER_CHOICE_WBXML = "application/vnd.uplanet.bearer-choice-wbxml";
  public static final String VND_UPLANET_CACHEOP = "application/vnd.uplanet.cacheop";
  public static final String VND_UPLANET_CACHEOP_WBXML = "application/vnd.uplanet.cacheop-wbxml";
  public static final String VND_UPLANET_CHANNEL = "application/vnd.uplanet.channel";
  public static final String VND_UPLANET_CHANNEL_WBXML = "application/vnd.uplanet.channel-wbxml";
  public static final String VND_UPLANET_LIST = "application/vnd.uplanet.list";
  public static final String VND_UPLANET_LISTCMD = "application/vnd.uplanet.listcmd";
  public static final String VND_UPLANET_LISTCMD_WBXML = "application/vnd.uplanet.listcmd-wbxml";
  public static final String VND_UPLANET_LIST_WBXML = "application/vnd.uplanet.list-wbxml";
  public static final String VND_URI_MAP = "application/vnd.uri-map";
  public static final String VND_UPLANET_SIGNAL = "application/vnd.uplanet.signal";
  public static final String VND_VALVE_SOURCE_MATERIAL = "application/vnd.valve.source.material";
  public static final String VND_VCX = "application/vnd.vcx";
  public static final String VND_VD_STUDY = "application/vnd.vd-study";
  public static final String VND_VECTORWORKS = "application/vnd.vectorworks";
  public static final String VND_VEL_JSON = "application/vnd.vel+json";
  public static final String VND_VERIMATRIX_VCAS = "application/vnd.verimatrix.vcas";
  public static final String VND_VERITONE_AION_JSON = "application/vnd.veritone.aion+json";
  public static final String VND_VERYANT_THIN = "application/vnd.veryant.thin";
  public static final String VND_VES_ENCRYPTED = "application/vnd.ves.encrypted";
  public static final String VND_VIDSOFT_VIDCONFERENCE = "application/vnd.vidsoft.vidconference";
  public static final String VND_VISIO = "application/vnd.visio";
  public static final String VND_VISIONARY = "application/vnd.visionary";
  public static final String VND_VIVIDENCE_SCRIPTFILE = "application/vnd.vividence.scriptfile";
  public static final String VND_VSF = "application/vnd.vsf";
  public static final String VND_WAP_SIC = "application/vnd.wap.sic";
  public static final String VND_WAP_SLC = "application/vnd.wap.slc";
  public static final String VND_WAP_WBXML = "application/vnd.wap.wbxml";
  public static final String VND_WAP_WMLC = "application/vnd.wap.wmlc";
  public static final String VND_WAP_WMLSCRIPTC = "application/vnd.wap.wmlscriptc";
  public static final String VND_WEBTURBO = "application/vnd.webturbo";
  public static final String VND_WFA_DPP = "application/vnd.wfa.dpp";
  public static final String VND_WFA_P2P = "application/vnd.wfa.p2p";
  public static final String VND_WFA_WSC_APPLICATION = "application/vnd.wfa.wsc";
  public static final String VND_WINDOWS_DEVICEPAIRING = "application/vnd.windows.devicepairing";
  public static final String VND_WMC = "application/vnd.wmc";
  public static final String VND_WMF_BOOTSTRAP = "application/vnd.wmf.bootstrap";
  public static final String VND_WOLFRAM_MATHEMATICA = "application/vnd.wolfram.mathematica";
  public static final String VND_WOLFRAM_MATHEMATICA_PACKAGE = "application/vnd.wolfram.mathematica.package";
  public static final String VND_WOLFRAM_PLAYER = "application/vnd.wolfram.player";
  public static final String VND_WORDPERFECT = "application/vnd.wordperfect";
  public static final String VND_WQD = "application/vnd.wqd";
  public static final String VND_WRQ_HP3000_LABELLED = "application/vnd.wrq-hp3000-labelled";
  public static final String VND_WT_STF = "application/vnd.wt.stf";
  public static final String VND_WV_CSP_XML = "application/vnd.wv.csp+xml";
  public static final String VND_WV_CSP_WBXML = "application/vnd.wv.csp+wbxml";
  public static final String VND_WV_SSP_XML = "application/vnd.wv.ssp+xml";
  public static final String VND_XACML_JSON = "application/vnd.xacml+json";
  public static final String VND_XARA = "application/vnd.xara";
  public static final String VND_XFDL = "application/vnd.xfdl";
  public static final String VND_XFDL_WEBFORM = "application/vnd.xfdl.webform";
  public static final String VND_XMI_XML = "application/vnd.xmi+xml";
  public static final String VND_XMPIE_CPKG = "application/vnd.xmpie.cpkg";
  public static final String VND_XMPIE_DPKG = "application/vnd.xmpie.dpkg";
  public static final String VND_XMPIE_PLAN = "application/vnd.xmpie.plan";
  public static final String VND_XMPIE_PPKG = "application/vnd.xmpie.ppkg";
  public static final String VND_XMPIE_XLIM = "application/vnd.xmpie.xlim";
  public static final String VND_YAMAHA_HV_DIC = "application/vnd.yamaha.hv-dic";
  public static final String VND_YAMAHA_HV_SCRIPT = "application/vnd.yamaha.hv-script";
  public static final String VND_YAMAHA_HV_VOICE = "application/vnd.yamaha.hv-voice";
  public static final String VND_YAMAHA_OPENSCOREFORMAT_OSFPVG_XML = "application/vnd.yamaha.openscoreformat.osfpvg+xml";
  public static final String VND_YAMAHA_OPENSCOREFORMAT = "application/vnd.yamaha.openscoreformat";
  public static final String VND_YAMAHA_REMOTE_SETUP = "application/vnd.yamaha.remote-setup";
  public static final String VND_YAMAHA_SMAF_AUDIO = "application/vnd.yamaha.smaf-audio";
  public static final String VND_YAMAHA_SMAF_PHRASE = "application/vnd.yamaha.smaf-phrase";
  public static final String VND_YAMAHA_THROUGH_NGN = "application/vnd.yamaha.through-ngn";
  public static final String VND_YAMAHA_TUNNEL_UDPENCAP = "application/vnd.yamaha.tunnel-udpencap";
  public static final String VND_YAOWEME = "application/vnd.yaoweme";
  public static final String VND_YELLOWRIVER_CUSTOM_MENU = "application/vnd.yellowriver-custom-menu";
  public static final String VND_YOUTUBE_YT_APPLICATION = "application/vnd.youtube.yt";
  public static final String VND_ZUL = "application/vnd.zul";
  public static final String VND_ZZAZZ_DECK_XML = "application/vnd.zzazz.deck+xml";
  public static final String VOICEXML_XML = "application/voicexml+xml";
  public static final String VOUCHER_CMS_JSON = "application/voucher-cms+json";
  public static final String VQ_RTCPXR = "application/vq-rtcpxr";
  public static final String WASM = "application/wasm";
  public static final String WATCHERINFO_XML = "application/watcherinfo+xml";
  public static final String WEBPUSH_OPTIONS_JSON = "application/webpush-options+json";
  public static final String WHOISPP_QUERY = "application/whoispp-query";
  public static final String WHOISPP_RESPONSE = "application/whoispp-response";
  public static final String WIDGET = "application/widget";
  public static final String WITA = "application/wita";
  public static final String WORDPERFECT5_1 = "application/wordperfect5.1";
  public static final String WSDL_XML = "application/wsdl+xml";
  public static final String WSPOLICY_XML = "application/wspolicy+xml";
  public static final String X_PKI_MESSAGE = "application/x-pki-message";
  public static final String X_WWW_FORM_URLENCODED = "application/x-www-form-urlencoded";
  public static final String X_X509_CA_CERT = "application/x-x509-ca-cert";
  public static final String X_X509_CA_RA_CERT = "application/x-x509-ca-ra-cert";
  public static final String X_X509_NEXT_CA_CERT = "application/x-x509-next-ca-cert";
  public static final String X400_BP = "application/x400-bp";
  public static final String XACML_XML = "application/xacml+xml";
  public static final String XCAP_ATT_XML = "application/xcap-att+xml";
  public static final String XCAP_CAPS_XML = "application/xcap-caps+xml";
  public static final String XCAP_DIFF_XML = "application/xcap-diff+xml";
  public static final String XCAP_EL_XML = "application/xcap-el+xml";
  public static final String XCAP_ERROR_XML = "application/xcap-error+xml";
  public static final String XCAP_NS_XML = "application/xcap-ns+xml";
  public static final String XCON_CONFERENCE_INFO_DIFF_XML = "application/xcon-conference-info-diff+xml";
  public static final String XCON_CONFERENCE_INFO_XML = "application/xcon-conference-info+xml";
  public static final String XENC_XML = "application/xenc+xml";
  public static final String XHTML_XML = "application/xhtml+xml";
  public static final String XLIFF_XML = "application/xliff+xml";
  public static final String XML_APPLICATION = "application/xml";
  public static final String XML_DTD = "application/xml-dtd";
  public static final String XML_EXTERNAL_PARSED_ENTITY_APPLICATION = "application/xml-external-parsed-entity";
  public static final String XML_PATCH_XML = "application/xml-patch+xml";
  public static final String XMPP_XML = "application/xmpp+xml";
  public static final String XOP_XML = "application/xop+xml";
  public static final String XSLT_XML = "application/xslt+xml";
  public static final String XV_XML = "application/xv+xml";
  public static final String YANG = "application/yang";
  public static final String YANG_DATA_JSON = "application/yang-data+json";
  public static final String YANG_DATA_XML = "application/yang-data+xml";
  public static final String YANG_PATCH_JSON = "application/yang-patch+json";
  public static final String YANG_PATCH_XML = "application/yang-patch+xml";
  public static final String YIN_XML = "application/yin+xml";
  public static final String ZIP = "application/zip";
  public static final String ZLIB = "application/zlib";
  public static final String ZSTD = "application/zstd";
  public static final String _1D_INTERLEAVED_PARITYFEC_AUDIO = "audio/1d-interleaved-parityfec";
  public static final String _32KADPCM = "audio/32kadpcm";
  public static final String _3GPP_AUDIO = "audio/3gpp";
  public static final String _3GPP2_AUDIO = "audio/3gpp2";
  public static final String AAC = "audio/aac";
  public static final String AC3 = "audio/ac3";
  public static final String AMR = "audio/AMR";
  public static final String AMR_WB = "audio/AMR-WB";
  public static final String AMR_WB_ = "audio/amr-wb+";
  public static final String APTX = "audio/aptx";
  public static final String ASC = "audio/asc";
  public static final String ATRAC_ADVANCED_LOSSLESS = "audio/ATRAC-ADVANCED-LOSSLESS";
  public static final String ATRAC_X = "audio/ATRAC-X";
  public static final String ATRAC3 = "audio/ATRAC3";
  public static final String BASIC = "audio/basic";
  public static final String BV16 = "audio/BV16";
  public static final String BV32 = "audio/BV32";
  public static final String CLEARMODE = "audio/clearmode";
  public static final String CN = "audio/CN";
  public static final String DAT12 = "audio/DAT12";
  public static final String DLS = "audio/dls";
  public static final String DSR_ES201108 = "audio/dsr-es201108";
  public static final String DSR_ES202050 = "audio/dsr-es202050";
  public static final String DSR_ES202211 = "audio/dsr-es202211";
  public static final String DSR_ES202212 = "audio/dsr-es202212";
  public static final String DV_AUDIO = "audio/DV";
  public static final String DVI4 = "audio/DVI4";
  public static final String EAC3 = "audio/eac3";
  public static final String ENCAPRTP_AUDIO = "audio/encaprtp";
  public static final String EVRC = "audio/EVRC";
  public static final String EVRC_QCP = "audio/EVRC-QCP";
  public static final String EVRC0 = "audio/EVRC0";
  public static final String EVRC1 = "audio/EVRC1";
  public static final String EVRCB = "audio/EVRCB";
  public static final String EVRCB0 = "audio/EVRCB0";
  public static final String EVRCB1 = "audio/EVRCB1";
  public static final String EVRCNW = "audio/EVRCNW";
  public static final String EVRCNW0 = "audio/EVRCNW0";
  public static final String EVRCNW1 = "audio/EVRCNW1";
  public static final String EVRCWB = "audio/EVRCWB";
  public static final String EVRCWB0 = "audio/EVRCWB0";
  public static final String EVRCWB1 = "audio/EVRCWB1";
  public static final String EVS = "audio/EVS";
  public static final String EXAMPLE_AUDIO = "audio/example";
  public static final String FLEXFEC_AUDIO = "audio/flexfec";
  public static final String FWDRED_AUDIO = "audio/fwdred";
  public static final String G711_0 = "audio/G711-0";
  public static final String G719 = "audio/G719";
  public static final String G7221 = "audio/G7221";
  public static final String G722 = "audio/G722";
  public static final String G723 = "audio/G723";
  public static final String G726_16 = "audio/G726-16";
  public static final String G726_24 = "audio/G726-24";
  public static final String G726_32 = "audio/G726-32";
  public static final String G726_40 = "audio/G726-40";
  public static final String G728 = "audio/G728";
  public static final String G729 = "audio/G729";
  public static final String G7291 = "audio/G7291";
  public static final String G729D = "audio/G729D";
  public static final String G729E = "audio/G729E";
  public static final String GSM = "audio/GSM";
  public static final String GSM_EFR = "audio/GSM-EFR";
  public static final String GSM_HR_08 = "audio/GSM-HR-08";
  public static final String ILBC = "audio/iLBC";
  public static final String IP_MR_V2_5 = "audio/ip-mr_v2.5";
  public static final String L8 = "audio/L8";
  public static final String L16 = "audio/L16";
  public static final String L20 = "audio/L20";
  public static final String L24 = "audio/L24";
  public static final String LPC = "audio/LPC";
  public static final String MELP = "audio/MELP";
  public static final String MELP600 = "audio/MELP600";
  public static final String MELP1200 = "audio/MELP1200";
  public static final String MELP2400 = "audio/MELP2400";
  public static final String MHAS = "audio/mhas";
  public static final String MOBILE_XMF = "audio/mobile-xmf";
  public static final String MPA = "audio/MPA";
  public static final String MP4_AUDIO = "audio/mp4";
  public static final String MP4A_LATM = "audio/MP4A-LATM";
  public static final String MPA_ROBUST = "audio/mpa-robust";
  public static final String MPEG = "audio/mpeg";
  public static final String MPEG4_GENERIC_AUDIO = "audio/mpeg4-generic";
  public static final String OGG_AUDIO = "audio/ogg";
  public static final String OPUS = "audio/opus";
  public static final String PARITYFEC_AUDIO = "audio/parityfec";
  public static final String PCMA = "audio/PCMA";
  public static final String PCMA_WB = "audio/PCMA-WB";
  public static final String PCMU = "audio/PCMU";
  public static final String PCMU_WB = "audio/PCMU-WB";
  public static final String PRS_SID = "audio/prs.sid";
  public static final String QCELP = "audio/QCELP";
  public static final String RAPTORFEC_AUDIO = "audio/raptorfec";
  public static final String RED_AUDIO = "audio/RED";
  public static final String RTP_ENC_AESCM128_AUDIO = "audio/rtp-enc-aescm128";
  public static final String RTPLOOPBACK_AUDIO = "audio/rtploopback";
  public static final String RTP_MIDI = "audio/rtp-midi";
  public static final String RTX_AUDIO = "audio/rtx";
  public static final String SCIP_AUDIO = "audio/scip";
  public static final String SMV = "audio/SMV";
  public static final String SMV0 = "audio/SMV0";
  public static final String SMV_QCP = "audio/SMV-QCP";
  public static final String SOFA = "audio/sofa";
  public static final String SP_MIDI = "audio/sp-midi";
  public static final String SPEEX = "audio/speex";
  public static final String T140C = "audio/t140c";
  public static final String T38_AUDIO = "audio/t38";
  public static final String TELEPHONE_EVENT = "audio/telephone-event";
  public static final String TETRA_ACELP = "audio/TETRA_ACELP";
  public static final String TETRA_ACELP_BB = "audio/TETRA_ACELP_BB";
  public static final String TONE = "audio/tone";
  public static final String TSVCIS = "audio/TSVCIS";
  public static final String UEMCLIP = "audio/UEMCLIP";
  public static final String ULPFEC_AUDIO = "audio/ulpfec";
  public static final String USAC = "audio/usac";
  public static final String VDVI = "audio/VDVI";
  public static final String VMR_WB = "audio/VMR-WB";
  public static final String VND_3GPP_IUFP = "audio/vnd.3gpp.iufp";
  public static final String VND_4SB = "audio/vnd.4SB";
  public static final String VND_AUDIOKOZ = "audio/vnd.audiokoz";
  public static final String VND_CELP = "audio/vnd.CELP";
  public static final String VND_CISCO_NSE = "audio/vnd.cisco.nse";
  public static final String VND_CMLES_RADIO_EVENTS = "audio/vnd.cmles.radio-events";
  public static final String VND_CNS_ANP1 = "audio/vnd.cns.anp1";
  public static final String VND_CNS_INF1 = "audio/vnd.cns.inf1";
  public static final String VND_DECE_AUDIO = "audio/vnd.dece.audio";
  public static final String VND_DIGITAL_WINDS = "audio/vnd.digital-winds";
  public static final String VND_DLNA_ADTS = "audio/vnd.dlna.adts";
  public static final String VND_DOLBY_HEAAC_1 = "audio/vnd.dolby.heaac.1";
  public static final String VND_DOLBY_HEAAC_2 = "audio/vnd.dolby.heaac.2";
  public static final String VND_DOLBY_MLP = "audio/vnd.dolby.mlp";
  public static final String VND_DOLBY_MPS = "audio/vnd.dolby.mps";
  public static final String VND_DOLBY_PL2 = "audio/vnd.dolby.pl2";
  public static final String VND_DOLBY_PL2X = "audio/vnd.dolby.pl2x";
  public static final String VND_DOLBY_PL2Z = "audio/vnd.dolby.pl2z";
  public static final String VND_DOLBY_PULSE_1 = "audio/vnd.dolby.pulse.1";
  public static final String VND_DRA = "audio/vnd.dra";
  public static final String VND_DTS = "audio/vnd.dts";
  public static final String VND_DTS_HD = "audio/vnd.dts.hd";
  public static final String VND_DTS_UHD = "audio/vnd.dts.uhd";
  public static final String VND_DVB_FILE_AUDIO = "audio/vnd.dvb.file";
  public static final String VND_EVERAD_PLJ = "audio/vnd.everad.plj";
  public static final String VND_HNS_AUDIO = "audio/vnd.hns.audio";
  public static final String VND_LUCENT_VOICE = "audio/vnd.lucent.voice";
  public static final String VND_MS_PLAYREADY_MEDIA_PYA = "audio/vnd.ms-playready.media.pya";
  public static final String VND_NOKIA_MOBILE_XMF = "audio/vnd.nokia.mobile-xmf";
  public static final String VND_NORTEL_VBK = "audio/vnd.nortel.vbk";
  public static final String VND_NUERA_ECELP4800 = "audio/vnd.nuera.ecelp4800";
  public static final String VND_NUERA_ECELP7470 = "audio/vnd.nuera.ecelp7470";
  public static final String VND_NUERA_ECELP9600 = "audio/vnd.nuera.ecelp9600";
  public static final String VND_OCTEL_SBC = "audio/vnd.octel.sbc";
  public static final String VND_PRESONUS_MULTITRACK = "audio/vnd.presonus.multitrack";
  public static final String VND_QCELP = "audio/vnd.qcelp";
  public static final String VND_RHETOREX_32KADPCM = "audio/vnd.rhetorex.32kadpcm";
  public static final String VND_RIP = "audio/vnd.rip";
  public static final String VND_SEALEDMEDIA_SOFTSEAL_MPEG = "audio/vnd.sealedmedia.softseal.mpeg";
  public static final String VND_VMX_CVSD = "audio/vnd.vmx.cvsd";
  public static final String VORBIS = "audio/vorbis";
  public static final String VORBIS_CONFIG = "audio/vorbis-config";
  public static final String COLLECTION = "font/collection";
  public static final String OTF = "font/otf";
  public static final String SFNT = "font/sfnt";
  public static final String TTF = "font/ttf";
  public static final String WOFF = "font/woff";
  public static final String WOFF2 = "font/woff2";
  public static final String ACES = "image/aces";
  public static final String AVCI = "image/avci";
  public static final String AVCS = "image/avcs";
  public static final String AVIF = "image/avif";
  public static final String BMP = "image/bmp";
  public static final String CGM = "image/cgm";
  public static final String DICOM_RLE = "image/dicom-rle";
  public static final String EMF = "image/emf";
  public static final String EXAMPLE_IMAGE = "image/example";
  public static final String FITS_IMAGE = "image/fits";
  public static final String G3FAX = "image/g3fax";
  public static final String HEIC = "image/heic";
  public static final String HEIC_SEQUENCE = "image/heic-sequence";
  public static final String HEIF = "image/heif";
  public static final String HEIF_SEQUENCE = "image/heif-sequence";
  public static final String HEJ2K = "image/hej2k";
  public static final String HSJ2 = "image/hsj2";
  public static final String JLS = "image/jls";
  public static final String JP2 = "image/jp2";
  public static final String JPH = "image/jph";
  public static final String JPHC = "image/jphc";
  public static final String JPM = "image/jpm";
  public static final String JPX = "image/jpx";
  public static final String JXR = "image/jxr";
  public static final String JXRA = "image/jxrA";
  public static final String JXRS = "image/jxrS";
  public static final String JXS = "image/jxs";
  public static final String JXSC = "image/jxsc";
  public static final String JXSI = "image/jxsi";
  public static final String JXSS = "image/jxss";
  public static final String KTX = "image/ktx";
  public static final String KTX2 = "image/ktx2";
  public static final String NAPLPS = "image/naplps";
  public static final String PNG = "image/png";
  public static final String PRS_BTIF = "image/prs.btif";
  public static final String PRS_PTI = "image/prs.pti";
  public static final String PWG_RASTER = "image/pwg-raster";
  public static final String SVG_XML = "image/svg+xml";
  public static final String T38_IMAGE = "image/t38";
  public static final String TIFF = "image/tiff";
  public static final String TIFF_FX = "image/tiff-fx";
  public static final String VND_ADOBE_PHOTOSHOP = "image/vnd.adobe.photoshop";
  public static final String VND_AIRZIP_ACCELERATOR_AZV = "image/vnd.airzip.accelerator.azv";
  public static final String VND_CNS_INF2 = "image/vnd.cns.inf2";
  public static final String VND_DECE_GRAPHIC = "image/vnd.dece.graphic";
  public static final String VND_DJVU = "image/vnd.djvu";
  public static final String VND_DWG = "image/vnd.dwg";
  public static final String VND_DXF = "image/vnd.dxf";
  public static final String VND_DVB_SUBTITLE_IMAGE = "image/vnd.dvb.subtitle";
  public static final String VND_FASTBIDSHEET = "image/vnd.fastbidsheet";
  public static final String VND_FPX = "image/vnd.fpx";
  public static final String VND_FST = "image/vnd.fst";
  public static final String VND_FUJIXEROX_EDMICS_MMR = "image/vnd.fujixerox.edmics-mmr";
  public static final String VND_FUJIXEROX_EDMICS_RLC = "image/vnd.fujixerox.edmics-rlc";
  public static final String VND_GLOBALGRAPHICS_PGB = "image/vnd.globalgraphics.pgb";
  public static final String VND_MICROSOFT_ICON = "image/vnd.microsoft.icon";
  public static final String VND_MIX = "image/vnd.mix";
  public static final String VND_MS_MODI = "image/vnd.ms-modi";
  public static final String VND_MOZILLA_APNG = "image/vnd.mozilla.apng";
  public static final String VND_NET_FPX = "image/vnd.net-fpx";
  public static final String VND_PCO_B16 = "image/vnd.pco.b16";
  public static final String VND_RADIANCE = "image/vnd.radiance";
  public static final String VND_SEALED_PNG = "image/vnd.sealed.png";
  public static final String VND_SEALEDMEDIA_SOFTSEAL_GIF = "image/vnd.sealedmedia.softseal.gif";
  public static final String VND_SEALEDMEDIA_SOFTSEAL_JPG = "image/vnd.sealedmedia.softseal.jpg";
  public static final String VND_SVF = "image/vnd.svf";
  public static final String VND_TENCENT_TAP = "image/vnd.tencent.tap";
  public static final String VND_VALVE_SOURCE_TEXTURE = "image/vnd.valve.source.texture";
  public static final String VND_WAP_WBMP = "image/vnd.wap.wbmp";
  public static final String VND_XIFF = "image/vnd.xiff";
  public static final String VND_ZBRUSH_PCX = "image/vnd.zbrush.pcx";
  public static final String WMF = "image/wmf";
  public static final String CPIM = "message/CPIM";
  public static final String DELIVERY_STATUS = "message/delivery-status";
  public static final String DISPOSITION_NOTIFICATION = "message/disposition-notification";
  public static final String EXAMPLE_MESSAGE = "message/example";
  public static final String FEEDBACK_REPORT = "message/feedback-report";
  public static final String GLOBAL = "message/global";
  public static final String GLOBAL_DELIVERY_STATUS = "message/global-delivery-status";
  public static final String GLOBAL_DISPOSITION_NOTIFICATION = "message/global-disposition-notification";
  public static final String GLOBAL_HEADERS = "message/global-headers";
  public static final String HTTP_MESSAGE = "message/http";
  public static final String IMDN_XML = "message/imdn+xml";
  public static final String NEWS = "message/news";
  public static final String S_HTTP = "message/s-http";
  public static final String SIP = "message/sip";
  public static final String SIPFRAG = "message/sipfrag";
  public static final String TRACKING_STATUS = "message/tracking-status";
  public static final String VND_SI_SIMP = "message/vnd.si.simp";
  public static final String VND_WFA_WSC_MESSAGE = "message/vnd.wfa.wsc";
  public static final String _3MF = "model/3mf";
  public static final String E57 = "model/e57";
  public static final String EXAMPLE_MODEL = "model/example";
  public static final String GLTF_BINARY = "model/gltf-binary";
  public static final String GLTF_JSON = "model/gltf+json";
  public static final String IGES_MODEL = "model/iges";
  public static final String MTL = "model/mtl";
  public static final String OBJ = "model/obj";
  public static final String PRC = "model/prc";
  public static final String STEP = "model/step";
  public static final String STEP_XML = "model/step+xml";
  public static final String STEP_ZIP = "model/step+zip";
  public static final String STEP_XML_ZIP = "model/step-xml+zip";
  public static final String STL = "model/stl";
  public static final String U3D = "model/u3d";
  public static final String VND_COLLADA_XML = "model/vnd.collada+xml";
  public static final String VND_DWF = "model/vnd.dwf";
  public static final String VND_FLATLAND_3DML = "model/vnd.flatland.3dml";
  public static final String VND_GDL = "model/vnd.gdl";
  public static final String VND_GS_GDL = "model/vnd.gs-gdl";
  public static final String VND_GTW = "model/vnd.gtw";
  public static final String VND_MOML_XML = "model/vnd.moml+xml";
  public static final String VND_MTS = "model/vnd.mts";
  public static final String VND_OPENGEX = "model/vnd.opengex";
  public static final String VND_PARASOLID_TRANSMIT_BINARY = "model/vnd.parasolid.transmit.binary";
  public static final String VND_PARASOLID_TRANSMIT_TEXT = "model/vnd.parasolid.transmit.text";
  public static final String VND_PYTHA_PYOX = "model/vnd.pytha.pyox";
  public static final String VND_ROSETTE_ANNOTATED_DATA_MODEL = "model/vnd.rosette.annotated-data-model";
  public static final String VND_SAP_VDS = "model/vnd.sap.vds";
  public static final String VND_USDZ_ZIP = "model/vnd.usdz+zip";
  public static final String VND_VALVE_SOURCE_COMPILED_MAP = "model/vnd.valve.source.compiled-map";
  public static final String VND_VTU = "model/vnd.vtu";
  public static final String X3D_VRML = "model/x3d-vrml";
  public static final String X3D_FASTINFOSET = "model/x3d+fastinfoset";
  public static final String X3D_XML = "model/x3d+xml";
  public static final String APPLEDOUBLE = "multipart/appledouble";
  public static final String BYTERANGES = "multipart/byteranges";
  public static final String ENCRYPTED = "multipart/encrypted";
  public static final String EXAMPLE_MULTIPART = "multipart/example";
  public static final String FORM_DATA = "multipart/form-data";
  public static final String HEADER_SET = "multipart/header-set";
  public static final String MULTILINGUAL = "multipart/multilingual";
  public static final String RELATED = "multipart/related";
  public static final String REPORT = "multipart/report";
  public static final String SIGNED = "multipart/signed";
  public static final String VND_BINT_MED_PLUS = "multipart/vnd.bint.med-plus";
  public static final String VOICE_MESSAGE = "multipart/voice-message";
  public static final String X_MIXED_REPLACE = "multipart/x-mixed-replace";
  public static final String _1D_INTERLEAVED_PARITYFEC_TEXT = "text/1d-interleaved-parityfec";
  public static final String CACHE_MANIFEST = "text/cache-manifest";
  public static final String CALENDAR = "text/calendar";
  public static final String CQL = "text/cql";
  public static final String CQL_EXPRESSION = "text/cql-expression";
  public static final String CQL_IDENTIFIER = "text/cql-identifier";
  public static final String CSS = "text/css";
  public static final String CSV = "text/csv";
  public static final String CSV_SCHEMA = "text/csv-schema";
  public static final String DIRECTORY = "text/directory";
  public static final String DNS_TEXT = "text/dns";
  public static final String ECMASCRIPT_TEXT = "text/ecmascript";
  public static final String ENCAPRTP_TEXT = "text/encaprtp";
  public static final String EXAMPLE_TEXT = "text/example";
  public static final String FHIRPATH = "text/fhirpath";
  public static final String FLEXFEC_TEXT = "text/flexfec";
  public static final String FWDRED_TEXT = "text/fwdred";
  public static final String GFF3 = "text/gff3";
  public static final String GRAMMAR_REF_LIST = "text/grammar-ref-list";
  public static final String HTML = "text/html";
  public static final String JAVASCRIPT_TEXT = "text/javascript";
  public static final String JCR_CND = "text/jcr-cnd";
  public static final String MARKDOWN = "text/markdown";
  public static final String MIZAR = "text/mizar";
  public static final String N3 = "text/n3";
  public static final String PARAMETERS = "text/parameters";
  public static final String PARITYFEC_TEXT = "text/parityfec";
  public static final String PROVENANCE_NOTATION = "text/provenance-notation";
  public static final String PRS_FALLENSTEIN_RST = "text/prs.fallenstein.rst";
  public static final String PRS_LINES_TAG = "text/prs.lines.tag";
  public static final String PRS_PROP_LOGIC = "text/prs.prop.logic";
  public static final String RAPTORFEC_TEXT = "text/raptorfec";
  public static final String RED_TEXT = "text/RED";
  public static final String RFC822_HEADERS = "text/rfc822-headers";
  public static final String RTF_TEXT = "text/rtf";
  public static final String RTP_ENC_AESCM128_TEXT = "text/rtp-enc-aescm128";
  public static final String RTPLOOPBACK_TEXT = "text/rtploopback";
  public static final String RTX_TEXT = "text/rtx";
  public static final String SGML_TEXT = "text/SGML";
  public static final String SHACLC = "text/shaclc";
  public static final String SHEX = "text/shex";
  public static final String SPDX = "text/spdx";
  public static final String STRINGS = "text/strings";
  public static final String T140 = "text/t140";
  public static final String TAB_SEPARATED_VALUES = "text/tab-separated-values";
  public static final String TROFF = "text/troff";
  public static final String TURTLE = "text/turtle";
  public static final String ULPFEC_TEXT = "text/ulpfec";
  public static final String URI_LIST = "text/uri-list";
  public static final String VCARD = "text/vcard";
  public static final String VND_A = "text/vnd.a";
  public static final String VND_ABC = "text/vnd.abc";
  public static final String VND_ASCII_ART = "text/vnd.ascii-art";
  public static final String VND_CURL_TEXT = "text/vnd.curl";
  public static final String VND_DEBIAN_COPYRIGHT = "text/vnd.debian.copyright";
  public static final String VND_DMCLIENTSCRIPT = "text/vnd.DMClientScript";
  public static final String VND_DVB_SUBTITLE_TEXT = "text/vnd.dvb.subtitle";
  public static final String VND_ESMERTEC_THEME_DESCRIPTOR = "text/vnd.esmertec.theme-descriptor";
  public static final String VND_FAMILYSEARCH_GEDCOM = "text/vnd.familysearch.gedcom";
  public static final String VND_FICLAB_FLT = "text/vnd.ficlab.flt";
  public static final String VND_FLY = "text/vnd.fly";
  public static final String VND_FMI_FLEXSTOR = "text/vnd.fmi.flexstor";
  public static final String VND_GML = "text/vnd.gml";
  public static final String VND_GRAPHVIZ = "text/vnd.graphviz";
  public static final String VND_HANS = "text/vnd.hans";
  public static final String VND_HGL = "text/vnd.hgl";
  public static final String VND_IN3D_3DML = "text/vnd.in3d.3dml";
  public static final String VND_IN3D_SPOT = "text/vnd.in3d.spot";
  public static final String VND_IPTC_NEWSML = "text/vnd.IPTC.NewsML";
  public static final String VND_IPTC_NITF = "text/vnd.IPTC.NITF";
  public static final String VND_LATEX_Z = "text/vnd.latex-z";
  public static final String VND_MOTOROLA_REFLEX = "text/vnd.motorola.reflex";
  public static final String VND_MS_MEDIAPACKAGE = "text/vnd.ms-mediapackage";
  public static final String VND_NET2PHONE_COMMCENTER_COMMAND = "text/vnd.net2phone.commcenter.command";
  public static final String VND_RADISYS_MSML_BASIC_LAYOUT = "text/vnd.radisys.msml-basic-layout";
  public static final String VND_SENX_WARPSCRIPT = "text/vnd.senx.warpscript";
  public static final String VND_SI_URICATALOGUE = "text/vnd.si.uricatalogue";
  public static final String VND_SUN_J2ME_APP_DESCRIPTOR = "text/vnd.sun.j2me.app-descriptor";
  public static final String VND_SOSI = "text/vnd.sosi";
  public static final String VND_TROLLTECH_LINGUIST = "text/vnd.trolltech.linguist";
  public static final String VND_WAP_SI = "text/vnd.wap.si";
  public static final String VND_WAP_SL = "text/vnd.wap.sl";
  public static final String VND_WAP_WML = "text/vnd.wap.wml";
  public static final String VND_WAP_WMLSCRIPT = "text/vnd.wap.wmlscript";
  public static final String VTT = "text/vtt";
  public static final String XML_TEXT = "text/xml";
  public static final String XML_EXTERNAL_PARSED_ENTITY_TEXT = "text/xml-external-parsed-entity";
  public static final String _1D_INTERLEAVED_PARITYFEC_VIDEO = "video/1d-interleaved-parityfec";
  public static final String _3GPP_VIDEO = "video/3gpp";
  public static final String _3GPP2_VIDEO = "video/3gpp2";
  public static final String _3GPP_TT = "video/3gpp-tt";
  public static final String AV1 = "video/AV1";
  public static final String BMPEG = "video/BMPEG";
  public static final String BT656 = "video/BT656";
  public static final String CELB = "video/CelB";
  public static final String DV_VIDEO = "video/DV";
  public static final String ENCAPRTP_VIDEO = "video/encaprtp";
  public static final String EXAMPLE_VIDEO = "video/example";
  public static final String FFV1 = "video/FFV1";
  public static final String FLEXFEC_VIDEO = "video/flexfec";
  public static final String H261 = "video/H261";
  public static final String H263 = "video/H263";
  public static final String H263_1998 = "video/H263-1998";
  public static final String H263_2000 = "video/H263-2000";
  public static final String H264 = "video/H264";
  public static final String H264_RCDO = "video/H264-RCDO";
  public static final String H264_SVC = "video/H264-SVC";
  public static final String H265 = "video/H265";
  public static final String ISO_SEGMENT = "video/iso.segment";
  public static final String JPEG = "video/JPEG";
  public static final String JPEG2000 = "video/jpeg2000";
  public static final String JXSV = "video/jxsv";
  public static final String MJ2 = "video/mj2";
  public static final String MP1S = "video/MP1S";
  public static final String MP2P = "video/MP2P";
  public static final String MP2T = "video/MP2T";
  public static final String MP4 = "video/mp4";
  public static final String MP4V_ES = "video/MP4V-ES";
  public static final String MPV = "video/MPV";
  public static final String MPEG4_GENERIC = "video/mpeg4-generic";
  public static final String NV = "video/nv";
  public static final String OGG = "video/ogg";
  public static final String PARITYFEC_VIDEO = "video/parityfec";
  public static final String POINTER = "video/pointer";
  public static final String QUICKTIME = "video/quicktime";
  public static final String RAPTORFEC_VIDEO = "video/raptorfec";
  public static final String RAW = "video/raw";
  public static final String RTP_ENC_AESCM128 = "video/rtp-enc-aescm128";
  public static final String RTPLOOPBACK_VIDEO = "video/rtploopback";
  public static final String RTX_VIDEO = "video/rtx";
  public static final String SCIP_VIDEO = "video/scip";
  public static final String SMPTE291 = "video/smpte291";
  public static final String SMPTE292M = "video/SMPTE292M";
  public static final String ULPFEC_VIDEO = "video/ulpfec";
  public static final String VC1 = "video/vc1";
  public static final String VC2 = "video/vc2";
  public static final String VND_CCTV = "video/vnd.CCTV";
  public static final String VND_DECE_HD = "video/vnd.dece.hd";
  public static final String VND_DECE_MOBILE = "video/vnd.dece.mobile";
  public static final String VND_DECE_MP4 = "video/vnd.dece.mp4";
  public static final String VND_DECE_PD = "video/vnd.dece.pd";
  public static final String VND_DECE_SD = "video/vnd.dece.sd";
  public static final String VND_DECE_VIDEO = "video/vnd.dece.video";
  public static final String VND_DIRECTV_MPEG = "video/vnd.directv.mpeg";
  public static final String VND_DIRECTV_MPEG_TTS = "video/vnd.directv.mpeg-tts";
  public static final String VND_DLNA_MPEG_TTS = "video/vnd.dlna.mpeg-tts";
  public static final String VND_DVB_FILE_VIDEO = "video/vnd.dvb.file";
  public static final String VND_FVT = "video/vnd.fvt";
  public static final String VND_HNS_VIDEO = "video/vnd.hns.video";
  public static final String VND_IPTVFORUM_1DPARITYFEC_1010 = "video/vnd.iptvforum.1dparityfec-1010";
  public static final String VND_IPTVFORUM_1DPARITYFEC_2005 = "video/vnd.iptvforum.1dparityfec-2005";
  public static final String VND_IPTVFORUM_2DPARITYFEC_1010 = "video/vnd.iptvforum.2dparityfec-1010";
  public static final String VND_IPTVFORUM_2DPARITYFEC_2005 = "video/vnd.iptvforum.2dparityfec-2005";
  public static final String VND_IPTVFORUM_TTSAVC = "video/vnd.iptvforum.ttsavc";
  public static final String VND_IPTVFORUM_TTSMPEG2 = "video/vnd.iptvforum.ttsmpeg2";
  public static final String VND_MOTOROLA_VIDEO = "video/vnd.motorola.video";
  public static final String VND_MOTOROLA_VIDEOP = "video/vnd.motorola.videop";
  public static final String VND_MPEGURL = "video/vnd.mpegurl";
  public static final String VND_MS_PLAYREADY_MEDIA_PYV = "video/vnd.ms-playready.media.pyv";
  public static final String VND_NOKIA_INTERLEAVED_MULTIMEDIA = "video/vnd.nokia.interleaved-multimedia";
  public static final String VND_NOKIA_MP4VR = "video/vnd.nokia.mp4vr";
  public static final String VND_NOKIA_VIDEOVOIP = "video/vnd.nokia.videovoip";
  public static final String VND_OBJECTVIDEO = "video/vnd.objectvideo";
  public static final String VND_RADGAMETTOOLS_BINK = "video/vnd.radgamettools.bink";
  public static final String VND_RADGAMETTOOLS_SMACKER = "video/vnd.radgamettools.smacker";
  public static final String VND_SEALED_MPEG1 = "video/vnd.sealed.mpeg1";
  public static final String VND_SEALED_MPEG4 = "video/vnd.sealed.mpeg4";
  public static final String VND_SEALED_SWF = "video/vnd.sealed.swf";
  public static final String VND_SEALEDMEDIA_SOFTSEAL_MOV = "video/vnd.sealedmedia.softseal.mov";
  public static final String VND_UVVU_MP4 = "video/vnd.uvvu.mp4";
  public static final String VND_YOUTUBE_YT_VIDEO = "video/vnd.youtube.yt";
  public static final String VND_VIVO = "video/vnd.vivo";
  public static final String VP8 = "video/VP8";
  public static final String VP9 = "video/VP9";
}
