/*
 * Decompiled with CFR 0.152.
 */
package top.zhogjianhao;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.collections4.IteratorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.zhogjianhao.ClassUtils;

public class CollectionUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CollectionUtils.class);

    public static boolean isEmpty(Collection<?> coll) {
        return !org.apache.commons.collections4.CollectionUtils.isNotEmpty(coll);
    }

    public static boolean isNotEmpty(Collection<?> coll) {
        return !CollectionUtils.isEmpty(coll);
    }

    public static boolean isEmptys(Collection<?> ... colls) {
        if (colls == null) {
            return true;
        }
        if (colls.length == 0) {
            throw new IllegalArgumentException("Colls: length should be greater than 0");
        }
        for (Collection<?> coll : colls) {
            if (!CollectionUtils.isEmpty(coll)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotEmptys(Collection<?> ... colls) {
        return !CollectionUtils.isEmptys(colls);
    }

    public static boolean sizeIsEmpty(Object object) {
        return org.apache.commons.collections4.CollectionUtils.sizeIsEmpty((Object)object);
    }

    public static boolean sizeIsNotEmpty(@NonNull Object object) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        return !CollectionUtils.sizeIsEmpty(object);
    }

    public static boolean sizeIsEmptys(Object ... objects) {
        if (objects == null) {
            return true;
        }
        if (objects.length == 0) {
            throw new IllegalArgumentException("Objects: length should be greater than 0");
        }
        for (Object object : objects) {
            if (!CollectionUtils.sizeIsEmpty(object)) continue;
            return false;
        }
        return true;
    }

    public static boolean sizeIsNotEmptys(Object ... objects) {
        if (objects == null) {
            throw new NullPointerException("objects is marked non-null but is null");
        }
        return !CollectionUtils.sizeIsEmptys(objects);
    }

    public static boolean isAllEmpty(Object object) {
        block8: {
            block9: {
                block7: {
                    if (object == null) {
                        return true;
                    }
                    if (object instanceof Collection) {
                        Collection obj1 = (Collection)object;
                        obj1.removeIf(Objects::isNull);
                        return obj1.size() == 0;
                    }
                    if (!(object instanceof Iterable)) break block7;
                    for (Object o : (Iterable)object) {
                        if (o == null) continue;
                        return false;
                    }
                    break block8;
                }
                if (object instanceof Map) {
                    return CollectionUtils.isAllEmptys(((Map)object).values());
                }
                if (object instanceof Object[]) {
                    Object[] obj1 = (Object[])object;
                    return Arrays.stream(obj1).noneMatch(Objects::nonNull);
                }
                if (!(object instanceof Iterator)) break block9;
                Iterator obj1 = (Iterator)object;
                while (obj1.hasNext()) {
                    if (obj1.next() == null) continue;
                    return false;
                }
                break block8;
            }
            if (!(object instanceof Enumeration)) break block8;
            Enumeration obj1 = (Enumeration)object;
            while (obj1.hasMoreElements()) {
                if (obj1.nextElement() == null) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isNotAllEmpty(@NonNull Object object) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        return !CollectionUtils.isAllEmptys(object);
    }

    public static boolean isAllEmptys(Object ... objects) {
        if (objects == null) {
            return true;
        }
        if (objects.length == 0) {
            throw new IllegalArgumentException("Objects: length should be greater than 0");
        }
        for (Object object : objects) {
            if (CollectionUtils.isAllEmpty(object)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotAllEmptys(Object ... objects) {
        if (objects == null) {
            throw new NullPointerException("objects is marked non-null but is null");
        }
        return !CollectionUtils.isAllEmptys(objects);
    }

    public static boolean isAnyEmpty(Object object) {
        block8: {
            block9: {
                block7: {
                    if (CollectionUtils.sizeIsEmpty(object)) {
                        return true;
                    }
                    if (object instanceof Collection) {
                        Collection obj1 = (Collection)object;
                        return obj1.contains(null);
                    }
                    if (!(object instanceof Iterable)) break block7;
                    for (Object o : (Iterable)object) {
                        if (o != null) continue;
                        return true;
                    }
                    break block8;
                }
                if (object instanceof Map) {
                    return ((Map)object).containsValue(null);
                }
                if (object instanceof Object[]) {
                    Object[] obj1 = (Object[])object;
                    return Arrays.stream(obj1).anyMatch(Objects::isNull);
                }
                if (!(object instanceof Iterator)) break block9;
                Iterator obj1 = (Iterator)object;
                while (obj1.hasNext()) {
                    if (obj1.next() != null) continue;
                    return true;
                }
                break block8;
            }
            if (!(object instanceof Enumeration)) break block8;
            Enumeration obj1 = (Enumeration)object;
            while (obj1.hasMoreElements()) {
                if (obj1.nextElement() != null) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isNotAnyEmpty(Object object) {
        return !CollectionUtils.isAnyEmpty(object);
    }

    public static boolean isAnyEmptys(Object ... objects) {
        if (objects == null) {
            return true;
        }
        if (objects.length == 0) {
            throw new IllegalArgumentException("Objects: length should be greater than 0");
        }
        for (Object object : objects) {
            if (!CollectionUtils.isAnyEmpty(object)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNotAnyEmptys(Object ... objects) {
        return !CollectionUtils.isAnyEmptys(objects);
    }

    private static Object toStringByBasic(Object object, boolean isByValue) {
        if (isByValue && (ClassUtils.isBasic(object) || object instanceof BigDecimal || object instanceof BigInteger)) {
            object = object instanceof Float || object instanceof Double || object instanceof BigDecimal ? new BigDecimal(object.toString()).stripTrailingZeros().toPlainString() : object.toString();
        }
        return object;
    }

    public static boolean isAllEquals(boolean isByValue, Function<Object, Boolean> continueFunction, Object ... objects) {
        if (objects == null) {
            return true;
        }
        if (objects.length == 0) {
            throw new IllegalArgumentException("Objects: length should be greater than 0");
        }
        Object prevObj = null;
        for (Object object : objects) {
            Object nextObj;
            int i;
            if (object instanceof Iterator) {
                object = IteratorUtils.toList((Iterator)((Iterator)object));
            }
            if (continueFunction != null && continueFunction.apply(object).booleanValue()) continue;
            if (object instanceof Collection || object instanceof Map) {
                Iterator<Object> iterator = object instanceof Collection ? ((Collection)object).iterator() : ((Map)object).values().iterator();
                i = 0;
                while (iterator.hasNext()) {
                    nextObj = CollectionUtils.toStringByBasic(iterator.next(), isByValue);
                    if (prevObj == null && i == 0) {
                        prevObj = nextObj;
                        i = 1;
                        continue;
                    }
                    if (!Objects.equals(prevObj, nextObj)) {
                        return false;
                    }
                    prevObj = nextObj;
                }
                continue;
            }
            if (object instanceof Iterable) {
                boolean i2 = false;
                for (Object o : (Iterable)object) {
                    Object nextObj2 = CollectionUtils.toStringByBasic(o, isByValue);
                    if (prevObj == null && !i2) {
                        prevObj = nextObj2;
                        i2 = true;
                        continue;
                    }
                    if (!Objects.equals(prevObj, nextObj2)) {
                        return false;
                    }
                    prevObj = nextObj2;
                }
                continue;
            }
            if (object instanceof Object[]) {
                Object[] objects1 = (Object[])object;
                for (i = 0; i < objects1.length; ++i) {
                    nextObj = CollectionUtils.toStringByBasic(objects1[i], isByValue);
                    if (prevObj == null && i == 0) {
                        prevObj = nextObj;
                        i = 1;
                        continue;
                    }
                    if (!Objects.equals(prevObj, nextObj)) {
                        return false;
                    }
                    prevObj = nextObj;
                }
                continue;
            }
            if (!(object instanceof Enumeration)) continue;
            Enumeration enumeration = (Enumeration)object;
            i = 0;
            while (enumeration.hasMoreElements()) {
                nextObj = CollectionUtils.toStringByBasic(enumeration.nextElement(), isByValue);
                if (prevObj == null && i == 0) {
                    prevObj = nextObj;
                    i = 1;
                    continue;
                }
                if (!Objects.equals(prevObj, nextObj)) {
                    return false;
                }
                prevObj = nextObj;
            }
        }
        return true;
    }

    public static boolean isNotAllEquals(boolean isByValue, Function<Object, Boolean> continueFunction, Object ... objects) {
        return !CollectionUtils.isAllEquals(isByValue, continueFunction, objects);
    }

    public static boolean isAllEqualsSameIndex(boolean isByValue, Function<Object, Boolean> continueFunction, Object ... objects) {
        if (objects == null) {
            return true;
        }
        if (objects.length < 2) {
            throw new IllegalArgumentException("Objects: length should be greater than 1");
        }
        Integer objectSize = null;
        for (Object object : objects) {
            if (object instanceof Iterator) {
                object = IteratorUtils.toList((Iterator)((Iterator)object));
            }
            if (continueFunction != null && continueFunction.apply(object).booleanValue()) continue;
            int size = -1;
            if (object instanceof Collection) {
                size = ((Collection)object).size();
            } else if (object instanceof Map) {
                size = ((Map)object).values().size();
            } else if (object instanceof Iterable) {
                int i = 0;
                for (Object o : (Iterable)object) {
                    ++i;
                }
                size = i;
            } else if (object instanceof Object[]) {
                size = ((Object[])object).length;
            } else if (object instanceof Enumeration) {
                Enumeration enumeration = (Enumeration)object;
                int i = 0;
                while (enumeration.hasMoreElements()) {
                    enumeration.nextElement();
                    ++i;
                }
                size = i;
            }
            if (objectSize != null && !objectSize.equals(size)) {
                return false;
            }
            objectSize = size;
        }
        LinkedList<Object> prevList = new LinkedList<Object>();
        for (Object object : objects) {
            Object nextObj;
            if (object instanceof Collection || object instanceof Map) {
                Iterator<Object> iterator = object instanceof Collection ? ((Collection)object).iterator() : ((Map)object).values().iterator();
                int i = 0;
                while (iterator.hasNext()) {
                    nextObj = CollectionUtils.toStringByBasic(iterator.next(), isByValue);
                    if (prevList.size() < i + 1) {
                        prevList.add(nextObj);
                        i = 1;
                    } else {
                        if (!Objects.equals(prevList.get(i), nextObj)) {
                            return false;
                        }
                        prevList.set(i, nextObj);
                    }
                    ++i;
                }
                continue;
            }
            if (object instanceof Iterable) {
                int i = 0;
                for (Object o : (Iterable)object) {
                    Object nextObj2 = CollectionUtils.toStringByBasic(o, isByValue);
                    if (prevList.size() < i + 1) {
                        prevList.add(nextObj2);
                        i = 1;
                        continue;
                    }
                    if (!Objects.equals(prevList.get(i), nextObj2)) {
                        return false;
                    }
                    prevList.set(i, nextObj2);
                    ++i;
                }
                continue;
            }
            if (object instanceof Object[]) {
                Object[] objects1 = (Object[])object;
                for (int i = 0; i < objects1.length; ++i) {
                    nextObj = CollectionUtils.toStringByBasic(objects1[i], isByValue);
                    if (prevList.size() < i + 1) {
                        prevList.add(nextObj);
                        i = 1;
                        continue;
                    }
                    if (!Objects.equals(prevList.get(i), nextObj)) {
                        return false;
                    }
                    prevList.set(i, nextObj);
                }
                continue;
            }
            if (!(object instanceof Enumeration)) continue;
            Enumeration enumeration = (Enumeration)object;
            int i = 0;
            while (enumeration.hasMoreElements()) {
                nextObj = CollectionUtils.toStringByBasic(enumeration.nextElement(), isByValue);
                if (prevList.size() < i + 1) {
                    prevList.add(nextObj);
                    i = 1;
                } else {
                    if (!Objects.equals(prevList.get(i), nextObj)) {
                        return false;
                    }
                    prevList.set(i, nextObj);
                }
                ++i;
            }
        }
        return true;
    }

    public static boolean isNotAllEqualsSameIndex(boolean isByValue, Function<Object, Boolean> continueFunction, Object ... objects) {
        return !CollectionUtils.isAllEqualsSameIndex(isByValue, continueFunction, objects);
    }
}

