/*
 * Decompiled with CFR 0.152.
 */
package top.zhogjianhao.pinyin;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Map;
import lombok.NonNull;
import top.zhogjianhao.FileUtils;
import top.zhogjianhao.StringUtils;
import top.zhogjianhao.pinyin.PinyinFeature;

public class PinyinUtils {
    private static final Map<String, String> PINYIN_DATA_WITH_TONE;
    private static final Map<String, String> PINYIN_DATA;

    public static String get(@NonNull String str, boolean isWithTone, boolean isOnlyFirst, String pinyinSeparator) {
        if (str == null) {
            throw new NullPointerException("str is marked non-null but is null");
        }
        if (StringUtils.isBlank((CharSequence)str)) {
            throw new IllegalArgumentException("Str: should not be blank");
        }
        Map<String, String> pinyinDataMap = isWithTone ? PINYIN_DATA_WITH_TONE : PINYIN_DATA;
        StringBuilder result = new StringBuilder();
        boolean hasPinyinSeparator = StringUtils.isNotBlank((CharSequence)pinyinSeparator);
        Boolean firstWordInitialCapFeature = PinyinFeature.getFirstWordInitialCap();
        Boolean secondWordInitialCapFeature = PinyinFeature.getSecondWordInitialCap();
        Boolean notPinyinAroundHasSeparator = PinyinFeature.getNotPinyinAroundHasSeparator();
        char[] arr = str.toCharArray();
        for (int i = 0; i < arr.length; ++i) {
            char singleChar = arr[i];
            String pinyin = pinyinDataMap.get(String.valueOf(singleChar));
            boolean pinyinNotBlank = StringUtils.isNotBlank((CharSequence)pinyin);
            if (pinyinNotBlank && isOnlyFirst) {
                int commaIndex = pinyin.indexOf(",");
                if (commaIndex != -1) {
                    pinyin = pinyin.substring(0, commaIndex);
                }
                if (i > 0 && secondWordInitialCapFeature.booleanValue()) {
                    pinyin = StringUtils.toInitialUpperCase(pinyin);
                }
            }
            if (pinyinNotBlank && (i == 0 && firstWordInitialCapFeature.booleanValue() || i > 0 && secondWordInitialCapFeature.booleanValue())) {
                int j;
                StringBuilder singlePinyinSb;
                if (i == 0) {
                    String[] singlePinyins = StringUtils.split((String)pinyin, (String)",");
                    singlePinyinSb = new StringBuilder();
                    for (j = 0; j < singlePinyins.length; ++j) {
                        singlePinyinSb.append(StringUtils.toInitialUpperCase(singlePinyins[j]));
                        if (j >= singlePinyins.length - 1) continue;
                        singlePinyinSb.append(",");
                    }
                    pinyin = singlePinyinSb.toString();
                } else {
                    String[] singlePinyins = StringUtils.split((String)pinyin, (String)",");
                    singlePinyinSb = new StringBuilder();
                    for (j = 0; j < singlePinyins.length; ++j) {
                        singlePinyinSb.append(StringUtils.toInitialUpperCase(singlePinyins[j]));
                        if (j >= singlePinyins.length - 1) continue;
                        singlePinyinSb.append(",");
                    }
                    pinyin = singlePinyinSb.toString();
                }
            }
            if (pinyinNotBlank) {
                if (i > 0 && hasPinyinSeparator) {
                    result.append(pinyinSeparator);
                }
                result.append(pinyin);
                hasPinyinSeparator = true;
                continue;
            }
            if (!notPinyinAroundHasSeparator.booleanValue()) {
                hasPinyinSeparator = false;
            }
            if (hasPinyinSeparator) {
                result.append(pinyinSeparator);
            }
            result.append(singleChar);
        }
        return result.toString();
    }

    public static String getAll(@NonNull String str, boolean isWithTone, @NonNull String pinyinSeparator) {
        if (str == null) {
            throw new NullPointerException("str is marked non-null but is null");
        }
        if (pinyinSeparator == null) {
            throw new NullPointerException("pinyinSeparator is marked non-null but is null");
        }
        return PinyinUtils.get(str, isWithTone, false, pinyinSeparator);
    }

    public static String getAll(@NonNull String str, boolean isWithTone) {
        if (str == null) {
            throw new NullPointerException("str is marked non-null but is null");
        }
        return PinyinUtils.get(str, isWithTone, false, null);
    }

    public static String getFirst(@NonNull String str, boolean isWithTone, @NonNull String pinyinSeparator) {
        if (str == null) {
            throw new NullPointerException("str is marked non-null but is null");
        }
        if (pinyinSeparator == null) {
            throw new NullPointerException("pinyinSeparator is marked non-null but is null");
        }
        return PinyinUtils.get(str, isWithTone, true, pinyinSeparator);
    }

    public static String getFirst(@NonNull String str, boolean isWithTone) {
        if (str == null) {
            throw new NullPointerException("str is marked non-null but is null");
        }
        return PinyinUtils.get(str, isWithTone, true, null);
    }

    public static String getWithTone(@NonNull String str, boolean isOnlyFirst, @NonNull String pinyinSeparator) {
        if (str == null) {
            throw new NullPointerException("str is marked non-null but is null");
        }
        if (pinyinSeparator == null) {
            throw new NullPointerException("pinyinSeparator is marked non-null but is null");
        }
        return PinyinUtils.get(str, true, isOnlyFirst, pinyinSeparator);
    }

    public static String getWithTone(@NonNull String str, boolean isOnlyFirst) {
        if (str == null) {
            throw new NullPointerException("str is marked non-null but is null");
        }
        return PinyinUtils.get(str, true, isOnlyFirst, null);
    }

    public static String getNotWithTone(@NonNull String str, boolean isOnlyFirst, @NonNull String pinyinSeparator) {
        if (str == null) {
            throw new NullPointerException("str is marked non-null but is null");
        }
        if (pinyinSeparator == null) {
            throw new NullPointerException("pinyinSeparator is marked non-null but is null");
        }
        return PinyinUtils.get(str, false, isOnlyFirst, pinyinSeparator);
    }

    public static String getNotWithTone(@NonNull String str, boolean isOnlyFirst) {
        if (str == null) {
            throw new NullPointerException("str is marked non-null but is null");
        }
        return PinyinUtils.get(str, false, isOnlyFirst, null);
    }

    public static String getAllWithTone(@NonNull String str, @NonNull String pinyinSeparator) {
        if (str == null) {
            throw new NullPointerException("str is marked non-null but is null");
        }
        if (pinyinSeparator == null) {
            throw new NullPointerException("pinyinSeparator is marked non-null but is null");
        }
        return PinyinUtils.get(str, true, false, pinyinSeparator);
    }

    public static String getAllWithTone(@NonNull String str) {
        if (str == null) {
            throw new NullPointerException("str is marked non-null but is null");
        }
        return PinyinUtils.get(str, true, false, null);
    }

    public static String getAllNotWithTone(@NonNull String str, @NonNull String pinyinSeparator) {
        if (str == null) {
            throw new NullPointerException("str is marked non-null but is null");
        }
        if (pinyinSeparator == null) {
            throw new NullPointerException("pinyinSeparator is marked non-null but is null");
        }
        return PinyinUtils.get(str, false, false, pinyinSeparator);
    }

    public static String getAllNotWithTone(@NonNull String str) {
        if (str == null) {
            throw new NullPointerException("str is marked non-null but is null");
        }
        return PinyinUtils.get(str, false, false, null);
    }

    public static String getFirstWithTone(@NonNull String str, @NonNull String pinyinSeparator) {
        if (str == null) {
            throw new NullPointerException("str is marked non-null but is null");
        }
        if (pinyinSeparator == null) {
            throw new NullPointerException("pinyinSeparator is marked non-null but is null");
        }
        return PinyinUtils.get(str, true, true, pinyinSeparator);
    }

    public static String getFirstWithTone(@NonNull String str) {
        if (str == null) {
            throw new NullPointerException("str is marked non-null but is null");
        }
        return PinyinUtils.get(str, true, true, null);
    }

    public static String getFirstNotWithTone(@NonNull String str, @NonNull String pinyinSeparator) {
        if (str == null) {
            throw new NullPointerException("str is marked non-null but is null");
        }
        if (pinyinSeparator == null) {
            throw new NullPointerException("pinyinSeparator is marked non-null but is null");
        }
        return PinyinUtils.get(str, false, true, pinyinSeparator);
    }

    public static String getFirstNotWithTone(@NonNull String str) {
        if (str == null) {
            throw new NullPointerException("str is marked non-null but is null");
        }
        return PinyinUtils.get(str, false, true, null);
    }

    public static boolean isPolyphonicWord(char c) {
        return PinyinUtils.get(String.valueOf(c), true, false, ",").contains(",");
    }

    static {
        try {
            File file = new File(FileUtils.getUserDir() + "/src/main/resources/pinyin/pinyinDataWithTone.dat");
            byte[] fileBytes = FileUtils.readFileToByteArray((File)file);
            PINYIN_DATA_WITH_TONE = (Map)new ObjectInputStream(new ByteArrayInputStream(fileBytes)).readObject();
            file = new File(FileUtils.getUserDir() + "/src/main/resources/pinyin/pinyinData.dat");
            fileBytes = FileUtils.readFileToByteArray((File)file);
            PINYIN_DATA = (Map)new ObjectInputStream(new ByteArrayInputStream(fileBytes)).readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

