/*
 * Decompiled with CFR 0.152.
 */
package trade.invision.indicators.indicators.bar;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.time.Instant;
import lombok.Generated;
import trade.invision.indicators.indicators.Indicator;
import trade.invision.indicators.series.bar.Bar;
import trade.invision.indicators.series.bar.BarSeries;

public class ContainsInstant
extends Indicator<Boolean> {
    private static final Cache<CacheKey, ContainsInstant> CACHE = Caffeine.newBuilder().weakValues().build();
    private final BarSeries barSeries;
    private final Indicator<Instant> check;

    public static ContainsInstant containsInstant(BarSeries barSeries, Indicator<Instant> check) {
        return (ContainsInstant)CACHE.get((Object)new CacheKey(barSeries, check), key -> new ContainsInstant(barSeries, check));
    }

    protected ContainsInstant(BarSeries barSeries, Indicator<Instant> check) {
        super(barSeries, 0);
        this.barSeries = barSeries;
        this.check = check;
    }

    @Override
    protected Boolean calculate(long index) {
        return ((Bar)this.barSeries.get(index)).containsInstant(this.check.getValue(index));
    }

    private static final class CacheKey {
        private final BarSeries barSeries;
        private final Indicator<Instant> check;

        @Generated
        public CacheKey(BarSeries barSeries, Indicator<Instant> check) {
            this.barSeries = barSeries;
            this.check = check;
        }

        @Generated
        public BarSeries getBarSeries() {
            return this.barSeries;
        }

        @Generated
        public Indicator<Instant> getCheck() {
            return this.check;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            BarSeries this$barSeries = this.getBarSeries();
            BarSeries other$barSeries = other.getBarSeries();
            if (this$barSeries == null ? other$barSeries != null : !this$barSeries.equals(other$barSeries)) {
                return false;
            }
            Indicator<Instant> this$check = this.getCheck();
            Indicator<Instant> other$check = other.getCheck();
            return !(this$check == null ? other$check != null : !this$check.equals(other$check));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BarSeries $barSeries = this.getBarSeries();
            result = result * 59 + ($barSeries == null ? 43 : $barSeries.hashCode());
            Indicator<Instant> $check = this.getCheck();
            result = result * 59 + ($check == null ? 43 : $check.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ContainsInstant.CacheKey(barSeries=" + String.valueOf(this.getBarSeries()) + ", check=" + String.valueOf(this.getCheck()) + ")";
        }
    }
}

