/*
 * Decompiled with CFR 0.152.
 */
package trade.invision.indicators.indicators.bb;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import trade.invision.indicators.indicators.Indicator;
import trade.invision.indicators.indicators.bb.BollingerBandsResult;
import trade.invision.indicators.indicators.bb.BollingerBandsResultType;
import trade.invision.indicators.indicators.ma.MovingAverageSupplier;
import trade.invision.indicators.indicators.operation.unary.UnaryOperation;
import trade.invision.indicators.indicators.statistical.StandardDeviation;
import trade.invision.num.Num;

public class BollingerBands
extends Indicator<BollingerBandsResult> {
    private static final Cache<CacheKey, BollingerBands> CACHE = Caffeine.newBuilder().weakValues().build();
    private final Indicator<Num> indicator;
    private final Set<BollingerBandsResultType> resultTypes;
    private final Num multiplier;
    private final StandardDeviation standardDeviation;
    private final Indicator<Num> averagingIndicator;

    public static Indicator<Num> bbMiddleBand(Indicator<Num> indicator, int length, Num multiplier, MovingAverageSupplier movingAverageSupplier, boolean unbiased) {
        return BollingerBands.bollingerBandsMiddleBand(indicator, length, multiplier, movingAverageSupplier, unbiased);
    }

    public static Indicator<Num> bollingerBandsMiddleBand(Indicator<Num> indicator, int length, Num multiplier, MovingAverageSupplier movingAverageSupplier, boolean unbiased) {
        return UnaryOperation.unaryOperation(BollingerBandsResult::getMiddleBand, BollingerBands.bollingerBands(indicator, Set.of(BollingerBandsResultType.MIDDLE_BAND), length, multiplier, movingAverageSupplier, unbiased));
    }

    public static Indicator<Num> bbUpperBand(Indicator<Num> indicator, int length, Num multiplier, MovingAverageSupplier movingAverageSupplier, boolean unbiased) {
        return BollingerBands.bollingerBandsUpperBand(indicator, length, multiplier, movingAverageSupplier, unbiased);
    }

    public static Indicator<Num> bollingerBandsUpperBand(Indicator<Num> indicator, int length, Num multiplier, MovingAverageSupplier movingAverageSupplier, boolean unbiased) {
        return UnaryOperation.unaryOperation(BollingerBandsResult::getUpperBand, BollingerBands.bollingerBands(indicator, Set.of(BollingerBandsResultType.UPPER_BAND), length, multiplier, movingAverageSupplier, unbiased));
    }

    public static Indicator<Num> bbLowerBand(Indicator<Num> indicator, int length, Num multiplier, MovingAverageSupplier movingAverageSupplier, boolean unbiased) {
        return BollingerBands.bollingerBandsLowerBand(indicator, length, multiplier, movingAverageSupplier, unbiased);
    }

    public static Indicator<Num> bollingerBandsLowerBand(Indicator<Num> indicator, int length, Num multiplier, MovingAverageSupplier movingAverageSupplier, boolean unbiased) {
        return UnaryOperation.unaryOperation(BollingerBandsResult::getLowerBand, BollingerBands.bollingerBands(indicator, Set.of(BollingerBandsResultType.LOWER_BAND), length, multiplier, movingAverageSupplier, unbiased));
    }

    public static Indicator<Num> bbBandwidth(Indicator<Num> indicator, int length, Num multiplier, MovingAverageSupplier movingAverageSupplier, boolean unbiased) {
        return BollingerBands.bollingerBandsBandwidth(indicator, length, multiplier, movingAverageSupplier, unbiased);
    }

    public static Indicator<Num> bollingerBandsBandwidth(Indicator<Num> indicator, int length, Num multiplier, MovingAverageSupplier movingAverageSupplier, boolean unbiased) {
        return UnaryOperation.unaryOperation(BollingerBandsResult::getBandwidth, BollingerBands.bollingerBands(indicator, Set.of(BollingerBandsResultType.BANDWIDTH), length, multiplier, movingAverageSupplier, unbiased));
    }

    public static Indicator<Num> bbPercentB(Indicator<Num> indicator, int length, Num multiplier, MovingAverageSupplier movingAverageSupplier, boolean unbiased) {
        return BollingerBands.bollingerBandsPercentB(indicator, length, multiplier, movingAverageSupplier, unbiased);
    }

    public static Indicator<Num> bollingerBandsPercentB(Indicator<Num> indicator, int length, Num multiplier, MovingAverageSupplier movingAverageSupplier, boolean unbiased) {
        return UnaryOperation.unaryOperation(BollingerBandsResult::getPercentB, BollingerBands.bollingerBands(indicator, Set.of(BollingerBandsResultType.PERCENT_B), length, multiplier, movingAverageSupplier, unbiased));
    }

    public static BollingerBands bb(Indicator<Num> indicator, Set<BollingerBandsResultType> resultTypes, int length, Num multiplier, MovingAverageSupplier movingAverageSupplier, boolean unbiased) {
        return BollingerBands.bollingerBands(indicator, resultTypes, length, multiplier, movingAverageSupplier, unbiased);
    }

    public static synchronized BollingerBands bollingerBands(Indicator<Num> indicator, Set<BollingerBandsResultType> resultTypes, int length, Num multiplier, MovingAverageSupplier movingAverageSupplier, boolean unbiased) {
        CacheKey cacheKey = new CacheKey(indicator, length, multiplier, movingAverageSupplier, unbiased);
        BollingerBands bollingerBands = (BollingerBands)CACHE.getIfPresent((Object)cacheKey);
        if (bollingerBands == null) {
            bollingerBands = new BollingerBands(indicator, resultTypes, length, multiplier, movingAverageSupplier, unbiased);
            CACHE.put((Object)cacheKey, (Object)bollingerBands);
        } else {
            bollingerBands.resultTypes.addAll(resultTypes);
            bollingerBands.purgeCache();
        }
        return bollingerBands;
    }

    protected BollingerBands(Indicator<Num> indicator, Set<BollingerBandsResultType> resultTypes, int length, Num multiplier, MovingAverageSupplier movingAverageSupplier, boolean unbiased) {
        super(indicator.getSeries(), length - 1);
        Preconditions.checkArgument((length > 0 ? 1 : 0) != 0, (Object)"'length' must be greater than zero!");
        Preconditions.checkArgument((resultTypes != null && !resultTypes.isEmpty() ? 1 : 0) != 0, (Object)"'resultTypes' must not be null or empty!");
        this.indicator = indicator;
        this.resultTypes = new HashSet<BollingerBandsResultType>(resultTypes);
        this.multiplier = multiplier;
        this.standardDeviation = StandardDeviation.standardDeviation(indicator, length, unbiased);
        this.averagingIndicator = movingAverageSupplier.supply(indicator, length);
    }

    @Override
    protected BollingerBandsResult calculate(long index) {
        BollingerBandsResult.BollingerBandsResultBuilder result = BollingerBandsResult.builder();
        Num middleBand = this.averagingIndicator.getValue(index);
        result.middleBand(middleBand);
        if (this.resultTypes.contains((Object)BollingerBandsResultType.UPPER_BAND) || this.resultTypes.contains((Object)BollingerBandsResultType.LOWER_BAND) || this.resultTypes.contains((Object)BollingerBandsResultType.BANDWIDTH) || this.resultTypes.contains((Object)BollingerBandsResultType.PERCENT_B)) {
            Num stdDev = (Num)this.standardDeviation.getValue(index);
            Num stdDevMultiplied = stdDev.multiply(this.multiplier);
            Num upperBand = middleBand.add(stdDevMultiplied);
            result.upperBand(upperBand);
            Num lowerBand = middleBand.subtract(stdDevMultiplied);
            result.lowerBand(lowerBand);
            if (this.resultTypes.contains((Object)BollingerBandsResultType.BANDWIDTH)) {
                result.bandwidth(upperBand.subtract(lowerBand).divide(middleBand));
            }
            if (this.resultTypes.contains((Object)BollingerBandsResultType.PERCENT_B)) {
                result.percentB(this.indicator.getValue(index).subtract(lowerBand).divide(upperBand.subtract(lowerBand)));
            }
        }
        return result.build();
    }

    private static final class CacheKey {
        private final Indicator<Num> indicator;
        private final int length;
        private final Num multiplier;
        private final MovingAverageSupplier movingAverageSupplier;
        private final boolean unbiased;

        @Generated
        public CacheKey(Indicator<Num> indicator, int length, Num multiplier, MovingAverageSupplier movingAverageSupplier, boolean unbiased) {
            this.indicator = indicator;
            this.length = length;
            this.multiplier = multiplier;
            this.movingAverageSupplier = movingAverageSupplier;
            this.unbiased = unbiased;
        }

        @Generated
        public Indicator<Num> getIndicator() {
            return this.indicator;
        }

        @Generated
        public int getLength() {
            return this.length;
        }

        @Generated
        public Num getMultiplier() {
            return this.multiplier;
        }

        @Generated
        public MovingAverageSupplier getMovingAverageSupplier() {
            return this.movingAverageSupplier;
        }

        @Generated
        public boolean isUnbiased() {
            return this.unbiased;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            if (this.getLength() != other.getLength()) {
                return false;
            }
            if (this.isUnbiased() != other.isUnbiased()) {
                return false;
            }
            Indicator<Num> this$indicator = this.getIndicator();
            Indicator<Num> other$indicator = other.getIndicator();
            if (this$indicator == null ? other$indicator != null : !this$indicator.equals(other$indicator)) {
                return false;
            }
            Num this$multiplier = this.getMultiplier();
            Num other$multiplier = other.getMultiplier();
            if (this$multiplier == null ? other$multiplier != null : !this$multiplier.equals(other$multiplier)) {
                return false;
            }
            MovingAverageSupplier this$movingAverageSupplier = this.getMovingAverageSupplier();
            MovingAverageSupplier other$movingAverageSupplier = other.getMovingAverageSupplier();
            return !(this$movingAverageSupplier == null ? other$movingAverageSupplier != null : !((Object)this$movingAverageSupplier).equals(other$movingAverageSupplier));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getLength();
            result = result * 59 + (this.isUnbiased() ? 79 : 97);
            Indicator<Num> $indicator = this.getIndicator();
            result = result * 59 + ($indicator == null ? 43 : $indicator.hashCode());
            Num $multiplier = this.getMultiplier();
            result = result * 59 + ($multiplier == null ? 43 : $multiplier.hashCode());
            MovingAverageSupplier $movingAverageSupplier = this.getMovingAverageSupplier();
            result = result * 59 + ($movingAverageSupplier == null ? 43 : ((Object)$movingAverageSupplier).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "BollingerBands.CacheKey(indicator=" + String.valueOf(this.getIndicator()) + ", length=" + this.getLength() + ", multiplier=" + String.valueOf(this.getMultiplier()) + ", movingAverageSupplier=" + String.valueOf(this.getMovingAverageSupplier()) + ", unbiased=" + this.isUnbiased() + ")";
        }
    }
}

