/*
 * Decompiled with CFR 0.152.
 */
package trade.invision.indicators.indicators.convergencedivergence;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.base.Preconditions;
import lombok.Generated;
import trade.invision.indicators.indicators.Indicator;
import trade.invision.indicators.indicators.convergencedivergence.ConvergenceDivergenceType;
import trade.invision.indicators.indicators.statistical.CorrelationCoefficient;
import trade.invision.indicators.indicators.statistical.regression.LinearRegression;
import trade.invision.num.Num;

public class ComplexConvergenceDivergence
extends Indicator<Boolean> {
    private static final Cache<CacheKey, ComplexConvergenceDivergence> CACHE = Caffeine.newBuilder().weakValues().build();
    private final ConvergenceDivergenceType type;
    private final Num correlationThreshold;
    private final Num slopeThreshold;
    private final Num slopeThresholdNegated;
    private final CorrelationCoefficient correlationCoefficient;
    private final Indicator<Num> firstSlope;
    private final Indicator<Num> secondSlope;

    public static ComplexConvergenceDivergence complexConvergenceDivergence(Indicator<Num> first, Indicator<Num> second, ConvergenceDivergenceType type, int length, Num correlationThreshold, Num slopeThreshold, boolean unbiased) {
        return (ComplexConvergenceDivergence)CACHE.get((Object)new CacheKey(first, second, type, length, correlationThreshold, slopeThreshold, unbiased), key -> new ComplexConvergenceDivergence(first, second, type, length, correlationThreshold, slopeThreshold, unbiased));
    }

    protected ComplexConvergenceDivergence(Indicator<Num> first, Indicator<Num> second, ConvergenceDivergenceType type, int length, Num correlationThreshold, Num slopeThreshold, boolean unbiased) {
        super(first.getSeries(), length - 1);
        Preconditions.checkArgument((length > 0 ? 1 : 0) != 0, (Object)"'length' must be greater than zero!");
        Preconditions.checkArgument((correlationThreshold.isGreaterThan(this.numOfZero()) && correlationThreshold.isLessThan(this.numOfOne()) ? 1 : 0) != 0, (Object)"'correlationThreshold' must be between zero and one (inclusive)!");
        Preconditions.checkArgument((slopeThreshold.isGreaterThan(this.numOfZero()) && slopeThreshold.isLessThan(this.numOfOne()) ? 1 : 0) != 0, (Object)"'slopeThreshold' must be between zero and one (inclusive)!");
        this.type = type;
        this.correlationThreshold = correlationThreshold;
        this.slopeThreshold = slopeThreshold;
        this.slopeThresholdNegated = slopeThreshold.negate();
        this.correlationCoefficient = !correlationThreshold.isZero(this.series.getEpsilon()) ? CorrelationCoefficient.correlationCoefficient(first, second, length, unbiased) : null;
        if (!slopeThreshold.isZero(this.series.getEpsilon())) {
            this.firstSlope = LinearRegression.linearRegressionSlope(first, length);
            this.secondSlope = LinearRegression.linearRegressionSlope(second, length);
        } else {
            this.firstSlope = null;
            this.secondSlope = null;
        }
    }

    @Override
    protected Boolean calculate(long index) {
        if (this.correlationCoefficient != null && ((Num)this.correlationCoefficient.getValue(index)).isLessThan(this.correlationThreshold)) {
            return false;
        }
        if (this.firstSlope != null && this.secondSlope != null) {
            Num firstSlopeValue = this.firstSlope.getValue(index);
            switch (this.type) {
                case POSITIVE_CONVERGENCE: 
                case POSITIVE_DIVERGENCE: {
                    if (!firstSlopeValue.isLessThan(this.slopeThreshold)) break;
                    return false;
                }
                case NEGATIVE_CONVERGENCE: 
                case NEGATIVE_DIVERGENCE: {
                    if (!firstSlopeValue.isGreaterThan(this.slopeThresholdNegated)) break;
                    return false;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            Num secondSlopeValue = this.secondSlope.getValue(index);
            switch (this.type) {
                case POSITIVE_CONVERGENCE: 
                case POSITIVE_DIVERGENCE: {
                    return secondSlopeValue.isGreaterThan(this.slopeThreshold);
                }
                case NEGATIVE_CONVERGENCE: 
                case NEGATIVE_DIVERGENCE: {
                    return secondSlopeValue.isLessThan(this.slopeThresholdNegated);
                }
            }
            throw new UnsupportedOperationException();
        }
        return true;
    }

    private static final class CacheKey {
        private final Indicator<Num> first;
        private final Indicator<Num> second;
        private final ConvergenceDivergenceType type;
        private final int length;
        private final Num correlationThreshold;
        private final Num slopeThreshold;
        private final boolean unbiased;

        @Generated
        public CacheKey(Indicator<Num> first, Indicator<Num> second, ConvergenceDivergenceType type, int length, Num correlationThreshold, Num slopeThreshold, boolean unbiased) {
            this.first = first;
            this.second = second;
            this.type = type;
            this.length = length;
            this.correlationThreshold = correlationThreshold;
            this.slopeThreshold = slopeThreshold;
            this.unbiased = unbiased;
        }

        @Generated
        public Indicator<Num> getFirst() {
            return this.first;
        }

        @Generated
        public Indicator<Num> getSecond() {
            return this.second;
        }

        @Generated
        public ConvergenceDivergenceType getType() {
            return this.type;
        }

        @Generated
        public int getLength() {
            return this.length;
        }

        @Generated
        public Num getCorrelationThreshold() {
            return this.correlationThreshold;
        }

        @Generated
        public Num getSlopeThreshold() {
            return this.slopeThreshold;
        }

        @Generated
        public boolean isUnbiased() {
            return this.unbiased;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            if (this.getLength() != other.getLength()) {
                return false;
            }
            if (this.isUnbiased() != other.isUnbiased()) {
                return false;
            }
            Indicator<Num> this$first = this.getFirst();
            Indicator<Num> other$first = other.getFirst();
            if (this$first == null ? other$first != null : !this$first.equals(other$first)) {
                return false;
            }
            Indicator<Num> this$second = this.getSecond();
            Indicator<Num> other$second = other.getSecond();
            if (this$second == null ? other$second != null : !this$second.equals(other$second)) {
                return false;
            }
            ConvergenceDivergenceType this$type = this.getType();
            ConvergenceDivergenceType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            Num this$correlationThreshold = this.getCorrelationThreshold();
            Num other$correlationThreshold = other.getCorrelationThreshold();
            if (this$correlationThreshold == null ? other$correlationThreshold != null : !this$correlationThreshold.equals(other$correlationThreshold)) {
                return false;
            }
            Num this$slopeThreshold = this.getSlopeThreshold();
            Num other$slopeThreshold = other.getSlopeThreshold();
            return !(this$slopeThreshold == null ? other$slopeThreshold != null : !this$slopeThreshold.equals(other$slopeThreshold));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getLength();
            result = result * 59 + (this.isUnbiased() ? 79 : 97);
            Indicator<Num> $first = this.getFirst();
            result = result * 59 + ($first == null ? 43 : $first.hashCode());
            Indicator<Num> $second = this.getSecond();
            result = result * 59 + ($second == null ? 43 : $second.hashCode());
            ConvergenceDivergenceType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            Num $correlationThreshold = this.getCorrelationThreshold();
            result = result * 59 + ($correlationThreshold == null ? 43 : $correlationThreshold.hashCode());
            Num $slopeThreshold = this.getSlopeThreshold();
            result = result * 59 + ($slopeThreshold == null ? 43 : $slopeThreshold.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ComplexConvergenceDivergence.CacheKey(first=" + String.valueOf(this.getFirst()) + ", second=" + String.valueOf(this.getSecond()) + ", type=" + String.valueOf((Object)this.getType()) + ", length=" + this.getLength() + ", correlationThreshold=" + String.valueOf(this.getCorrelationThreshold()) + ", slopeThreshold=" + String.valueOf(this.getSlopeThreshold()) + ", unbiased=" + this.isUnbiased() + ")";
        }
    }
}

