/*
 * Decompiled with CFR 0.152.
 */
package trade.invision.indicators.indicators.convergencedivergence;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.base.Preconditions;
import lombok.Generated;
import trade.invision.indicators.indicators.Indicator;
import trade.invision.indicators.indicators.convergencedivergence.ConvergenceDivergenceType;
import trade.invision.indicators.indicators.risingfalling.local.LocalFallingPercentage;
import trade.invision.indicators.indicators.risingfalling.local.LocalRisingPercentage;
import trade.invision.num.Num;

public class SimpleConvergenceDivergence
extends Indicator<Boolean> {
    private static final Cache<CacheKey, SimpleConvergenceDivergence> CACHE = Caffeine.newBuilder().weakValues().build();
    private final Indicator<Num> riseFallFirst;
    private final Indicator<Num> riseFallSecond;
    private final Num percentageThreshold;

    public static SimpleConvergenceDivergence simpleConvergenceDivergence(Indicator<Num> first, Indicator<Num> second, ConvergenceDivergenceType type, int length, Num percentageThreshold) {
        return (SimpleConvergenceDivergence)CACHE.get((Object)new CacheKey(first, second, type, length, percentageThreshold), key -> new SimpleConvergenceDivergence(first, second, type, length, percentageThreshold));
    }

    protected SimpleConvergenceDivergence(Indicator<Num> first, Indicator<Num> second, ConvergenceDivergenceType type, int length, Num percentageThreshold) {
        super(first.getSeries(), length - 1);
        Preconditions.checkArgument((length > 0 ? 1 : 0) != 0, (Object)"'length' must be greater than zero!");
        Preconditions.checkArgument((percentageThreshold.isGreaterThan(this.numOfZero()) && percentageThreshold.isLessThan(this.numOfOne()) ? 1 : 0) != 0, (Object)"'percentageThreshold' must be between zero and one (inclusive)!");
        this.percentageThreshold = percentageThreshold;
        switch (type) {
            case POSITIVE_CONVERGENCE: {
                this.riseFallFirst = LocalRisingPercentage.localRisingPercentage(first, length);
                this.riseFallSecond = LocalRisingPercentage.localRisingPercentage(second, length);
                break;
            }
            case NEGATIVE_CONVERGENCE: {
                this.riseFallFirst = LocalFallingPercentage.localFallingPercentage(first, length);
                this.riseFallSecond = LocalFallingPercentage.localFallingPercentage(second, length);
                break;
            }
            case POSITIVE_DIVERGENCE: {
                this.riseFallFirst = LocalRisingPercentage.localRisingPercentage(first, length);
                this.riseFallSecond = LocalFallingPercentage.localFallingPercentage(second, length);
                break;
            }
            case NEGATIVE_DIVERGENCE: {
                this.riseFallFirst = LocalFallingPercentage.localFallingPercentage(first, length);
                this.riseFallSecond = LocalRisingPercentage.localRisingPercentage(second, length);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    @Override
    protected Boolean calculate(long index) {
        return this.riseFallFirst.getValue(index).isGreaterThanOrEqual(this.percentageThreshold, this.series.getEpsilon()) && this.riseFallSecond.getValue(index).isGreaterThanOrEqual(this.percentageThreshold, this.series.getEpsilon());
    }

    private static final class CacheKey {
        private final Indicator<Num> first;
        private final Indicator<Num> second;
        private final ConvergenceDivergenceType type;
        private final int length;
        private final Num percentageThreshold;

        @Generated
        public CacheKey(Indicator<Num> first, Indicator<Num> second, ConvergenceDivergenceType type, int length, Num percentageThreshold) {
            this.first = first;
            this.second = second;
            this.type = type;
            this.length = length;
            this.percentageThreshold = percentageThreshold;
        }

        @Generated
        public Indicator<Num> getFirst() {
            return this.first;
        }

        @Generated
        public Indicator<Num> getSecond() {
            return this.second;
        }

        @Generated
        public ConvergenceDivergenceType getType() {
            return this.type;
        }

        @Generated
        public int getLength() {
            return this.length;
        }

        @Generated
        public Num getPercentageThreshold() {
            return this.percentageThreshold;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            if (this.getLength() != other.getLength()) {
                return false;
            }
            Indicator<Num> this$first = this.getFirst();
            Indicator<Num> other$first = other.getFirst();
            if (this$first == null ? other$first != null : !this$first.equals(other$first)) {
                return false;
            }
            Indicator<Num> this$second = this.getSecond();
            Indicator<Num> other$second = other.getSecond();
            if (this$second == null ? other$second != null : !this$second.equals(other$second)) {
                return false;
            }
            ConvergenceDivergenceType this$type = this.getType();
            ConvergenceDivergenceType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            Num this$percentageThreshold = this.getPercentageThreshold();
            Num other$percentageThreshold = other.getPercentageThreshold();
            return !(this$percentageThreshold == null ? other$percentageThreshold != null : !this$percentageThreshold.equals(other$percentageThreshold));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getLength();
            Indicator<Num> $first = this.getFirst();
            result = result * 59 + ($first == null ? 43 : $first.hashCode());
            Indicator<Num> $second = this.getSecond();
            result = result * 59 + ($second == null ? 43 : $second.hashCode());
            ConvergenceDivergenceType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            Num $percentageThreshold = this.getPercentageThreshold();
            result = result * 59 + ($percentageThreshold == null ? 43 : $percentageThreshold.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SimpleConvergenceDivergence.CacheKey(first=" + String.valueOf(this.getFirst()) + ", second=" + String.valueOf(this.getSecond()) + ", type=" + String.valueOf((Object)this.getType()) + ", length=" + this.getLength() + ", percentageThreshold=" + String.valueOf(this.getPercentageThreshold()) + ")";
        }
    }
}

