/*
 * Decompiled with CFR 0.152.
 */
package trade.invision.indicators.indicators.draw;

import org.jetbrains.annotations.Nullable;
import trade.invision.indicators.indicators.Indicator;
import trade.invision.indicators.indicators.extrema.global.GlobalMaximum;
import trade.invision.indicators.indicators.extrema.global.GlobalMinimum;
import trade.invision.indicators.indicators.extrema.local.LocalMaximum;
import trade.invision.indicators.indicators.extrema.local.LocalMinimum;
import trade.invision.num.Num;

public abstract class AbstractDrawupDrawdown
extends Indicator<Num> {
    private final Indicator<Num> indicator;
    private final boolean drawup;
    private final boolean percentage;
    private final Indicator<Num> extremaIndicator;

    public AbstractDrawupDrawdown(Indicator<Num> indicator, @Nullable Integer length, boolean drawup, boolean percentage) {
        super(indicator.getSeries(), 0);
        this.indicator = indicator;
        this.drawup = drawup;
        this.percentage = percentage;
        this.extremaIndicator = length == null ? (drawup ? GlobalMinimum.globalMinimum(indicator) : GlobalMaximum.globalMaximum(indicator)) : (drawup ? LocalMinimum.localMinimum(indicator, length) : LocalMaximum.localMaximum(indicator, length));
    }

    @Override
    protected Num calculate(long index) {
        Num extremaValue = this.extremaIndicator.getValue(index);
        Num currentValue = this.indicator.getValue(index);
        Num value = this.percentage ? currentValue.divide(extremaValue).decrement() : currentValue.subtract(extremaValue);
        return this.drawup ? this.numOfZero().maximum(value) : this.numOfZero().minimum(value);
    }
}

