/*
 * Decompiled with CFR 0.152.
 */
package trade.invision.indicators.indicators.ma.ema;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.base.Preconditions;
import lombok.Generated;
import trade.invision.indicators.indicators.Indicator;
import trade.invision.indicators.indicators.ma.ema.ExponentialMovingAverage;
import trade.invision.num.Num;

public class TripleExponentialMovingAverage
extends Indicator<Num> {
    private static final Cache<CacheKey, TripleExponentialMovingAverage> CACHE = Caffeine.newBuilder().weakValues().build();
    private final ExponentialMovingAverage ema;
    private final ExponentialMovingAverage emaOfEma;
    private final ExponentialMovingAverage emaOfEmaOfEma;

    public static TripleExponentialMovingAverage tema(Indicator<Num> indicator, int length) {
        return TripleExponentialMovingAverage.tripleExponentialMovingAverage(indicator, length);
    }

    public static TripleExponentialMovingAverage tripleExponentialMovingAverage(Indicator<Num> indicator, int length) {
        return TripleExponentialMovingAverage.tripleExponentialMovingAverage(indicator, length, indicator.getSeries().getNumFactory().two());
    }

    public static TripleExponentialMovingAverage tema(Indicator<Num> indicator, int length, Num smoothing) {
        return TripleExponentialMovingAverage.tripleExponentialMovingAverage(indicator, length, smoothing);
    }

    public static TripleExponentialMovingAverage tripleExponentialMovingAverage(Indicator<Num> indicator, int length, Num smoothing) {
        return (TripleExponentialMovingAverage)CACHE.get((Object)new CacheKey(indicator, length, smoothing), key -> new TripleExponentialMovingAverage(indicator, length, smoothing));
    }

    protected TripleExponentialMovingAverage(Indicator<Num> indicator, int length, Num smoothing) {
        super(indicator.getSeries(), length * 3);
        Preconditions.checkArgument((length > 0 ? 1 : 0) != 0, (Object)"'length' must be greater than zero!");
        this.ema = ExponentialMovingAverage.exponentialMovingAverage(indicator, length, smoothing);
        this.emaOfEma = ExponentialMovingAverage.exponentialMovingAverage(this.ema, length, smoothing);
        this.emaOfEmaOfEma = ExponentialMovingAverage.exponentialMovingAverage(this.emaOfEma, length, smoothing);
    }

    @Override
    protected Num calculate(long index) {
        return this.numOfThree().multiply(((Num)this.ema.getValue(index)).subtract((Num)this.emaOfEma.getValue(index))).add((Num)this.emaOfEmaOfEma.getValue(index));
    }

    private static final class CacheKey {
        private final Indicator<Num> indicator;
        private final int length;
        private final Num smoothing;

        @Generated
        public CacheKey(Indicator<Num> indicator, int length, Num smoothing) {
            this.indicator = indicator;
            this.length = length;
            this.smoothing = smoothing;
        }

        @Generated
        public Indicator<Num> getIndicator() {
            return this.indicator;
        }

        @Generated
        public int getLength() {
            return this.length;
        }

        @Generated
        public Num getSmoothing() {
            return this.smoothing;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            if (this.getLength() != other.getLength()) {
                return false;
            }
            Indicator<Num> this$indicator = this.getIndicator();
            Indicator<Num> other$indicator = other.getIndicator();
            if (this$indicator == null ? other$indicator != null : !this$indicator.equals(other$indicator)) {
                return false;
            }
            Num this$smoothing = this.getSmoothing();
            Num other$smoothing = other.getSmoothing();
            return !(this$smoothing == null ? other$smoothing != null : !this$smoothing.equals(other$smoothing));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getLength();
            Indicator<Num> $indicator = this.getIndicator();
            result = result * 59 + ($indicator == null ? 43 : $indicator.hashCode());
            Num $smoothing = this.getSmoothing();
            result = result * 59 + ($smoothing == null ? 43 : $smoothing.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "TripleExponentialMovingAverage.CacheKey(indicator=" + String.valueOf(this.getIndicator()) + ", length=" + this.getLength() + ", smoothing=" + String.valueOf(this.getSmoothing()) + ")";
        }
    }
}

